/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.util;

import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.lib.ddl.DDLCommand;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.util.CommandBufferExceptionHandler;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class CommandBuffer {
    Vector commands;
    CommandBufferExceptionHandler handler;
    boolean debugmode;
    boolean executionWithException;

    public void add(DDLCommand dDLCommand) {
        if (this.commands == null) {
            this.commands = new Vector();
        }
        this.commands.add(dDLCommand);
    }

    public void setExceptionHandler(CommandBufferExceptionHandler commandBufferExceptionHandler) {
        this.handler = commandBufferExceptionHandler;
    }

    public boolean isDebugMode() {
        return this.debugmode;
    }

    public void setDebugMode(boolean bl) {
        this.debugmode = bl;
    }

    public String getCommands() throws DDLException {
        String string = "";
        Enumeration enumeration = this.commands.elements();
        while (enumeration.hasMoreElements()) {
            DDLCommand dDLCommand = (DDLCommand)enumeration.nextElement();
            string = string + dDLCommand.getCommand() + "\n";
        }
        return string;
    }

    public void execute() throws DDLException {
        boolean bl = false;
        this.executionWithException = false;
        DatabaseSpecification databaseSpecification = null;
        Enumeration enumeration = this.commands.elements();
        while (enumeration.hasMoreElements()) {
            DDLCommand dDLCommand = (DDLCommand)enumeration.nextElement();
            try {
                if (databaseSpecification == null && (databaseSpecification = dDLCommand.getSpecification()).getJDBCConnection() == null) {
                    bl = true;
                    databaseSpecification.openJDBCConnection();
                }
                if (this.debugmode) {
                    System.out.println(dDLCommand);
                }
                dDLCommand.execute();
                this.executionWithException = dDLCommand.wasException();
            }
            catch (Exception exception) {
                this.executionWithException = true;
                boolean bl2 = false;
                if (this.handler != null) {
                    bl2 = this.handler.shouldContinueAfterException(exception);
                }
                if (bl2) continue;
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)exception.getMessage(), 0));
            }
        }
        if (bl) {
            databaseSpecification.closeJDBCConnection();
        }
    }

    public boolean wasException() {
        return this.executionWithException;
    }
}

