/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.util;

import java.text.ParseException;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openide.util.MapFormat;

public class CommandFormatter {
    Vector items;

    public static String format(String string, Map map) throws ParseException, IllegalArgumentException {
        CommandFormatter commandFormatter = new CommandFormatter(string);
        return commandFormatter.format(map);
    }

    public CommandFormatter(String string) throws ParseException {
        this(new StringTokenizer(string, "[]", true));
    }

    private CommandFormatter(StringTokenizer stringTokenizer) throws ParseException {
        this.items = this.scan(stringTokenizer);
    }

    private Vector scan(StringTokenizer stringTokenizer) throws ParseException {
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            String string = (String)stringTokenizer.nextElement();
            Object object = string;
            if (string.equals("[")) {
                object = this.scan(stringTokenizer);
            } else if (string.equals("]")) break;
            vector.add(object);
        }
        return vector;
    }

    public String format(Map map) throws IllegalArgumentException {
        return this.format(this.items, map);
    }

    private String format(Vector vector, Map map) throws IllegalArgumentException {
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof Vector) {
                try {
                    object = this.format((Vector)object, map);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(object instanceof String)) continue;
            MapFormat mapFormat = new MapFormat(map);
            mapFormat.setThrowExceptionIfKeyWasNotFound(true);
            String string2 = mapFormat.format((String)object);
            if (string2 != null) {
                string = string + string2;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return string;
    }
}

