/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.openide.util.NbBundle;

public class PListReader {
    protected StreamTokenizer tokenizer = null;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");

    public static Map read(String string) throws FileNotFoundException, ParseException, IOException {
        PListReader pListReader = new PListReader(string);
        return pListReader.getData();
    }

    public PListReader(String string) throws FileNotFoundException, ParseException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.tokenizer = this.createTokenizer(bufferedReader);
    }

    public PListReader(File file) throws FileNotFoundException, ParseException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        this.tokenizer = this.createTokenizer(bufferedReader);
    }

    public PListReader(InputStream inputStream) throws FileNotFoundException, ParseException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.tokenizer = this.createTokenizer(bufferedReader);
    }

    private StreamTokenizer createTokenizer(BufferedReader bufferedReader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(33, 33);
        streamTokenizer.wordChars(96, 96);
        streamTokenizer.wordChars(39, 39);
        streamTokenizer.wordChars(35, 35);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(37, 37);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(124, 124);
        streamTokenizer.wordChars(63, 63);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.quoteChar(34);
        return streamTokenizer;
    }

    private Object read(StreamTokenizer streamTokenizer) throws FileNotFoundException, ParseException, IOException {
        DictionaryNode dictionaryNode = new DictionaryNode(streamTokenizer);
        return dictionaryNode.getBindings();
    }

    public HashMap getData() throws FileNotFoundException, ParseException, IOException {
        return (HashMap)this.read(this.tokenizer);
    }

    public StreamTokenizer getTokenizer() {
        return this.tokenizer;
    }

    class ArrayNode
    extends Node {
        Vector bindings = new Vector();

        public ArrayNode(StreamTokenizer streamTokenizer) throws ParseException, IOException {
            this.parse(streamTokenizer);
        }

        public void parse(StreamTokenizer streamTokenizer) throws ParseException, IOException {
            Object object = null;
            try {
                this.parseChar(streamTokenizer, 40);
                block14: while (true) {
                    streamTokenizer.nextToken();
                    switch (streamTokenizer.ttype) {
                        case -3: {
                            object = streamTokenizer.sval;
                            break;
                        }
                        case 34: {
                            object = streamTokenizer.sval;
                            break;
                        }
                        case 41: {
                            throw new EOFException();
                        }
                        case 123: {
                            streamTokenizer.pushBack();
                            object = new DictionaryNode(streamTokenizer).getBindings();
                            break;
                        }
                        case 40: {
                            streamTokenizer.pushBack();
                            object = new ArrayNode(streamTokenizer).getBindings();
                            break;
                        }
                        case -2: {
                            object = this.parseNumber(streamTokenizer);
                            break;
                        }
                        default: {
                            throw new ParseException(MessageFormat.format(bundle.getString("EXC_ExpectedObject"), streamTokenizer.toString()), streamTokenizer.lineno());
                        }
                    }
                    this.bindings.add(object);
                    streamTokenizer.nextToken();
                    switch (streamTokenizer.ttype) {
                        case 41: {
                            throw new EOFException();
                        }
                        case 44: {
                            continue block14;
                        }
                    }
                    break;
                }
                throw new ParseException(MessageFormat.format(bundle.getString("EXC_Expected"), "','", streamTokenizer.toString()), streamTokenizer.lineno());
            }
            catch (EOFException eOFException) {
                return;
            }
        }

        public Vector getBindings() {
            return this.bindings;
        }
    }

    class DictionaryNode
    extends Node {
        HashMap bindings = new HashMap();

        public DictionaryNode(StreamTokenizer streamTokenizer) throws ParseException, IOException {
            this.parse(streamTokenizer);
        }

        public void parse(StreamTokenizer streamTokenizer) throws ParseException, IOException {
            String string = null;
            Object object = null;
            try {
                this.parseChar(streamTokenizer, 123);
                while (true) {
                    streamTokenizer.nextToken();
                    switch (streamTokenizer.ttype) {
                        case -3: {
                            string = streamTokenizer.sval;
                            break;
                        }
                        case 34: {
                            string = streamTokenizer.sval;
                            break;
                        }
                        case 125: {
                            throw new EOFException();
                        }
                        default: {
                            throw new ParseException(MessageFormat.format(bundle.getString("EXC_UnexpectedKey"), streamTokenizer.toString()), streamTokenizer.lineno());
                        }
                    }
                    this.parseChar(streamTokenizer, 61);
                    streamTokenizer.nextToken();
                    switch (streamTokenizer.ttype) {
                        case -3: {
                            object = streamTokenizer.sval;
                            break;
                        }
                        case 34: {
                            object = streamTokenizer.sval;
                            break;
                        }
                        case 123: {
                            streamTokenizer.pushBack();
                            object = new DictionaryNode(streamTokenizer).getBindings();
                            break;
                        }
                        case 40: {
                            streamTokenizer.pushBack();
                            object = new ArrayNode(streamTokenizer).getBindings();
                            break;
                        }
                        case -2: {
                            object = this.parseNumber(streamTokenizer);
                            break;
                        }
                        default: {
                            throw new ParseException(MessageFormat.format(bundle.getString("EXC_ExpectedObject"), streamTokenizer.toString()), streamTokenizer.lineno());
                        }
                    }
                    this.parseChar(streamTokenizer, 59);
                    this.bindings.put(string, object);
                }
            }
            catch (EOFException eOFException) {
                return;
            }
        }

        public Object get(String string) {
            return this.bindings.get(string);
        }

        public Set getKeys() {
            return this.bindings.keySet();
        }

        public HashMap getBindings() {
            return this.bindings;
        }
    }

    abstract class Node {
        Node() {
        }

        public void parseChar(StreamTokenizer streamTokenizer, int n) throws IOException, ParseException {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != n) {
                char[] cArray = new char[]{(char)n};
                throw new ParseException(MessageFormat.format(bundle.getString("EXC_Expected"), new String(cArray), streamTokenizer.toString()), streamTokenizer.lineno());
            }
        }

        public Object parseNumber(StreamTokenizer streamTokenizer) throws IOException {
            String string = Double.toString(streamTokenizer.nval);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                while (streamTokenizer.ttype == -2) {
                    string = string + Double.toString(streamTokenizer.nval);
                    streamTokenizer.nextToken();
                }
                streamTokenizer.pushBack();
                return string;
            }
            streamTokenizer.pushBack();
            double d = Math.rint(streamTokenizer.nval);
            if (d == streamTokenizer.nval) {
                return new Integer((int)d);
            }
            return new Double(streamTokenizer.nval);
        }
    }
}

