/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;

public class TreeObjectListProxyListener
implements PropertyChangeListener {
    private final TreeObjectList list;
    private final Set listeners = new HashSet();

    public TreeObjectListProxyListener(TreeObjectList list) {
        this.list = list;
        list.addPropertyChangeListener(this);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TreeObject next = (TreeObject)it.next();
            if (next == null) continue;
            next.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object source = e.getSource();
        if (source == this.list) {
            TreeObject oldObject;
            if ("contentInsert".equals(name)) {
                TreeObject newObject = (TreeObject)e.getNewValue();
                if (newObject != null) {
                    newObject.addPropertyChangeListener(this);
                }
            } else if ("contentRemove".equals(name) && (oldObject = (TreeObject)e.getOldValue()) != null) {
                oldObject.removePropertyChangeListener(this);
            }
        }
        this.forward(e);
    }

    private void forward(PropertyChangeEvent e) {
        HashSet peers = new HashSet();
        Set set = this.listeners;
        synchronized (set) {
            peers.addAll(this.listeners);
        }
        Iterator it = peers.iterator();
        while (it.hasNext()) {
            PropertyChangeListener next = (PropertyChangeListener)it.next();
            if (next == null) continue;
            next.propertyChange(e);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            return;
        }
        this.listeners.add(l);
    }
}

