/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.beans.PropertyEditorSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.java.Util;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;

public class FileSystemPE
extends PropertyEditorSupport {
    private FileSystem fs;
    private String[] tags = null;
    private FileSystem[] fss = null;
    private static String INVALID_MSG = Util.getString("LABEL_TargetInvalid");
    private static String DEFAULT_MSG = Util.getString("LABEL_TargetDefault");

    private final FileSystem[] findUsableFilesystems() {
        Enumeration enumeration = FileSystemCapability.COMPILE.fileSystems();
        LinkedList<FileSystem> linkedList = null;
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (!this.canUseFilesystem(fileSystem)) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<FileSystem>();
            }
            linkedList.add(fileSystem);
        }
        return linkedList == null ? new FileSystem[]{} : linkedList.toArray(new FileSystem[linkedList.size()]);
    }

    protected boolean canUseFilesystem(FileSystem fileSystem) {
        return !fileSystem.isReadOnly() && !fileSystem.isDefault() && !fileSystem.isHidden() && fileSystem.isValid() && fileSystem.getCapability().capableOf(FileSystemCapability.COMPILE);
    }

    private synchronized void updateTags() {
        this.fss = this.findUsableFilesystems();
        this.tags = new String[this.fss.length + 1];
        int n = 0;
        while (n < this.fss.length) {
            this.tags[n + 1] = this.fss[n].getDisplayName();
            ++n;
        }
        this.tags[0] = DEFAULT_MSG;
    }

    public void setValue(Object object) {
        this.fs = (FileSystem)object;
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.fs;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public synchronized String[] getTags() {
        this.updateTags();
        return this.tags;
    }

    public String getAsText() {
        if (this.fs == null) {
            return DEFAULT_MSG;
        }
        if (this.fs == JavaCompilerType.TARGET_INVALID || !this.fs.isValid()) {
            return INVALID_MSG;
        }
        return this.fs.getDisplayName();
    }

    public synchronized void setAsText(String string) throws IllegalArgumentException {
        this.updateTags();
        if (string.equals(DEFAULT_MSG)) {
            this.setValue(null);
            return;
        }
        int n = 0;
        while (n < this.tags.length) {
            if (string.equals(this.tags[n])) {
                this.setValue(this.fss[n - 1]);
                return;
            }
            ++n;
        }
        throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("No such fs:" + string), MessageFormat.format(Util.getString("MSG_InvalidTargetFS"), string));
    }

    public static class Local
    extends FileSystemPE {
        protected boolean canUseFileSystem(FileSystem fileSystem) {
            File file = NbClassPath.toFile((FileObject)fileSystem.getRoot());
            return file != null && file.exists() && file.isDirectory();
        }
    }
}

