/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.imptool.BodyIdentifier;
import org.netbeans.modules.java.imptool.IdentifierNode;
import org.netbeans.modules.java.imptool.ImpDataSourceNode;
import org.netbeans.modules.java.imptool.ImpToolSettings;
import org.netbeans.modules.java.imptool.ImportLineNode;
import org.netbeans.modules.java.imptool.MethodParameterOwner;
import org.netbeans.modules.java.imptool.PackageNode;
import org.netbeans.modules.java.imptool.PackageResolver;
import org.netbeans.modules.java.imptool.SourceIdentifier;
import org.netbeans.modules.java.imptool.SourceIdentifiersList;
import org.netbeans.modules.java.imptool.SourceImport;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.PositionBounds;
import org.openide.util.SharedClassObject;

public class ImpDataSource {
    private TreeMap sourceIDMap;
    private TreeMap packageMap;
    private TreeMap idNodes;
    private HashMap dupSimpleNames;
    private HashSet topCLassNames;
    private ImpToolSettings impSetting;
    private JavaDataObject dataObject;
    private PackageResolver packageResolver;
    private SourceCookie.Editor sourceEditor;
    private JavaEditor javaEditor;
    private SourceElement sourceElement;
    private String sourceFilePackageName;
    private int stage = 0;
    private static final int FQN_STAGE = 1;
    private static final int IMPORT_STAGE = 2;
    private static final int RESOLVE_STAGE = 3;
    private static final int COMMIT_STAGE = 4;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaEditor;
    static /* synthetic */ Class class$org$netbeans$modules$java$imptool$ImpToolSettings;

    ImpDataSource(JavaDataObject javaDataObject, Collection collection) {
        Object object;
        Iterator iterator = collection.iterator();
        this.dataObject = javaDataObject;
        this.sourceEditor = (SourceCookie.Editor)javaDataObject.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = ImpDataSource.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
        this.javaEditor = (JavaEditor)javaDataObject.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = ImpDataSource.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor);
        this.sourceElement = javaDataObject.getSource();
        this.sourceIDMap = new TreeMap();
        this.packageMap = new TreeMap();
        this.idNodes = new TreeMap();
        this.dupSimpleNames = new HashMap();
        this.topCLassNames = new HashSet();
        this.impSetting = (ImpToolSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$java$imptool$ImpToolSettings == null ? (class$org$netbeans$modules$java$imptool$ImpToolSettings = ImpDataSource.class$("org.netbeans.modules.java.imptool.ImpToolSettings")) : class$org$netbeans$modules$java$imptool$ImpToolSettings), (boolean)true);
        ClassElement[] classElementArray = this.sourceElement.getAllClasses();
        Identifier identifier = this.sourceElement.getPackage();
        this.sourceFilePackageName = identifier != null ? identifier.getSourceName() : "";
        int n = 0;
        while (n < classElementArray.length) {
            FieldElement fieldElement;
            object = classElementArray[n];
            FieldElement[] fieldElementArray = object.getFields();
            ConstructorElement[] constructorElementArray = object.getConstructors();
            MethodElement[] methodElementArray = object.getMethods();
            Identifier identifier2 = object.getSuperclass();
            this.topCLassNames.add(object.getName().getFullName());
            if (!this.isGuarded((org.openide.src.Element)object)) {
                if (identifier2 != null) {
                    this.addIdentifier(identifier2, 1, object);
                }
                this.addIdentifierFromArray(object.getInterfaces(), 2, (org.openide.src.Element)object);
            }
            int n2 = 0;
            while (n2 < fieldElementArray.length) {
                fieldElement = fieldElementArray[n2];
                if (!this.isGuarded((org.openide.src.Element)fieldElement)) {
                    this.addIdentifierFromType(fieldElement.getType(), fieldElement);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < constructorElementArray.length) {
                fieldElement = constructorElementArray[n2];
                if (!this.isGuarded((org.openide.src.Element)fieldElement)) {
                    this.addIdentifierFromMethodParams((ConstructorElement)fieldElement);
                    this.addIdentifierFromArray(fieldElement.getExceptions(), 3, (org.openide.src.Element)fieldElement);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < methodElementArray.length) {
                fieldElement = methodElementArray[n2];
                if (!this.isGuarded((org.openide.src.Element)fieldElement)) {
                    this.addIdentifierFromMethodParams((ConstructorElement)fieldElement);
                    this.addIdentifierFromArray(fieldElement.getExceptions(), 3, (org.openide.src.Element)fieldElement);
                    this.addIdentifierFromType(fieldElement.getReturn(), fieldElement);
                }
                ++n2;
            }
            ++n;
        }
        while (iterator.hasNext()) {
            object = (BodyIdentifier)iterator.next();
            if (this.isGuardedIndetifier((BodyIdentifier)object)) continue;
            this.addIdentifier(((BodyIdentifier)object).getIdentifier(), 4, object);
        }
        Import[] importArray = this.sourceElement.getImports();
        n = 0;
        while (n < importArray.length) {
            object = new SourceImport(importArray[n]);
            ((SourceImport)object).setUsed(!this.impSetting.isRemoveImport());
            this.addImport((SourceImport)object);
            ++n;
        }
        if (this.impSetting.getResolveStrategy() == 1) {
            this.tryResolveIdetifiers();
        }
    }

    private void addIdentifierFromType(Type type, Object object) {
        if (type.isClass()) {
            this.addIdentifier(type.getTypeIdentifier(), 0, object);
        } else if (type.isArray()) {
            this.addIdentifierFromType(type.getElementType(), object);
        }
    }

    private void addIdentifierFromMethodParams(ConstructorElement constructorElement) {
        MethodParameter[] methodParameterArray = constructorElement.getParameters();
        int n = 0;
        while (n < methodParameterArray.length) {
            MethodParameterOwner methodParameterOwner = new MethodParameterOwner(constructorElement, n);
            this.addIdentifierFromType(methodParameterArray[n].getType(), methodParameterOwner);
            ++n;
        }
    }

    private void addIdentifierFromArray(Identifier[] identifierArray, int n, org.openide.src.Element element) {
        int n2 = 0;
        while (n2 < identifierArray.length) {
            this.addIdentifier(identifierArray[n2], n, element);
            ++n2;
        }
    }

    private void addIdentifier(Identifier identifier, int n, Object object) {
        if (this.onlySimpleNameAllowed(identifier)) {
            return;
        }
        SourceIdentifier sourceIdentifier = new SourceIdentifier(identifier, n, object);
        this.addObjectToMap(this.sourceIDMap, sourceIdentifier.getPackage(), sourceIdentifier.getName(), sourceIdentifier);
        if (identifier.getResolutionStatus() == 2) {
            String string = identifier.getSourceName();
            IdentifierNode identifierNode = (IdentifierNode)((Object)this.idNodes.get(string));
            if (identifierNode == null) {
                SourceIdentifiersList sourceIdentifiersList = new SourceIdentifiersList(this);
                sourceIdentifiersList.addSourceIdentifier(sourceIdentifier);
                identifierNode = new IdentifierNode(sourceIdentifiersList);
                this.idNodes.put(string, identifierNode);
            } else {
                identifierNode.add(sourceIdentifier);
            }
        }
    }

    private void addImport(SourceImport sourceImport) {
        String string = sourceImport.getPackage();
        String string2 = sourceImport.isPackage() ? "*" : sourceImport.getName();
        TreeMap<String, SourceImport> treeMap = (TreeMap<String, SourceImport>)this.packageMap.get(string);
        if (treeMap == null) {
            treeMap = new TreeMap<String, SourceImport>();
            this.packageMap.put(string, treeMap);
        }
        treeMap.put(string2, sourceImport);
    }

    private void addObjectToMap(TreeMap treeMap, String string, String string2, SourceIdentifier sourceIdentifier) {
        SourceIdentifiersList sourceIdentifiersList;
        TreeMap<String, SourceIdentifiersList> treeMap2 = (TreeMap<String, SourceIdentifiersList>)treeMap.get(string);
        if (treeMap2 == null) {
            treeMap2 = new TreeMap<String, SourceIdentifiersList>();
            treeMap.put(string, treeMap2);
        }
        if ((sourceIdentifiersList = (SourceIdentifiersList)treeMap2.get(string2)) == null) {
            sourceIdentifiersList = new SourceIdentifiersList(this);
            treeMap2.put(string2, sourceIdentifiersList);
        }
        sourceIdentifiersList.addSourceIdentifier(sourceIdentifier);
    }

    private void checkDupNames(HashMap hashMap, SourceIdentifiersList sourceIdentifiersList) {
        if (sourceIdentifiersList.count() == 0) {
            return;
        }
        String string = sourceIdentifiersList.getName();
        List list = (List)this.dupSimpleNames.get(string);
        if (list != null) {
            list.add(sourceIdentifiersList);
        } else {
            SourceIdentifiersList sourceIdentifiersList2 = (SourceIdentifiersList)hashMap.get(string);
            if (sourceIdentifiersList2 != null) {
                ArrayList<SourceIdentifiersList> arrayList = new ArrayList<SourceIdentifiersList>();
                arrayList.add(sourceIdentifiersList2);
                arrayList.add(sourceIdentifiersList);
                this.dupSimpleNames.put(string, arrayList);
            } else {
                hashMap.put(string, sourceIdentifiersList);
            }
        }
    }

    private boolean isImplicitlyImported(String string) {
        if (string == "") {
            return true;
        }
        if (string.equals("java.lang")) {
            return true;
        }
        return string.equals(this.sourceFilePackageName);
    }

    private boolean onlySimpleNameAllowed(Identifier identifier) {
        if (identifier.getResolutionStatus() != 1) {
            return false;
        }
        String string = identifier.getFullName();
        if (!string.startsWith(this.sourceFilePackageName)) {
            return false;
        }
        Iterator iterator = this.topCLassNames.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    ImpDataSourceNode createRootFQNNode() {
        Node[] nodeArray = new Node[]{};
        Children.Array array = new Children.Array();
        array.add(this.idNodes.values().toArray(nodeArray));
        this.stage = 1;
        return new ImpDataSourceNode((Children)array, 0);
    }

    ImpDataSourceNode createRootImportNode() {
        Node[] nodeArray = new Node[]{};
        Children.Array array = new Children.Array();
        Iterator iterator = this.sourceIDMap.keySet().iterator();
        ArrayList<PackageNode> arrayList = new ArrayList<PackageNode>();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == "") continue;
            boolean bl = this.isImplicitlyImported(string);
            TreeMap treeMap = (TreeMap)this.sourceIDMap.get(string);
            Iterator iterator2 = treeMap.values().iterator();
            while (iterator2.hasNext()) {
                SourceIdentifiersList sourceIdentifiersList = (SourceIdentifiersList)iterator2.next();
                this.checkDupNames(hashMap, sourceIdentifiersList);
                arrayList.add(new PackageNode(sourceIdentifiersList));
                if (bl) continue;
                this.setFQNDefaultFlagFor(sourceIdentifiersList);
            }
        }
        array.add(arrayList.toArray(nodeArray));
        this.stage = 2;
        return new ImpDataSourceNode((Children)array, 1);
    }

    ImpDataSourceNode createRootResolveNode() {
        Children.Array array = new Children.Array();
        int n = 0;
        this.mergeSourceIDToPackages();
        Collection collection = this.packageMap.values();
        Iterator iterator = collection.iterator();
        Node[] nodeArray = new Node[collection.size()];
        while (iterator.hasNext()) {
            TreeMap treeMap = (TreeMap)iterator.next();
            nodeArray[n++] = ImportLineNode.createPackageNode(treeMap.values());
        }
        array.add(nodeArray);
        this.stage = 3;
        return new ImpDataSourceNode((Children)array, 2);
    }

    void setPackage(String string, SourceIdentifier sourceIdentifier) {
        TreeMap treeMap = (TreeMap)this.sourceIDMap.get(sourceIdentifier.getPackage());
        String string2 = sourceIdentifier.getName();
        if (treeMap == null) {
            throw new IllegalArgumentException("Package TreeMap mismatch");
        }
        SourceIdentifiersList sourceIdentifiersList = (SourceIdentifiersList)treeMap.get(string2);
        if (sourceIdentifiersList == null) {
            throw new IllegalArgumentException("Name TreeMap mismatch");
        }
        if (!sourceIdentifiersList.removeSourceIdentifier(sourceIdentifier)) {
            throw new IllegalArgumentException("Array mismatch");
        }
        if (sourceIdentifiersList.count() == 0) {
            treeMap.remove(string2);
        }
        sourceIdentifier.setPackage(string);
        this.addObjectToMap(this.sourceIDMap, string, string2, sourceIdentifier);
    }

    void setFQNDefaultFlagFor(SourceIdentifiersList sourceIdentifiersList) {
        int n = sourceIdentifiersList.count();
        int n2 = n > this.impSetting.getMaxFqn() ? 2 : 1;
        sourceIdentifiersList.setFQNFlag(n2);
    }

    void mergeSourceIDToPackages() {
        SourceImport sourceImport;
        TreeMap treeMap;
        Object object;
        Iterator iterator = this.sourceIDMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isImplicitlyImported(string)) continue;
            object = (TreeMap)this.packageMap.get(string);
            treeMap = (TreeMap)this.sourceIDMap.get(string);
            Iterator iterator2 = treeMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                SourceIdentifiersList sourceIdentifiersList = (SourceIdentifiersList)treeMap.get(string2);
                if (sourceIdentifiersList.reallyUseFQN()) continue;
                sourceImport = null;
                if (object != null) {
                    sourceImport = (SourceImport)((TreeMap)object).get(string2);
                }
                if (sourceImport == null) {
                    sourceImport = new SourceImport(string, string2);
                    this.addImport(sourceImport);
                }
                sourceImport.setUsed(true);
            }
        }
        Iterator iterator3 = this.packageMap.keySet().iterator();
        while (iterator3.hasNext()) {
            object = (String)iterator3.next();
            treeMap = (TreeMap)this.packageMap.get(object);
            if (treeMap.get("*") == null) {
                sourceImport = new SourceImport((String)object, "*");
                sourceImport.setUsed(false);
                this.addImport(sourceImport);
            }
            this.setUseDefaultFlagFor(treeMap);
        }
    }

    void setUseDefaultFlagFor(TreeMap treeMap) {
        Iterator iterator = treeMap.values().iterator();
        int n = 0;
        SourceImport sourceImport = null;
        while (iterator.hasNext()) {
            SourceImport sourceImport2 = (SourceImport)iterator.next();
            if (sourceImport2.isPackage()) {
                sourceImport = sourceImport2;
                continue;
            }
            if (!sourceImport2.isUse()) continue;
            ++n;
        }
        if (sourceImport != null) {
            if (n > this.impSetting.getSingleImports()) {
                sourceImport.setUse(true);
            } else {
                sourceImport.setUse(false);
            }
        }
    }

    void commitIdentifiers() throws SourceException, IOException, BadLocationException {
        Iterator iterator = this.sourceIDMap.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((TreeMap)iterator.next()).values().iterator();
            while (iterator2.hasNext()) {
                SourceIdentifiersList sourceIdentifiersList = (SourceIdentifiersList)iterator2.next();
                sourceIdentifiersList.commit();
            }
        }
    }

    void commitImports() throws SourceException {
        Iterator iterator = this.packageMap.values().iterator();
        ArrayList arrayList = new ArrayList();
        Import[] importArray = new Import[]{};
        while (iterator.hasNext()) {
            TreeMap treeMap = (TreeMap)iterator.next();
            SourceImport sourceImport = (SourceImport)treeMap.get("*");
            if (this.addImportToList(arrayList, sourceImport)) continue;
            Iterator iterator2 = treeMap.values().iterator();
            while (iterator2.hasNext()) {
                this.addImportToList(arrayList, (SourceImport)iterator2.next());
            }
        }
        importArray = arrayList.toArray(importArray);
        this.dataObject.getSource().setImports(importArray);
    }

    private void commitAllChanges() {
        final Exception[] exceptionArray = new Exception[]{null};
        this.dataObject.suspendSupports();
        try {
            this.sourceElement.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        ImpDataSource.this.commitIdentifiers();
                        ImpDataSource.this.commitImports();
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                    }
                }
            });
        }
        catch (SourceException sourceException) {
            exceptionArray[0] = sourceException;
        }
        this.dataObject.resumeSupports();
        if (exceptionArray[0] != null) {
            ErrorManager.getDefault().notify((Throwable)exceptionArray[0]);
        }
    }

    private boolean addImportToList(List list, SourceImport sourceImport) {
        if (sourceImport.isUse()) {
            list.add(sourceImport.getImport());
            return true;
        }
        return false;
    }

    private Collection getAllPackages() {
        String[] stringArray = this.impSetting.getResolvePlaces();
        HashSet hashSet = new HashSet(this.sourceIDMap.keySet());
        Set set = this.packageMap.keySet();
        hashSet.remove("");
        set.remove("");
        hashSet.addAll(set);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.length() > 0) {
                hashSet.add(string);
            }
            ++n;
        }
        return hashSet;
    }

    PackageResolver getPackageResolver() {
        if (this.packageResolver == null) {
            this.packageResolver = new PackageResolver(this.getAllPackages());
        }
        return this.packageResolver;
    }

    Collection getDupSimpleName(String string) {
        return (Collection)this.dupSimpleNames.get(string);
    }

    private void tryResolveIdetifiers() {
        TreeMap treeMap = (TreeMap)this.sourceIDMap.get("");
        if (treeMap != null) {
            treeMap = (TreeMap)treeMap.clone();
            Iterator iterator = treeMap.values().iterator();
            PackageResolver packageResolver = this.getPackageResolver();
            while (iterator.hasNext()) {
                SourceIdentifiersList sourceIdentifiersList = (SourceIdentifiersList)iterator.next();
                String string = packageResolver.getPackageForClass(sourceIdentifiersList.getName());
                if (string == null) continue;
                sourceIdentifiersList.setPackage(string);
            }
        }
    }

    void runSilentFromNextStage() {
        switch (this.stage + 1) {
            case 1: {
                this.createRootFQNNode();
            }
            case 2: {
                this.createRootImportNode();
            }
            case 3: {
                this.createRootResolveNode();
            }
            case 4: {
                this.commitAllChanges();
            }
        }
    }

    private boolean isGuarded(org.openide.src.Element element) {
        if (this.sourceEditor != null && this.javaEditor != null) {
            PositionBounds positionBounds;
            Element element2 = this.sourceEditor.sourceToText(element);
            int n = element2.getStartOffset();
            int n2 = element2.getEndOffset() - 1;
            if (!element2.isLeaf()) {
                Element element3 = element2.getElement(0);
                n2 = element3.getStartOffset() - 1;
            }
            return !this.javaEditor.testOverlap(positionBounds = this.javaEditor.createBounds(n, n2, true));
        }
        return false;
    }

    private boolean isGuardedIndetifier(BodyIdentifier bodyIdentifier) {
        if (this.javaEditor != null) {
            return !this.javaEditor.testOverlap(bodyIdentifier.getBounds());
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

