/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.java.tools.ElementFilter;
import org.netbeans.modules.java.tools.ElementRenderer;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.netbeans.modules.java.tools.OverrideAction;
import org.netbeans.modules.java.tools.SuperclassList;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.src.ElementFormat;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;

public class OverridePanelBase
extends JPanel
implements ListSelectionListener,
PropertyChangeListener {
    private static final Identifier JAVA_LANG_OBJECT = Identifier.create((String)"java.lang.Object");
    private InheritanceSupport support;
    private SuperclassList superclassList;
    private ListCellRenderer selectedRenderer;
    private ElementFilter.Method overrideFilter;
    private Comparator overrideComparator;
    private DefaultListModel overrideModel;
    private int buttonPanelWidth = -1;
    private boolean initialized;
    protected static final ElementFormat FORMAT_AVAILABLE = new ElementFormat(OverrideAction.getString("FMT_DefaultMethodFormat"));
    private JCheckBox onlyAbstract;
    private JList availableList;
    private JPanel firstPanel;
    private JPanel selectedPanel;
    private JButton selectAllMethods;
    private JButton overrideButton;
    private JPanel showOptions;
    private JCheckBox generateSuper;
    private JCheckBox includeInherited;
    private JPanel secondPanel;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane1;
    private JPanel jPanel4;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JList overrideList;
    private JPanel availablePanel;
    private JButton selectAll;
    private JPanel superclassHolder;
    private JPanel thirdPanel;
    private JButton removeButton;

    public OverridePanelBase(InheritanceSupport inheritanceSupport) {
        this.support = inheritanceSupport;
    }

    private static ResourceBundle getBundle() {
        return OverrideAction.getBundle();
    }

    protected void initializeGUI() {
        if (this.initialized) {
            return;
        }
        this.initComponents();
        this.addEtchedBorder(this.firstPanel, OverrideAction.getString("LAB_InheritedClasses"));
        this.addEtchedBorder(this.secondPanel, OverrideAction.getString("LAB_OverridableMethods"));
        this.addEtchedBorder(this.thirdPanel, OverrideAction.getString("LAB_SelectedMethods"));
        this.showOptions.setBorder(new CompoundBorder(new TitledBorder(OverridePanelBase.getBundle().getString("LAB_Options")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.superclassList = new SuperclassList();
        this.superclassHolder.add((Component)this.superclassList, "Center");
        this.superclassList.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("selectedNodes".equals(string)) {
                    OverridePanelBase.this.refreshAvailableMethods();
                }
            }
        });
        this.selectedRenderer = new ElementRenderer(this.getAvailableMethodsFormat());
        this.overrideFilter = new DefaultMethodFilter();
        this.overrideComparator = new DefaultMethodComparator();
        this.overrideList.setCellRenderer(this.selectedRenderer);
        this.availableList.setCellRenderer(this.selectedRenderer);
        this.availableList.addListSelectionListener(this);
        this.availableList.addPropertyChangeListener(this);
        this.overrideList.addListSelectionListener(this);
        this.overrideList.addPropertyChangeListener(this);
        this.initAccessibility();
        Dimension dimension = this.jPanel3.getPreferredSize();
        this.buttonPanelWidth = dimension.width;
        dimension = this.jPanel4.getPreferredSize();
        if (this.buttonPanelWidth < dimension.width) {
            this.buttonPanelWidth = dimension.width;
        }
        dimension = this.jPanel2.getPreferredSize();
        if (this.buttonPanelWidth < dimension.width) {
            this.buttonPanelWidth = dimension.width;
        }
        this.initialized = true;
    }

    public boolean isGenerateSuperCall() {
        return this.generateSuper.isSelected();
    }

    protected ElementFormat getAvailableMethodsFormat() {
        return FORMAT_AVAILABLE;
    }

    public void addNotify() {
        this.superclassList.setData(this.support);
        this.overrideList.setModel(this.createOverrideModel());
        super.addNotify();
    }

    protected InheritanceSupport getSupport() {
        return this.support;
    }

    protected void setSupport(InheritanceSupport inheritanceSupport) {
        this.support = inheritanceSupport;
    }

    private void addEtchedBorder(JPanel jPanel, String string) {
        TitledBorder titledBorder = new TitledBorder(string);
        titledBorder.setBorder(new EtchedBorder(1));
        jPanel.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(new Insets(8, 8, 8, 8))));
    }

    protected ListModel createOverrideModel() {
        this.overrideModel = this.createFilterModel(this.support.getOverridingMethods(), this.overrideFilter, this.overrideComparator);
        return this.overrideModel;
    }

    protected Comparator getAvailableMethodsComparator() {
        return this.overrideComparator;
    }

    protected ElementFilter.Method getAvailableMethodsFilter(boolean bl, final boolean bl2) {
        if (bl) {
            return new ElementFilter.Method(){

                public boolean accept(MethodElement methodElement) {
                    boolean bl = OverridePanelBase.this.support.isOverridable(methodElement);
                    if (bl2) {
                        bl &= !OverridePanelBase.this.support.isImplemented(methodElement);
                    }
                    return bl;
                }
            };
        }
        return new ElementFilter.Method(){

            public boolean accept(MethodElement methodElement) {
                boolean bl;
                boolean bl22 = bl = OverridePanelBase.this.support.isOverridable(methodElement) && OverridePanelBase.this.support.isDeclaredFirst(methodElement, methodElement.getDeclaringClass());
                if (bl2) {
                    bl &= !OverridePanelBase.this.support.isImplemented(methodElement);
                }
                return bl;
            }
        };
    }

    protected void refreshAvailableMethods() {
        boolean bl = this.includeInherited.isSelected();
        ElementFilter.Method method = this.getAvailableMethodsFilter(bl, this.onlyAbstract.isSelected());
        Collection collection = this.superclassList.getSelectedClasses();
        Collection collection2 = this.support.collectMethods(collection, bl, method);
        TreeSet treeSet = new TreeSet(this.getAvailableMethodsComparator());
        treeSet.addAll(collection2);
        DefaultListModel defaultListModel = new DefaultListModel();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        this.availableList.setModel(defaultListModel);
    }

    protected DefaultListModel createFilterModel(Collection collection, ElementFilter.Method method, Comparator comparator) {
        DefaultListModel defaultListModel = new DefaultListModel();
        TreeSet<MethodElement> treeSet = new TreeSet<MethodElement>(comparator);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement = (MethodElement)iterator.next();
            if (!method.accept(methodElement)) continue;
            treeSet.add(methodElement);
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        return defaultListModel;
    }

    protected void overrideMethod(MethodElement methodElement) throws SourceException {
        int n = 0;
        while (n < this.overrideModel.getSize()) {
            if (this.overrideComparator.compare(this.overrideModel.getElementAt(n), methodElement) < 0) break;
            ++n;
        }
        this.overrideModel.insertElementAt(methodElement, n);
    }

    protected void removeMethod(MethodElement methodElement) throws SourceException {
        this.overrideList.getSelectionModel().clearSelection();
        this.overrideModel.removeElement(methodElement);
    }

    private void selectAllSuperclasses() {
        ExplorerManager explorerManager = this.superclassList.getExplorerManager();
        Node[] nodeArray = explorerManager.getExploredContext().getChildren().getNodes();
        try {
            explorerManager.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void unselectAllSuperclasses() {
        ExplorerManager explorerManager = this.superclassList.getExplorerManager();
        Node[] nodeArray = new Node[]{};
        try {
            explorerManager.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void removeSelectedMethods() {
        Object[] objectArray = this.overrideList.getSelectedValues();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        try {
            int n = 0;
            while (n < objectArray.length) {
                MethodElement methodElement = (MethodElement)objectArray[n];
                this.removeMethod(methodElement);
                ++n;
            }
        }
        catch (SourceException sourceException) {
            ErrorManager.getDefault().notify((Throwable)sourceException);
        }
    }

    protected void overrideSelectedMethods() {
        Object[] objectArray = this.availableList.getSelectedValues();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            MethodElement methodElement = (MethodElement)objectArray[n];
            try {
                this.overrideMethod(methodElement);
            }
            catch (SourceException sourceException) {
                ErrorManager.getDefault().notify((Throwable)sourceException);
            }
            ++n;
        }
    }

    private void initComponents() {
        this.firstPanel = new JPanel();
        this.superclassHolder = new JPanel();
        this.jPanel3 = new CommonSizePanel();
        this.selectAll = new JButton();
        this.secondPanel = new JPanel();
        this.availablePanel = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.availableList = new JList();
        this.jPanel2 = new CommonSizePanel();
        this.showOptions = new JPanel();
        this.includeInherited = new JCheckBox();
        this.onlyAbstract = new JCheckBox();
        this.selectAllMethods = new JButton();
        this.overrideButton = new JButton();
        this.thirdPanel = new JPanel();
        this.selectedPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.overrideList = new JList();
        this.jPanel4 = new CommonSizePanel();
        this.removeButton = new JButton();
        this.generateSuper = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(700, 550));
        this.firstPanel.setLayout(new GridBagLayout());
        this.superclassHolder.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.firstPanel.add((Component)this.superclassHolder, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setPreferredSize(new Dimension(124, 157));
        this.jPanel3.setMinimumSize(new Dimension(124, 33));
        this.selectAll.setToolTipText(OverridePanelBase.getBundle().getString("ACS_SelectAllAncestorsA11yDesc"));
        this.selectAll.setMnemonic(OverridePanelBase.getBundle().getString("CTL_selectAllAncestors").charAt(0));
        this.selectAll.setText(OverridePanelBase.getBundle().getString("BTN_SelectAllAncestors"));
        this.selectAll.setPreferredSize(new Dimension(90, 27));
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanelBase.this.selectAllActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel3.add((Component)this.selectAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.firstPanel.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.5;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.firstPanel, gridBagConstraints);
        this.secondPanel.setLayout(new GridBagLayout());
        this.availablePanel.setLayout(new GridBagLayout());
        this.jScrollPane3.setPreferredSize(new Dimension(200, 100));
        this.jScrollPane3.setViewportView(this.availableList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.availablePanel.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.secondPanel.add((Component)this.availablePanel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.showOptions.setLayout(new BoxLayout(this.showOptions, 1));
        this.includeInherited.setToolTipText(OverridePanelBase.getBundle().getString("ACS_ShowInheritedMethodsA11yDesc"));
        this.includeInherited.setMnemonic(OverridePanelBase.getBundle().getString("CTL_includeInherited").charAt(0));
        this.includeInherited.setText(OverridePanelBase.getBundle().getString("BTN_ShowInheritedMethods"));
        this.includeInherited.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanelBase.this.includeInheritedActionPerformed(actionEvent);
            }
        });
        this.showOptions.add(this.includeInherited);
        this.onlyAbstract.setToolTipText(OverridePanelBase.getBundle().getString("ACS_ShowOnlyAbstractMethodsA11yDesc"));
        this.onlyAbstract.setMnemonic(OverridePanelBase.getBundle().getString("CTL_onlyAbstract").charAt(0));
        this.onlyAbstract.setText(OverridePanelBase.getBundle().getString("BTN_ShowOnlyAbstractMethods"));
        this.onlyAbstract.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanelBase.this.onlyAbstractActionPerformed(actionEvent);
            }
        });
        this.showOptions.add(this.onlyAbstract);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel2.add((Component)this.showOptions, gridBagConstraints);
        this.selectAllMethods.setToolTipText(OverridePanelBase.getBundle().getString("ACS_SelectAllAvailableMethodsA11yDesc"));
        this.selectAllMethods.setMnemonic(OverridePanelBase.getBundle().getString("CTL_selectAllMethods").charAt(0));
        this.selectAllMethods.setText(OverridePanelBase.getBundle().getString("BTN_SelectAllAvailableMethods"));
        this.selectAllMethods.setPreferredSize(new Dimension(90, 27));
        this.selectAllMethods.setEnabled(false);
        this.selectAllMethods.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanelBase.this.selectAllMethodsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.selectAllMethods, gridBagConstraints);
        this.overrideButton.setToolTipText(OverridePanelBase.getBundle().getString("ACS_OverrideMethodA11yDesc"));
        this.overrideButton.setMnemonic(OverridePanelBase.getBundle().getString("CTL_overrideButton").charAt(0));
        this.overrideButton.setText(OverridePanelBase.getBundle().getString("BTN_OverrideMethod"));
        this.overrideButton.setPreferredSize(new Dimension(90, 27));
        this.overrideButton.setEnabled(false);
        this.overrideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanelBase.this.overrideButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.overrideButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.secondPanel.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        this.add((Component)this.secondPanel, gridBagConstraints);
        this.thirdPanel.setLayout(new GridBagLayout());
        this.selectedPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(200, 100));
        this.jScrollPane1.setViewportView(this.overrideList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.selectedPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.thirdPanel.add((Component)this.selectedPanel, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setPreferredSize(new Dimension(124, 157));
        this.jPanel4.setMinimumSize(new Dimension(124, 37));
        this.removeButton.setToolTipText(OverridePanelBase.getBundle().getString("ACS_RemoveOverridenMethodA11yDesc"));
        this.removeButton.setMnemonic(OverridePanelBase.getBundle().getString("CTL_removeButton").charAt(0));
        this.removeButton.setText(OverridePanelBase.getBundle().getString("BTN_RemoveOverridenMethod"));
        this.removeButton.setPreferredSize(new Dimension(90, 27));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanelBase.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.thirdPanel.add((Component)this.jPanel4, gridBagConstraints);
        this.generateSuper.setToolTipText(OverridePanelBase.getBundle().getString("ACS_GenerateSuperCallA11yDesc"));
        this.generateSuper.setMnemonic(OverridePanelBase.getBundle().getString("CTL_generateSuper").charAt(0));
        this.generateSuper.setSelected(true);
        this.generateSuper.setText(OverridePanelBase.getBundle().getString("BTN_GenerateSuperCall"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.thirdPanel.add((Component)this.generateSuper, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        this.add((Component)this.thirdPanel, gridBagConstraints);
    }

    private void overrideButtonActionPerformed(ActionEvent actionEvent) {
        this.overrideSelectedMethods();
    }

    private void onlyAbstractActionPerformed(ActionEvent actionEvent) {
        this.refreshAvailableMethods();
    }

    private void includeInheritedActionPerformed(ActionEvent actionEvent) {
        this.refreshAvailableMethods();
    }

    private void selectAllMethodsActionPerformed(ActionEvent actionEvent) {
        ListSelectionModel listSelectionModel = this.availableList.getSelectionModel();
        listSelectionModel.setSelectionInterval(0, this.availableList.getModel().getSize() - 1);
    }

    private void selectAllActionPerformed(ActionEvent actionEvent) {
        this.selectAllSuperclasses();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.overrideList.getSelectedValues();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        try {
            int n = 0;
            while (n < objectArray.length) {
                MethodElement methodElement = (MethodElement)objectArray[n];
                this.removeMethod(methodElement);
                ++n;
            }
        }
        catch (SourceException sourceException) {
            ErrorManager.getDefault().notify((Throwable)sourceException);
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_OverrideTool"));
        this.superclassHolder.getAccessibleContext().setAccessibleName(OverridePanelBase.getBundle().getString("ACSN_superclassHolder"));
        this.superclassHolder.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_superclassHolder"));
        this.availableList.getAccessibleContext().setAccessibleName(OverridePanelBase.getBundle().getString("ACSN_availableList"));
        this.availableList.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_availableList"));
        this.overrideList.getAccessibleContext().setAccessibleName(OverridePanelBase.getBundle().getString("ACSN_overrideList"));
        this.overrideList.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_overrideList"));
        this.selectAll.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_selectAll"));
        this.includeInherited.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_includeInherited"));
        this.onlyAbstract.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_onlyAbstract"));
        this.selectAllMethods.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_selectAllMethods"));
        this.overrideButton.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_overrideButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_removeButton"));
        this.generateSuper.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_generateSuper"));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.availableList) {
            boolean bl = !this.availableList.isSelectionEmpty();
            this.overrideButton.setEnabled(bl);
        } else if (listSelectionEvent.getSource() == this.overrideList) {
            boolean bl = !this.overrideList.isSelectionEmpty();
            this.removeButton.setEnabled(bl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"model".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (propertyChangeEvent.getSource() == this.availableList) {
            ListModel listModel = this.availableList.getModel();
            boolean bl = listModel.getSize() > 0;
            this.selectAllMethods.setEnabled(bl);
        }
    }

    private class CommonSizePanel
    extends JPanel {
        private CommonSizePanel() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (OverridePanelBase.this.buttonPanelWidth < 0) {
                return dimension;
            }
            dimension.width = OverridePanelBase.this.buttonPanelWidth;
            return dimension;
        }
    }

    private static class DefaultMethodComparator
    implements Comparator {
        private DefaultMethodComparator() {
        }

        public int compare(Object object, Object object2) {
            MethodElement methodElement = (MethodElement)object;
            MethodElement methodElement2 = (MethodElement)object2;
            if (methodElement == methodElement2) {
                return 0;
            }
            int n = methodElement.getName().getSourceName().compareTo(methodElement2.getName().getSourceName());
            if (n != 0) {
                return n;
            }
            n = methodElement.getParameters().length - methodElement2.getParameters().length;
            if (n != 0) {
                return n;
            }
            MethodParameter[] methodParameterArray = methodElement.getParameters();
            MethodParameter[] methodParameterArray2 = methodElement2.getParameters();
            int n2 = 0;
            while (n2 < methodParameterArray.length) {
                n = methodParameterArray[n2].getFullString().compareTo(methodParameterArray2[n2].getFullString());
                if (n != 0) {
                    return n;
                }
                ++n2;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return object instanceof DefaultMethodComparator;
        }
    }

    private static class DefaultMethodFilter
    implements ElementFilter.Method {
        private DefaultMethodFilter() {
        }

        public boolean accept(MethodElement methodElement) {
            return !Modifier.isAbstract(methodElement.getModifiers());
        }
    }
}

