/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.openorb.util.ZipHandle;
import org.openorb.util.ZipUtil;

public class ClassLoader
extends java.lang.ClassLoader {
    private Vector path_list = new Vector();
    private Hashtable used_archive = new Hashtable();

    public void addPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.path_list.addElement(string2);
            if (!string2.endsWith(".jar")) continue;
            this.addManifestReferences(string2);
        }
    }

    private void addManifestReferences(String string) {
        try {
            Manifest manifest = new JarFile(string).getManifest();
            String string2 = string.substring(0, string.lastIndexOf(File.separator) + 1);
            if (manifest == null) {
                return;
            }
            String string3 = manifest.getMainAttributes().getValue("Class-Path");
            if (string3 == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.path_list.addElement(string2 + stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        if (bl && clazz != null) {
            this.resolveClass(clazz);
        }
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    protected Class findClass(String string) {
        byte[] byArray = null;
        int n = 0;
        while (n < this.path_list.size()) {
            String string2 = (String)this.path_list.elementAt(n);
            if (string2.endsWith(".zip") || string2.endsWith(".jar") ? (byArray = this.loadClassFromArchive(string2, this.name_to_archive_class(string))) != null : (byArray = this.loadClassFromPath(string2, string)) != null) break;
            ++n;
        }
        if (byArray == null) {
            return null;
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    private byte[] loadClassFromArchive(String string, String string2) {
        try {
            boolean bl = false;
            ZipHandle zipHandle = (ZipHandle)this.used_archive.get(string);
            if (zipHandle == null) {
                try {
                    zipHandle = ZipUtil.OpenZip(string);
                    bl = true;
                }
                catch (IOException iOException) {
                    ZipUtil.CloseZip(zipHandle);
                    return null;
                }
            }
            if (!ZipUtil.containsFile(zipHandle, string2)) {
                if (bl) {
                    ZipUtil.CloseZip(zipHandle);
                }
                return null;
            }
            byte[] byArray = ZipUtil.getFileContent(zipHandle, string2);
            if (bl) {
                this.used_archive.put(string, zipHandle);
            }
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String name_to_archive_class(String string) {
        String string2 = string.replace('.', '/');
        return string2 + ".class";
    }

    private String name_to_class(String string) {
        String string2 = string.replace('.', File.separatorChar);
        return string2 + ".class";
    }

    private byte[] loadClassFromPath(String string, String string2) {
        File file;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!(file = new File(string + this.name_to_class(string2))).exists()) {
            return null;
        }
        try {
            long l;
            FileInputStream fileInputStream = new FileInputStream(file);
            long l2 = 0L;
            Vector<byte[]> vector = new Vector<byte[]>();
            byte[] byArray = null;
            while ((l = (long)fileInputStream.read(byArray = new byte[2048], 0, byArray.length)) != -1L) {
                l2 += l;
                byte[] byArray2 = new byte[(int)l];
                System.arraycopy(byArray, 0, byArray2, 0, (int)l);
                vector.addElement(byArray2);
            }
            fileInputStream.close();
            byte[] byArray3 = new byte[(int)l2];
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                byArray = (byte[])vector.elementAt(n2);
                System.arraycopy(byArray, 0, byArray3, n, byArray.length);
                n += byArray.length;
                ++n2;
            }
            return byArray3;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public URL getResource(String string) {
        try {
            URL uRL = java.lang.ClassLoader.getSystemClassLoader().getResource(string);
            if (uRL != null) {
                return uRL;
            }
            return this.findResource(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected URL findResource(String string) {
        try {
            String string2 = null;
            int n = 0;
            while (n < this.path_list.size()) {
                String string3 = (String)this.path_list.elementAt(n);
                if (string3.endsWith(".zip") || string3.endsWith(".jar")) {
                    string2 = this.loadResourceFromArchive(string3, string);
                    if (string2 != null) {
                        break;
                    }
                } else {
                    string2 = this.loadResourceFromPath(string3, string);
                    if (string2 == null) break;
                    break;
                }
                ++n;
            }
            if (string2 == null) {
                return null;
            }
            return new URL(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String loadResourceFromArchive(String string, String string2) {
        try {
            boolean bl = false;
            ZipHandle zipHandle = (ZipHandle)this.used_archive.get(string);
            if (zipHandle == null) {
                try {
                    zipHandle = ZipUtil.OpenZip(string);
                    bl = true;
                }
                catch (IOException iOException) {
                    ZipUtil.CloseZip(zipHandle);
                    return null;
                }
            }
            if (!ZipUtil.containsFile(zipHandle, string2)) {
                if (bl) {
                    ZipUtil.CloseZip(zipHandle);
                }
                return null;
            }
            return new String("jar:file:" + string + "!/" + string2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String name_to_resource(String string) {
        String string2 = string.replace('/', File.separatorChar);
        return string2;
    }

    private String loadResourceFromPath(String string, String string2) {
        File file;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!(file = new File(string + string2)).exists()) {
            return null;
        }
        return new String("file:" + file.getAbsolutePath());
    }
}

