/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.xerces.parsers.DOMParser;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.openorb.CORBA.kernel.Properties;
import org.openorb.ReleaseInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configurator {
    private Properties _props = new Properties();
    private static final String[] _specials = new String[]{"openorb.home", "openorb.config", "openorb.profile", "OpenORB", "openorb.dir", "Config", "Profile"};
    private URL _currDoc = null;
    private HashMap _initModules = new HashMap();
    private HashMap _parsedFiles = new HashMap();
    private HashMap _cmdLineAlias = new HashMap();
    private ArrayList _moduleInits = new ArrayList();
    private static final String CONFIG_NS = "http://www.openorb.org/config";
    private static final String CONFIG_DTD = "http://www.openorb.org/config/OpenORB.dtd";
    private static final String CONFIG_PUBLIC = "-//www.openorb.org//OpenORB Config//EN";
    private DOMParser _parser;

    public Configurator(String[] stringArray, java.util.Properties properties) {
        this.setupHandler();
        java.util.Properties properties2 = this.getORBProperties();
        this.parseSpecialArgs(stringArray, properties, properties2);
        this._currDoc = this.findRootConfig();
        this.handleXMLImport(this._currDoc);
        if (properties2 != null) {
            this.addProperties("", properties2);
        }
        java.util.Properties properties3 = null;
        try {
            properties3 = System.getProperties();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (properties3 != null) {
            this.addProperties("", properties3);
        }
        if (properties != null) {
            this.addProperties("", properties);
        }
        if (stringArray != null) {
            this._cmdLineAlias.put("SrvName", "openorb.server.alias");
            this._cmdLineAlias.put("Debug", "openorb.debug");
            this._cmdLineAlias.put("DefaultInitialReference", "openorb.defaultInitialReference");
            this.parseArgs(stringArray);
        }
        this.addProperties("openorb.version.", ReleaseInfo.getProperties());
    }

    public Properties getProperties() {
        return this._props;
    }

    public String[] getInitializers() {
        String[] stringArray = new String[this._moduleInits.size()];
        this._moduleInits.toArray(stringArray);
        return stringArray;
    }

    public URL addFragment(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.toString();
        int n = string2.indexOf(35);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (string == null) {
            return new URL(string2);
        }
        return new URL(string2 + '#' + string.toLowerCase());
    }

    private void addProperty(String string, String string2) {
        String string3 = string.toLowerCase();
        int n = 0;
        while (n < _specials.length) {
            if (string3.startsWith(_specials[n])) {
                return;
            }
            ++n;
        }
        if (string.startsWith("org.omg.PortableInterceptor.ORBInitializerClass")) {
            if (string.length() >= 48) {
                if (this._initModules.containsKey(string)) {
                    ((AbstractCollection)this._moduleInits).remove(this._initModules.get(string));
                }
                this._initModules.put(string, string2);
            }
            this._moduleInits.add(string2);
        } else if (string.startsWith("org.openorb.PI.FeatureInitializerClass")) {
            if (string.length() >= 39) {
                if (this._initModules.containsKey(string)) {
                    ((AbstractCollection)this._moduleInits).remove(this._initModules.get(string));
                }
                this._initModules.put(string, string2);
            }
            this._moduleInits.add(string2);
        } else if (string.startsWith("ImportModule")) {
            URL uRL;
            try {
                uRL = new URL(this._props.formatString(string2));
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL(this._props.formatString("${openorb.config}#" + string2));
                }
                catch (MalformedURLException malformedURLException2) {
                    throw new INITIALIZE("Malformed URL in ImportModule");
                }
            }
            this.handleURLImport(uRL);
        } else {
            this._props.addProperty(string, string2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addProperties(String var1_1, java.util.Properties var2_2) {
        if (var2_2 == null) {
            return;
        }
        try {
            var3_3 = var2_2.propertyNames();
            if (true) ** GOTO lbl15
        }
        catch (SecurityException var4_4) {
            return;
        }
        do {
            try {
                var4_5 = (String)var3_3.nextElement();
                this.addProperty(var1_1 + var4_5, var2_2.getProperty(var4_5));
            }
            catch (SecurityException var4_6) {
                // empty catch block
            }
lbl15:
            // 3 sources

        } while (var3_3.hasMoreElements());
    }

    private void setupHandler() {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs");
            if (string == null) {
                System.setProperty("java.protocol.handler.pkgs", "org.openorb.util.urlhandler");
            } else if (string.indexOf("java.protocol.handler.pkgs") < 0) {
                System.setProperty("java.protocol.handler.pkgs", string + "|" + "org.openorb.util.urlhandler");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private java.util.Properties getORBProperties() {
        String string;
        java.util.Properties properties = new java.util.Properties();
        try {
            string = System.getProperty("java.home");
        }
        catch (SecurityException securityException) {
            return null;
        }
        File file = new File(string + File.separator + "lib" + File.separator + "orb.properties");
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private URL parseURL(String string) {
        int n = (string = this._props.formatString(string)).lastIndexOf(35);
        if (n >= 0) {
            string = string.substring(0, n) + string.substring(n).toLowerCase();
        }
        try {
            return new URL(this._currDoc, string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private String parseSpecialArg(String string, String string2, String string3, String[] stringArray, java.util.Properties properties, java.util.Properties properties2) {
        String string4;
        if (stringArray != null) {
            int n = stringArray.length - 1;
            while (n >= 0) {
                if (stringArray[n] != null && stringArray[n].startsWith("-ORB")) {
                    int n2 = stringArray[n].indexOf(61);
                    if (n2 >= 0) {
                        string4 = stringArray[n].substring(4, n2);
                        if (string4.equals(string3) || string4.equalsIgnoreCase(string + "." + string2)) {
                            return stringArray[n].substring(n2 + 1);
                        }
                    } else if (stringArray.length >= n + 1) {
                        n2 = stringArray[n + 1].indexOf(61);
                        if (n2 >= 0) {
                            if (stringArray[n].substring(4).equalsIgnoreCase(string) && stringArray[n + 1].substring(0, n2).equalsIgnoreCase(string2)) {
                                return stringArray[n + 1].substring(n2 + 1);
                            }
                        } else {
                            string4 = stringArray[n].substring(4);
                            if (string4.equals(string3) || string4.equalsIgnoreCase(string + "." + string2)) {
                                return stringArray[n + 1];
                            }
                        }
                    }
                }
                --n;
            }
        }
        String string5 = string + "." + string2;
        if (properties != null && (string4 = properties.getProperty(string5)) != null) {
            return string4;
        }
        try {
            string4 = System.getProperty(string5);
            if (string4 != null) {
                return string4;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (properties2 != null) {
            return properties2.getProperty(string5);
        }
        return null;
    }

    private void parseSpecialArgs(String[] stringArray, java.util.Properties properties, java.util.Properties properties2) {
        URL uRL;
        String string = this.parseSpecialArg("openorb", "home", "OpenORB", stringArray, properties, properties2);
        if (string != null) {
            uRL = this.parseURL(string);
            if (uRL == null) {
                throw new INITIALIZE("Can't parse openorb.home property as a URL.");
            }
            this._props.addProperty("openorb.home", uRL);
        } else {
            try {
                this._props.addProperty("openorb.home", new URL("resource:/org/openorb/"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new INITIALIZE("Cannot create resource URL. Please set the openorb.home property.");
            }
        }
        string = this.parseSpecialArg("openorb", "config", "Config", stringArray, properties, properties2);
        if (string != null) {
            uRL = this.parseURL(string);
            if (uRL == null) {
                throw new INITIALIZE("Can't parse openorb.config property as a URL.");
            }
            this._props.addProperty("openorb.config", uRL);
        }
        if ((string = this.parseSpecialArg("openorb", "profile", "Profile", stringArray, properties, properties2)) != null) {
            this._props.addProperty("openorb.profile", string);
        }
    }

    private URL findRootConfigIn(String string, String string2, String string3) {
        File file = null;
        try {
            file = new File(System.getProperty(string), string2);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (file != null && file.exists()) {
            try {
                URL uRL = file.toURL();
                this._props.addProperty("openorb.config", uRL);
                if (string3 != null) {
                    uRL = this.addFragment(uRL, string3);
                }
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private URL findRootConfig() {
        String string = this._props.getStringProperty("openorb.profile", null);
        URL uRL = this._props.getURLProperty("openorb.config", null);
        if (uRL != null) {
            if (uRL.getRef() == null && string != null) {
                try {
                    uRL = this.addFragment(uRL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new INITIALIZE("Unable to parse profile from openorb.profile");
                }
            }
            return uRL;
        }
        uRL = this.findRootConfigIn("user.dir", "OpenORB.xml", string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.findRootConfigIn("user.home", "OpenORB.xml", string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.findRootConfigIn("user.home", ".OpenORB.xml", string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.findRootConfigIn("java.home", "OpenORB.xml", string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this._props.getURLProperty("openorb.home", null);
        if (uRL != null) {
            try {
                uRL = new URL(uRL, "config/OpenORB.xml");
                this._props.addProperty("openorb.config", uRL);
                if (string != null) {
                    uRL = this.addFragment(uRL, string);
                }
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        throw new INITIALIZE("Unable to locate OpenORB.xml");
    }

    private String handleURLImport(URL uRL) {
        String string = uRL.getFile();
        if (string.endsWith(".properties")) {
            return this.handlePropertiesImport(uRL);
        }
        if (string.endsWith(".xml")) {
            return this.handleXMLImport(uRL);
        }
        throw new INITIALIZE("Unknown type for URL \"" + uRL + "\"");
    }

    private String handlePropertiesImport(URL uRL) {
        if (this._initModules.containsKey(uRL)) {
            return uRL.getRef();
        }
        try {
            java.util.Properties properties = new java.util.Properties();
            properties.load(uRL.openStream());
            this._initModules.put(uRL, null);
            String string = uRL.getRef();
            if (string == null) {
                this.addProperties("", properties);
            } else {
                this.addProperties(string + ".", properties);
            }
            return string;
        }
        catch (IOException iOException) {
            throw new INITIALIZE("Unable to read properties file from URL \"" + uRL + "\"");
        }
    }

    private Document parseXML(URL uRL) {
        Document document = (Document)this._parsedFiles.get(uRL);
        if (document != null) {
            return document;
        }
        if (this._parser == null) {
            this._parser = new DOMParser();
            this._parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    if (Configurator.CONFIG_PUBLIC.equals(string)) {
                        URL uRL = Configurator.this.parseURL("${openorb.home}config/OpenORB.dtd");
                        InputSource inputSource = new InputSource(uRL.toString());
                        try {
                            inputSource.setByteStream(uRL.openStream());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return inputSource;
                    }
                    return null;
                }
            });
        }
        try {
            this._parser.parse(uRL.toString());
        }
        catch (SAXException sAXException) {
            throw new INITIALIZE("Exception while parsing XML File \"" + uRL + "\" :" + sAXException.toString());
        }
        catch (IOException iOException) {
            throw new INITIALIZE("IOException while parsing XML File \"" + uRL + "\" :" + iOException.toString());
        }
        document = this._parser.getDocument();
        this._parsedFiles.put(uRL, document);
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleXMLImport(URL uRL) {
        String string;
        URL uRL2;
        block37: {
            String string2;
            block36: {
                Object object;
                block35: {
                    String string3;
                    block34: {
                        uRL2 = this._currDoc;
                        try {
                            Element element;
                            Object object2;
                            this._currDoc = uRL;
                            String string4 = uRL.getRef();
                            if (string4 != null) {
                                if (this._initModules.containsKey(uRL)) {
                                    if (this._initModules.get(uRL) == null) {
                                        String string5 = null;
                                        Object var12_7 = null;
                                        this._currDoc = uRL2;
                                        return string5;
                                    }
                                    string3 = string4;
                                    break block34;
                                }
                                try {
                                    this._currDoc = this.addFragment(uRL, null);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    throw new INTERNAL();
                                }
                            }
                            Document document = this.parseXML(this._currDoc);
                            Element element2 = document.getDocumentElement();
                            if (string4 == null) {
                                object2 = null;
                                try {
                                    object2 = System.getProperty("user.name");
                                }
                                catch (SecurityException securityException) {
                                    // empty catch block
                                }
                                if (object2 != null) {
                                    object = element2.getElementsByTagName("associations");
                                    switch (object.getLength()) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            object = ((Element)object.item(0)).getElementsByTagName("association");
                                            int n = 0;
                                            while (n < object.getLength() && string4 == null) {
                                                element = (Element)object.item(n);
                                                if (!element.hasAttribute("profile")) {
                                                    throw new INITIALIZE("Association in \"" + this._currDoc + "\" is missing profile.");
                                                }
                                                StringTokenizer stringTokenizer = new StringTokenizer(element.getAttribute("user"));
                                                while (stringTokenizer.hasMoreTokens()) {
                                                    if (!stringTokenizer.nextToken().equals(object2)) continue;
                                                    string4 = element.getAttribute("profile");
                                                    break;
                                                }
                                                ++n;
                                            }
                                            break;
                                        }
                                        default: {
                                            throw new INITIALIZE("Document \"" + this._currDoc + "\" has multiple associaton elements.");
                                        }
                                    }
                                }
                                if (string4 == null) {
                                    string4 = element2.hasAttribute("profile") ? element2.getAttribute("profile") : "default";
                                }
                                try {
                                    uRL = this.addFragment(uRL, string4);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    throw new INITIALIZE("Unable to parse default profile name from \"" + this._currDoc + "\"");
                                }
                                if (this._initModules.containsKey(uRL)) {
                                    if (this._initModules.get(uRL) == null) {
                                        object = null;
                                        break block35;
                                    }
                                    string2 = string4;
                                    break block36;
                                }
                            }
                            if (element2.hasAttribute("xml:base")) {
                                try {
                                    this._currDoc = new URL(this._currDoc, this._props.formatString(element2.getAttribute("xml:base")));
                                }
                                catch (MalformedURLException malformedURLException) {
                                    throw new INITIALIZE("The xml:base attribute of the xml file \"" + this._currDoc + "\" cannot be parsed");
                                }
                            }
                            if ((object2 = document.getElementById(string4)) == null) {
                                object = element2.getChildNodes();
                                int n = 0;
                                while (n < object.getLength()) {
                                    Node node = object.item(n);
                                    if (node.getNodeType() == 1 && string4.equalsIgnoreCase((element = (Element)node).getAttribute("name"))) {
                                        object2 = element;
                                        break;
                                    }
                                    ++n;
                                }
                                if (object2 == null) {
                                    throw new INITIALIZE("Cannot find element \"" + uRL + "\"");
                                }
                            }
                            if (((String)(object = object2.getTagName())).equals("profile")) {
                                this.handleImportElem((Element)object2, uRL, true);
                                this._initModules.put(uRL, null);
                                string4 = null;
                            } else if (((String)object).equals("module")) {
                                if (object2.hasAttribute("initializer")) {
                                    this._moduleInits.add(object2.getAttribute("initializer"));
                                }
                                this._initModules.put(uRL, string4);
                            }
                            this.handleProperties((Element)object2, string4, uRL);
                            string = string4;
                            break block37;
                        }
                        catch (Throwable throwable) {
                            Object var12_12 = null;
                            this._currDoc = uRL2;
                            throw throwable;
                        }
                    }
                    Object var12_8 = null;
                    this._currDoc = uRL2;
                    return string3;
                }
                Object var12_9 = null;
                this._currDoc = uRL2;
                return object;
            }
            Object var12_10 = null;
            this._currDoc = uRL2;
            return string2;
        }
        Object var12_11 = null;
        this._currDoc = uRL2;
        return string;
    }

    private boolean handleProperties(Element element, String string, URL uRL) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string2 = element2.getTagName();
                if (string2.equals("import")) {
                    if (uRL == null) {
                        return false;
                    }
                    String string3 = this.handleImportElem(element2, uRL, false);
                    if (!this.handleProperties(element2, string3, null)) {
                        if (string3 == null) {
                            throw new INITIALIZE("Attempt to set properties from import of profile in \"" + uRL + "\"");
                        }
                        throw new INITIALIZE("Import statment in \"" + uRL + "\" has child import.");
                    }
                } else if (string2.equals("property") || string2.equals("rootproperty")) {
                    if (string == null) {
                        if (uRL == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + uRL + "\" defines properties, dissalowed");
                    }
                    this.handlePropertyElem(element2, string, uRL);
                } else if (string2.equals("propalias")) {
                    if (string == null) {
                        if (uRL == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + uRL + "\" defines propaliases, dissalowed");
                    }
                    this.handlePropaliasElem(element2, string, uRL);
                } else if (string2.equals("propertyset")) {
                    if (string == null) {
                        if (uRL == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + uRL + "\" defines propertyset, dissalowed");
                    }
                } else if (!string2.equals("description")) {
                    throw new INITIALIZE("Unknown element type " + string2 + " in \"" + uRL + "\"");
                }
            }
            ++n;
        }
        return true;
    }

    private Element nextElement(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    private String handleImportElem(Element element, URL uRL, boolean bl) {
        String string;
        URL uRL2;
        boolean bl2 = element.hasAttribute("extends");
        boolean bl3 = element.hasAttribute("module");
        boolean bl4 = element.hasAttribute("profile");
        boolean bl5 = element.hasAttribute("xlink:href");
        switch ((bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0) + (bl5 ? 1 : 0)) {
            case 0: {
                if (!bl) {
                    throw new INITIALIZE("Import from \"" + uRL + "\" does not specify a target");
                }
                return null;
            }
            case 1: {
                if (bl5 || (bl ? bl2 : bl4 || bl3)) break;
                throw new INITIALIZE("Atribute " + (bl ? (bl4 ? "profile" : "module") : "extends") + " found when " + (bl ? "extends" : "profile or module") + " attribute is expected in \"" + uRL + "\"");
            }
            default: {
                throw new INITIALIZE("Multiple " + (bl ? "extends present in profile" : "import targets in module") + " at \"" + uRL + "\"");
            }
        }
        if (!bl5) {
            try {
                if (bl2) {
                    uRL2 = this.addFragment(uRL, element.getAttribute("extends"));
                }
                if (bl3) {
                    uRL2 = this.addFragment(uRL, element.getAttribute("module"));
                }
                if (bl4) {
                    uRL2 = this.addFragment(uRL, element.getAttribute("profile"));
                }
                throw new Error("Impossible state");
            }
            catch (MalformedURLException malformedURLException) {
                throw new INITIALIZE("Unable to parse " + (bl ? "extends" : "module") + " for " + (bl ? "profile" : "module import in") + " \"" + uRL + "\"");
            }
        } else if (element.hasAttribute("xlink:href")) {
            string = element.getAttribute("xlink:href");
            uRL2 = this.parseURL(string);
            if (uRL2 == null) {
                throw new INITIALIZE("Unable to parse URL \"" + string + "\" from " + (bl ? "profile" : "module import in") + " \"" + uRL + "\"");
            }
        } else {
            if (!bl) {
                throw new INITIALIZE("Import from \"" + uRL + "\" does not specify a target");
            }
            return null;
        }
        string = this.handleURLImport(uRL2);
        if (bl) {
            if (string != null) {
                throw new INITIALIZE("Attempted to extend module \"" + uRL2 + "\" from profile \"" + uRL + "\"");
            }
        } else if (!bl5 && (string == null ? bl3 : bl4)) {
            throw new INITIALIZE("Attempted to import " + (string == null ? "profile" : "module") + "  \"" + uRL2 + "\" from " + (string == null ? "module" : "profile") + " \"" + uRL + "\"");
        }
        return string;
    }

    private void handlePropaliasElem(Element element, String string, URL uRL) {
        String string2 = element.getAttribute("name");
        if (string2.length() == 0) {
            throw new INITIALIZE("Propalias in \"" + uRL + "\" does not have a name");
        }
        String string3 = element.getAttribute("alias");
        if (string3.length() == 0) {
            throw new INITIALIZE("Propalias in \"" + uRL + "\" does not have an alias");
        }
        string2 = string + "." + string2;
        this._cmdLineAlias.put(string3, string2);
    }

    private void handlePropertyElem(Element element, String string, URL uRL) {
        String string2 = element.getAttribute("name");
        if (string2.length() == 0) {
            throw new INITIALIZE("Property in \"" + uRL + "\" does not have a name");
        }
        String string3 = element.hasAttribute("value") ? element.getAttribute("value") : "true";
        if (element.hasAttribute("root")) {
            String string4 = element.getAttribute("root");
            if (string4.equals("false")) {
                string2 = string + "." + string2;
            } else if (!string4.equals("true")) {
                throw new INITIALIZE("Property " + string2 + " in \"" + uRL + "\" has illegal value for root attribute");
            }
        } else if (!element.getTagName().equals("rootproperty")) {
            string2 = string + "." + string2;
        }
        this.addProperty(string2, string3);
    }

    private void parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && stringArray[n].startsWith("-ORB")) {
                String string;
                String string2;
                int n2 = stringArray[n].indexOf(61);
                if (n2 < 0) {
                    if (stringArray.length <= n + 1 || stringArray[n + 1] == null || stringArray[n + 1].startsWith("-")) {
                        string2 = stringArray[n].substring(4);
                        string = "true";
                    } else {
                        n2 = stringArray[n + 1].indexOf(61);
                        if (n2 < 0) {
                            string2 = stringArray[n].substring(4);
                            string = stringArray[n + 1];
                        } else {
                            string2 = stringArray[n].substring(4) + "." + stringArray[n + 1].substring(0, n2);
                            string = stringArray[n + 1].substring(n2 + 1);
                        }
                        ++n;
                    }
                } else {
                    string2 = stringArray[n].substring(4, n2);
                    string = stringArray[n].substring(n2 + 1);
                }
                if (this._cmdLineAlias.containsKey(string2)) {
                    string2 = (String)this._cmdLineAlias.get(string2);
                }
                this.addProperty(string2, string);
            }
            ++n;
        }
    }
}

