/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ORBInitializer;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.kernel.Configurator;
import org.openorb.CORBA.kernel.ORBConnector;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.CORBA.kernel.Properties;
import org.openorb.CORBA.kernel.Property;
import org.openorb.CORBA.kernel.PropertyNotFoundException;
import org.openorb.PI.FeatureInitializer;
import org.openorb.PI.ORBInitInfo;
import org.openorb.util.Trace;

public class OpenORBLoader
implements ORBLoader {
    private Properties _properties = null;
    private ORB _orb;
    private static final String ORBSingletonClassKey = "org.omg.CORBA.ORBSingletonClass";
    private static final String defaultORBSingleton = "org.openorb.CORBA.ORBSingleton";

    public void init(String[] stringArray, java.util.Properties properties, ORB oRB) {
        ORBInitInfo oRBInitInfo;
        Object object;
        if (this._orb != null) {
            throw new INITIALIZE("Multiple initialize for orb");
        }
        this._orb = oRB;
        try {
            System.setProperty(ORBSingletonClassKey, defaultORBSingleton);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        org.omg.CORBA.ORB oRB2 = org.omg.CORBA.ORB.init();
        if (!(oRB2 instanceof ORBSingleton)) {
            throw new INITIALIZE("Unable to complete init orb singleton is not openorb singleton.\nPlease use: System.setProperty(\"org.omg.CORBA.ORBSingletonClass\", \"org.openorb.CORBA.ORBSingleton\");\nAs the first statement in your application.");
        }
        this._orb.setFeature("ORBLoader", this);
        Configurator configurator = new Configurator(stringArray, properties);
        this._properties = configurator.getProperties();
        try {
            object = new Object[4];
            object[0] = stringArray == null ? new String[]{} : stringArray;
            object[1] = oRB;
            this.load_initializers((Object[])object, configurator.getInitializers());
            oRBInitInfo = (ORBInitInfo)this.constructClass("openorb.pi.ORBInitInfoClass", "org.openorb.PI.OpenORBInitInfo", (Object[])object);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SystemException) {
                throw (SystemException)invocationTargetException.getTargetException();
            }
            throw new INITIALIZE(invocationTargetException.toString());
        }
        oRBInitInfo.pre_init();
        try {
            object = (ORBConnector)this.constructClass("openorb.kernel.ORBConnectorClass", "org.openorb.CORBA.kernel.OpenORBConnector", null);
            object.load_kernel(this._orb, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SystemException) {
                throw (SystemException)invocationTargetException.getTargetException();
            }
            throw new INITIALIZE(invocationTargetException.toString());
        }
        this.enableTrace();
        oRBInitInfo.post_init();
    }

    public void display_configuration(PrintWriter printWriter) {
        this._properties.display(printWriter);
    }

    public Iterator properties(String string) {
        return this._properties.properties(string);
    }

    public Property getProperty(String string) {
        return this._properties.getProperty(string);
    }

    public String getStringProperty(String string, String string2) {
        return this._properties.getStringProperty(string, string2);
    }

    public String getStringProperty(String string) throws PropertyNotFoundException {
        return this._properties.getStringProperty(string);
    }

    public int getIntProperty(String string, int n) {
        return this._properties.getIntProperty(string, n);
    }

    public int getIntProperty(String string) throws PropertyNotFoundException {
        return this._properties.getIntProperty(string);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        return this._properties.getBooleanProperty(string, bl);
    }

    public boolean getBooleanProperty(String string) throws PropertyNotFoundException {
        return this._properties.getBooleanProperty(string);
    }

    public URL getURLProperty(String string, URL uRL) {
        return this._properties.getURLProperty(string, uRL);
    }

    public URL getURLProperty(String string) throws PropertyNotFoundException {
        return this._properties.getURLProperty(string);
    }

    public Class getClassProperty(String string, Class clazz) {
        return this._properties.getClassProperty(string, clazz);
    }

    public Class getClassProperty(String string, String string2) {
        return this._properties.getClassProperty(string, string2);
    }

    public Class getClassProperty(String string) throws PropertyNotFoundException {
        return this._properties.getClassProperty(string);
    }

    public Object constructClass(String string, String string2, Object[] objectArray) throws InvocationTargetException {
        return this.constructClass(string, string2, objectArray, null);
    }

    public Object constructClass(String string, String string2, Object[] objectArray, Class[] classArray) throws InvocationTargetException {
        if (objectArray != null) {
            if (classArray == null) {
                classArray = new Class[objectArray.length];
            } else if (objectArray.length != classArray.length) {
                throw new IllegalArgumentException("Length of args and args_t do not match");
            }
            int n = 0;
            while (n < objectArray.length) {
                if (classArray[n] == null) {
                    classArray[n] = objectArray[n] == null ? Void.TYPE : objectArray[n].getClass();
                }
                ++n;
            }
        }
        try {
            return this.classConstructor(string, string2, classArray).newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException.toString());
        }
    }

    public Constructor classConstructor(String string, String string2, Class[] classArray) {
        Class clazz = this.getClassProperty(string, string2);
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException.toString());
        }
    }

    private void enableTrace() {
        int n;
        try {
            n = this.getIntProperty("Verbose");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            n = this.getIntProperty("openorb.debug", 0);
        }
        if (n != 0) {
            if (n > 4) {
                Trace.start_debugging_session("Intra verbose mode", null, n, this._orb);
            } else {
                Trace.setTraceLevel(n);
            }
        }
    }

    private void load_initializers(Object[] objectArray, String[] stringArray) {
        ArrayList arrayList = new ArrayList(stringArray.length);
        ArrayList arrayList2 = new ArrayList(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            Object obj;
            try {
                obj = Class.forName(stringArray[n]).newInstance();
            }
            catch (Exception exception) {
                throw new INITIALIZE("Unable to load initializer class \"" + stringArray[n] + "\"");
            }
            boolean bl = false;
            if (obj instanceof ORBInitializer) {
                arrayList.add(obj);
                bl = true;
            }
            if (obj instanceof FeatureInitializer) {
                arrayList2.add(obj);
                bl = true;
            }
            if (!bl) {
                throw new INITIALIZE("Initializer class \"" + stringArray[n] + "\" is of unknown type");
            }
            ++n;
        }
        objectArray[2] = new ORBInitializer[arrayList.size()];
        arrayList.toArray((Object[])objectArray[2]);
        objectArray[3] = new FeatureInitializer[arrayList2.size()];
        arrayList2.toArray((Object[])objectArray[3]);
    }
}

