/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.omg.CORBA.INITIALIZE;
import org.openorb.CORBA.kernel.Property;
import org.openorb.CORBA.kernel.PropertyNotFoundException;

public class Properties {
    private SortedMap _properties = Collections.synchronizedSortedMap(new TreeMap(new Comparator(){

        public int compare(Object object, Object object2) {
            return ((String)object).compareToIgnoreCase((String)object2);
        }
    }));

    public void addProperty(String string, String string2) {
        if (string2 == null) {
            this._properties.remove(string);
        } else {
            this._properties.put(string, new Property(string, string2, this));
        }
    }

    public void addProperty(String string, int n) {
        this._properties.put(string, new Property(string, Integer.toString(n), new Integer(n)));
    }

    public void addProperty(String string, boolean bl) {
        this._properties.put(string, new Property(string, bl ? "true" : "false", new Boolean(bl)));
    }

    public void addProperty(String string, URL uRL) {
        this._properties.put(string, new Property(string, uRL.toString(), uRL));
    }

    public void addProperty(String string, Class clazz) {
        if (clazz == null) {
            this._properties.remove(string);
        } else {
            this._properties.put(string, new Property(string, clazz.getName(), clazz));
        }
    }

    public Iterator properties(String string) {
        if (string == null) {
            return Collections.unmodifiableCollection(this._properties.values()).iterator();
        }
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        return Collections.unmodifiableCollection(this._properties.subMap(string + "\u0000", string + "\uffff").values()).iterator();
    }

    public void display(PrintWriter printWriter) {
        Iterator iterator = this.properties(null);
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            printWriter.println(property.getName() + "=" + property.getValue());
        }
    }

    public String formatString(String string) {
        int n;
        int n2;
        URL uRL = null;
        String string2 = string;
        if (string.startsWith("${")) {
            n2 = string.indexOf("}");
            if (n2 < 0) {
                throw new IllegalArgumentException("Unbalanced ${ } in \"" + string);
            }
            try {
                uRL = this.getURLProperty(string.substring(2, n2), null);
                string2 = string.substring(n2 + 1);
                if (string2.startsWith("#")) {
                    return uRL.toString() + string2;
                }
            }
            catch (INITIALIZE iNITIALIZE) {
                // empty catch block
            }
        }
        if ((n = string2.indexOf("${")) >= 0) {
            n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                stringBuffer.append(string2.substring(n2, n));
                n2 = string2.indexOf("}", n);
                if (n2 < 0) {
                    throw new IllegalArgumentException("Unbalanced ${ } in \"" + string + "\"");
                }
                String string3 = string2.substring(n + 2, n2);
                String string4 = this.getStringProperty(string3, null);
                if (string4 == null) {
                    return null;
                }
                stringBuffer.append(string4);
            } while ((n = string2.indexOf("${", n2)) >= 0);
            string2 = stringBuffer.toString();
        }
        if (uRL != null) {
            try {
                return new URL(uRL, string2).toString();
            }
            catch (MalformedURLException malformedURLException) {
                return uRL.toString() + string2;
            }
        }
        return string2;
    }

    public Property getProperty(String string) {
        return (Property)this._properties.get(string);
    }

    public String getStringProperty(String string, String string2) {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            return string2;
        }
        return property.getValue();
    }

    public String getStringProperty(String string) throws PropertyNotFoundException {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        return property.getValue();
    }

    public int getIntProperty(String string, int n) {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            return n;
        }
        return property.getIntValue();
    }

    public int getIntProperty(String string) throws PropertyNotFoundException {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        return property.getIntValue();
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            return bl;
        }
        return property.getBooleanValue();
    }

    public boolean getBooleanProperty(String string) throws PropertyNotFoundException {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        return property.getBooleanValue();
    }

    public URL getURLProperty(String string, URL uRL) {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            return uRL;
        }
        return property.getURLValue();
    }

    public URL getURLProperty(String string) throws PropertyNotFoundException {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        return property.getURLValue();
    }

    public Class getClassProperty(String string, Class clazz) {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            return clazz;
        }
        return property.getClassValue();
    }

    public Class getClassProperty(String string, String string2) {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            try {
                return Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new INITIALIZE("Unable to load default class \"" + string2 + "\"");
            }
        }
        return property.getClassValue();
    }

    public Class getClassProperty(String string) throws PropertyNotFoundException {
        Property property = (Property)this._properties.get(string);
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        return property.getClassValue();
    }
}

