/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.omg.CORBA.INITIALIZE;
import org.openorb.CORBA.kernel.Properties;

public class Property {
    private final String _name;
    private final String _value;
    private Object _typed = null;
    private Properties _props = null;

    Property(String string, String string2, Properties properties) {
        this._name = string;
        this._value = string2;
        this._props = properties;
    }

    Property(String string, String string2, Object object) {
        this._name = string;
        this._value = string2;
        this._typed = object;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public int getIntValue() {
        int n;
        if (this._typed != null && this._typed instanceof Integer) {
            return (Integer)this._typed;
        }
        int n2 = 10;
        String string = this._value;
        if (string.startsWith("0x") && string.length() > 2) {
            n2 = 16;
            string = string.substring(2);
        } else if (string.startsWith("-0x") && string.length() > 3) {
            n2 = 16;
            string = "-" + string.substring(3);
        } else if (string.startsWith("0") || string.startsWith("-0")) {
            n2 = 8;
        }
        try {
            n = Integer.parseInt(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new INITIALIZE("the property value \"" + this._name + "\" cannot be parsed as an integer");
        }
        this._typed = new Integer(n);
        return n;
    }

    public boolean getBooleanValue() {
        if (this._typed != null && this._typed instanceof Boolean) {
            return (Boolean)this._typed;
        }
        boolean bl = !this._value.equalsIgnoreCase("false") && !this._value.equalsIgnoreCase("no");
        this._typed = new Boolean(bl);
        return bl;
    }

    public Class getClassValue() {
        if (this._typed != null && this._typed instanceof Class) {
            return (Class)this._typed;
        }
        try {
            Class<?> clazz;
            this._typed = clazz = Class.forName(this._value);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new INITIALIZE("the property value \"" + this._name + "\" cannot be loaded as a class");
        }
    }

    public URL getURLValue() {
        if (this._typed != null && this._typed instanceof URL) {
            return (URL)this._typed;
        }
        String string = this._props.formatString(this._value);
        try {
            URL uRL = new URL(string);
            this._typed = uRL;
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.exists()) {
                try {
                    URL uRL = file.toURL();
                    this._typed = uRL;
                    return uRL;
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
            throw new INITIALIZE("the property value \"" + this._name + "\" cannot be parsed as a URL");
        }
    }
}

