/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.PI;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.ClientManager;
import org.openorb.PI.CodecFactoryManager;
import org.openorb.PI.CodecFactoryManagerImpl;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.PI.FeatureInitializer;
import org.openorb.PI.IORManager;
import org.openorb.PI.ORBInitInfo;
import org.openorb.PI.ServerManager;
import org.openorb.policy.PolicyFactoryManager;

public class OpenORBInitInfo
extends LocalObject
implements org.omg.PortableInterceptor.ORBInitInfo,
FeatureInitInfo,
ORBInitInfo {
    private ORB _orb;
    private String[] _args;
    private ORBInitializer[] _orbInits;
    private FeatureInitializer[] _featureInits;
    private ORBLoader _loader;
    private int _slots = 0;
    private ArrayList _client_interceptors = new ArrayList();
    private ArrayList _server_interceptors = new ArrayList();
    private ArrayList _ior_interceptors = new ArrayList();
    private CodecFactoryManager _codecmanager;
    private int _phase = 0;
    private static final int PHASE_CREATED = 0;
    private static final int PHASE_PRE_INIT = 1;
    private static final int PHASE_POST_INIT = 3;
    private static final int PHASE_COMPLETE = 4;

    public OpenORBInitInfo(String[] stringArray, ORB oRB, ORBInitializer[] oRBInitializerArray, FeatureInitializer[] featureInitializerArray) {
        this._args = stringArray;
        this._orb = oRB;
        this._orbInits = oRBInitializerArray;
        this._featureInits = featureInitializerArray;
        try {
            this._loader = (ORBLoader)this._orb.getFeature("ORBLoader");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._loader == null) {
            throw new INITIALIZE();
        }
    }

    public void pre_init() {
        if (this._phase != 0) {
            throw new INITIALIZE();
        }
        this._phase = 1;
        this._codecmanager = new CodecFactoryManagerImpl();
        this._orb.addInitialReference("CodecFactory", (Object)((java.lang.Object)this._codecmanager));
        this._orb.setFeature("CodecFactoryManager", this._codecmanager);
        if (this._orbInits != null) {
            int n = 0;
            while (n < this._orbInits.length) {
                this._orbInits[n].pre_init(this);
                ++n;
            }
        }
    }

    public void post_init() {
        if (this._phase != 1) {
            throw new INITIALIZE();
        }
        this._phase = 3;
        if (this._featureInits != null) {
            int n = 0;
            while (n < this._featureInits.length) {
                this._featureInits[n].init(this, this);
                ++n;
            }
        }
        CurrentImpl currentImpl = new CurrentImpl(this._orb);
        this._orb.addInitialReference("PICurrent", currentImpl);
        this._orb.setFeature("PICurrent", currentImpl);
        if (this._orbInits != null) {
            int n = 0;
            while (n < this._orbInits.length) {
                this._orbInits[n].post_init(this);
                ++n;
            }
        }
        currentImpl.set_slots(this._slots);
        this.create_client_interceptor_manager(currentImpl);
        this.create_server_interceptor_manager(currentImpl);
        this.create_ior_interceptor_manager();
        this._phase = 4;
    }

    private void create_client_interceptor_manager(CurrentImpl currentImpl) {
        if (!this._loader.getBooleanProperty("openorb.client.enable", true)) {
            return;
        }
        if (this._client_interceptors.isEmpty()) {
            return;
        }
        ClientRequestInterceptor[] clientRequestInterceptorArray = new ClientRequestInterceptor[this._client_interceptors.size()];
        this._client_interceptors.toArray(clientRequestInterceptorArray);
        ClientManager clientManager = null;
        java.lang.Object[] objectArray = new java.lang.Object[]{clientRequestInterceptorArray, currentImpl};
        try {
            clientManager = (ClientManager)this._loader.constructClass("openorb.pi.ClientManagerClass", "org.openorb.PI.SimpleClientManager", objectArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE(exception.toString());
        }
        if (clientManager != null) {
            this._orb.setFeature("ClientInterceptorManager", clientManager);
        }
    }

    private void create_server_interceptor_manager(CurrentImpl currentImpl) {
        if (!this._loader.getBooleanProperty("openorb.server.enable", true)) {
            return;
        }
        if (this._server_interceptors.isEmpty()) {
            return;
        }
        ServerRequestInterceptor[] serverRequestInterceptorArray = new ServerRequestInterceptor[this._server_interceptors.size()];
        this._server_interceptors.toArray(serverRequestInterceptorArray);
        ServerManager serverManager = null;
        java.lang.Object[] objectArray = new java.lang.Object[]{serverRequestInterceptorArray, currentImpl};
        try {
            serverManager = (ServerManager)this._loader.constructClass("openorb.pi.ServerManagerClass", "org.openorb.PI.SimpleServerManager", objectArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE(exception.toString());
        }
        if (serverManager != null) {
            this._orb.setFeature("ServerInterceptorManager", serverManager);
        }
    }

    private void create_ior_interceptor_manager() {
        if (!this._loader.getBooleanProperty("openorb.server.enable", true)) {
            return;
        }
        IORInterceptor[] iORInterceptorArray = new IORInterceptor[this._ior_interceptors.size()];
        this._ior_interceptors.toArray(iORInterceptorArray);
        IORManager iORManager = null;
        java.lang.Object[] objectArray = new java.lang.Object[]{iORInterceptorArray};
        try {
            iORManager = (IORManager)this._loader.constructClass("org.openorb.PI.IORManagerClass", "org.openorb.PI.SimpleIORManager", objectArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE(exception.toString());
        }
        if (iORManager != null) {
            this._orb.setFeature("IORInterceptorManager", iORManager);
        }
    }

    public ORB orb() {
        return this._orb;
    }

    public ORBLoader getLoader() {
        return this._orb.getLoader();
    }

    public void setFeature(String string, java.lang.Object object) {
        this._orb.setFeature(string, object);
    }

    public java.lang.Object getFeature(String string) {
        return this._orb.getFeature(string);
    }

    public String[] arguments() {
        return this._args;
    }

    public String orb_id() {
        return "OpenORB";
    }

    public CodecFactory codec_factory() {
        return (CodecFactory)((java.lang.Object)this._codecmanager);
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        try {
            Object object2 = this.resolve_initial_references(string);
        }
        catch (InvalidName invalidName) {
            this._orb.addInitialReference(string, object);
            return;
        }
        throw new InvalidName();
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        try {
            return this._orb.resolve_initial_references(string);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InvalidName();
        }
    }

    public void add_client_request_interceptor(ClientRequestInterceptor clientRequestInterceptor) throws DuplicateName {
        this.check_duplicate(this._client_interceptors, clientRequestInterceptor.name());
        this._client_interceptors.add(clientRequestInterceptor);
    }

    public void add_server_request_interceptor(ServerRequestInterceptor serverRequestInterceptor) throws DuplicateName {
        this.check_duplicate(this._server_interceptors, serverRequestInterceptor.name());
        this._server_interceptors.add(serverRequestInterceptor);
    }

    public void add_ior_interceptor(IORInterceptor iORInterceptor) throws DuplicateName {
        this.check_duplicate(this._ior_interceptors, iORInterceptor.name());
        this._ior_interceptors.add(iORInterceptor);
    }

    public int allocate_slot_id() {
        return this._slots++;
    }

    public void register_policy_factory(int n, PolicyFactory policyFactory) {
        PolicyFactoryManager policyFactoryManager = (PolicyFactoryManager)this._orb.getFeature("PolicyFactoryManager");
        policyFactoryManager.add_policy_factory(n, policyFactory);
    }

    private void check_duplicate(ArrayList arrayList, String string) throws DuplicateName {
        if (string.length() == 0) {
            return;
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            if (!string.equals(((Interceptor)iterator.next()).name())) continue;
            throw new DuplicateName();
        }
    }
}

