/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.PI;

import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.ClientManager;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.RequestCallback;
import org.openorb.util.Trace;

public class SimpleClientManager
implements ClientManager {
    private ClientRequestInterceptor[] _list = null;
    private CurrentImpl _current;
    public static final int BAD_INTERCEPTOR_RESPONSE = 0;

    public SimpleClientManager(ClientRequestInterceptor[] clientRequestInterceptorArray, CurrentImpl currentImpl) {
        this._list = clientRequestInterceptorArray;
        this._current = currentImpl;
    }

    public void send_request(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        int n = 0;
        CurrentOperations currentOperations = this._current.remove();
        try {
            while (n < this._list.length) {
                this._list[n].send_request(clientRequestInfo);
                this._current.remove();
                ++n;
            }
        }
        catch (ForwardRequest forwardRequest) {
            this._current.remove();
            requestCallback.reply_location_forward(forwardRequest.forward, forwardRequest.permanent);
            this.receive_other_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (SystemException systemException) {
            INTERNAL iNTERNAL;
            this._current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                iNTERNAL = new INTERNAL(0, CompletionStatus.COMPLETED_NO);
            }
            iNTERNAL.completed = CompletionStatus.COMPLETED_NO;
            requestCallback.reply_system_exception(iNTERNAL);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this._current.remove();
            Trace.high("SimpleClientManager::send_request", "Received an unexcepted exception : " + runtimeException.toString());
            requestCallback.reply_runtime_exception(runtimeException);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (Error error) {
            this._current.remove();
            Trace.high("SimpleClientManager::send_request", "Received an unexcepted exception : " + error.toString());
            requestCallback.reply_error(error);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        this._current.set(currentOperations);
    }

    public void send_poll(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        int n = 0;
        CurrentOperations currentOperations = this._current.remove();
        try {
            while (n < this._list.length) {
                this._list[n].send_poll(clientRequestInfo);
                this._current.remove();
                ++n;
            }
        }
        catch (SystemException systemException) {
            INTERNAL iNTERNAL;
            this._current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                iNTERNAL = new INTERNAL(0, CompletionStatus.COMPLETED_NO);
            }
            requestCallback.reply_system_exception(iNTERNAL);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this._current.remove();
            Trace.high("SimpleClientManager::send_poll", "Received an unexcepted exception : " + runtimeException.toString());
            requestCallback.reply_runtime_exception(runtimeException);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (Error error) {
            this._current.remove();
            Trace.high("SimpleClientManager::send_poll", "Received an unexcepted exception : " + error.toString());
            requestCallback.reply_error(error);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        this._current.set(currentOperations);
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        int n = this._list.length - 1;
        CurrentOperations currentOperations = this._current.remove();
        try {
            while (n >= 0) {
                this._list[n].receive_reply(clientRequestInfo);
                this._current.remove();
                --n;
            }
        }
        catch (SystemException systemException) {
            INTERNAL iNTERNAL;
            this._current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_YES) {
                iNTERNAL = new INTERNAL(0, CompletionStatus.COMPLETED_YES);
            }
            requestCallback.reply_system_exception(iNTERNAL);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this._current.remove();
            Trace.high("SimpleClientManager::receive_reply", "Received an unexcepted exception : " + runtimeException.toString());
            requestCallback.reply_runtime_exception(runtimeException);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (Error error) {
            this._current.remove();
            Trace.high("SimpleClientManager::receive_reply", "Received an unexcepted exception : " + error.toString());
            requestCallback.reply_error(error);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        this._current.set(currentOperations);
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        CurrentOperations currentOperations = this._current.remove();
        this.receive_exception_point(this._list.length - 1, clientRequestInfo, requestCallback);
        this._current.set(currentOperations);
    }

    private void receive_exception_point(int n, ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        if (n < 0) {
            return;
        }
        CompletionStatus completionStatus = clientRequestInfo.reply_status() == 1 ? SystemExceptionHelper.extract((Any)clientRequestInfo.received_exception()).completed : CompletionStatus.COMPLETED_YES;
        while (n >= 0) {
            block9: {
                try {
                    this._list[n].receive_exception(clientRequestInfo);
                }
                catch (SystemException systemException) {
                    INTERNAL iNTERNAL;
                    if (systemException.completed != completionStatus) {
                        iNTERNAL = new INTERNAL(0, completionStatus);
                    }
                    requestCallback.reply_system_exception(iNTERNAL);
                }
                catch (RuntimeException runtimeException) {
                    Trace.high("SimpleClientManager::receive_exception", "Received an unexcepted exception : " + runtimeException.toString());
                    requestCallback.reply_runtime_exception(runtimeException);
                }
                catch (Error error) {
                    Trace.high("SimpleClientManager::receive_exception", "Received an unexcepted exception : " + error.toString());
                    requestCallback.reply_error(error);
                }
                catch (ForwardRequest forwardRequest) {
                    this._current.remove();
                    if (completionStatus != CompletionStatus.COMPLETED_YES) {
                        requestCallback.reply_system_exception(new INTERNAL(0, CompletionStatus.COMPLETED_YES));
                        break block9;
                    }
                    requestCallback.reply_location_forward(forwardRequest.forward, forwardRequest.permanent);
                    this.receive_other_point(n - 1, clientRequestInfo, requestCallback);
                    return;
                }
                this._current.remove();
            }
            --n;
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        CurrentOperations currentOperations = this._current.remove();
        this.receive_other_point(this._list.length - 1, clientRequestInfo, requestCallback);
        this._current.set(currentOperations);
    }

    private void receive_other_point(int n, ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        if (n < 0) {
            return;
        }
        try {
            while (n >= 0) {
                try {
                    this._list[n].receive_other(clientRequestInfo);
                }
                catch (ForwardRequest forwardRequest) {
                    requestCallback.reply_location_forward(forwardRequest.forward, forwardRequest.permanent);
                }
                this._current.remove();
                --n;
            }
        }
        catch (SystemException systemException) {
            INTERNAL iNTERNAL;
            this._current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                iNTERNAL = new INTERNAL(0, CompletionStatus.COMPLETED_NO);
            }
            requestCallback.reply_system_exception(iNTERNAL);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this._current.remove();
            Trace.high("SimpleClientManager::send_request", "Received an unexcepted exception : " + runtimeException.toString());
            requestCallback.reply_runtime_exception(runtimeException);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (Error error) {
            this._current.remove();
            Trace.high("SimpleClientManager::send_request", "Received an unexcepted exception : " + error.toString());
            requestCallback.reply_error(error);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
    }
}

