/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.PI;

import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.RequestCallback;
import org.openorb.PI.ServerManager;
import org.openorb.util.Trace;

public class SimpleServerManager
implements ServerManager {
    private ServerRequestInterceptor[] _list;
    private CurrentImpl _current;
    public static final int BAD_INTERCEPTOR_RESPONSE = 0;

    public SimpleServerManager(ServerRequestInterceptor[] serverRequestInterceptorArray, CurrentImpl currentImpl) {
        this._list = serverRequestInterceptorArray;
        this._current = currentImpl;
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        int n = 0;
        CurrentOperations currentOperations = this._current.remove();
        try {
            while (n < this._list.length) {
                this._list[n].receive_request_service_contexts(serverRequestInfo);
                this._current.remove();
                ++n;
            }
        }
        catch (SystemException systemException) {
            INTERNAL iNTERNAL;
            this._current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                iNTERNAL = new INTERNAL(0, CompletionStatus.COMPLETED_NO);
            }
            requestCallback.reply_system_exception(iNTERNAL);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (ForwardRequest forwardRequest) {
            this._current.remove();
            requestCallback.reply_location_forward(forwardRequest.forward, forwardRequest.permanent);
            this.send_other_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this._current.remove();
            Trace.high("ServerInterceptorManager::recieve_request_service_contexts", "Received an unexcepted exception : " + runtimeException.toString());
            requestCallback.reply_runtime_exception(runtimeException);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (Error error) {
            this._current.remove();
            Trace.high("ServerInterceptorManager::recieve_request_service_contexts", "Received an unexcepted exception : " + error.toString());
            requestCallback.reply_error(error);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        this._current.set(currentOperations);
    }

    public void receive_request(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        int n = 0;
        CurrentOperations currentOperations = this._current.remove();
        try {
            while (n < this._list.length) {
                this._list[n].receive_request(serverRequestInfo);
                this._current.remove();
                ++n;
            }
        }
        catch (SystemException systemException) {
            INTERNAL iNTERNAL;
            this._current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                iNTERNAL = new INTERNAL(0, CompletionStatus.COMPLETED_NO);
            }
            requestCallback.reply_system_exception(iNTERNAL);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (ForwardRequest forwardRequest) {
            this._current.remove();
            requestCallback.reply_location_forward(forwardRequest.forward, forwardRequest.permanent);
            this.send_other_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this._current.remove();
            Trace.high("ServerInterceptorManager::recieve_request", "Received an unexcepted exception : " + runtimeException.toString());
            requestCallback.reply_runtime_exception(runtimeException);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (Error error) {
            this._current.remove();
            Trace.high("ServerInterceptorManager::recieve_request", "Received an unexcepted exception : " + error.toString());
            requestCallback.reply_error(error);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        this._current.set(currentOperations);
    }

    public void send_reply(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        int n = this._list.length - 1;
        CurrentOperations currentOperations = this._current.remove();
        try {
            while (n >= 0) {
                this._list[n].send_reply(serverRequestInfo);
                this._current.remove();
                --n;
            }
        }
        catch (SystemException systemException) {
            INTERNAL iNTERNAL;
            this._current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_YES) {
                iNTERNAL = new INTERNAL(0, CompletionStatus.COMPLETED_YES);
            }
            requestCallback.reply_system_exception(iNTERNAL);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this._current.remove();
            Trace.high("ServerInterceptorManager::send_reply", "Received an unexcepted exception : " + runtimeException.toString());
            requestCallback.reply_runtime_exception(runtimeException);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (Error error) {
            this._current.remove();
            Trace.high("ServerInterceptorManager::send_reply", "Received an unexcepted exception : " + error.toString());
            requestCallback.reply_error(error);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        this._current.set(currentOperations);
    }

    public void send_exception(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        CurrentOperations currentOperations = this._current.remove();
        this.send_exception_point(this._list.length - 1, serverRequestInfo, requestCallback);
        this._current.set(currentOperations);
    }

    private void send_exception_point(int n, ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        if (n < 0) {
            return;
        }
        CompletionStatus completionStatus = serverRequestInfo.reply_status() == 1 ? SystemExceptionHelper.extract((Any)serverRequestInfo.sending_exception()).completed : CompletionStatus.COMPLETED_YES;
        while (n >= 0) {
            try {
                this._list[n].send_exception(serverRequestInfo);
                this._current.remove();
            }
            catch (SystemException systemException) {
                INTERNAL iNTERNAL;
                this._current.remove();
                if (systemException.completed != completionStatus) {
                    iNTERNAL = new INTERNAL(0, completionStatus);
                }
                requestCallback.reply_system_exception(iNTERNAL);
            }
            catch (RuntimeException runtimeException) {
                this._current.remove();
                Trace.high("ServerInterceptorManager::send_exception", "Received an unexcepted exception : " + runtimeException.toString());
                requestCallback.reply_runtime_exception(runtimeException);
            }
            catch (Error error) {
                this._current.remove();
                Trace.high("ServerInterceptorManager::send_exception", "Received an unexcepted exception : " + error.toString());
                requestCallback.reply_error(error);
            }
            catch (ForwardRequest forwardRequest) {
                this._current.remove();
                if (completionStatus != CompletionStatus.COMPLETED_YES) {
                    requestCallback.reply_system_exception(new INTERNAL(0, CompletionStatus.COMPLETED_YES));
                }
                requestCallback.reply_location_forward(forwardRequest.forward, forwardRequest.permanent);
                this.send_other_point(n - 1, serverRequestInfo, requestCallback);
                return;
            }
            --n;
        }
    }

    public void send_other(ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        CurrentOperations currentOperations = this._current.remove();
        this.send_other_point(this._list.length - 1, serverRequestInfo, requestCallback);
        this._current.set(currentOperations);
    }

    private void send_other_point(int n, ServerRequestInfo serverRequestInfo, RequestCallback requestCallback) {
        if (n < 0) {
            return;
        }
        try {
            try {
                while (n >= 0) {
                    this._list[n].send_other(serverRequestInfo);
                    this._current.remove();
                    --n;
                }
            }
            catch (ForwardRequest forwardRequest) {
                this._current.remove();
                requestCallback.reply_location_forward(forwardRequest.forward, forwardRequest.permanent);
            }
        }
        catch (SystemException systemException) {
            INTERNAL iNTERNAL;
            this._current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                iNTERNAL = new INTERNAL(0, CompletionStatus.COMPLETED_NO);
            }
            requestCallback.reply_system_exception(iNTERNAL);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this._current.remove();
            Trace.high("ServerInterceptorManager::send_other", "Received an unexcepted exception : " + runtimeException.toString());
            requestCallback.reply_runtime_exception(runtimeException);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
        catch (Error error) {
            this._current.remove();
            Trace.high("ServerInterceptorManager::send_other", "Received an unexcepted exception : " + error.toString());
            requestCallback.reply_error(error);
            this.send_exception_point(n - 1, serverRequestInfo, requestCallback);
        }
    }
}

