/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.poa;

import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdAssignmentPolicyValueHelper;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValueHelper;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValueHelper;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.LifespanPolicyValueHelper;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.RequestProcessingPolicyValueHelper;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValueHelper;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;
import org.omg.PortableServer.ThreadPolicyValueHelper;

class PolicyFactoryImpl
extends LocalObject
implements PolicyFactory {
    static PolicyFactoryImpl instance = null;
    private static ThreadPolicyImpl[] pol_thread = null;
    private static LifespanPolicyImpl[] pol_lifespan = null;
    private static IdUniquenessPolicyImpl[] pol_idUniqueness = null;
    private static IdAssignmentPolicyImpl[] pol_idAssignment = null;
    private static ServantRetentionPolicyImpl[] pol_servantRetention = null;
    private static RequestProcessingPolicyImpl[] pol_requestProcessing = null;
    private static ImplicitActivationPolicyImpl[] pol_implicitActivation = null;

    private PolicyFactoryImpl() {
    }

    static PolicyFactoryImpl getInstance() {
        if (instance == null) {
            instance = new PolicyFactoryImpl();
        }
        return instance;
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        switch (n) {
            case 16: {
                if (!any.type().equal(ThreadPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_thread_policy(ThreadPolicyValueHelper.extract(any).value());
            }
            case 17: {
                if (!any.type().equal(LifespanPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_lifespan_policy(LifespanPolicyValueHelper.extract(any).value());
            }
            case 18: {
                if (!any.type().equal(IdUniquenessPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_id_uniqueness_policy(IdUniquenessPolicyValueHelper.extract(any).value());
            }
            case 19: {
                if (!any.type().equal(IdAssignmentPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_id_assignment_policy(IdAssignmentPolicyValueHelper.extract(any).value());
            }
            case 21: {
                if (!any.type().equal(ServantRetentionPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_servant_retention_policy(ServantRetentionPolicyValueHelper.extract(any).value());
            }
            case 22: {
                if (!any.type().equal(RequestProcessingPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_request_processing_policy(RequestProcessingPolicyValueHelper.extract(any).value());
            }
            case 20: {
                if (!any.type().equal(ImplicitActivationPolicyValueHelper.type())) {
                    throw new PolicyError(2);
                }
                return this.create_implicit_activation_policy(ImplicitActivationPolicyValueHelper.extract(any).value());
            }
        }
        throw new PolicyError(0);
    }

    ThreadPolicy create_thread_policy(int n) {
        if (pol_thread == null) {
            pol_thread = new ThreadPolicyImpl[2];
        }
        if (pol_thread[n] == null) {
            PolicyFactoryImpl.pol_thread[n] = new ThreadPolicyImpl(n);
        }
        return pol_thread[n];
    }

    LifespanPolicy create_lifespan_policy(int n) {
        if (pol_lifespan == null) {
            pol_lifespan = new LifespanPolicyImpl[2];
        }
        if (pol_lifespan[n] == null) {
            PolicyFactoryImpl.pol_lifespan[n] = new LifespanPolicyImpl(n);
        }
        return pol_lifespan[n];
    }

    IdUniquenessPolicy create_id_uniqueness_policy(int n) {
        if (pol_idUniqueness == null) {
            pol_idUniqueness = new IdUniquenessPolicyImpl[2];
        }
        if (pol_idUniqueness[n] == null) {
            PolicyFactoryImpl.pol_idUniqueness[n] = new IdUniquenessPolicyImpl(n);
        }
        return pol_idUniqueness[n];
    }

    IdAssignmentPolicy create_id_assignment_policy(int n) {
        if (pol_idAssignment == null) {
            pol_idAssignment = new IdAssignmentPolicyImpl[2];
        }
        if (pol_idAssignment[n] == null) {
            PolicyFactoryImpl.pol_idAssignment[n] = new IdAssignmentPolicyImpl(n);
        }
        return pol_idAssignment[n];
    }

    ServantRetentionPolicy create_servant_retention_policy(int n) {
        if (pol_servantRetention == null) {
            pol_servantRetention = new ServantRetentionPolicyImpl[2];
        }
        if (pol_servantRetention[n] == null) {
            PolicyFactoryImpl.pol_servantRetention[n] = new ServantRetentionPolicyImpl(n);
        }
        return pol_servantRetention[n];
    }

    RequestProcessingPolicy create_request_processing_policy(int n) {
        if (pol_requestProcessing == null) {
            pol_requestProcessing = new RequestProcessingPolicyImpl[3];
        }
        if (pol_requestProcessing[n] == null) {
            PolicyFactoryImpl.pol_requestProcessing[n] = new RequestProcessingPolicyImpl(n);
        }
        return pol_requestProcessing[n];
    }

    ImplicitActivationPolicy create_implicit_activation_policy(int n) {
        if (pol_implicitActivation == null) {
            pol_implicitActivation = new ImplicitActivationPolicyImpl[2];
        }
        if (pol_implicitActivation[n] == null) {
            PolicyFactoryImpl.pol_implicitActivation[n] = new ImplicitActivationPolicyImpl(n);
        }
        return pol_implicitActivation[n];
    }

    private static class ImplicitActivationPolicyImpl
    extends LocalObject
    implements ImplicitActivationPolicy {
        private ImplicitActivationPolicyValue value;

        ImplicitActivationPolicyImpl(int n) {
            this.value = ImplicitActivationPolicyValue.from_int(n);
        }

        public ImplicitActivationPolicyValue value() {
            return this.value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 20;
        }
    }

    private static class RequestProcessingPolicyImpl
    extends LocalObject
    implements RequestProcessingPolicy {
        private RequestProcessingPolicyValue value;

        RequestProcessingPolicyImpl(int n) {
            this.value = RequestProcessingPolicyValue.from_int(n);
        }

        public RequestProcessingPolicyValue value() {
            return this.value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 22;
        }
    }

    private static class ServantRetentionPolicyImpl
    extends LocalObject
    implements ServantRetentionPolicy {
        private ServantRetentionPolicyValue value;

        ServantRetentionPolicyImpl(int n) {
            this.value = ServantRetentionPolicyValue.from_int(n);
        }

        public ServantRetentionPolicyValue value() {
            return this.value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 21;
        }
    }

    private static class IdAssignmentPolicyImpl
    extends LocalObject
    implements IdAssignmentPolicy {
        private IdAssignmentPolicyValue value;

        IdAssignmentPolicyImpl(int n) {
            this.value = IdAssignmentPolicyValue.from_int(n);
        }

        public IdAssignmentPolicyValue value() {
            return this.value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 19;
        }
    }

    private static class IdUniquenessPolicyImpl
    extends LocalObject
    implements IdUniquenessPolicy {
        private IdUniquenessPolicyValue value;

        IdUniquenessPolicyImpl(int n) {
            this.value = IdUniquenessPolicyValue.from_int(n);
        }

        public IdUniquenessPolicyValue value() {
            return this.value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 18;
        }
    }

    private static class LifespanPolicyImpl
    extends LocalObject
    implements LifespanPolicy {
        private LifespanPolicyValue value;

        LifespanPolicyImpl(int n) {
            this.value = LifespanPolicyValue.from_int(n);
        }

        public LifespanPolicyValue value() {
            return this.value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 17;
        }
    }

    private static class ThreadPolicyImpl
    extends LocalObject
    implements ThreadPolicy {
        private ThreadPolicyValue value;

        ThreadPolicyImpl(int n) {
            this.value = ThreadPolicyValue.from_int(n);
        }

        public ThreadPolicyValue value() {
            return this.value;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 16;
        }
    }
}

