/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.poa;

import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagerHelper;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.openorb.PI.ComponentSet;
import org.openorb.adapter.poa.POA;
import org.openorb.adapter.poa.POADomainManagerImpl;
import org.openorb.net.ServerManager;
import org.openorb.util.Trace;

class RootPOA
extends POA {
    private static final String[] ROOT_POA_NAME = new String[]{"POA"};
    private static final String[] PERSIST_DOMAIN_POA_NAME = new String[]{"POAPDM"};
    private static final String[] DOMAIN_POA_NAME = new String[]{"POADM"};
    private POA domain_manager_poa;
    private POA persist_domain_manager_poa;

    private RootPOA(ORB oRB, Policy[] policyArray) throws InvalidPolicy {
        super(oRB, null, ROOT_POA_NAME, null, policyArray);
    }

    static POA create_root_poa(ServerManager serverManager, Policy[] policyArray) {
        try {
            Policy[] policyArray2 = new Policy[policyArray.length + 1];
            System.arraycopy(policyArray, 0, policyArray2, 0, policyArray.length);
            policyArray2[policyArray.length] = POA.policy_factory.create_implicit_activation_policy(0);
            ORB oRB = serverManager.orb();
            RootPOA rootPOA = new RootPOA(oRB, policyArray2);
            policyArray2 = new Policy[policyArray.length + 4];
            policyArray2[policyArray.length] = POA.policy_factory.create_id_assignment_policy(0);
            policyArray2[policyArray.length + 1] = POA.policy_factory.create_lifespan_policy(0);
            policyArray2[policyArray.length + 2] = POA.policy_factory.create_servant_retention_policy(1);
            policyArray2[policyArray.length + 3] = POA.policy_factory.create_request_processing_policy(1);
            rootPOA.domain_manager_poa = new DomainManagerPOA(oRB, rootPOA, DOMAIN_POA_NAME, null, policyArray2);
            policyArray2[policyArray.length + 1] = POA.policy_factory.create_lifespan_policy(1);
            rootPOA.persist_domain_manager_poa = new DomainManagerPOA(oRB, rootPOA, PERSIST_DOMAIN_POA_NAME, rootPOA.domain_manager_poa.getAdapterManager(), policyArray2);
            POADomainManagerImpl pOADomainManagerImpl = new POADomainManagerImpl(rootPOA);
            try {
                rootPOA.domain_manager_poa.set_servant(pOADomainManagerImpl);
                rootPOA.persist_domain_manager_poa.set_servant(pOADomainManagerImpl);
            }
            catch (WrongPolicy wrongPolicy) {
                Trace.assert(false, "wrong policy?");
            }
            try {
                rootPOA.domain_manager_poa.getAdapterManager().activate();
            }
            catch (AdapterInactive adapterInactive) {
                Trace.assert(false, "Newley created adapter inactive?");
            }
            serverManager.register_adapter(rootPOA.aid, rootPOA);
            serverManager.register_adapter(rootPOA.domain_manager_poa.aid, rootPOA.domain_manager_poa);
            serverManager.register_adapter(rootPOA.persist_domain_manager_poa.aid, rootPOA.persist_domain_manager_poa);
            return rootPOA;
        }
        catch (InvalidPolicy invalidPolicy) {
            throw new INV_POLICY();
        }
    }

    DomainManager create_poa_domain_manager(byte[] byArray, boolean bl) {
        try {
            if (bl) {
                return DomainManagerHelper.narrow(this.persist_domain_manager_poa.create_reference_with_id(byArray, DomainManagerHelper.id()));
            }
            return DomainManagerHelper.narrow(this.domain_manager_poa.create_reference_with_id(byArray, DomainManagerHelper.id()));
        }
        catch (WrongPolicy wrongPolicy) {
            Trace.assert(false, "Wrong policy?");
            return null;
        }
    }

    private static class DomainManagerPOA
    extends POA {
        public DomainManagerPOA(ORB oRB, POA pOA, String[] stringArray, ServerManager.AdapterManager adapterManager, Policy[] policyArray) throws InvalidPolicy {
            super(oRB, pOA, stringArray, adapterManager, policyArray);
        }

        protected Object create_reference(byte[] byArray, String string) {
            if (this.poa_comp_set == null) {
                this.poa_comp_set = new ComponentSet(this.serverManager.orb(), this.policy_set, null);
                this.poa_comp_set.interception_point();
            }
            return super.create_reference(byArray, string);
        }
    }
}

