/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.SendingContext.RunTime;
import org.openorb.CORBA.DataInputStream;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ObjectStub;
import org.openorb.CORBA.typecode.TypeCodeArray;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.AbstractInputStream;
import org.openorb.io.BufferSource;
import org.openorb.io.StorageBuffer;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class CDRInputStream
extends AbstractInputStream {
    private static final int CODEBASE = 1;
    private static final int NO_TYPE_INFORMATION = 0;
    private static final int SINGLE_TYPE_INFORMATION = 2;
    private static final int MULTIPLE_TYPE_INFORMATION = 6;
    private static final int MASK_TYPE_INFORMATION = 6;
    private static final int CHUNK = 8;
    private org.omg.CORBA.ORB _orb;
    private Version _version;
    protected Map _value_cache = new HashMap();
    private MarkState _mark = null;
    private String _charEnc = "UTF-8";
    private String _wcharEnc = "UnicodeBig";
    private int _wcharAlign = 2;
    private boolean _wcharReverse = false;
    private int _index = 0;
    private boolean _swap = false;
    private int _encaps_remain = -1;
    private int _pending_encaps_close = 0;
    private LinkedList _encaps_stack = new LinkedList();
    private int _value_level = 0;
    private boolean _pending_value_reopen = false;
    private boolean _in_chunked_value = false;
    private int _value_indirect = -1;
    private int _continueLevel = 0;
    private OctetSeqHolder tmpBuf = new OctetSeqHolder();
    private IntHolder tmpOff = new IntHolder();
    private IntHolder tmpLen = new IntHolder();
    static /* synthetic */ Class class$org$omg$CORBA$Object;

    public CDRInputStream(org.omg.CORBA.ORB oRB, boolean bl, Version version, StorageBuffer storageBuffer) {
        super(storageBuffer);
        this._orb = oRB;
        this.bigEndian(bl);
        this._version = version;
        if (this._version.minor == 0) {
            this._charEnc = "US-ASCII";
            this._wcharEnc = null;
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, boolean bl, Version version, BufferSource bufferSource) {
        super(bufferSource);
        this._orb = oRB;
        this.bigEndian(bl);
        this._version = version;
        if (this._version.minor == 0) {
            this._charEnc = "US-ASCII";
            this._wcharEnc = null;
        }
    }

    public org.omg.CORBA.ORB orb() {
        return this._orb;
    }

    public void setCodesets(int n, int n2) {
        if (n != 0) {
            this._charEnc = CodeSetDatabase.codesetIDtoEncoding(n);
            if (CodeSetDatabase.codesetIDtoAlignment(n) > 1) {
                throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
            }
        }
        if (n2 == 0) {
            this._wcharEnc = null;
        } else {
            this._wcharEnc = CodeSetDatabase.codesetIDtoEncoding(n2);
            if (this._wcharEnc.equals("UnicodeBigUnmarked")) {
                this._wcharEnc = "UnicodeBig";
            }
            this._wcharAlign = CodeSetDatabase.codesetIDtoAlignment(n2);
            if (this._version.minor == 1 && this._wcharAlign != 2) {
                throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
            }
            if (this._swap && this._wcharAlign > 1) {
                try {
                    String string = CodeSetDatabase.canonicalize(this._wcharEnc);
                    if (string.startsWith("Unicode")) {
                        this._wcharEnc = "UnicodeLittle";
                    } else {
                        this._wcharReverse = true;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Trace.assert(false, "Unsupported encoding should be impossible");
                }
            }
        }
    }

    public int index() {
        return this._index;
    }

    public void reset_index() {
        this._index = 0;
    }

    public Version version() {
        return this._version;
    }

    public boolean bigEndian() {
        return !this._swap;
    }

    public void bigEndian(boolean bl) {
        this._swap = !bl;
    }

    public void alignment(int n) {
        int n2;
        if (this._pending_value_reopen) {
            this._pending_value_reopen = false;
            n2 = this.peek_long();
            if (n2 < 0x7FFFFF00 || n2 > Integer.MAX_VALUE) {
                this.begin_value_chunk(this.read_long());
            }
        }
        if (n > 1 && (n2 = this._index % n) != 0) {
            this.force_skip(n - n2);
        }
    }

    public void begin_encapsulation() {
        int n = this.read_ulong();
        this._encaps_stack.addLast(new Boolean(this._swap));
        this._encaps_stack.addLast(new Integer(this._encaps_remain));
        this._encaps_stack.addLast(new Integer(this._index));
        this._encaps_stack.addLast(new Boolean(false));
        this._encaps_remain = n;
        this._in_chunked_value = false;
        this._swap = this.read_boolean();
    }

    public void end_encapsulation() {
        if (this._pending_encaps_close == 0) {
            this.force_skip(this._encaps_remain);
        }
        --this._pending_encaps_close;
    }

    public long skip(long l) {
        long l2 = super.skip(l);
        this.postread((int)l2);
        return l2;
    }

    public void mark(int n) {
        super.mark(n);
        this._mark = new MarkState();
    }

    public void reset() throws IOException {
        super.reset();
        this._mark.reset();
        this._mark = null;
    }

    public boolean read_boolean() {
        return this.read_octet() == 1;
    }

    public char read_char() {
        this.alignment(1);
        this.tmpLen.value = 1;
        this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
        this.postread(1);
        try {
            String string = new String(this.tmpBuf.value, this.tmpOff.value, 1, this._charEnc);
            if (string.length() == 1) {
                return string.charAt(0);
            }
            this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
        return '\u0000';
    }

    public char read_wchar() {
        if (this._wcharEnc == null) {
            if (this._version.minor == 0) {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            }
            return '\u0000';
        }
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        switch (this._version.minor) {
            case 0: {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                return '\u0000';
            }
            case 1: {
                this.alignment(2);
                this.tmpLen.value = 2;
                n2 = 2;
                this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                if (this.tmpLen.value != 0) {
                    byArray = new byte[2];
                    if (this._wcharReverse) {
                        byArray[1] = this.tmpBuf.value[this.tmpOff.value];
                        this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                        byArray[0] = this.tmpBuf.value[this.tmpOff.value];
                    } else {
                        byArray[0] = this.tmpBuf.value[this.tmpOff.value];
                        this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                        byArray[1] = this.tmpBuf.value[this.tmpOff.value];
                    }
                    n = 0;
                } else if (this._wcharReverse) {
                    byArray = new byte[]{this.tmpBuf.value[1], this.tmpBuf.value[0]};
                    n = 0;
                } else {
                    byArray = this.tmpBuf.value;
                    n = this.tmpOff.value;
                }
                this.postread(2);
                break;
            }
            case 2: {
                int n3;
                this.alignment(1);
                this.tmpLen.value = 1;
                this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                n2 = this.tmpLen.value = this.tmpBuf.value[this.tmpOff.value];
                this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                this.postread(n2 - this.tmpLen.value + 1);
                if (this.tmpLen.value != 0) {
                    byArray = new byte[n2];
                    n = 0;
                    System.arraycopy(this.tmpBuf.value, this.tmpOff.value, byArray, 0, n2 - this.tmpLen.value);
                    this.read_octet_array(byArray, n2 - this.tmpLen.value, this.tmpLen.value);
                    if (!this._wcharReverse) break;
                    int n4 = 0;
                    while (n4 < this._wcharAlign / 2) {
                        n3 = byArray[n4];
                        byArray[n4] = byArray[this._wcharAlign - n4];
                        byArray[this._wcharAlign - n4] = n3;
                        ++n4;
                    }
                    break;
                }
                if (this._wcharReverse) {
                    byArray = new byte[n2];
                    n = 0;
                    n3 = 0;
                    while (n3 < this._wcharAlign) {
                        byArray[n3] = this.tmpBuf.value[this.tmpOff.value + this._wcharAlign - n3];
                        ++n3;
                    }
                    break;
                }
                byArray = this.tmpBuf.value;
                n = this.tmpOff.value;
            }
        }
        try {
            String string = new String(byArray, n, n2, this._wcharEnc);
            if (string.length() == 1) {
                return string.charAt(0);
            }
            this.cancel(new MARSHAL("Unable to decode wchar value", 1146056977, CompletionStatus.COMPLETED_MAYBE));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
        return '\u0000';
    }

    public byte read_octet() {
        this.alignment(1);
        this.tmpLen.value = 1;
        this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
        byte by = this.tmpBuf.value[this.tmpOff.value];
        this.postread(1);
        return by;
    }

    public short read_short() {
        int n;
        this.alignment(2);
        this.tmpLen.value = 2;
        if (this.next(this.tmpBuf, this.tmpOff, this.tmpLen) == 2) {
            n = (this.tmpBuf.value[this.tmpOff.value] & 0xFF) << (this._swap ? 0 : 8) | (this.tmpBuf.value[this.tmpOff.value + 1] & 0xFF) << (this._swap ? 8 : 0);
        } else {
            n = (this.tmpBuf.value[this.tmpOff.value] & 0xFF) << (this._swap ? 0 : 8);
            this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            n |= (this.tmpBuf.value[this.tmpOff.value] & 0xFF) << (this._swap ? 8 : 0);
        }
        this.postread(2);
        return (short)n;
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        int n;
        this.alignment(4);
        this.tmpLen.value = 4;
        int n2 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
        if (n2 == 4) {
            n = (this.tmpBuf.value[this.tmpOff.value] & 0xFF) << (this._swap ? 0 : 24) | (this.tmpBuf.value[this.tmpOff.value + 1] & 0xFF) << (this._swap ? 8 : 16) | (this.tmpBuf.value[this.tmpOff.value + 2] & 0xFF) << (this._swap ? 16 : 8) | (this.tmpBuf.value[this.tmpOff.value + 3] & 0xFF) << (this._swap ? 24 : 0);
        } else {
            n = 0;
            int n3 = this._swap ? 0 : 24;
            while (true) {
                int n4 = 0;
                while (n4 < n2) {
                    n |= (this.tmpBuf.value[this.tmpOff.value + n4] & 0xFF) << n3;
                    n3 += this._swap ? 8 : -8;
                    ++n4;
                }
                boolean bl = this._swap ? n3 < 24 : n3 > 0;
                if (!bl) break;
                n2 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            }
        }
        this.postread(4);
        return n;
    }

    private int peek_long() {
        this.mark(4);
        int n = this.read_long();
        try {
            this.reset();
        }
        catch (IOException iOException) {
            Trace.assert(false, iOException.toString());
        }
        return n;
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        long l;
        this.alignment(8);
        this.tmpLen.value = 8;
        int n = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
        if (n == 8) {
            l = ((long)this.tmpBuf.value[this.tmpOff.value] & 0xFFL) << (this._swap ? 0 : 56) | ((long)this.tmpBuf.value[this.tmpOff.value + 1] & 0xFFL) << (this._swap ? 8 : 48) | ((long)this.tmpBuf.value[this.tmpOff.value + 2] & 0xFFL) << (this._swap ? 16 : 40) | ((long)this.tmpBuf.value[this.tmpOff.value + 3] & 0xFFL) << (this._swap ? 24 : 32) | ((long)this.tmpBuf.value[this.tmpOff.value + 4] & 0xFFL) << (this._swap ? 32 : 24) | ((long)this.tmpBuf.value[this.tmpOff.value + 5] & 0xFFL) << (this._swap ? 40 : 16) | ((long)this.tmpBuf.value[this.tmpOff.value + 6] & 0xFFL) << (this._swap ? 48 : 8) | ((long)this.tmpBuf.value[this.tmpOff.value + 7] & 0xFFL) << (this._swap ? 56 : 0);
        } else {
            l = 0L;
            long l2 = this._swap ? 0L : 56L;
            while (true) {
                int n2 = 0;
                while (n2 < n) {
                    l |= (long)(this.tmpBuf.value[this.tmpOff.value + n2] & 0xFF) << (int)l2;
                    l2 += this._swap ? 8L : -8L;
                    ++n2;
                }
                boolean bl = this._swap ? l2 < 56L : l2 > 0L;
                if (!bl) break;
                n = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            }
        }
        this.postread(8);
        return l;
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public String read_string() {
        int n;
        byte[] byArray;
        int n2;
        this.tmpLen.value = n2 = this.read_ulong();
        this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
        this.postread(n2 - this.tmpLen.value);
        if (this.tmpLen.value == 0) {
            byArray = this.tmpBuf.value;
            n = this.tmpOff.value;
        } else {
            byArray = new byte[n2];
            n = 0;
            System.arraycopy(this.tmpBuf.value, this.tmpOff.value, byArray, 0, n2 - this.tmpLen.value);
            this.read_octet_array(byArray, n2 - this.tmpLen.value, this.tmpLen.value);
        }
        try {
            return new String(byArray, n, n2 - 1, this._charEnc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
            return null;
        }
    }

    public String read_wstring() {
        int n;
        byte[] byArray;
        if (this._wcharEnc == null) {
            if (this._version.minor == 0) {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            }
            return null;
        }
        if (this._version.minor == 0) {
            this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            return null;
        }
        int n2 = this.read_ulong();
        if (this._version.minor == 1 && this._wcharAlign > 1) {
            n2 *= this._wcharAlign;
        }
        this.tmpLen.value = n2;
        this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
        this.postread(n2 - this.tmpLen.value);
        if (this.tmpLen.value != 0) {
            byArray = new byte[n2];
            n = 0;
            System.arraycopy(this.tmpBuf.value, this.tmpOff.value, byArray, 0, n2 - this.tmpLen.value);
            this.read_octet_array(byArray, n2 - this.tmpLen.value, this.tmpLen.value);
            if (this._wcharReverse) {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = 0;
                    while (n4 < this._wcharAlign / 2) {
                        byte by = byArray[n + n3 + n4];
                        byArray[n + n3 + n4] = byArray[n + n3 + this._wcharAlign - n4];
                        byArray[n + n3 + this._wcharAlign - n4] = by;
                        ++n4;
                    }
                    n3 += this._wcharAlign;
                }
            }
        } else if (this._wcharReverse) {
            byArray = new byte[n2];
            n = 0;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < this._wcharAlign) {
                    byArray[n5 + n6] = this.tmpBuf.value[this.tmpOff.value + n5 + this._wcharAlign - n6];
                    ++n6;
                }
                n5 += this._wcharAlign;
            }
        } else {
            byArray = this.tmpBuf.value;
            n = this.tmpOff.value;
        }
        if (this._version.minor == 1) {
            n2 -= this._wcharAlign == 0 ? 1 : this._wcharAlign;
        }
        if (n2 == 0) {
            return "";
        }
        try {
            return new String(byArray, n, n2, this._wcharEnc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
            return null;
        }
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        this.alignment(1);
        this.tmpLen.value = n2;
        while (this.tmpLen.value > 0) {
            int n3 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            int n4 = 0;
            while (n4 < n3) {
                blArray[n + n4] = this.tmpBuf.value[this.tmpOff.value + n4] == 1;
                ++n4;
            }
            n += n3;
        }
        this.postread(n2);
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        int n3;
        byte[] byArray;
        this.alignment(1);
        this.tmpLen.value = n2;
        this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
        this.postread(n2 - this.tmpLen.value);
        if (this.tmpLen.value == 0) {
            byArray = this.tmpBuf.value;
            n3 = this.tmpOff.value;
        } else {
            byArray = new byte[n2];
            n3 = 0;
            System.arraycopy(this.tmpBuf.value, this.tmpOff.value, byArray, 0, n2 - this.tmpLen.value);
            this.read_octet_array(byArray, n2 - this.tmpLen.value, this.tmpLen.value);
        }
        try {
            String string = new String(byArray, n3, n2, this._charEnc);
            if (string.length() != n2) {
                this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
            }
            string.getChars(0, n2, cArray, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        if (this._wcharEnc == null) {
            if (this._version.minor == 0) {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        switch (this._version.minor) {
            case 0: {
                this.cancel(new MARSHAL("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 1: {
                int n3;
                int n4;
                byte[] byArray;
                this.alignment(2);
                int n5 = this.tmpLen.value = 2 * n2;
                this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                this.postread(n5 - this.tmpLen.value);
                if (this.tmpLen.value != 0) {
                    byArray = new byte[n5];
                    n4 = 0;
                    System.arraycopy(this.tmpBuf.value, this.tmpOff.value, byArray, 0, n5 - this.tmpLen.value);
                    this.read_octet_array(byArray, n5 - this.tmpLen.value, this.tmpLen.value);
                    if (this._wcharReverse) {
                        int n6 = 0;
                        while (n6 < n5) {
                            n3 = byArray[n6];
                            byArray[n6] = byArray[n6 + 1];
                            byArray[n6 + 1] = n3;
                            n6 += 2;
                        }
                    }
                } else if (this._wcharReverse) {
                    byArray = new byte[n5];
                    n4 = 0;
                    n3 = 0;
                    while (n3 < n5) {
                        byArray[0] = this.tmpBuf.value[this.tmpOff.value + n3 + 1];
                        byArray[1] = this.tmpBuf.value[this.tmpOff.value + n3];
                        n3 += 2;
                    }
                } else {
                    byArray = this.tmpBuf.value;
                    n4 = this.tmpOff.value;
                }
                try {
                    String string = new String(byArray, n4, n5, this._wcharEnc);
                    if (string.length() != n2) {
                        this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
                    }
                    string.getChars(0, n2, cArray, n);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Trace.assert(false, "Unsupported encoding should be impossible");
                }
                return;
            }
            case 2: {
                this.alignment(1);
                int n7 = 0;
                int n8 = 0;
                while (n8 < n2) {
                    int n9;
                    byte[] byArray;
                    this.tmpLen.value = 1;
                    this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                    int n10 = this.tmpLen.value = this.tmpBuf.value[this.tmpOff.value];
                    this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                    if (this.tmpLen.value != 0) {
                        this.postread(n7 + n10 + 1 - this.tmpLen.value);
                        n7 = 0;
                        byArray = new byte[n10];
                        n9 = 0;
                        System.arraycopy(this.tmpBuf.value, this.tmpOff.value, byArray, 0, n10 - this.tmpLen.value);
                        this.read_octet_array(byArray, n10 - this.tmpLen.value, this.tmpLen.value);
                        if (this._wcharReverse) {
                            int n11 = 0;
                            while (n11 < this._wcharAlign / 2) {
                                byte by = byArray[n9 + n11];
                                byArray[n9 + n11] = byArray[n9 + this._wcharAlign - n11];
                                byArray[n9 + this._wcharAlign - n11] = by;
                                ++n11;
                            }
                        }
                    } else if (this._wcharReverse) {
                        byArray = new byte[n10];
                        n9 = 0;
                        int n12 = 0;
                        while (n12 < this._wcharAlign) {
                            byArray[n12] = this.tmpBuf.value[this.tmpOff.value + this._wcharAlign - 1];
                            ++n12;
                        }
                    } else {
                        n7 += n10 + 1;
                        byArray = this.tmpBuf.value;
                        n9 = this.tmpOff.value;
                    }
                    try {
                        String string = new String(byArray, n9, n10, this._wcharEnc);
                        if (string.length() != 1) {
                            this.cancel(new MARSHAL("Unable to decode wchar value", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                        }
                        cArray[n + n8] = string.charAt(0);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Trace.assert(false, "Unsupported encoding should be impossible");
                    }
                    ++n8;
                }
                if (n7 <= 0) break;
                this.postread(n7);
            }
        }
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        this.alignment(1);
        this.tmpLen.value = n2;
        while (this.tmpLen.value > 0) {
            int n3 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            System.arraycopy(this.tmpBuf.value, this.tmpOff.value, byArray, n, n3);
            n += n3;
        }
        this.postread(n2);
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        this.alignment(2);
        this.tmpLen.value = n2 * 2;
        while (this.tmpLen.value > 0) {
            int n3 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            int n4 = 0;
            while (n4 < n3 - 1) {
                sArray[n] = (short)((this.tmpBuf.value[this.tmpOff.value + n4] & 0xFF) << (this._swap ? 0 : 8) | (this.tmpBuf.value[this.tmpOff.value + n4 + 1] & 0xFF) << (this._swap ? 8 : 0));
                n4 += 2;
                ++n;
            }
            if (n3 % 2 == 0) continue;
            int n5 = (this.tmpBuf.value[this.tmpOff.value + n3] & 0xFF) << (this._swap ? 0 : 8);
            int n6 = this.tmpLen.value;
            this.tmpLen.value = 1;
            this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            sArray[n] = (short)(n5 | (this.tmpBuf.value[this.tmpOff.value] & 0xFF) << (this._swap ? 8 : 0));
            ++n;
            this.tmpLen.value = n6 - 1;
        }
        this.postread(n2 * 2);
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        this.alignment(4);
        this.tmpLen.value = n2 * 4;
        while (this.tmpLen.value > 0) {
            int n3 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            int n4 = 0;
            while (n4 < n3 - 3) {
                nArray[n] = (this.tmpBuf.value[this.tmpOff.value + n4] & 0xFF) << (this._swap ? 0 : 24) | (this.tmpBuf.value[this.tmpOff.value + n4 + 1] & 0xFF) << (this._swap ? 8 : 16) | (this.tmpBuf.value[this.tmpOff.value + n4 + 2] & 0xFF) << (this._swap ? 16 : 8) | (this.tmpBuf.value[this.tmpOff.value + n4 + 3] & 0xFF) << (this._swap ? 24 : 0);
                n4 += 4;
                ++n;
            }
            if (n3 % 4 == 0) continue;
            nArray[n] = 0;
            int n5 = n3 % 4;
            n3 -= n3 % 4;
            int n6 = 0;
            while (n6 < n5) {
                nArray[n] = nArray[n] | (this.tmpBuf.value[this.tmpOff.value + n3 + n6] & 0xFF) << (this._swap ? 8 * n6 : 24 - 8 * n6);
                ++n6;
            }
            int n7 = this.tmpLen.value - (4 - n6);
            while (n6 < 4) {
                this.tmpLen.value = 4 - n6;
                n3 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                int n8 = 0;
                while (n8 < n3) {
                    nArray[n] = nArray[n] | (this.tmpBuf.value[this.tmpOff.value + n8] & 0xFF) << (this._swap ? 8 * n6 : 24 - 8 * n6);
                    ++n8;
                    ++n6;
                }
            }
            this.tmpLen.value = n7;
        }
        this.postread(n2 * 4);
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        this.alignment(8);
        this.tmpLen.value = n2 * 8;
        while (this.tmpLen.value > 0) {
            int n3 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
            int n4 = 0;
            while (n4 < n3 - 7) {
                lArray[n] = (long)(this.tmpBuf.value[this.tmpOff.value + n4] & 0xFF) << (int)(this._swap ? 0L : 56L) | (long)(this.tmpBuf.value[this.tmpOff.value + n4 + 1] & 0xFF) << (int)(this._swap ? 8L : 48L) | (long)(this.tmpBuf.value[this.tmpOff.value + n4 + 2] & 0xFF) << (int)(this._swap ? 16L : 40L) | (long)(this.tmpBuf.value[this.tmpOff.value + n4 + 3] & 0xFF) << (int)(this._swap ? 24L : 32L) | (long)(this.tmpBuf.value[this.tmpOff.value + n4 + 4] & 0xFF) << (int)(this._swap ? 32L : 24L) | (long)(this.tmpBuf.value[this.tmpOff.value + n4 + 5] & 0xFF) << (int)(this._swap ? 40L : 16L) | (long)(this.tmpBuf.value[this.tmpOff.value + n4 + 6] & 0xFF) << (int)(this._swap ? 48L : 8L) | (long)(this.tmpBuf.value[this.tmpOff.value + n4 + 7] & 0xFF) << (int)(this._swap ? 56L : 0L);
                n4 += 8;
                ++n;
            }
            if (n3 % 8 == 0) continue;
            lArray[n] = 0L;
            int n5 = n3 % 8;
            n3 -= n3 % 8;
            int n6 = 0;
            while (n6 < n5) {
                lArray[n] = lArray[n] | (long)(this.tmpBuf.value[this.tmpOff.value + n3 + n6] & 0xFF) << (int)(this._swap ? (long)(8 * n6) : (long)(56 - 8 * n6));
                ++n6;
            }
            int n7 = this.tmpLen.value - (8 - n6);
            while (n6 < 8) {
                this.tmpLen.value = 8 - n6;
                n3 = this.next(this.tmpBuf, this.tmpOff, this.tmpLen);
                int n8 = 0;
                while (n8 < n3) {
                    lArray[n] = lArray[n] | (long)(this.tmpBuf.value[this.tmpOff.value + n8] & 0xFF) << (int)(this._swap ? (long)(8 * n6) : (long)(56 - 8 * n6));
                    ++n8;
                    ++n6;
                }
            }
            this.tmpLen.value = n7;
        }
        this.postread(n2 * 8);
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        int[] nArray = new int[n2];
        this.read_long_array(nArray, 0, n2);
        int n3 = 0;
        while (n3 < n2) {
            fArray[n + n3] = Float.intBitsToFloat(nArray[n3]);
            ++n3;
        }
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        long[] lArray = new long[n2];
        this.read_longlong_array(lArray, 0, n2);
        int n3 = 0;
        while (n3 < n2) {
            dArray[n + n3] = Double.longBitsToDouble(lArray[n3]);
            ++n3;
        }
    }

    public TypeCode read_TypeCode() {
        return this.read_TypeCodeValue(new HashMap());
    }

    private TypeCode read_TypeCodeValue(HashMap hashMap) {
        TypeCode typeCode = null;
        this.alignment(4);
        Integer n = new Integer(this._index);
        int n2 = this.read_ulong();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                typeCode = this._orb.get_primitive_tc(TCKind.from_int(n2));
                break;
            }
            case 14: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string2 = this.read_string();
                this.end_encapsulation();
                typeCode = this._orb.create_interface_tc(string, string2);
                break;
            }
            case 15: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string3 = this.read_string();
                hashMap.put(n, string);
                int n3 = this.read_ulong();
                StructMember[] structMemberArray = new StructMember[n3];
                int n4 = 0;
                while (n4 < n3) {
                    structMemberArray[n4] = new StructMember();
                    structMemberArray[n4].name = this.read_string();
                    structMemberArray[n4].type = this.read_TypeCodeValue(hashMap);
                    ++n4;
                }
                this.end_encapsulation();
                typeCode = this._orb.create_struct_tc(string, string3, structMemberArray);
                break;
            }
            case 16: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string4 = this.read_string();
                hashMap.put(n, string);
                TypeCode typeCode2 = this.read_TypeCodeValue(hashMap);
                int n5 = this.read_long();
                int n6 = this.read_ulong();
                UnionMember[] unionMemberArray = new UnionMember[n6];
                int n7 = 0;
                while (n7 < n6) {
                    unionMemberArray[n7] = new UnionMember();
                    unionMemberArray[n7].label = this._orb.create_any();
                    unionMemberArray[n7].label.read_value(this, typeCode2);
                    if (n7 == n5) {
                        unionMemberArray[n7].label.insert_octet((byte)0);
                    }
                    unionMemberArray[n7].name = this.read_string();
                    unionMemberArray[n7].type = this.read_TypeCodeValue(hashMap);
                    ++n7;
                }
                this.end_encapsulation();
                typeCode = this._orb.create_union_tc(string, string4, typeCode2, unionMemberArray);
                break;
            }
            case 17: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string5 = this.read_string();
                int n8 = this.read_ulong();
                String[] stringArray = new String[n8];
                int n9 = 0;
                while (n9 < n8) {
                    stringArray[n9] = this.read_string();
                    ++n9;
                }
                this.end_encapsulation();
                typeCode = this._orb.create_enum_tc(string, string5, stringArray);
                break;
            }
            case 18: {
                int n10 = this.read_ulong();
                typeCode = this._orb.create_string_tc(n10);
                break;
            }
            case 19: {
                this.begin_encapsulation();
                TypeCodeArray typeCodeArray = new TypeCodeArray(TCKind.tk_sequence);
                hashMap.put(n, typeCodeArray);
                TypeCode typeCode3 = this.read_TypeCodeValue(hashMap);
                int n11 = this.read_ulong();
                typeCodeArray.setLength(n11);
                typeCodeArray.setElementType(typeCode3);
                this.end_encapsulation();
                typeCode = typeCodeArray;
                break;
            }
            case 20: {
                this.begin_encapsulation();
                TypeCode typeCode4 = this.read_TypeCodeValue(hashMap);
                int n12 = this.read_ulong();
                this.end_encapsulation();
                typeCode = this._orb.create_array_tc(n12, typeCode4);
                break;
            }
            case 21: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string6 = this.read_string();
                hashMap.put(n, string);
                TypeCode typeCode5 = this.read_TypeCodeValue(hashMap);
                this.end_encapsulation();
                typeCode = this._orb.create_alias_tc(string, string6, typeCode5);
                break;
            }
            case 22: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string7 = this.read_string();
                hashMap.put(n, string);
                int n13 = this.read_ulong();
                StructMember[] structMemberArray = new StructMember[n13];
                int n14 = 0;
                while (n14 < n13) {
                    structMemberArray[n14] = new StructMember();
                    structMemberArray[n14].name = this.read_string();
                    structMemberArray[n14].type = this.read_TypeCodeValue(hashMap);
                    ++n14;
                }
                this.end_encapsulation();
                typeCode = this._orb.create_exception_tc(string, string7, structMemberArray);
                hashMap.put(n, typeCode);
                break;
            }
            case 27: {
                int n15 = this.read_ulong();
                typeCode = this._orb.create_wstring_tc(n15);
                break;
            }
            case 28: {
                short s = this.read_ushort();
                short s2 = this.read_ushort();
                typeCode = this._orb.create_fixed_tc(s, s2);
                break;
            }
            case 29: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string8 = this.read_string();
                hashMap.put(n, string);
                short s = this.read_short();
                TypeCode typeCode6 = this.read_TypeCodeValue(hashMap);
                int n16 = this.read_ulong();
                ValueMember[] valueMemberArray = new ValueMember[n16];
                int n17 = 0;
                while (n17 < n16) {
                    valueMemberArray[n17] = new ValueMember();
                    valueMemberArray[n17].name = this.read_string();
                    valueMemberArray[n17].type = this.read_TypeCodeValue(hashMap);
                    valueMemberArray[n17].access = this.read_short();
                    ++n17;
                }
                this.end_encapsulation();
                typeCode = this._orb.create_value_tc(string, string8, s, typeCode6, valueMemberArray);
                break;
            }
            case 30: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string9 = this.read_string();
                hashMap.put(n, string);
                TypeCode typeCode7 = this.read_TypeCodeValue(hashMap);
                this.end_encapsulation();
                typeCode = this._orb.create_value_box_tc(string, string9, typeCode7);
                break;
            }
            case 31: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string10 = this.read_string();
                this.end_encapsulation();
                typeCode = this._orb.create_native_tc(string, string10);
                break;
            }
            case 32: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string11 = this.read_string();
                this.end_encapsulation();
                typeCode = this._orb.create_abstract_interface_tc(string, string11);
                break;
            }
            case -1: {
                int n18 = this.read_long();
                int n19 = this._index + n18 - 4;
                n19 += n19 & 3;
                java.lang.Object v = hashMap.get(new Integer(n19));
                if (v instanceof String) {
                    typeCode = this._orb.create_recursive_tc((String)v);
                    break;
                }
                if (v != null) {
                    typeCode = (TypeCode)v;
                    break;
                }
                this.cancel(new MARSHAL("Invalid typecode offset", 1146056978, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            default: {
                this.cancel(new MARSHAL("Invalid typecode kind", 1146056979, CompletionStatus.COMPLETED_MAYBE));
            }
        }
        hashMap.put(n, typeCode);
        return typeCode;
    }

    public Any read_any() {
        TypeCode typeCode = this.read_TypeCode();
        Any any = this._orb.create_any();
        any.read_value(this, typeCode);
        return any;
    }

    public Principal read_Principal() {
        byte[] byArray = new byte[this.read_ulong()];
        this.read_octet_array(byArray, 0, byArray.length);
        return new org.openorb.CORBA.Principal(byArray);
    }

    public Object read_Object() {
        IOR iOR = IORHelper.read(this);
        if (iOR.type_id.length() == 0 && iOR.profiles.length == 0) {
            return null;
        }
        return new ObjectStub(this._orb, iOR);
    }

    public Object read_Object(Class clazz) {
        IOR iOR = IORHelper.read(this);
        if (iOR.type_id.length() == 0 && iOR.profiles.length == 0) {
            return null;
        }
        if (clazz == null || !(class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = CDRInputStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz)) {
            return new ObjectStub(this._orb, iOR);
        }
        ObjectImpl objectImpl = null;
        try {
            objectImpl = (ObjectImpl)clazz.newInstance();
        }
        catch (Exception exception) {
            this.cancel(new BAD_PARAM("Unable to instantiate class", 1146056962, CompletionStatus.COMPLETED_NO));
        }
        Delegate delegate = new Delegate(this._orb, iOR);
        objectImpl._set_delegate(delegate);
        return objectImpl;
    }

    public Context read_Context() {
        java.lang.Object object;
        NVList nVList = this._orb.create_list(0);
        int n = this.read_ulong() / 2;
        int n2 = 0;
        while (n2 < n) {
            object = this._orb.create_any();
            String string = this.read_string();
            ((Any)object).insert_string(this.read_string());
            nVList.add_value(string, (Any)object, 0);
            ++n2;
        }
        object = new org.openorb.CORBA.dii.Context("", null, this._orb);
        ((Context)object).set_values(nVList);
        return object;
    }

    public BigDecimal read_fixed() {
        return this.read_fixed((short)-1, (short)-1);
    }

    public BigDecimal read_fixed(TypeCode typeCode) {
        try {
            return this.read_fixed(typeCode.fixed_digits(), typeCode.fixed_scale());
        }
        catch (BadKind badKind) {
            this.cancel(new BAD_PARAM("Typecode is not fixed type", 1146056963, CompletionStatus.COMPLETED_NO));
            return null;
        }
    }

    public BigDecimal read_fixed(short s, short s2) {
        BigDecimal bigDecimal;
        StringBuffer stringBuffer = new StringBuffer();
        short s3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            byte by = this.read_octet();
            int n = by >>> 4 & 0xF;
            int n2 = by & 0xF;
            if (n > 9) {
                this.cancel(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE));
            }
            if (bl || n > 0) {
                stringBuffer.append(48 + n);
                ++s3;
            }
            if (n2 < 10) {
                stringBuffer.append(48 + n2);
                ++s3;
            } else {
                if (n2 == 12) {
                    bl2 = true;
                    break;
                }
                if (n2 == 13) break;
                this.cancel(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE));
            }
            bl = true;
        }
        if (s >= 0 && s3 > s) {
            this.cancel(new MARSHAL("Fixed data does not match type", 1146056980, CompletionStatus.COMPLETED_MAYBE));
        }
        try {
            bigDecimal = new BigDecimal(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.cancel(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE));
            return null;
        }
        if (bl2) {
            bigDecimal = bigDecimal.negate();
        }
        if (s2 > 0) {
            bigDecimal = bigDecimal.movePointLeft(s2);
        }
        return bigDecimal;
    }

    public Serializable read_value() {
        return this.read_value(this.read_long(), null, null, null, null);
    }

    public Serializable read_value(String string) {
        return this.read_value(this.read_long(), string, null, null, null);
    }

    public Serializable read_value(Class clazz) {
        return this.read_value(this.read_long(), null, clazz, null, null);
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        return this.read_value(this.read_long(), null, null, boxedValueHelper, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Serializable read_value(int var1_1, String var2_2, Class var3_3, BoxedValueHelper var4_4, Serializable var5_5) {
        block57: {
            block56: {
                block55: {
                    block54: {
                        block59: {
                            block62: {
                                block60: {
                                    block61: {
                                        if (var1_1 == 0) {
                                            return null;
                                        }
                                        if (var1_1 == -1) {
                                            var6_6 = this._index + this.read_long();
                                            var7_7 = (String)this._value_cache.get(new Integer(var6_6));
                                            if (var7_7 instanceof MARSHAL) {
                                                this.cancel((MARSHAL)var7_7);
                                            }
                                            if (var7_7 instanceof Serializable) {
                                                return (Serializable)var7_7;
                                            }
                                            this.cancel(new IndirectionException(var6_6));
                                        }
                                        if (var1_1 < 0x7FFFFF00 || var1_1 > 0x7FFFFFFF) {
                                            this.cancel(new MARSHAL("Invalid value tag", 1146056981, CompletionStatus.COMPLETED_MAYBE));
                                        }
                                        var6_6 = this._index - 4;
                                        var7_7 = null;
                                        if ((var1_1 & 1) == 1) {
                                            if (this.peek_long() == -1) {
                                                this.read_long();
                                                var8_8 = this._index + this.read_long();
                                                var9_10 = this._value_cache.get(new Integer(var8_8));
                                                if (var9_10 == null || !(var9_10 instanceof String)) {
                                                    this.cancel(new IndirectionException(var8_8));
                                                }
                                                var7_7 = (String)var9_10;
                                            } else {
                                                var8_8 = this._index;
                                                var7_7 = this.read_string();
                                                this._value_cache.put(new Integer(var8_8), var7_7);
                                            }
                                        }
                                        var8_9 = null;
                                        if ((var1_1 & 6) == 0) break block59;
                                        if ((var1_1 & 6) != 6) break block60;
                                        var9_11 = this.read_long();
                                        if (var9_11 != -1) break block61;
                                        var10_14 = this._index + this.read_long();
                                        var11_15 = this._value_cache.get(new Integer(var10_14));
                                        if (var11_15 == null || !(var11_15 instanceof String[])) {
                                            this.cancel(new IndirectionException(var10_14));
                                        }
                                        var8_9 = (String[])var11_15;
                                        this._value_cache.put(new Integer(this._index - 4), var8_9);
                                        break block59;
                                    }
                                    var8_9 = new String[var9_11];
                                    this._value_cache.put(new Integer(this._index - 4), var8_9);
                                    break block62;
                                }
                                var8_9 = new String[1];
                            }
                            var9_12 = 0;
                            while (var9_12 < var8_9.length) {
                                if (this.peek_long() == -1) {
                                    this.read_long();
                                    var10_14 = this._index + this.read_long();
                                    var11_15 = this._value_cache.get(new Integer(var10_14));
                                    if (var11_15 == null || !(var11_15 instanceof String)) {
                                        this.cancel(new IndirectionException(var10_14));
                                    }
                                    var8_9[var9_12] = (String)var11_15;
                                    this._value_cache.put(new Integer(this._index - 4), var8_9[var9_12]);
                                } else {
                                    this.alignment(4);
                                    var10_14 = this._index;
                                    var8_9[var9_12] = this.read_string();
                                    this._value_cache.put(new Integer(var10_14), var8_9[var9_12]);
                                }
                                ++var9_12;
                            }
                        }
                        var9_13 = this._in_chunked_value;
                        var10_14 = this._value_level;
                        if ((var1_1 & 8) == 8) {
                            var11_16 = this.peek_long();
                            if (var11_16 < 0x7FFFFF00 || var11_16 > 0x7FFFFFFF) {
                                this.begin_value_chunk(this.read_ulong());
                            }
                            this._in_chunked_value = true;
                        }
                        ++this._value_level;
                        this._value_indirect = var6_6;
                        try {
                            block64: {
                                block63: {
                                    if (var4_4 == null) break block63;
                                    var11_17 = var4_4.read_value(this);
                                    this._value_cache.put(new Integer(this._value_indirect), var11_17);
                                    this._value_indirect = -1;
                                    var12_20 = var11_17;
                                    var14_24 = null;
                                    if ((var1_1 & 8) != 8) break block54;
                                    if (true) ** GOTO lbl172
                                }
                                if (var5_5 != null) {
                                    var11_18 = this.read_value(var5_5);
                                    break block55;
                                }
                                var11_19 = null;
                                if (var8_9 == null) break block64;
                                var12_21 = 0;
                                if (true) ** GOTO lbl212
                            }
                            if (var2_2 != null) {
                                var11_19 = this.read_value_withtype(var2_2, var7_7, var3_3);
                            }
lbl103:
                            // 5 sources

                            while (true) {
                                if (var11_19 == null) {
                                    var12_22 = new MARSHAL("Unable to locate value factory", 83099649, CompletionStatus.COMPLETED_YES);
                                    this._value_cache.put(new Integer(this._value_indirect), var12_22);
                                    this._value_indirect = -1;
                                    if (this._continueLevel > 0) {
                                        throw var12_22;
                                    }
                                    this.cancel(var12_22);
                                }
                                if (var3_3 != null && !var3_3.isInstance(var11_19)) {
                                    this.cancel(new BAD_PARAM("Returned type does not match expected type", 1146056964, CompletionStatus.COMPLETED_YES));
                                }
                                var12_23 = var11_19;
                                break block56;
                                break;
                            }
                        }
                        catch (Throwable var13_48) {
                            var14_27 = null;
                            if ((var1_1 & 8) != 8) break block57;
                            if (true) ** GOTO lbl280
                        }
                    }
                    this._value_level = var10_14;
                    return var12_20;
                }
                var14_25 = null;
                if ((var1_1 & 8) != 8) {
                    this._value_level = var10_14;
                    return var11_18;
                }
                ** GOTO lbl206
            }
            var14_26 = null;
            if ((var1_1 & 8) != 8) {
                this._value_level = var10_14;
                return var12_23;
            }
            ** GOTO lbl245
        }
        this._value_level = var10_14;
        throw var13_48;
        do {
            if (this._encaps_remain > 0) {
                this.force_skip(this._encaps_remain);
            }
            this._pending_value_reopen = false;
            var15_28 = this.read_long();
            if (var15_28 >= 0x7FFFFF00 && var15_28 <= 0x7FFFFFFF) {
                var16_32 = this._index - 4;
                try {
                    try {
                        ++this._continueLevel;
                        this.read_value(var15_28, null, null, null, null);
                    }
                    catch (MARSHAL var17_36) {
                        if (var17_36.minor != 83099649) {
                            throw (MARSHAL)var17_36.fillInStackTrace();
                        }
                        var19_40 = null;
                        --this._continueLevel;
                    }
                    var19_40 = null;
                    --this._continueLevel;
                }
                catch (Throwable var18_44) {
                    var19_40 = null;
                    --this._continueLevel;
                    throw var18_44;
                }
            }
            if (var15_28 > 0) {
                this.begin_value_chunk(var15_28);
                continue;
            }
            this._value_level = -var15_28 - 1;
lbl172:
            // 5 sources

        } while (this._value_level > var10_14);
        this._pending_value_reopen = this._in_chunked_value = var9_13;
        return var12_20;
lbl-1000:
        // 1 sources

        {
            block65: {
                if (this._encaps_remain > 0) {
                    this.force_skip(this._encaps_remain);
                }
                this._pending_value_reopen = false;
                var15_29 = this.read_long();
                if (var15_29 < 0x7FFFFF00 || var15_29 > 0x7FFFFFFF) break block65;
                var16_33 = this._index - 4;
                try {}
                catch (Throwable var18_45) {
                    var19_41 = null;
                    --this._continueLevel;
                    throw var18_45;
                }
                try {}
                catch (MARSHAL var17_37) {
                    if (var17_37.minor != 83099649) {
                        throw (MARSHAL)var17_37.fillInStackTrace();
                    }
                    var19_41 = null;
                    --this._continueLevel;
                    continue;
                }
                ++this._continueLevel;
                this.read_value(var15_29, null, null, null, null);
                var19_41 = null;
                --this._continueLevel;
                continue;
            }
            if (var15_29 > 0) {
                this.begin_value_chunk(var15_29);
                continue;
            }
            this._value_level = -var15_29 - 1;
lbl206:
            // 5 sources

            ** while (this._value_level > var10_14)
        }
lbl207:
        // 1 sources

        this._pending_value_reopen = this._in_chunked_value = var9_13;
        return var11_18;
        do {
            if ((var11_19 = this.read_value_withtype(var8_9[var12_21], var7_7, var3_3)) != null || var2_2 != null && var8_9[var12_21].equals(var2_2)) ** GOTO lbl103
            ++var12_21;
lbl212:
            // 2 sources

        } while (var12_21 < var8_9.length);
        ** while (true)
lbl-1000:
        // 1 sources

        {
            block66: {
                if (this._encaps_remain > 0) {
                    this.force_skip(this._encaps_remain);
                }
                this._pending_value_reopen = false;
                var15_30 = this.read_long();
                if (var15_30 < 0x7FFFFF00 || var15_30 > 0x7FFFFFFF) break block66;
                var16_34 = this._index - 4;
                try {}
                catch (Throwable var18_46) {
                    var19_42 = null;
                    --this._continueLevel;
                    throw var18_46;
                }
                try {}
                catch (MARSHAL var17_38) {
                    if (var17_38.minor != 83099649) {
                        throw (MARSHAL)var17_38.fillInStackTrace();
                    }
                    var19_42 = null;
                    --this._continueLevel;
                    continue;
                }
                ++this._continueLevel;
                this.read_value(var15_30, null, null, null, null);
                var19_42 = null;
                --this._continueLevel;
                continue;
            }
            if (var15_30 > 0) {
                this.begin_value_chunk(var15_30);
                continue;
            }
            this._value_level = -var15_30 - 1;
lbl245:
            // 5 sources

            ** while (this._value_level > var10_14)
        }
lbl246:
        // 1 sources

        this._pending_value_reopen = this._in_chunked_value = var9_13;
        return var12_23;
        do {
            block67: {
                if (this._encaps_remain > 0) {
                    this.force_skip(this._encaps_remain);
                }
                this._pending_value_reopen = false;
                var15_31 = this.read_long();
                if (var15_31 < 0x7FFFFF00 || var15_31 > 0x7FFFFFFF) break block67;
                var16_35 = this._index - 4;
                try {}
                catch (Throwable var18_47) {
                    var19_43 = null;
                    --this._continueLevel;
                    throw var18_47;
                }
                try {}
                catch (MARSHAL var17_39) {
                    if (var17_39.minor != 83099649) {
                        throw (MARSHAL)var17_39.fillInStackTrace();
                    }
                    var19_43 = null;
                    --this._continueLevel;
                    continue;
                }
                ++this._continueLevel;
                this.read_value(var15_31, null, null, null, null);
                var19_43 = null;
                --this._continueLevel;
                continue;
            }
            if (var15_31 > 0) {
                this.begin_value_chunk(var15_31);
                continue;
            }
            this._value_level = -var15_31 - 1;
lbl280:
            // 5 sources

        } while (this._value_level > var10_14);
        this._pending_value_reopen = this._in_chunked_value = var9_13;
        throw var13_48;
    }

    private void begin_value_chunk(int n) {
        this._encaps_stack.addLast(new Integer(this._encaps_remain));
        this._encaps_stack.addLast(new Integer(this._index));
        this._encaps_stack.addLast(new Boolean(true));
        this._encaps_remain = n;
    }

    private Serializable read_value_withtype(String string, String string2, Class clazz) {
        ValueFactory valueFactory = ((ORB)this._orb).lookup_value_factory(string);
        if (valueFactory != null) {
            return valueFactory.read_value(this);
        }
        Serializable serializable = this.value_extended_unmarshal(this._value_indirect, clazz, string, string2, null);
        if (serializable != null) {
            this._value_cache.put(new Integer(this._value_indirect), serializable);
            return serializable;
        }
        BoxedValueHelper boxedValueHelper = null;
        try {
            String string3 = RepoIDHelper.idToClass(string, 2);
            boxedValueHelper = (BoxedValueHelper)Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (boxedValueHelper != null) {
            serializable = boxedValueHelper.read_value(this);
            this._value_cache.put(new Integer(this._value_indirect), serializable);
            this._value_indirect = -1;
            return serializable;
        }
        if (string2 != null && (valueFactory = this.loadFactoryWithID(string, string2)) != null) {
            return valueFactory.read_value(this);
        }
        return null;
    }

    public Serializable read_value(Serializable serializable) {
        if (this._value_indirect < 0) {
            return this.read_value(this.read_long(), null, null, null, serializable);
        }
        this._value_cache.put(new Integer(this._value_indirect), serializable);
        if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).unmarshal(new DataInputStream(this));
        } else if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._read(this);
        } else {
            this.cancel(new BAD_PARAM("Unable to read value into class", 1146056964, CompletionStatus.COMPLETED_YES));
        }
        return serializable;
    }

    protected Serializable value_extended_unmarshal(int n, Class clazz, String string, String string2, RunTime runTime) {
        return null;
    }

    public java.lang.Object read_abstract_interface() {
        if (this.read_boolean()) {
            return this.read_Object();
        }
        return this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        if (this.read_boolean()) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    private void postread(int n) {
        this._index += n;
        if (this._encaps_remain > 0) {
            this._encaps_remain -= n;
            while (this._encaps_remain == 0) {
                boolean bl = (Boolean)this._encaps_stack.removeLast();
                int n2 = this._index - (Integer)this._encaps_stack.removeLast();
                this._encaps_remain = (Integer)this._encaps_stack.removeLast() - n2;
                if (bl) {
                    this._pending_value_reopen = true;
                } else {
                    this._swap = (Boolean)this._encaps_stack.removeLast();
                    if (!this._encaps_stack.isEmpty()) {
                        this._in_chunked_value = (Boolean)this._encaps_stack.getLast();
                    }
                    ++this._pending_encaps_close;
                }
                if (this._encaps_remain >= 0) continue;
                this._encaps_remain = -1;
            }
        }
    }

    protected ValueFactory loadFactoryWithID(String string, String string2) {
        String string3 = RepoIDHelper.idToClass(string, 4);
        try {
            Class clazz = this.loadClassFromURL(string3, string2);
            clazz = string2 != null ? this.loadClassFromURL(string3, string2) : Class.forName(string3);
            if (clazz != null) {
                return (ValueFactory)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Class loadClassFromURL(String string, String string2) {
        try {
            java.lang.Object object;
            if (string2 == null) {
                return Class.forName(string);
            }
            ClassLoader classLoader = (ClassLoader)this._value_cache.get(string2);
            if (classLoader == null) {
                object = new StringTokenizer(string2, " ");
                URL[] uRLArray = new URL[((StringTokenizer)object).countTokens()];
                int n = 0;
                int n2 = 0;
                while (n2 < uRLArray.length) {
                    try {
                        uRLArray[n] = new URL(((StringTokenizer)object).nextToken());
                        ++n;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    ++n2;
                }
                if (n != uRLArray.length) {
                    URL[] uRLArray2 = uRLArray;
                    uRLArray = new URL[n];
                    System.arraycopy(uRLArray2, 0, uRLArray, 0, n);
                }
                classLoader = new URLClassLoader(uRLArray);
                this._value_cache.put(string2, classLoader);
            }
            object = classLoader.loadClass(string);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.high(this.toString(), "Unable to find class from an URL : " + string);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MarkState {
        int _index;
        boolean _swap;
        int _encaps_remain = -1;
        int _pending_encaps_close;
        LinkedList _encaps_stack;
        int _value_level;
        boolean _pending_value_reopen;
        boolean _in_chunked_value;
        int _value_indirect;

        MarkState() {
            this._index = CDRInputStream.this._index;
            this._swap = CDRInputStream.this._swap;
            this._encaps_remain = CDRInputStream.this._encaps_remain;
            this._pending_encaps_close = CDRInputStream.this._pending_encaps_close;
            this._encaps_stack = new LinkedList(CDRInputStream.this._encaps_stack);
            this._value_level = CDRInputStream.this._value_level;
            this._pending_value_reopen = CDRInputStream.this._pending_value_reopen;
            this._in_chunked_value = CDRInputStream.this._in_chunked_value;
            this._value_indirect = CDRInputStream.this._value_indirect;
        }

        void reset() {
            CDRInputStream.this._index = this._index;
            CDRInputStream.this._swap = this._swap;
            CDRInputStream.this._encaps_remain = this._encaps_remain;
            CDRInputStream.this._pending_encaps_close = this._pending_encaps_close;
            CDRInputStream.this._encaps_stack = this._encaps_stack;
            CDRInputStream.this._value_level = this._value_level;
            CDRInputStream.this._pending_value_reopen = this._pending_value_reopen;
            CDRInputStream.this._in_chunked_value = this._in_chunked_value;
            CDRInputStream.this._value_indirect = this._value_indirect;
        }
    }
}

