/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;
import org.openorb.CORBA.Any;
import org.openorb.CORBA.DataOutputStream;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.typecode.TypeCodeBase;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.ExtendedOutputStream;
import org.openorb.io.MarshalBuffer;
import org.openorb.util.IdentityKey;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class CDROutputStream
extends OutputStream
implements ExtendedOutputStream {
    private static final int NO_CODEBASE = 0;
    private static final int CODEBASE = 1;
    private static final int NO_TYPE_INFORMATION = 0;
    private static final int SINGLE_TYPE_INFORMATION = 2;
    private static final int MULTIPLE_TYPE_INFORMATION = 6;
    private static final int CHUNK = 8;
    private static final int NO_CHUNK = 0;
    private org.omg.CORBA.ORB _orb;
    private Version _version;
    private MarshalBuffer _buf;
    private String _charEnc = "UTF-8";
    private String _wcharEnc = "UnicodeBigUnmarked";
    private int _wcharAlign = 2;
    private int _index = 0;
    private int _pending_align = 0;
    private int _realign = 0;
    private LinkedList _old_realign = new LinkedList();
    private int _value_level = 0;
    private boolean _in_chunked_value = false;
    private Map _value_idx = new HashMap();
    private Map _url_idx = new HashMap();
    private Map _typecode_list_idx = new HashMap();
    private Map _typecode_idx = new HashMap();
    private int _pending_value_closes = 0;
    private boolean _pending_value_open = false;
    private OctetSeqHolder tmpBuf = new OctetSeqHolder();
    private IntHolder tmpOff = new IntHolder();
    private IntHolder tmpLen = new IntHolder();
    private String _systemURLs = null;
    private static final MarshalBuffer.BlockGenerator ENCAPS_GEN = new MarshalBuffer.BlockGenerator(){

        public void endBlock(byte[] byArray, int n, int n2, int n3, java.lang.Object object) {
            byArray[n] = (byte)((n3 -= 4) >>> 24);
            byArray[n + 1] = (byte)(n3 >>> 16);
            byArray[n + 2] = (byte)(n3 >>> 8);
            byArray[n + 3] = (byte)n3;
        }

        public void fragmentBlock(byte[] byArray, int n, int n2, int n3, MarshalBuffer marshalBuffer, java.lang.Object object) {
            Trace.assert(false, "unable to fragment encapsulation");
        }
    };
    private static final MarshalBuffer.BlockGenerator CHUNK_GEN = new MarshalBuffer.BlockGenerator(){

        public void endBlock(byte[] byArray, int n, int n2, int n3, java.lang.Object object) {
            Trace.assert((n3 -= 4) > 0);
            byArray[n] = (byte)(n3 >>> 24);
            byArray[n + 1] = (byte)(n3 >>> 16);
            byArray[n + 2] = (byte)(n3 >>> 8);
            byArray[n + 3] = (byte)n3;
        }

        public void fragmentBlock(byte[] byArray, int n, int n2, int n3, MarshalBuffer marshalBuffer, java.lang.Object object) {
            Trace.assert((n3 -= 4) > 0);
            byArray[n] = (byte)(n3 >>> 24);
            byArray[n + 1] = (byte)(n3 >>> 16);
            byArray[n + 2] = (byte)(n3 >>> 8);
            byArray[n + 3] = (byte)n3;
            ((CDROutputStream)object)._pending_value_open = true;
        }
    };
    private static final IOR nullIOR = new IOR("", new TaggedProfile[0]);

    public CDROutputStream(org.omg.CORBA.ORB oRB, Version version, MarshalBuffer marshalBuffer) {
        this._orb = oRB;
        this._version = version;
        this._buf = marshalBuffer;
        if (this._version.minor == 0) {
            this._charEnc = "US-ASCII";
            this._wcharEnc = null;
        }
    }

    public void setCodesets(int n, int n2) {
        if (n != 0) {
            this._charEnc = CodeSetDatabase.codesetIDtoEncoding(n);
            if (this._charEnc == null || CodeSetDatabase.codesetIDtoAlignment(n) > 1) {
                this._buf.cancel(new CODESET_INCOMPATIBLE());
                return;
            }
        }
        if (n2 == 0) {
            this._wcharEnc = null;
        } else {
            this._wcharEnc = CodeSetDatabase.codesetIDtoEncoding(n2);
            this._wcharAlign = CodeSetDatabase.codesetIDtoAlignment(n2);
            if (this._wcharEnc == null || this._version.minor == 1 && this._wcharAlign != 2) {
                this._buf.cancel(new CODESET_INCOMPATIBLE());
                return;
            }
        }
    }

    void addHeader(MarshalBuffer.HeaderGenerator headerGenerator, int n, boolean bl, java.lang.Object object) {
        this._buf.addHeader(headerGenerator, n, bl, object);
        this._index += n;
    }

    void allowFragment() {
        this._buf.setAllowFragment(true);
    }

    public org.omg.CORBA.ORB orb() {
        return this._orb;
    }

    public Version version() {
        return this._version;
    }

    public void alignment(int n) {
        if (this._pending_value_closes > 0) {
            this.value_end_block();
            if (this._in_chunked_value) {
                this._pending_value_open = true;
            }
        }
        if (this._pending_value_open) {
            this._pending_value_open = false;
            this.value_begin_block();
        }
        if (n > 1 || this._pending_align > 0) {
            int n2;
            if (n < this._pending_align) {
                n = this._pending_align;
                this._pending_align = 0;
            }
            if ((n2 = (this._index - this._realign) % n) != 0) {
                int n3 = n - n2;
                this._buf.pad(n3);
                this._index += n3;
            }
        }
    }

    public void pending_alignment(int n) {
        this._pending_align = n;
    }

    public int index() {
        return this._index;
    }

    public void begin_encapsulation() {
        this.alignment(4);
        this._buf.beginBlock(ENCAPS_GEN, 4, false, null);
        this._index += 4;
        this._old_realign.addLast(new Integer(this._realign));
        this._realign = (this._index - this._realign) % 8;
        this.write_boolean(false);
    }

    public void end_encapsulation() {
        this._buf.endBlock();
        this._realign = (Integer)this._old_realign.removeLast();
    }

    public void write(int n) {
        this.write_octet((byte)n);
    }

    public void write(byte[] byArray) {
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.write_octet_array(byArray, n, n2);
    }

    public void close() {
        if (!this._old_realign.isEmpty()) {
            this._buf.cancel(new MARSHAL("closed stream without closing all encapsulation layers", 1146056982, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this._value_level - this._pending_value_closes > 0) {
            this._buf.cancel(new MARSHAL("closed stream before value completley marshalled", 1146056981, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this._pending_value_closes > 0) {
            this.value_end_block();
        }
        this._buf.close();
    }

    public void flush() {
    }

    public InputStream create_input_stream() {
        this._buf.cancel(new NO_IMPLEMENT());
        throw new NO_IMPLEMENT();
    }

    void cancel(SystemException systemException) {
        this._buf.cancel(systemException);
    }

    public void write_boolean(boolean bl) {
        this.alignment(1);
        this._buf.alloc(this.tmpBuf, this.tmpOff, 1);
        ++this._index;
        this.tmpBuf.value[this.tmpOff.value] = bl ? (byte)1 : 0;
    }

    public void write_octet(byte by) {
        this.alignment(1);
        this._buf.alloc(this.tmpBuf, this.tmpOff, 1);
        ++this._index;
        this.tmpBuf.value[this.tmpOff.value] = by;
    }

    public void write_char(char c) {
        try {
            byte[] byArray = String.valueOf(c).getBytes(this._charEnc);
            if (byArray.length != 1) {
                this._buf.cancel(new DATA_CONVERSION("Bad char type", 83099649, CompletionStatus.COMPLETED_MAYBE));
            }
            this.alignment(1);
            this._buf.append(byArray, 0, 1);
            ++this._index;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
    }

    public void write_wchar(char c) {
        if (this._wcharEnc == null) {
            if (this._version.minor == 0) {
                this._buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this._buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            switch (this._version.minor) {
                case 0: {
                    this._buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    break;
                }
                case 1: {
                    this.alignment(2);
                    byte[] byArray = String.valueOf(c).getBytes(this._wcharEnc);
                    if (byArray.length != 2) {
                        this._buf.cancel(new DATA_CONVERSION("Bad wchar type", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                    }
                    this._buf.append(byArray, 0, 2);
                    this._index += 2;
                    break;
                }
                case 2: {
                    this.alignment(1);
                    byte[] byArray = String.valueOf(c).getBytes(this._wcharEnc);
                    this._buf.alloc(this.tmpBuf, this.tmpOff, byArray.length + 1);
                    this._index += byArray.length + 1;
                    this.tmpBuf.value[this.tmpOff.value] = (byte)byArray.length;
                    System.arraycopy(byArray, 0, this.tmpBuf.value, this.tmpOff.value + 1, byArray.length);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
    }

    public void write_short(short s) {
        this.alignment(2);
        this._buf.alloc(this.tmpBuf, this.tmpOff, 2);
        this._index += 2;
        this.tmpBuf.value[this.tmpOff.value] = (byte)(s >>> 8);
        this.tmpBuf.value[this.tmpOff.value + 1] = (byte)s;
    }

    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.alignment(4);
        this._buf.alloc(this.tmpBuf, this.tmpOff, 4);
        this._index += 4;
        this.tmpBuf.value[this.tmpOff.value] = (byte)(n >>> 24);
        this.tmpBuf.value[this.tmpOff.value + 1] = (byte)(n >>> 16);
        this.tmpBuf.value[this.tmpOff.value + 2] = (byte)(n >>> 8);
        this.tmpBuf.value[this.tmpOff.value + 3] = (byte)n;
    }

    public void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_longlong(long l) {
        this.alignment(8);
        this._buf.alloc(this.tmpBuf, this.tmpOff, 8);
        this._index += 8;
        this.tmpBuf.value[this.tmpOff.value] = (byte)(l >>> 56);
        this.tmpBuf.value[this.tmpOff.value + 1] = (byte)(l >>> 48);
        this.tmpBuf.value[this.tmpOff.value + 2] = (byte)(l >>> 40);
        this.tmpBuf.value[this.tmpOff.value + 3] = (byte)(l >>> 32);
        this.tmpBuf.value[this.tmpOff.value + 4] = (byte)(l >>> 24);
        this.tmpBuf.value[this.tmpOff.value + 5] = (byte)(l >>> 16);
        this.tmpBuf.value[this.tmpOff.value + 6] = (byte)(l >>> 8);
        this.tmpBuf.value[this.tmpOff.value + 7] = (byte)l;
    }

    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        if (string == null) {
            this._buf.cancel(new BAD_PARAM("Cannot marshal null string", 1146056965, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (string.length() == 0) {
            this.write_ulong(1);
            this.write_octet((byte)0);
            return;
        }
        try {
            byte[] byArray = (string + '\u0000').getBytes(this._charEnc);
            this.write_ulong(byArray.length);
            this._buf.append(byArray, 0, byArray.length);
            this._index += byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
    }

    public void write_wstring(String string) {
        if (string == null) {
            this._buf.cancel(new BAD_PARAM("Cannot marshal null wstring", 1146056965, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this._wcharEnc == null) {
            if (this._version.minor == 0) {
                this._buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this._buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            byte[] byArray = null;
            switch (this._version.minor) {
                case 0: {
                    this._buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                case 1: {
                    byArray = (string + '\u0000').getBytes(this._wcharEnc);
                    this.write_ulong(byArray.length / 2);
                    break;
                }
                case 2: {
                    byArray = string.getBytes(this._wcharEnc);
                    this.write_ulong(byArray.length);
                }
            }
            this._buf.append(byArray, 0, byArray.length);
            this._index += byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (n + n2 > blArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        this._buf.alloc(this.tmpBuf, this.tmpOff, n2);
        this._index += n2;
        int n3 = 0;
        while (n3 < n2) {
            this.tmpBuf.value[this.tmpOff.value + n3] = blArray[n + n3] ? (byte)1 : 0;
            ++n3;
        }
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        if (n + n2 > cArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        try {
            byte[] byArray = new String(cArray, n, n2).getBytes(this._charEnc);
            if (byArray.length != n2) {
                this._buf.cancel(new DATA_CONVERSION("Bad char type", 83099649, CompletionStatus.COMPLETED_MAYBE));
            }
            this._buf.append(byArray, 0, n2);
            this._index += n2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (n + n2 > cArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        if (this._wcharEnc == null) {
            if (this._version.minor == 0) {
                this._buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this._buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            switch (this._version.minor) {
                case 0: {
                    this._buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                case 1: {
                    this.alignment(2);
                    byte[] byArray = new String(cArray, n, n2).getBytes(this._wcharEnc);
                    if (byArray.length != 2 * n2) {
                        this._buf.cancel(new DATA_CONVERSION("Bad whar type", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                    }
                    this._buf.append(byArray, 0, byArray.length);
                    this._index += byArray.length;
                    break;
                }
                case 2: {
                    this.alignment(1);
                    if (this._wcharAlign == 0) {
                        int n3 = n;
                        while (n3 < n + n2) {
                            byte[] byArray = String.valueOf(cArray[n3]).getBytes(this._wcharEnc);
                            this._buf.alloc(this.tmpBuf, this.tmpOff, byArray.length + 1);
                            this._index += byArray.length + 1;
                            this.tmpBuf.value[this.tmpOff.value] = (byte)byArray.length;
                            System.arraycopy(byArray, 0, this.tmpBuf.value, this.tmpOff.value + 1, byArray.length);
                            ++n3;
                        }
                        break;
                    }
                    this._buf.alloc(this.tmpBuf, this.tmpOff, n2 + n2 * this._wcharAlign);
                    int n4 = this.tmpOff.value;
                    int n5 = n;
                    while (n5 < n + n2) {
                        byte[] byArray = String.valueOf(cArray[n5]).getBytes(this._wcharEnc);
                        this.tmpBuf.value[n4] = (byte)this._wcharAlign;
                        System.arraycopy(byArray, 0, this.tmpBuf.value, n4 + 1, byArray.length);
                        n4 += this._wcharAlign + 1;
                        ++n5;
                    }
                    this._index += n2 + n2 * this._wcharAlign;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.assert(false, "Unsupported encoding should be impossible");
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        this._buf.append(byArray, n, n2);
        this._index += n2;
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        if (n + n2 > sArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(2);
        this._buf.alloc(this.tmpBuf, this.tmpOff, n2 * 2);
        this._index += n2 * 2;
        int n3 = 0;
        while (n3 < n2) {
            this.tmpBuf.value[this.tmpOff.value + n3 * 2] = (byte)(sArray[n + n3] >>> 8);
            this.tmpBuf.value[this.tmpOff.value + n3 * 2 + 1] = (byte)sArray[n + n3];
            ++n3;
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        if (n + n2 > nArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(4);
        this._buf.alloc(this.tmpBuf, this.tmpOff, n2 * 4);
        this._index += n2 * 4;
        int n3 = 0;
        while (n3 < n2) {
            this.tmpBuf.value[this.tmpOff.value + n3 * 4] = (byte)(nArray[n + n3] >>> 24);
            this.tmpBuf.value[this.tmpOff.value + n3 * 4 + 1] = (byte)(nArray[n + n3] >>> 16);
            this.tmpBuf.value[this.tmpOff.value + n3 * 4 + 2] = (byte)(nArray[n + n3] >>> 8);
            this.tmpBuf.value[this.tmpOff.value + n3 * 4 + 3] = (byte)nArray[n + n3];
            ++n3;
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        if (n + n2 > lArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(8);
        this._buf.alloc(this.tmpBuf, this.tmpOff, n2 * 8);
        this._index += n2 * 8;
        int n3 = 0;
        while (n3 < n2) {
            this.tmpBuf.value[this.tmpOff.value + n3 * 8] = (byte)(lArray[n + n3] >>> 56);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 1] = (byte)(lArray[n + n3] >>> 48);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 2] = (byte)(lArray[n + n3] >>> 40);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 3] = (byte)(lArray[n + n3] >>> 32);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 4] = (byte)(lArray[n + n3] >>> 24);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 5] = (byte)(lArray[n + n3] >>> 16);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 6] = (byte)(lArray[n + n3] >>> 8);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 7] = (byte)lArray[n + n3];
            ++n3;
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        if (n + n2 > fArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(4);
        this._buf.alloc(this.tmpBuf, this.tmpOff, n2 * 4);
        this._index += n2 * 4;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Float.floatToIntBits(fArray[n + n3]);
            this.tmpBuf.value[this.tmpOff.value + n3 * 4] = (byte)(n4 >>> 24);
            this.tmpBuf.value[this.tmpOff.value + n3 * 4 + 1] = (byte)(n4 >>> 16);
            this.tmpBuf.value[this.tmpOff.value + n3 * 4 + 2] = (byte)(n4 >>> 8);
            this.tmpBuf.value[this.tmpOff.value + n3 * 4 + 3] = (byte)n4;
            ++n3;
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        if (n + n2 > dArray.length || n2 < 0 || n < 0) {
            this._buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(8);
        this._buf.alloc(this.tmpBuf, this.tmpOff, n2 * 8);
        this._index += n2 * 8;
        int n3 = 0;
        while (n3 < n2) {
            long l = Double.doubleToLongBits(dArray[n + n3]);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8] = (byte)(l >>> 56);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 1] = (byte)(l >>> 48);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 2] = (byte)(l >>> 40);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 3] = (byte)(l >>> 32);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 4] = (byte)(l >>> 24);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 5] = (byte)(l >>> 16);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 6] = (byte)(l >>> 8);
            this.tmpBuf.value[this.tmpOff.value + n3 * 8 + 7] = (byte)l;
            ++n3;
        }
    }

    public void write_Object(Object object) {
        IOR iOR;
        if (object == null) {
            iOR = nullIOR;
        } else {
            try {
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).ior();
            }
            catch (SystemException systemException) {
                this._buf.cancel(systemException);
                return;
            }
        }
        IORHelper.write(this, iOR);
    }

    public void write_TypeCode(TypeCode typeCode) {
        this.write_TypeCodeValue(typeCode, new HashMap());
    }

    private void write_TypeCodeValue(TypeCode typeCode, Map map) {
        int n = typeCode.kind().value();
        try {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    this.write_long(n);
                    return;
                }
                case 18: 
                case 27: {
                    this.write_long(n);
                    this.write_ulong(typeCode.length());
                    return;
                }
                case 28: {
                    this.write_long(n);
                    this.write_ushort(typeCode.fixed_digits());
                    this.write_ushort(typeCode.fixed_scale());
                    return;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    break;
                }
                default: {
                    Trace.assert(false, "Unknown type kind");
                    throw new MARSHAL("error: Unknown type kind", 0, CompletionStatus.COMPLETED_NO);
                }
            }
            Integer n2 = (Integer)map.get(typeCode);
            if (n2 != null) {
                this.write_long(-1);
                this.write_long(n2 - this._index);
                return;
            }
            this.alignment(4);
            n2 = new Integer(this._index);
            map.put(typeCode, n2);
            this.write_long(n);
            this.begin_encapsulation();
            switch (n) {
                case 19: 
                case 20: {
                    this.write_TypeCodeValue(typeCode.content_type(), map);
                    this.write_ulong(typeCode.length());
                    break;
                }
                case 14: 
                case 31: 
                case 32: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    break;
                }
                case 15: 
                case 22: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_ulong(typeCode.member_count());
                    int n3 = 0;
                    while (n3 < typeCode.member_count()) {
                        this.write_string(typeCode.member_name(n3));
                        this.write_TypeCodeValue(typeCode.member_type(n3), map);
                        ++n3;
                    }
                    break;
                }
                case 16: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_TypeCodeValue(typeCode.discriminator_type(), map);
                    this.write_long(typeCode.default_index());
                    this.write_ulong(typeCode.member_count());
                    int n4 = 0;
                    while (n4 < typeCode.member_count()) {
                        if (n4 != typeCode.default_index()) {
                            ((Any)typeCode.member_label(n4)).write_value(this);
                        } else {
                            TypeCode typeCode2 = TypeCodeBase._base_type(typeCode.discriminator_type());
                            switch (typeCode2.kind().value()) {
                                case 2: {
                                    this.write_short((short)0);
                                    break;
                                }
                                case 4: {
                                    this.write_ushort((short)0);
                                    break;
                                }
                                case 3: {
                                    this.write_long(0);
                                    break;
                                }
                                case 5: {
                                    this.write_ulong(0);
                                    break;
                                }
                                case 8: {
                                    this.write_boolean(false);
                                    break;
                                }
                                case 9: {
                                    this.write_char('\u0000');
                                    break;
                                }
                                case 17: {
                                    this.write_ulong(0);
                                    break;
                                }
                                default: {
                                    Trace.assert(false, "Unknown type kind");
                                    throw new MARSHAL();
                                }
                            }
                        }
                        this.write_string(typeCode.member_name(n4));
                        this.write_TypeCodeValue(typeCode.member_type(n4), map);
                        ++n4;
                    }
                    break;
                }
                case 17: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_ulong(typeCode.member_count());
                    int n5 = 0;
                    while (n5 < typeCode.member_count()) {
                        this.write_string(typeCode.member_name(n5));
                        ++n5;
                    }
                    break;
                }
                case 21: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_TypeCodeValue(typeCode.content_type(), map);
                    break;
                }
                case 29: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_short(typeCode.type_modifier());
                    this.write_TypeCodeValue(typeCode.concrete_base_type(), map);
                    this.write_ulong(typeCode.member_count());
                    int n6 = 0;
                    while (n6 < typeCode.member_count()) {
                        this.write_string(typeCode.member_name(n6));
                        this.write_TypeCodeValue(typeCode.member_type(n6), map);
                        this.write_short(typeCode.member_visibility(n6));
                        ++n6;
                    }
                    break;
                }
                case 30: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_TypeCodeValue(typeCode.content_type(), map);
                }
            }
            this.end_encapsulation();
        }
        catch (BadKind badKind) {
            Trace.assert(false, "BadKind during marshall");
            throw new MARSHAL("error: BadKind during marshall", 0, CompletionStatus.COMPLETED_NO);
        }
        catch (Bounds bounds) {
            Trace.assert(false, "Bounds during marshall");
            throw new MARSHAL("error: Bounds during marshall", 0, CompletionStatus.COMPLETED_NO);
        }
    }

    public void write_any(org.omg.CORBA.Any any) {
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public void write_Principal(Principal principal) {
        byte[] byArray = principal.name();
        this.write_ulong(byArray.length);
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal, (short)-1, (short)-1);
    }

    public void write_fixed(BigDecimal bigDecimal, TypeCode typeCode) {
        try {
            this.write_fixed(bigDecimal, typeCode.fixed_digits(), typeCode.fixed_scale());
        }
        catch (BadKind badKind) {
            this._buf.cancel(new BAD_PARAM("Typecode is not a fixed typecode", 1146056963, CompletionStatus.COMPLETED_NO));
        }
    }

    public void write_fixed(BigDecimal bigDecimal, short s, short s2) {
        String string = bigDecimal.abs().movePointRight(bigDecimal.scale()).toString();
        if (s2 >= 0) {
            int n = s2 - bigDecimal.scale();
            if (n < 0) {
                string = string.substring(0, string.length() + n);
                n = 0;
            } else if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer(string);
                while (n-- > 0) {
                    stringBuffer.append('0');
                }
                string = stringBuffer.toString();
            }
        }
        if (s >= 0 && string.length() > s) {
            this._buf.cancel(new MARSHAL("value too large for type", 1146056980, CompletionStatus.COMPLETED_NO));
            return;
        }
        byte[] byArray = new byte[string.length() / 2 + 1];
        int n = 0;
        int n2 = 0;
        if (string.length() % 2 == 0) {
            byArray[n++] = (byte)(string.charAt(n2++) - 48);
        }
        while (n < byArray.length - 1) {
            byArray[n++] = (byte)(string.charAt(n2++) - 48 << 8 | string.charAt(n2++) - 48);
        }
        byArray[n] = (byte)(string.charAt(n2) - 48 | (bigDecimal.signum() < 0 ? 13 : 12));
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write_Context(Context context, ContextList contextList) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < contextList.count()) {
            try {
                NVList nVList = context.get_values("", 0, contextList.item(n));
                int n2 = 0;
                while (n2 < nVList.count()) {
                    vector.addElement(nVList.item(n2).name());
                    vector.addElement(nVList.item(n2).value().extract_string());
                    ++n2;
                }
            }
            catch (org.omg.CORBA.Bounds bounds) {
                // empty catch block
            }
            ++n;
        }
        if (vector.size() != 0) {
            this.write_ulong(vector.size());
            int n3 = 0;
            while (n3 < vector.size()) {
                this.write_string((String)vector.elementAt(n3));
                ++n3;
            }
        } else if (contextList.count() != 0) {
            this.write_ulong(0);
        }
    }

    public void write_value(Serializable serializable) {
        this.write_value(serializable, null, null);
    }

    public void write_value(Serializable serializable, String string) {
        this.write_value(serializable, string, null);
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable, null, null);
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        this.write_value(serializable, null, boxedValueHelper);
    }

    private void value_begin_block() {
        this.alignment(4);
        this._buf.beginBlock(CHUNK_GEN, 4, true, this);
        this._index += 4;
    }

    private void value_end_block() {
        if (!this._pending_value_open) {
            this._buf.endBlock();
        }
        this._value_level -= this._pending_value_closes;
        this._pending_value_closes = 0;
        this.write_long(-(this._value_level + 1));
    }

    /*
     * Unable to fully structure code
     */
    private void write_value(Serializable var1_1, String var2_2, BoxedValueHelper var3_3) {
        block48: {
            if (this._pending_value_closes > 0) {
                this.value_end_block();
                if (this._in_chunked_value) {
                    this._pending_value_open = true;
                }
            }
            var4_4 = null;
            var5_5 = this.value_extended_replace(var1_1);
            if (var5_5 != var1_1) {
                var4_4 = var1_1;
                var1_1 = var5_5;
            }
            if (var1_1 == null) {
                this.write_long(0);
                return;
            }
            var6_6 = (Integer)this._value_idx.get(new IdentityKey(var1_1));
            if (var6_6 != null) {
                this.write_long(-1);
                this.write_long(var6_6 - this._index);
                return;
            }
            this._pending_value_open = false;
            var6_7 = 0x7FFFFF00;
            var7_8 = null;
            var8_9 = 0;
            if (var3_3 != null) {
                var8_9 = 3;
                var7_8 = new String[]{var3_3.get_id()};
            } else if (var1_1 instanceof StreamableValue) {
                var8_9 = 2;
                var7_8 = ((ValueBase)var1_1)._truncatable_ids();
            } else if (var1_1 instanceof CustomValue) {
                var8_9 = 1;
                var7_8 = ((ValueBase)var1_1)._truncatable_ids();
            } else if (var1_1 instanceof ValueBase) {
                var8_9 = 3;
                var7_8 = ((ValueBase)var1_1)._truncatable_ids();
                var13_10 = RepoIDHelper.idToClass(var7_8[0], 2);
                try {
                    var3_3 = (BoxedValueHelper)Class.forName(var13_10).newInstance();
                }
                catch (Exception var14_12) {
                    this._buf.cancel(new MARSHAL("Unable to load boxed value helper", 1146056981, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
            } else if (var1_1.getClass().isArray() && var2_2 != null && var2_2.startsWith("IDL:")) {
                var8_9 = 3;
                var13_10 = RepoIDHelper.idToClass(var2_2, 2);
                try {
                    var3_3 = (BoxedValueHelper)Class.forName(var13_10).newInstance();
                }
                catch (Exception var14_13) {
                    this._buf.cancel(new MARSHAL("Unable to load boxed value helper", 1146056981, CompletionStatus.COMPLETED_MAYBE));
                }
            } else {
                var8_9 = 4;
                var7_8 = this.value_extended_get_IDs(var1_1);
                if (var7_8 == null) {
                    this._buf.cancel(new BAD_PARAM("Unable to find IDs for valuetype.", 1146056964, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
            }
            var13_11 = var7_8.length;
            if (var2_2 != null) {
                if (var7_8.length == 1 && var7_8[0].equals(var2_2)) {
                    var13_11 = 0;
                } else {
                    var13_11 = 0;
                    while (var13_11 < var7_8.length) {
                        if (var2_2.equals(var7_8[var13_11])) {
                            ++var13_11;
                            break;
                        }
                        ++var13_11;
                    }
                }
            }
            var6_7 = var13_11 == 0 ? (var6_7 |= 0) : (var13_11 == 1 ? (var6_7 |= 2) : (var6_7 |= 6));
            var14_14 = this.getURLCodeBase(var1_1);
            var6_7 = var14_14 != null ? (var6_7 |= 1) : (var6_7 |= 0);
            var15_15 = var8_9 == 1 || var13_11 > 1 || this._in_chunked_value != false;
            var16_16 = this._in_chunked_value;
            if (var15_15) {
                this._in_chunked_value = true;
                var6_7 |= 8;
            } else {
                var6_7 |= 0;
            }
            this.alignment(4);
            this._value_idx.put(new IdentityKey(var1_1), new Integer(this._index));
            if (var4_4 != null) {
                this._value_idx.put(new IdentityKey(var4_4), new Integer(this._index));
            }
            this.write_long(var6_7);
            if (var14_14 != null) {
                var17_17 = (Integer)this._url_idx.get(var14_14);
                if (var17_17 != null) {
                    this.write_ulong(-1);
                    this.write_long(var17_17 - this._index);
                } else {
                    this.alignment(4);
                    this._url_idx.put(var14_14, new Integer(this._index));
                    this.write_string(var14_14);
                }
            }
            if (var13_11 <= 0) break block48;
            if (var13_11 <= 1) ** GOTO lbl109
            if (var13_11 < var7_8.length) ** GOTO lbl108
            var17_17 = (Integer)this._typecode_list_idx.get(var1_1.getClass());
            if (var17_17 != null) {
                this.write_ulong(-1);
                this.write_long(var17_17 - this._index);
            } else {
                this.alignment(4);
                this._typecode_list_idx.put(var1_1.getClass(), new Integer(this._index));
lbl108:
                // 2 sources

                this.write_long(var13_11);
lbl109:
                // 2 sources

                var17_18 = 0;
                while (var17_18 < var13_11) {
                    var18_20 = (Integer)this._typecode_idx.get(var7_8[var17_18]);
                    if (var18_20 != null) {
                        this.write_ulong(-1);
                        this.write_long(var18_20 - this._index);
                    } else {
                        this.alignment(4);
                        this._typecode_idx.put(var7_8[var17_18], new Integer(this._index));
                        this.write_string(var7_8[var17_18]);
                    }
                    ++var17_18;
                }
            }
        }
        ++this._value_level;
        if (var15_15) {
            this._pending_value_open = true;
        }
        switch (var8_9) {
            case 2: {
                ((StreamableValue)var1_1)._write(this);
                break;
            }
            case 3: {
                var3_3.write_value(this, var1_1);
                break;
            }
            case 1: {
                var17_19 = new DataOutputStream(this);
                ((CustomValue)var1_1).marshal(var17_19);
                break;
            }
            case 4: {
                try {
                    this.value_extended_marshal(var1_1);
                    break;
                }
                catch (SystemException var18_21) {
                    var18_21.printStackTrace();
                    this._buf.cancel(var18_21);
                    return;
                }
                catch (Throwable var19_22) {
                    var19_22.printStackTrace();
                    this._buf.cancel(new MARSHAL("Exception thrown during extended marshal", 1146056981, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
            }
        }
        if (var15_15) {
            ++this._pending_value_closes;
            this._in_chunked_value = var16_16;
        } else {
            --this._value_level;
        }
    }

    protected Serializable value_extended_replace(Serializable serializable) {
        return serializable;
    }

    protected String[] value_extended_get_IDs(Serializable serializable) {
        return null;
    }

    protected boolean value_extended_custom(Serializable serializable) {
        return true;
    }

    protected void value_extended_marshal(Serializable serializable) {
        this._buf.cancel(new BAD_PARAM("Unable to marshal valuetype", 1146056964, CompletionStatus.COMPLETED_MAYBE));
    }

    public void write_abstract_interface(java.lang.Object object) {
        if (object != null && object instanceof Object) {
            this.write_boolean(true);
            this.write_Object((Object)object);
        } else if (object == null || object instanceof Serializable) {
            this.write_boolean(false);
            this.write_value((Serializable)object);
        } else {
            this._buf.cancel(new BAD_PARAM("Attempt to marshal unknown interface type", 1146056967, CompletionStatus.COMPLETED_MAYBE));
        }
    }

    private String getURLCodeBase(java.lang.Object object) {
        java.lang.Object object2;
        if (this._systemURLs == null) {
            object2 = ((ORB)this._orb).getLoader();
            this._systemURLs = object2.getStringProperty("openorb.URLCodeBase", "");
        }
        if (this._systemURLs.length() != 0) {
            return this._systemURLs;
        }
        object2 = object.getClass().getClassLoader();
        if (!(object2 instanceof URLClassLoader)) {
            return null;
        }
        URL[] uRLArray = ((URLClassLoader)object2).getURLs();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < uRLArray.length) {
            if (!uRLArray[n].getProtocol().equals("file")) {
                stringBuffer.append(uRLArray[n].toString()).append(' ');
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }
}

