/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.openorb.util.Trace;

public abstract class CodeSetDatabase {
    private static HashMap _codesetToDatabase = new HashMap();
    private static HashMap _charsetToDatabase = new HashMap();
    private static CodeSetComponentInfo _clientCodeSets;
    private static CodeSetComponentInfo _serverCodeSets;

    static void addEntry(String string, int n, short[] sArray, int n2, String string2, int n3, boolean bl) {
        if (n3 < 0 || _codesetToDatabase.containsKey(new Integer(n))) {
            return;
        }
        Arrays.sort(sArray);
        String string3 = null;
        try {
            string3 = CodeSetDatabase.canonicalize(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        DatabaseEntry databaseEntry = new DatabaseEntry(string, n, sArray, n2, string3, n3, bl);
        _codesetToDatabase.put(new Integer(n), databaseEntry);
        if (string3 != null) {
            _codesetToDatabase.put(string3, databaseEntry);
        }
        int n4 = 0;
        while (n4 < sArray.length) {
            Short s = new Short(sArray[n4]);
            DatabaseEntry[] databaseEntryArray = (DatabaseEntry[])_charsetToDatabase.get(s);
            if (databaseEntryArray == null) {
                databaseEntryArray = new DatabaseEntry[]{databaseEntry};
            } else {
                DatabaseEntry[] databaseEntryArray2 = databaseEntryArray;
                databaseEntryArray = new DatabaseEntry[databaseEntryArray2.length + 1];
                System.arraycopy(databaseEntryArray2, 0, databaseEntryArray, 0, databaseEntryArray2.length);
                databaseEntryArray[databaseEntryArray2.length] = databaseEntry;
            }
            _charsetToDatabase.put(s, databaseEntryArray);
            ++n4;
        }
    }

    public static String canonicalize(String string) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, string);
        return outputStreamWriter.getEncoding();
    }

    public static String codesetIDtoEncoding(int n) {
        DatabaseEntry databaseEntry = (DatabaseEntry)_codesetToDatabase.get(new Integer(n));
        if (databaseEntry == null) {
            return null;
        }
        return databaseEntry._encoding;
    }

    public static int codesetIDtoAlignment(int n) {
        DatabaseEntry databaseEntry = (DatabaseEntry)_codesetToDatabase.get(new Integer(n));
        if (databaseEntry == null) {
            return -1;
        }
        if (databaseEntry._maxSize == 1) {
            return 1;
        }
        if (databaseEntry._align == 1) {
            return 0;
        }
        return databaseEntry._align;
    }

    public static String codesetIDtoDescription(int n) {
        DatabaseEntry databaseEntry = (DatabaseEntry)_codesetToDatabase.get(new Integer(n));
        if (databaseEntry == null) {
            return "Unknown encoding";
        }
        return databaseEntry._description;
    }

    public static int encodingToCodesetID(String string) {
        try {
            string = CodeSetDatabase.canonicalize(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
        DatabaseEntry databaseEntry = (DatabaseEntry)_codesetToDatabase.get(string);
        if (databaseEntry == null) {
            return 0;
        }
        return databaseEntry._codesetID;
    }

    static CodeSetComponentInfo getClientCodeSets() {
        return _clientCodeSets;
    }

    static CodeSetComponentInfo getServerCodeSets() {
        return _serverCodeSets;
    }

    private static CodeSetComponentInfo initCodeSets(boolean bl) {
        int n;
        String string = new OutputStreamWriter(System.out).getEncoding();
        int n2 = CodeSetDatabase.encodingToCodesetID(string);
        int n3 = CodeSetDatabase.codesetIDtoAlignment(n2);
        if ((bl ? _clientCodeSets : _serverCodeSets) == null) {
            Trace.high("CodeSetDatabase", "Native encoding / codeset: \"" + string + "\" / " + Integer.toHexString(n2));
        }
        if (n2 == 0 || n3 > 1) {
            n2 = CodeSetDatabase.encodingToCodesetID("UTF-8");
        }
        CodeSetComponent codeSetComponent = new CodeSetComponent(n2, CodeSetDatabase.allCompatCodesets(n2, true, bl));
        if (codeSetComponent.conversion_code_sets == null) {
            Trace.high("CodeSetDatabase", "Unable to locate csc_char conv codesets");
            codeSetComponent.conversion_code_sets = new int[0];
        }
        if (codeSetComponent.native_code_set != (n = CodeSetDatabase.encodingToCodesetID("US-ASCII"))) {
            int n4 = 0;
            while (n4 < codeSetComponent.conversion_code_sets.length) {
                if (n == codeSetComponent.conversion_code_sets[n4]) {
                    n = 0;
                    break;
                }
                ++n4;
            }
            if (n != 0) {
                int[] nArray = new int[codeSetComponent.conversion_code_sets.length + 1];
                System.arraycopy(codeSetComponent.conversion_code_sets, 0, nArray, 0, codeSetComponent.conversion_code_sets.length);
                nArray[codeSetComponent.conversion_code_sets.length] = n;
                codeSetComponent.conversion_code_sets = nArray;
            }
        }
        n2 = 65801;
        CodeSetComponent codeSetComponent2 = new CodeSetComponent(n2, CodeSetDatabase.allCompatCodesets(n2, false, bl));
        if (codeSetComponent2.conversion_code_sets == null) {
            Trace.high("CodeSetDatabase", "Unable to locate cscw_char conv codesets");
            codeSetComponent2.conversion_code_sets = new int[0];
        }
        return new CodeSetComponentInfo(codeSetComponent, codeSetComponent2);
    }

    public static boolean compatableCodesets(int n, int n2) {
        DatabaseEntry databaseEntry = (DatabaseEntry)_codesetToDatabase.get(new Integer(n));
        DatabaseEntry databaseEntry2 = (DatabaseEntry)_codesetToDatabase.get(new Integer(n2));
        if (databaseEntry == null || databaseEntry2 == null) {
            return false;
        }
        if (databaseEntry._charsetIDs.length == 1) {
            return databaseEntry2._charsetIDs.length == 1 && databaseEntry._charsetIDs[0] == databaseEntry2._charsetIDs[0];
        }
        if (databaseEntry2._charsetIDs.length == 1) {
            return false;
        }
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n3 < databaseEntry._charsetIDs.length && n4 < databaseEntry2._charsetIDs.length) {
            if (databaseEntry._charsetIDs[n3] == databaseEntry2._charsetIDs[n4]) {
                if (bl) {
                    return true;
                }
                bl = true;
                ++n3;
                ++n4;
                continue;
            }
            if (databaseEntry._charsetIDs[n3] < databaseEntry2._charsetIDs[n4]) {
                ++n3;
                continue;
            }
            ++n4;
        }
        return false;
    }

    private static int[] allCompatCodesets(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        Object[] objectArray;
        DatabaseEntry databaseEntry = (DatabaseEntry)_codesetToDatabase.get(new Integer(n));
        if (databaseEntry == null) {
            return null;
        }
        short[] sArray = databaseEntry._charsetIDs;
        if (sArray.length == 1) {
            DatabaseEntry[] databaseEntryArray = (DatabaseEntry[])_charsetToDatabase.get(new Short(sArray[0]));
            int[] nArray = new int[databaseEntryArray.length];
            int n4 = 0;
            int n5 = 0;
            while (n5 < databaseEntryArray.length) {
                if (!(bl2 && !databaseEntryArray[n5]._server || databaseEntryArray[n5]._encoding == null || databaseEntryArray[n5]._charsetIDs.length != 1 || bl && databaseEntryArray[n5]._align > 1 || databaseEntryArray[n5]._codesetID == n)) {
                    nArray[n4++] = databaseEntryArray[n5]._codesetID;
                }
                ++n5;
            }
            if (n4 < nArray.length) {
                int[] nArray2 = new int[n4];
                System.arraycopy(nArray, 0, nArray2, 0, n4);
                return nArray2;
            }
            return nArray;
        }
        ArrayList[] arrayListArray = new ArrayList[sArray.length - 1];
        int n6 = 0;
        while (n6 < arrayListArray.length) {
            arrayListArray[n6] = new ArrayList();
            ++n6;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(databaseEntry);
        int n7 = 0;
        int n8 = 0;
        while (n8 < sArray.length) {
            objectArray = (DatabaseEntry[])_charsetToDatabase.get(new Short(sArray[n8]));
            n3 = 0;
            while (n3 < objectArray.length) {
                if (!(bl2 && !objectArray[n8]._server || objectArray[n8]._encoding == null || bl && objectArray[n3]._align > 1 || !hashSet.add(objectArray[n3]))) {
                    n2 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    while (n9 < databaseEntry._charsetIDs.length && n9 < objectArray[n8]._charsetIDs.length) {
                        if (databaseEntry._charsetIDs[n9] == objectArray[n8]._charsetIDs[n10]) {
                            ++n2;
                            ++n9;
                            ++n10;
                            continue;
                        }
                        if (databaseEntry._charsetIDs[n9] < objectArray[n8]._charsetIDs[n10]) {
                            ++n8;
                            continue;
                        }
                        ++n3;
                    }
                    if (n2 >= 2) {
                        arrayListArray[arrayListArray.length - n2 + 2].add(new Integer(objectArray[n3]._codesetID));
                        ++n7;
                    }
                }
                ++n3;
            }
            ++n8;
        }
        objectArray = new int[n7];
        n3 = 0;
        n2 = 0;
        while (n2 < arrayListArray.length) {
            Iterator iterator = ((AbstractList)arrayListArray[n2]).iterator();
            while (iterator.hasNext()) {
                objectArray[n3++] = (Integer)iterator.next();
            }
            ++n2;
        }
        return objectArray;
    }

    private static final void usage() {
        System.err.println("usage: java org.openorb.iiop.CodeSetDatabase <database file>");
        System.err.println();
        System.err.println("  This program converts a codeset registry obtained from ftp://ftp.opengroup.org/pub/code_set_registry ");
        System.err.println("  into a class org.openorb.iiop.CodeSetDatabaseInit, which is used to initialize the code set database.");
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length != 1) {
            CodeSetDatabase.usage();
            return;
        }
        File file2 = new File(stringArray[0]);
        if (!file2.isFile() || !file2.canRead()) {
            System.err.println("Cannot open \"" + stringArray[0] + "\" for reading.");
            System.exit(1);
        }
        if ((file = new File("CodeSetDatabaseInit.java")).exists() && !file.isFile()) {
            System.err.println("Unable to overwrite non-file CodeSetDatabaseInit.java");
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            if (file.isFile()) {
                System.out.print("Overwrite CodeSetDatabaseInit.java? (yes): ");
                System.out.flush();
                if (bufferedReader.readLine().length() != 0) {
                    return;
                }
            }
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file2));
            printWriter.println("// CodeSetDatabaseInit.java");
            printWriter.println("// Automaticaly generated on " + new Date());
            printWriter.println("// Do not modify");
            printWriter.println();
            printWriter.println("package org.openorb.iiop;");
            printWriter.println();
            printWriter.println("abstract class CodeSetDatabaseInit {");
            printWriter.println();
            printWriter.println("\tstatic {");
            while ((string = bufferedReader2.readLine()) != null) {
                int n;
                String string2;
                StringBuffer stringBuffer;
                block21: {
                    block20: {
                        int n2;
                        block19: {
                            if (!string.equals("start")) continue;
                            System.out.println();
                            stringBuffer = new StringBuffer("CodeSetDatabase.addEntry(\"");
                            string = bufferedReader2.readLine();
                            System.out.println(string);
                            stringBuffer.append(string.substring("Short Description\t".length()));
                            stringBuffer.append("\", ");
                            string = bufferedReader2.readLine();
                            System.out.println(string);
                            stringBuffer.append(string.substring("Registered Value\t".length()));
                            stringBuffer.append(", new short [] { ");
                            int n3 = Integer.parseInt(string.substring("Registered Value\t0x".length()), 16);
                            string = bufferedReader2.readLine();
                            System.out.println(string);
                            int n4 = string.indexOf("0x") - 1;
                            int n5 = string.indexOf(58, n4);
                            while (n5 >= 0) {
                                stringBuffer.append(string.substring(n4 + 1, n5));
                                n4 = n5;
                                n5 = string.indexOf(58, n4 + 1);
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(string.substring(n4 + 1));
                            stringBuffer.append(" } , ");
                            string = bufferedReader2.readLine();
                            System.out.println(string);
                            n2 = Integer.parseInt(string.substring("Max Bytes per Character\t".length()));
                            stringBuffer.append(string.substring("Max Bytes per Character\t".length()));
                            stringBuffer.append(", \"");
                            while (!(string = bufferedReader2.readLine()).equals("end")) {
                                System.out.println(string);
                            }
                            System.out.println();
                            DatabaseEntry databaseEntry = (DatabaseEntry)_codesetToDatabase.get(new Integer(n3));
                            if (databaseEntry != null && databaseEntry._align >= 0) {
                                try {
                                    CodeSetDatabase.canonicalize(databaseEntry._encoding);
                                    System.out.print("Reuse old? encoding=\"" + databaseEntry._encoding + "\" align=" + databaseEntry._align + " (yes): ");
                                    System.out.flush();
                                    if (bufferedReader.readLine().length() == 0) {
                                        stringBuffer.append(databaseEntry._encoding);
                                        stringBuffer.append("\", ");
                                        stringBuffer.append(databaseEntry._align);
                                        stringBuffer.append(", ");
                                        stringBuffer.append(databaseEntry._server);
                                        stringBuffer.append(");");
                                        printWriter.println("\t\t" + stringBuffer);
                                        printWriter.flush();
                                    }
                                    break block19;
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    System.out.print("Reuse old? unknown encoding=\"" + databaseEntry._encoding + "\" align=" + databaseEntry._align + " (yes): ");
                                    System.out.flush();
                                    if (bufferedReader.readLine().length() != 0) break block19;
                                    stringBuffer.append(databaseEntry._encoding);
                                    stringBuffer.append("\", ");
                                    stringBuffer.append(databaseEntry._align);
                                    stringBuffer.append(", ");
                                    stringBuffer.append(databaseEntry._server);
                                    stringBuffer.append(");");
                                    printWriter.println("\t\t/* Unsupported: */" + stringBuffer);
                                    printWriter.flush();
                                }
                                continue;
                            }
                        }
                        while (true) {
                            System.out.print("Encoding name (blank to skip): ");
                            System.out.flush();
                            string2 = bufferedReader.readLine();
                            n = -1;
                            if (string2.length() == 0) break block20;
                            try {
                                String string3 = CodeSetDatabase.canonicalize(string2);
                                System.out.println("Canonical name: \"" + string3 + "\"");
                                System.out.print("Store encoding? (yes): ");
                                System.out.flush();
                                if (bufferedReader.readLine().length() == 0 && (n = CodeSetDatabase.discoverWidth(n2, string2, -1, bufferedReader)) >= 0) {
                                    printWriter.print("\t\t");
                                    break block21;
                                }
                                printWriter.print("\t\t// ");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                System.out.print("Unsupported encoding. Use anyhow? (yes), (a)gain, no: ");
                                System.out.flush();
                                if ((string = bufferedReader.readLine()).startsWith("a")) continue;
                                if (string.length() == 0 && (n = CodeSetDatabase.discoverWidth(n2, null, -1, bufferedReader)) >= 0) {
                                    printWriter.print("\t\t/* Unsupported: */ ");
                                    break block21;
                                }
                                printWriter.print("\t\t// /* Unsupported: */ ");
                            }
                            break;
                        }
                        break block21;
                    }
                    printWriter.print("\t\t// ");
                }
                System.out.print("Use encoding in server profiles? (no): ");
                System.out.flush();
                boolean bl = bufferedReader.readLine().length() != 0;
                stringBuffer.append(string2);
                stringBuffer.append("\", ");
                stringBuffer.append(n);
                stringBuffer.append(", ");
                stringBuffer.append(bl);
                stringBuffer.append(");");
                printWriter.println(stringBuffer);
                printWriter.flush();
                System.out.println();
            }
            printWriter.println("\t}");
            printWriter.println("}");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("IO Exception occoured");
        }
    }

    private static int discoverWidth(int n, String string, int n2, BufferedReader bufferedReader) throws IOException {
        if (n == 1) {
            return 1;
        }
        if (string == null) {
            System.out.print("Codeset width? 1, 2, 4, prefixed, (cancel): ");
            System.out.flush();
            String string2 = bufferedReader.readLine();
            if (string2.equals("1")) {
                return 1;
            }
            if (string2.equals("2")) {
                return 2;
            }
            if (string2.equals("4")) {
                return 4;
            }
            if (string2.startsWith("p")) {
                return 0;
            }
            return -1;
        }
        while (true) {
            int n3 = n2;
            switch (n2) {
                case 0: {
                    System.out.print("Codeset width? 1, 2, 4, (prefixed), guess, cancel: ");
                    break;
                }
                case 1: {
                    System.out.print("Codeset width? (1), 2, 4, prefixed, guess, cancel: ");
                    break;
                }
                case 2: {
                    System.out.print("Codeset width? 1, (2), 4, prefixed, guess, cancel: ");
                    break;
                }
                case 4: {
                    System.out.print("Codeset width? 1, 2, (4), prefixed, guess, cancel: ");
                    break;
                }
                default: {
                    System.out.print("Codeset width? 1, 2, 4, prefixed, (guess), cancel: ");
                }
            }
            String string3 = bufferedReader.readLine();
            if (string3.length() == 0) {
                if (n2 != -1) {
                    return n2;
                }
            } else {
                if (string3.equals("1")) {
                    return 1;
                }
                if (string3.equals("2")) {
                    return 2;
                }
                if (string3.equals("4")) {
                    return 4;
                }
                if (string3.startsWith("p")) {
                    return 0;
                }
                if (!string3.startsWith("g")) {
                    return -1;
                }
            }
            System.out.println("Guessing char width");
            int[] nArray = new int[n * 2 + 1];
            char c = '\u0000';
            while (c < '\uffff') {
                try {
                    int n4 = String.valueOf(c).getBytes(string).length;
                    nArray[n4] = nArray[n4] + 1;
                }
                catch (Error error) {
                    nArray[0] = nArray[0] + 1;
                }
                c = (char)(c + '\u0001');
            }
            int n5 = 0;
            while (n5 < nArray.length) {
                if (nArray[n5] > 0) {
                    System.out.println(nArray[n5] + " of length " + n5);
                }
                ++n5;
            }
            System.out.println("String \"aa\" is length " + "aa".getBytes(string).length);
            if (nArray[1] == 0) continue;
            n2 = nArray[2] != 0 ? 0 : 1;
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.openorb.iiop.CodeSetDatabaseInit");
            _serverCodeSets = CodeSetDatabase.initCodeSets(true);
            _clientCodeSets = CodeSetDatabase.initCodeSets(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class DatabaseEntry {
        final String _description;
        final int _codesetID;
        final short[] _charsetIDs;
        final int _maxSize;
        final String _encoding;
        final int _align;
        final boolean _server;

        DatabaseEntry(String string, int n, short[] sArray, int n2, String string2, int n3, boolean bl) {
            this._description = string;
            this._codesetID = n;
            this._charsetIDs = sArray;
            this._maxSize = n2;
            this._encoding = string2;
            this._align = n3;
            this._server = bl;
        }
    }
}

