/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ListenPointHelper;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.net.AbstractAddress;
import org.openorb.net.Address;
import org.openorb.util.Trace;

public class IIOPAddress
extends AbstractAddress
implements Cloneable {
    private InetAddress _host;
    private String _hostname;
    private int _port;
    private Version _vers;
    private int _orb_type = 0;
    private int _hash = -1;
    private String _protocol = "iiop";
    private CodeSetComponentInfo _codesetComponentInfo = null;
    private IIOPAddress[] alternates = null;
    public static final short MASK_PRI_VERSION = 15;
    public static final short[] PRI_VERSION = new short[]{15, 14, 13};
    public static final short PRI_FLAG_ALTERNATE = 2048;
    public static final short PRI_FLAG_NONPRIMARY = 1024;
    public static final short MASK_PRI_SECURE = 240;
    public static final short PRI_UNSECURE = 240;

    private IIOPAddress() {
    }

    public void setHost(InetAddress inetAddress) {
        if (inetAddress != null) {
            this._host = inetAddress;
            this._hostname = inetAddress.getHostName();
            this._hash = -1;
        }
    }

    public void setPort(int n) {
        if (n != 0) {
            this._port = n;
            this._hash = -1;
        }
    }

    public void setProtocol(String string) {
        this._protocol = string;
        this._hash = -1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.assert(false);
            return null;
        }
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String get_hostname() {
        return this._hostname;
    }

    public InetAddress get_host() {
        return this._host;
    }

    public int get_port() {
        return this._port;
    }

    public Version get_version() {
        return this._vers;
    }

    public int get_orb_type() {
        return this._orb_type;
    }

    public CodeSetComponentInfo getCodesetComponentInfo() {
        return this._codesetComponentInfo;
    }

    public Address[] get_alternates() {
        return this.alternates;
    }

    public String getEndpointString() {
        return this._protocol + ":" + this._vers.major + "." + this._vers.minor + "@" + this._hostname + ":" + this._port;
    }

    public String getEndpointDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getEndpointString());
        if (this._host == null) {
            stringBuffer.append(" host unknown");
        } else {
            boolean bl = false;
            if (this.getPriority((short)240) != 240) {
                stringBuffer.append(" flags: secure(");
                stringBuffer.append(this.getPriority((short)240) >> 8);
                stringBuffer.append(")");
                bl = true;
            }
            if (this.getPriority((short)1024) == 0) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    stringBuffer.append(" flags: ");
                }
                stringBuffer.append("primary");
                bl = true;
            }
            if (this.getPriority((short)2048) != 0) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    stringBuffer.append(" flags: ");
                }
                stringBuffer.append("alternate");
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this._hash == -1) {
            this._hash = super.hashCode() ^ this._host.hashCode() ^ this._port ^ this._protocol.hashCode();
        }
        return this._hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IIOPAddress)) {
            return false;
        }
        IIOPAddress iIOPAddress = (IIOPAddress)object;
        if (this._port != iIOPAddress._port || !this._hostname.equals(iIOPAddress._hostname) || !this._protocol.equals(iIOPAddress._protocol)) {
            return false;
        }
        return super.equals(object);
    }

    static IIOPAddress[] get_addresses(Codec codec, IOR iOR, int n) {
        if (iOR.profiles[n].tag != 0) {
            throw new INV_OBJREF("Invalid tag for object reference", 1146056972, CompletionStatus.COMPLETED_NO);
        }
        IIOPAddress iIOPAddress = new IIOPAddress();
        iIOPAddress.set_ior(iOR, n);
        byte[] byArray = iOR.profiles[n].profile_data;
        if (byArray[1] != 1) {
            return new IIOPAddress[0];
        }
        TaggedComponent[] taggedComponentArray = null;
        try {
            Object object;
            int n2;
            short s;
            Object object2;
            TaggedComponent[] taggedComponentArray2;
            switch (byArray[2]) {
                case 0: {
                    IDLEntity iDLEntity = ProfileBody_1_0Helper.extract(codec.decode_value(byArray, ProfileBody_1_0Helper.type()));
                    iIOPAddress._vers = iDLEntity.iiop_version;
                    iIOPAddress._hostname = iDLEntity.host;
                    iIOPAddress._port = iDLEntity.port & 0xFFFF;
                    iIOPAddress.set_oid(iDLEntity.object_key);
                    taggedComponentArray = new TaggedComponent[]{};
                    break;
                }
                default: {
                    IDLEntity iDLEntity = ProfileBody_1_1Helper.extract(codec.decode_value(byArray, ProfileBody_1_1Helper.type()));
                    iIOPAddress._vers = ((ProfileBody_1_1)iDLEntity).iiop_version;
                    iIOPAddress._hostname = ((ProfileBody_1_1)iDLEntity).host;
                    iIOPAddress._port = ((ProfileBody_1_1)iDLEntity).port & 0xFFFF;
                    iIOPAddress.set_oid(((ProfileBody_1_1)iDLEntity).object_key);
                    taggedComponentArray = ((ProfileBody_1_1)iDLEntity).components;
                    if (iIOPAddress._vers.minor <= 2) break;
                    iIOPAddress._vers.minor = (byte)2;
                }
            }
            try {
                iIOPAddress._host = InetAddress.getByName(iIOPAddress._hostname);
            }
            catch (UnknownHostException unknownHostException) {
                iIOPAddress._host = null;
                iIOPAddress._hash = iIOPAddress._hostname.hashCode() ^ iIOPAddress._port;
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < iOR.profiles.length) {
                if (iOR.profiles[n4].tag == 1) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 == 0) {
                taggedComponentArray2 = taggedComponentArray;
            } else {
                if (taggedComponentArray != null) {
                    object2 = new TaggedComponent[n3 + 1][];
                    object2[n3] = taggedComponentArray;
                } else {
                    object2 = new TaggedComponent[n3][];
                }
                s = 0;
                while (s < iOR.profiles.length && n3 > 0) {
                    if (iOR.profiles[s].tag == 1) {
                        object2[--n3] = TaggedComponentSeqHelper.extract(codec.decode_value(iOR.profiles[s].profile_data, TaggedComponentSeqHelper.type()));
                    }
                    ++s;
                }
                n3 = 0;
                int n5 = 0;
                while (n5 < ((TaggedComponent[][])object2).length) {
                    n3 += object2[n5].length;
                    ++n5;
                }
                taggedComponentArray2 = new TaggedComponent[n3];
                n3 = 0;
                n2 = 0;
                while (n2 < ((TaggedComponent[][])object2).length) {
                    System.arraycopy(object2[n2], 0, taggedComponentArray2, n3, object2[n2].length);
                    n3 += ((Object)object2[n2]).length;
                    ++n2;
                }
            }
            iIOPAddress.set_components(taggedComponentArray2, taggedComponentArray.length);
            object2 = ORB.init();
            s = (short)(0x4F0 | PRI_VERSION[byArray[2]]);
            ArrayList<IIOPAddress[]> arrayList = new ArrayList<IIOPAddress[]>();
            n2 = 0;
            while (n2 < taggedComponentArray2.length) {
                switch (taggedComponentArray2[n2].tag) {
                    case 3: {
                        object = ListenPointHelper.extract(codec.decode_value(taggedComponentArray2[n2].component_data, ListenPointHelper.type()));
                        arrayList.add((IIOPAddress[])object);
                        iIOPAddress.set_component_data(n2, "ComponentID = " + taggedComponentArray2[n2].tag + " Alternate IIOP Address: " + ((ListenPoint)object).host + ":" + ((ListenPoint)object).port);
                        break;
                    }
                    case 0: {
                        iIOPAddress._orb_type = codec.decode_value(taggedComponentArray2[n2].component_data, ((ORB)object2).get_primitive_tc(TCKind.tk_long)).extract_long();
                        object = Integer.toHexString(iIOPAddress._orb_type);
                        iIOPAddress.set_component_data(n2, "ComponentID = " + taggedComponentArray2[n2].tag + " ORB Type: 0x" + "00000000".substring(((String)object).length()) + (String)object);
                        break;
                    }
                    case 1: {
                        iIOPAddress._codesetComponentInfo = CodeSetComponentInfoHelper.extract(codec.decode_value(taggedComponentArray2[n2].component_data, CodeSetComponentInfoHelper.type()));
                        StringBuffer stringBuffer = new StringBuffer("ComponentID = " + taggedComponentArray2[n2].tag + " Codesets \n");
                        stringBuffer.append("\tFor char Data: ");
                        int n6 = iIOPAddress._codesetComponentInfo.ForCharData.native_code_set;
                        int n7 = 0;
                        while (n7 <= iIOPAddress._codesetComponentInfo.ForCharData.conversion_code_sets.length) {
                            String string = Integer.toHexString(n6);
                            stringBuffer.append("\n\t\t0x").append("00000000".substring(string.length())).append(string);
                            stringBuffer.append(" ").append(CodeSetDatabase.codesetIDtoDescription(n6));
                            if (n7 < iIOPAddress._codesetComponentInfo.ForCharData.conversion_code_sets.length) {
                                n6 = iIOPAddress._codesetComponentInfo.ForCharData.conversion_code_sets[n7];
                            }
                            ++n7;
                        }
                        stringBuffer.append("\n\tFor wchar Data: ");
                        n6 = iIOPAddress._codesetComponentInfo.ForWcharData.native_code_set;
                        int n8 = 0;
                        while (n8 <= iIOPAddress._codesetComponentInfo.ForWcharData.conversion_code_sets.length) {
                            String string = Integer.toHexString(n6);
                            stringBuffer.append("\n\t\t0x").append("00000000".substring(string.length())).append(string);
                            stringBuffer.append(" ").append(CodeSetDatabase.codesetIDtoDescription(n6));
                            if (n8 < iIOPAddress._codesetComponentInfo.ForWcharData.conversion_code_sets.length) {
                                n6 = iIOPAddress._codesetComponentInfo.ForWcharData.conversion_code_sets[n8];
                            }
                            ++n8;
                        }
                        iIOPAddress.set_component_data(n2, stringBuffer.toString());
                        break;
                    }
                    case 28: {
                        if (taggedComponentArray2[n2].component_data[1] != 0) {
                            s = (short)(s & 0xFFFFFBFF);
                            iIOPAddress.set_component_data(n2, "ComponentID = " + taggedComponentArray2[n2].tag + " Primary profile");
                            break;
                        }
                        iIOPAddress.set_component_data(n2, "ComponentID = " + taggedComponentArray2[n2].tag + " NonPrimary profile");
                        break;
                    }
                    case 2: {
                        throw new NO_IMPLEMENT();
                    }
                }
                ++n2;
            }
            iIOPAddress.setPriority(s);
            object = new IIOPAddress[1 + arrayList.size()];
            object[0] = iIOPAddress;
            int n9 = 0;
            while (n9 < arrayList.size()) {
                ListenPoint listenPoint = (ListenPoint)arrayList.get(n9);
                object[n9 + 1] = (IIOPAddress)iIOPAddress.clone();
                object[n9 + 1]._hostname = listenPoint.host;
                try {
                    ((IIOPAddress)object[n9 + 1])._host = InetAddress.getByName(listenPoint.host);
                }
                catch (UnknownHostException unknownHostException) {
                    ((IIOPAddress)object[n9 + 1])._host = null;
                    ((IIOPAddress)object[n9 + 1])._hash = ((IIOPAddress)object[n9 + 1])._hostname.hashCode() ^ ((IIOPAddress)object[n9 + 1])._port;
                }
                ((IIOPAddress)object[n9 + 1])._port = listenPoint.port & 0xFFFF;
                ((AbstractAddress)object[n9 + 1]).setPriority((short)2048, (short)2048);
                ++n9;
            }
            return object;
        }
        catch (FormatMismatch formatMismatch) {
            throw new INV_OBJREF("Profile data cannot be parsed", 1146056973, CompletionStatus.COMPLETED_NO);
        }
        catch (TypeMismatch typeMismatch) {
            throw new INV_OBJREF("Profile data cannot be parsed", 1146056973, CompletionStatus.COMPLETED_NO);
        }
    }
}

