/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.GIOP.TargetAddressHelper;
import org.omg.GIOP.Version;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.openorb.CORBA.ORB;
import org.openorb.iiop.CDRInputStream;
import org.openorb.iiop.CDROutputStream;
import org.openorb.iiop.HeaderBlock;
import org.openorb.iiop.IIOPAddress;
import org.openorb.iiop.IIOPClientProtocol;
import org.openorb.iiop.IIOPClientRequest;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPServerProtocol;
import org.openorb.iiop.SocketQueue;
import org.openorb.io.BufferSource;
import org.openorb.io.MarshalBuffer;
import org.openorb.io.StorageBuffer;
import org.openorb.net.Address;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientRequest;
import org.openorb.net.RebindChannelException;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerRequest;
import org.openorb.net.Transport;
import org.openorb.util.Trace;

public class IIOPClientChannel
implements ClientChannel {
    private static final byte[] RESERVED = new byte[]{0, 0, 0};
    private org.omg.CORBA.ORB _orb;
    private IIOPClientProtocol _protocol;
    private ClientManager _clientManager;
    java.lang.Object _syncState;
    int _state = 0x12000000;
    private boolean _firstConnect = true;
    private boolean _inPause = false;
    boolean _pendClose = false;
    private boolean _pendSC = false;
    SocketQueue _socketQueue;
    private org.omg.IIOP.Version _version = new org.omg.IIOP.Version(1, 0);
    SystemException _closeException = null;
    private short _disposition = 0;
    Map _activeRequests = new HashMap();
    int _channelAge = 0;
    int _tcsc;
    int _tcsw;
    private static final int CONN_SC_TOTAL = 2;
    private static final int CONN_SC_CODESETS = 0;
    private static final int CONN_SC_BIDIR = 1;
    private static final int CONN_SC_STATUS_UNSENT = 0;
    private static final int CONN_SC_STATUS_PEND = 1;
    private static final int CONN_SC_STATUS_SENT = 2;
    private int[] _scSent = null;
    private boolean _isDelegated = false;
    private IIOPServerProtocol _serverProtocol;
    IIOPServerChannel _peer;
    private Constructor _os_ctor;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$GIOP$Version;
    static /* synthetic */ Class class$org$openorb$io$MarshalBuffer;

    IIOPClientChannel(IIOPClientProtocol iIOPClientProtocol, Transport transport, IIOPServerProtocol iIOPServerProtocol, int n, int n2) {
        this._protocol = iIOPClientProtocol;
        this._orb = this._protocol.orb();
        this._clientManager = this._protocol.getClientManager();
        this._socketQueue = new SocketQueue(transport);
        this._socketQueue.setClientChannel(this);
        this._syncState = new java.lang.Object();
        this._serverProtocol = iIOPServerProtocol;
        this._tcsc = n;
        this._tcsw = n2;
        try {
            Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPClientChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPClientChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPClientChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this._os_ctor = ((ORB)this._orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", classArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE("Unable to initialize output stream constructor");
        }
        Trace.high(this.toString(), "created");
    }

    IIOPClientChannel(IIOPClientProtocol iIOPClientProtocol, IIOPServerChannel iIOPServerChannel) {
        this._protocol = iIOPClientProtocol;
        this._orb = this._protocol.orb();
        this._clientManager = this._protocol.getClientManager();
        this._peer = iIOPServerChannel;
        this._socketQueue = this._peer._socketQueue;
        this._socketQueue.setClientChannel(this);
        this._syncState = this._peer._syncState;
        this._state = 0x11000000;
        this._isDelegated = true;
        this._tcsc = this._peer._tcsc;
        this._tcsw = this._peer._tcsw;
        try {
            Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPClientChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPClientChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPClientChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this._os_ctor = ((ORB)this._orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", classArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE("Unable to initialize output stream constructor");
        }
    }

    public String toString() {
        return "ClientChannel: " + this._socketQueue.toString();
    }

    public org.omg.IIOP.Version version() {
        return this._version;
    }

    public int getTCSC() {
        return this._tcsc;
    }

    public int getTCSW() {
        return this._tcsw;
    }

    public org.omg.CORBA.ORB orb() {
        return this._orb;
    }

    public int state() {
        if (this._isDelegated) {
            java.lang.Object object = this._syncState;
            synchronized (object) {
                if (this._peer != null) {
                    int n = 0x11000000;
                    return n;
                }
                int n = 0x12000000;
                return n;
            }
        }
        return this._state;
    }

    boolean isDelegated() {
        return this._isDelegated;
    }

    public int active_requests() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            int n = this._activeRequests.size() + (this._peer != null ? this._peer._activeRequests.size() : 0);
            return n;
        }
    }

    public int channel_age() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (!this._activeRequests.isEmpty() || this._peer != null && !this._peer._activeRequests.isEmpty()) {
                int n = RequestIDAllocator.peek_request_id();
                return n;
            }
            if (this._peer != null && this._channelAge < this._peer._channelAge) {
                int n = this._peer._channelAge;
                return n;
            }
            int n = this._channelAge;
            return n;
        }
    }

    private void request_open(Object object, Address address) {
        switch (this._state) {
            case 0x11000000: {
                return;
            }
            case 0x13000000: {
                throw this._closeException;
            }
        }
        if (this._isDelegated && this._peer == null) {
            throw new TRANSIENT(0, CompletionStatus.COMPLETED_NO);
        }
        this._socketQueue.open();
        this._state = 0x11000000;
        this._firstConnect = false;
        this._pendClose = false;
        this._closeException = null;
        this.connectionSCReset();
        this._peer = null;
        this._clientManager.register_channel(this);
        Trace.high(this.toString(), "opened");
    }

    public void pause() {
        if (this._isDelegated) {
            this._peer.soft_close(false);
            return;
        }
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this.active_requests() > 0) {
                return;
            }
            if (this._state != 0x11000000) {
                return;
            }
            Trace.high(this.toString(), "paused");
            this._state = 0x12000000;
            if (this._peer != null) {
                this._peer._state = 1;
                this._peer._peer = null;
                this._peer = null;
            }
            this._inPause = true;
        }
        this._clientManager.unregister_channel(this);
        this._socketQueue.close();
        java.lang.Object object2 = this._syncState;
        synchronized (object2) {
            this._inPause = false;
            this._syncState.notifyAll();
        }
    }

    void server_pause(SystemException systemException) {
        String string;
        IIOPServerChannel iIOPServerChannel = null;
        ServerRequest[] serverRequestArray = null;
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._state != 0x11000000) {
                Trace.high(this.toString(), "already closed");
                return;
            }
            this._state = 0x12000000;
            if (this._peer != null) {
                if (!this._peer._activeRequests.isEmpty()) {
                    serverRequestArray = new ServerRequest[this._peer._activeRequests.size()];
                    this._peer._activeRequests.values().toArray(serverRequestArray);
                    this._peer._activeRequests.clear();
                }
                iIOPServerChannel = this._peer;
                this._peer._state = 1;
                this._peer._peer = null;
                this._peer = null;
            }
            this._inPause = true;
        }
        if (this._isDelegated) {
            string = iIOPServerChannel.toString();
            iIOPServerChannel._serverManager.unregister_channel(iIOPServerChannel);
        } else {
            string = this.toString();
            this._clientManager.unregister_channel(this);
        }
        this._socketQueue.close();
        IIOPClientRequest[] iIOPClientRequestArray = null;
        java.lang.Object object2 = this._syncState;
        synchronized (object2) {
            this._inPause = false;
            this._syncState.notifyAll();
            if (!this._activeRequests.isEmpty()) {
                iIOPClientRequestArray = new IIOPClientRequest[this._activeRequests.size()];
                this._activeRequests.values().toArray(iIOPClientRequestArray);
                this._activeRequests.clear();
            }
            Trace.high(string, this._isDelegated ? "paused by client" : "paused by server");
        }
        if (iIOPClientRequestArray != null) {
            int n = 0;
            while (n < iIOPClientRequestArray.length) {
                iIOPClientRequestArray[n].cancel(systemException);
                ++n;
            }
        }
        if (serverRequestArray != null) {
            int n = 0;
            while (n < serverRequestArray.length) {
                serverRequestArray[n].client_cancel();
                ++n;
            }
        }
    }

    public void close(boolean bl, SystemException systemException) {
        if (this._isDelegated) {
            if (bl) {
                this._peer.close();
            } else {
                this._peer.soft_close(this._pendClose);
            }
            return;
        }
        IIOPClientRequest[] iIOPClientRequestArray = null;
        ServerRequest[] serverRequestArray = null;
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._state == 0x12000000) {
                boolean bl2 = false;
                while (this._inPause) {
                    try {
                        this._syncState.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                this._closeException = systemException;
                this._state = 0x13000000;
                return;
            }
            if (this._state == 0x13000000) {
                return;
            }
            this._state = 0x13000000;
            this._closeException = systemException;
            if (!bl && this.active_requests() > 0) {
                this._pendClose = true;
                if (this._peer != null) {
                    this._peer._pendClose = true;
                }
                return;
            }
            iIOPClientRequestArray = new IIOPClientRequest[this._activeRequests.size()];
            this._activeRequests.values().toArray(iIOPClientRequestArray);
            this._activeRequests.clear();
            if (this._peer != null) {
                serverRequestArray = new ServerRequest[this._peer._activeRequests.size()];
                this._peer._activeRequests.values().toArray(serverRequestArray);
                this._peer._activeRequests.clear();
                this._peer._state = 1;
                this._peer._peer = null;
                this._peer = null;
            }
        }
        this._clientManager.unregister_channel(this);
        this._socketQueue.close();
        Trace.high(this.toString(), "closed");
        if (iIOPClientRequestArray != null) {
            int n = 0;
            while (n < iIOPClientRequestArray.length) {
                iIOPClientRequestArray[n].cancel(systemException);
                ++n;
            }
        }
        if (serverRequestArray != null) {
            int n = 0;
            while (n < serverRequestArray.length) {
                serverRequestArray[n].client_cancel();
                ++n;
            }
        }
    }

    public ClientRequest create_request(Object object, Address address, java.lang.Object object2, String string, boolean bl) throws RebindChannelException {
        int n = RequestIDAllocator.get_request_id() << 1;
        if (this._isDelegated) {
            --n;
        }
        IIOPClientRequest iIOPClientRequest = new IIOPClientRequest(n, object, address, object2, this, string, bl);
        java.lang.Object object3 = this._syncState;
        synchronized (object3) {
            this.check_rebind(address);
            this._activeRequests.put(new Integer(n), iIOPClientRequest);
        }
        Trace.medium(this.toString(), "request #" + n + " created");
        return iIOPClientRequest;
    }

    public ClientRequest create_locate_request(Object object, Address address, java.lang.Object object2) throws RebindChannelException {
        int n = RequestIDAllocator.get_request_id() << 1;
        if (this._isDelegated) {
            --n;
        }
        IIOPClientRequest iIOPClientRequest = new IIOPClientRequest(n, object, address, object2, this);
        java.lang.Object object3 = this._syncState;
        synchronized (object3) {
            this.check_rebind(address);
            this._activeRequests.put(new Integer(n), iIOPClientRequest);
        }
        Trace.medium(this.toString(), "locate request #" + n + " created");
        return iIOPClientRequest;
    }

    private void check_rebind(Address address) throws RebindChannelException {
        if (this._isDelegated && this._peer == null) {
            this._protocol.rebindBidirDelegate(this, (IIOPAddress)address);
            Trace.assert(false);
            return;
        }
    }

    boolean cancel_request(IIOPClientRequest iIOPClientRequest, boolean bl) {
        int n = iIOPClientRequest.request_id();
        boolean bl2 = false;
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._state == 0x13000000) {
                boolean bl3 = false;
                return bl3;
            }
            if (this._pendSC && !iIOPClientRequest.is_locate()) {
                this.connectionSCCanceled();
                this._pendSC = false;
                this._syncState.notifyAll();
            }
            if (this._activeRequests.isEmpty() || this._activeRequests.remove(new Integer(n)) == null) {
                boolean bl4 = false;
                return bl4;
            }
            if (this._activeRequests.isEmpty()) {
                this._channelAge = RequestIDAllocator.peek_request_id();
                bl2 = this._pendClose && (this._peer == null || this._peer._activeRequests.isEmpty());
            }
        }
        Trace.medium(this.toString(), "request #" + n + " canceled");
        if (bl2) {
            if (this._isDelegated) {
                this._peer.soft_close(false);
            } else {
                this.close(false, this._closeException);
            }
            return true;
        }
        if (bl) {
            byte[] byArray = new byte[]{71, 73, 79, 80, this._version.major, this._version.minor, 2, 4, (byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
            StorageBuffer storageBuffer = new StorageBuffer(byArray, 0, 12);
            this._socketQueue.enqueue(storageBuffer, iIOPClientRequest.get_transport_association());
        }
        return true;
    }

    OutputStream begin_marshal(IIOPClientRequest iIOPClientRequest) {
        CDROutputStream cDROutputStream;
        short s;
        org.omg.IIOP.Version version = ((IIOPAddress)iIOPClientRequest.address()).get_version();
        Version version2 = new Version(1, 0);
        boolean bl = false;
        java.lang.Object object = this._syncState;
        synchronized (object) {
            boolean bl2;
            if (this._version.minor < version.minor) {
                this._version.minor = version.minor;
            }
            version2.minor = this._version.minor;
            boolean bl3 = bl2 = !iIOPClientRequest.is_locate();
            if (bl2) {
                while (this._inPause || this._pendSC) {
                    try {
                        this._syncState.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.request_open(iIOPClientRequest.target(), iIOPClientRequest.address());
            if (bl2) {
                this._pendSC = this.connectionSCAdd(iIOPClientRequest);
            }
            s = this._disposition;
        }
        MarshalBuffer marshalBuffer = new MarshalBuffer(new MarshalListener(), iIOPClientRequest);
        try {
            java.lang.Object[] objectArray = new java.lang.Object[]{iIOPClientRequest.orb(), version2, marshalBuffer};
            cDROutputStream = (CDROutputStream)this._os_ctor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE("Unable to create CDROutputStream class");
        }
        cDROutputStream.setCodesets(this._tcsc, this._tcsw);
        int n = iIOPClientRequest.request_id();
        if (iIOPClientRequest.is_request()) {
            new HeaderBlock(0, n, cDROutputStream);
            switch (version2.minor) {
                case 0: 
                case 1: {
                    ServiceContextListHelper.write(cDROutputStream, iIOPClientRequest.get_request_service_contexts());
                    cDROutputStream.write_long(n);
                    cDROutputStream.write_boolean(iIOPClientRequest.response_expected());
                    OctetSeqHelper.write(cDROutputStream, iIOPClientRequest.address().getTargetAddress((short)0).object_key());
                    cDROutputStream.write_string(iIOPClientRequest.operation());
                    cDROutputStream.write_long(0);
                    break;
                }
                case 2: {
                    cDROutputStream.write_long(n);
                    cDROutputStream.allowFragment();
                    switch (iIOPClientRequest.sync_scope()) {
                        case 0: 
                        case 1: {
                            cDROutputStream.write_octet((byte)0);
                            break;
                        }
                        case 2: {
                            cDROutputStream.write_octet((byte)1);
                            break;
                        }
                        case 3: {
                            cDROutputStream.write_octet((byte)3);
                        }
                    }
                    cDROutputStream.write_octet_array(RESERVED, 0, 3);
                    TargetAddressHelper.write(cDROutputStream, iIOPClientRequest.address().getTargetAddress(s));
                    cDROutputStream.write_string(iIOPClientRequest.operation());
                    ServiceContextListHelper.write(cDROutputStream, iIOPClientRequest.get_request_service_contexts());
                    cDROutputStream.pending_alignment(8);
                }
            }
        } else {
            new HeaderBlock(3, n, cDROutputStream);
            cDROutputStream.write_long(n);
            switch (version2.minor) {
                case 0: 
                case 1: {
                    byte[] byArray = iIOPClientRequest.address().getTargetAddress((short)0).object_key();
                    OctetSeqHelper.write(cDROutputStream, byArray);
                    break;
                }
                case 2: {
                    cDROutputStream.allowFragment();
                    TargetAddressHelper.write(cDROutputStream, iIOPClientRequest.address().getTargetAddress(s));
                }
            }
        }
        return cDROutputStream;
    }

    protected boolean connectionSCAdd(IIOPClientRequest iIOPClientRequest) {
        IDLEntity iDLEntity;
        java.lang.Object object;
        if (this._scSent == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this._scSent[0] == 0 && this._version.minor > 0) {
            if (this._tcsc != 0 || this._tcsw != 0) {
                object = new byte[]{0, 0, 0, 0, (byte)(this._tcsc >>> 24), (byte)(this._tcsc >>> 16), (byte)(this._tcsc >>> 8), (byte)this._tcsc, (byte)(this._tcsw >>> 24), (byte)(this._tcsw >>> 16), (byte)(this._tcsw >>> 8), (byte)this._tcsw};
                iDLEntity = new ServiceContext(1, (byte[])object);
                iIOPClientRequest.add_request_service_context((ServiceContext)iDLEntity, true);
                this._scSent[0] = 1;
                bl2 = true;
            } else {
                this._scSent[0] = 2;
                bl = true;
            }
        }
        if (this._scSent[1] == 0) {
            object = this._protocol.getBiDirSC();
            if (object != null) {
                iDLEntity = null;
                try {
                    iDLEntity = BidirectionalPolicyHelper.narrow(iIOPClientRequest.get_request_policy(37));
                }
                catch (INV_POLICY iNV_POLICY) {
                    // empty catch block
                }
                if (iDLEntity != null && iDLEntity.value() == 1) {
                    this._peer = new IIOPServerChannel(this._serverProtocol.getServerManager(), this, this._protocol._codec);
                    Trace.high(this.toString(), "became bidirectional with peer " + this._peer.toString());
                    iIOPClientRequest.add_request_service_context((ServiceContext)object, true);
                    this._scSent[1] = 1;
                    bl2 = true;
                }
            } else {
                this._scSent[1] = 2;
                bl = true;
            }
        }
        if (bl2) {
            return true;
        }
        if (bl) {
            boolean bl3 = true;
            int n = 0;
            while (n < this._scSent.length) {
                bl3 = this._scSent[n] == 2;
                if (!bl3) break;
                ++n;
            }
            if (bl3) {
                this._scSent = null;
            }
        }
        return false;
    }

    protected void connectionSCSent() {
        if (this._scSent != null) {
            boolean bl = true;
            int n = 0;
            while (n < this._scSent.length) {
                if (this._scSent[n] != 0) {
                    this._scSent[n] = 2;
                } else {
                    bl = false;
                }
                ++n;
            }
            if (bl) {
                this._scSent = null;
            }
        }
    }

    protected void connectionSCCanceled() {
        if (this._scSent != null) {
            int n = 0;
            while (n < this._scSent.length) {
                if (this._scSent[n] == 1) {
                    this._scSent[n] = 0;
                }
                ++n;
            }
        }
    }

    protected void connectionSCReset() {
        this._scSent = new int[2];
    }

    public void run_send() {
        if (this._isDelegated) {
            return;
        }
        while (!Thread.interrupted() && this._socketQueue.send(0) >= 0) {
        }
    }

    public int send(int n) {
        if (this._isDelegated) {
            return -1;
        }
        return this._socketQueue.send(n);
    }

    public int send_pending() {
        if (this._isDelegated) {
            return -1;
        }
        return this._socketQueue.send_pending();
    }

    public boolean recv(int n) {
        if (this._isDelegated) {
            return false;
        }
        return this._socketQueue.process_or_enqueue(true, n);
    }

    public void run_recv() {
        if (this._isDelegated) {
            return;
        }
        while (!Thread.interrupted() && this._socketQueue.process_or_enqueue(true, 1000)) {
        }
    }

    int process_reply(byte by, CDRInputStream cDRInputStream, byte by2, boolean bl, BufferSource bufferSource, java.lang.Object object) {
        int n = -1;
        ServiceContext[] serviceContextArray = null;
        cDRInputStream.setCodesets(this._tcsc, this._tcsw);
        int n2 = 0;
        IIOPClientRequest iIOPClientRequest = null;
        boolean bl2 = false;
        try {
            try {
                if (by < 2 && by2 == 1) {
                    serviceContextArray = ServiceContextListHelper.read(cDRInputStream);
                }
                n2 = cDRInputStream.read_long();
                java.lang.Object object2 = this._syncState;
                synchronized (object2) {
                    if (bl) {
                        iIOPClientRequest = (IIOPClientRequest)this._activeRequests.get(new Integer(n2));
                    } else {
                        iIOPClientRequest = (IIOPClientRequest)this._activeRequests.remove(new Integer(n2));
                        if (this._activeRequests.isEmpty()) {
                            this._channelAge = RequestIDAllocator.peek_request_id();
                            bl2 = this._pendClose && (this._peer == null || this._peer._activeRequests.isEmpty());
                        }
                    }
                }
                if (iIOPClientRequest == null) {
                    Trace.medium(this.toString(), "request #" + n2 + (bl ? "" : " last") + " reply fragment discarded, no corresponding request.");
                } else if (!iIOPClientRequest.checkReplyTransportAssoc(object)) {
                    iIOPClientRequest = null;
                    Trace.medium(this.toString(), "request #" + n2 + (bl ? "" : " last") + " reply fragment discarded, sender not authorized.");
                } else {
                    Trace.medium(this.toString(), "request #" + n2 + (bl ? "" : " last") + " reply fragment received");
                    iIOPClientRequest.setReplySource(bufferSource);
                    n = cDRInputStream.read_long();
                    if (by >= 2 && by2 == 1) {
                        serviceContextArray = ServiceContextListHelper.read(cDRInputStream);
                        try {
                            cDRInputStream.alignment(8);
                        }
                        catch (MARSHAL mARSHAL) {
                        }
                    }
                }
                java.lang.Object var15_17 = null;
            }
            catch (SystemException systemException) {
                if (iIOPClientRequest == null) {
                    this.close(true, this._closeException);
                } else {
                    iIOPClientRequest.cancel(systemException);
                }
                int n3 = n2;
                java.lang.Object var15_18 = null;
                bufferSource.removeWaitingForBufferListener(null);
                return n3;
            }
            bufferSource.removeWaitingForBufferListener(null);
        }
        catch (Throwable throwable) {
            java.lang.Object var15_19 = null;
            bufferSource.removeWaitingForBufferListener(null);
            throw throwable;
        }
        if (iIOPClientRequest != null) {
            iIOPClientRequest.handle_reply(n, serviceContextArray, cDRInputStream);
        }
        if (bl2) {
            if (this._isDelegated) {
                this._peer.soft_close(false);
            } else {
                this.close(false, this._closeException);
            }
        }
        return n2;
    }

    void process_fragment(int n, StorageBuffer storageBuffer, boolean bl, java.lang.Object object) {
        IIOPClientRequest iIOPClientRequest;
        boolean bl2 = false;
        java.lang.Object object2 = this._syncState;
        synchronized (object2) {
            if (bl) {
                iIOPClientRequest = (IIOPClientRequest)this._activeRequests.get(new Integer(n));
            } else {
                iIOPClientRequest = (IIOPClientRequest)this._activeRequests.remove(new Integer(n));
                if (this._activeRequests.isEmpty()) {
                    this._channelAge = RequestIDAllocator.peek_request_id();
                    bl2 = this._pendClose && (this._peer == null || this._peer._activeRequests.isEmpty());
                }
            }
        }
        if (iIOPClientRequest == null) {
            Trace.medium(this.toString(), "request #" + n + (bl ? "" : " last") + " reply fragment discarded, no corresponding request.");
        } else if (!iIOPClientRequest.checkReplyTransportAssoc(object)) {
            Trace.medium(this.toString(), "request #" + n + (bl ? "" : " last") + " reply fragment discarded, sender not authorized.");
        } else {
            Trace.medium(this.toString(), "request #" + n + (bl ? "" : " last") + " reply fragment.");
            iIOPClientRequest.getReplySource().addLast(storageBuffer, !bl);
        }
        if (bl2) {
            if (this._isDelegated) {
                this._peer.soft_close(false);
            } else {
                this.close(false, this._closeException);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(false, new BAD_INV_ORDER(0x4F40004, CompletionStatus.COMPLETED_NO));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MarshalListener
    implements MarshalBuffer.Listener {
        private boolean _fragSent = false;

        private MarshalListener() {
        }

        public void availIncreaced(MarshalBuffer marshalBuffer, int n, java.lang.Object object) {
            while (n > 120000) {
                this._fragSent = true;
                IIOPClientRequest iIOPClientRequest = (IIOPClientRequest)object;
                if (iIOPClientRequest.state() != 1) {
                    return;
                }
                StorageBuffer storageBuffer = marshalBuffer.fragment(120000);
                if (IIOPClientChannel.this._socketQueue.enqueue(storageBuffer, iIOPClientRequest.get_transport_association())) {
                    Trace.medium(IIOPClientChannel.this.toString(), "request #" + iIOPClientRequest.request_id() + " fragment sent");
                }
                n -= 120000;
            }
        }

        public void bufferClosed(MarshalBuffer marshalBuffer, int n, java.lang.Object object) {
            IIOPClientRequest iIOPClientRequest = (IIOPClientRequest)object;
            if (iIOPClientRequest.state() != 1) {
                return;
            }
            StorageBuffer storageBuffer = marshalBuffer.lastFragment();
            if (IIOPClientChannel.this._socketQueue.enqueue(storageBuffer, iIOPClientRequest.get_transport_association())) {
                Trace.medium(IIOPClientChannel.this.toString(), "request #" + iIOPClientRequest.request_id() + " last fragment sent");
            }
            if (IIOPClientChannel.this._pendSC && !iIOPClientRequest.is_locate()) {
                java.lang.Object object2 = IIOPClientChannel.this._syncState;
                synchronized (object2) {
                    IIOPClientChannel.this.connectionSCSent();
                    IIOPClientChannel.this._pendSC = false;
                    IIOPClientChannel.this._syncState.notifyAll();
                }
            }
        }

        public void bufferCanceled(MarshalBuffer marshalBuffer, SystemException systemException, java.lang.Object object) {
            IIOPClientRequest iIOPClientRequest = (IIOPClientRequest)object;
            IIOPClientChannel.this.cancel_request(iIOPClientRequest, this._fragSent);
            if (iIOPClientRequest.state() != 1) {
                return;
            }
            systemException.completed = CompletionStatus.COMPLETED_NO;
            iIOPClientRequest.cancel(systemException);
            throw systemException;
        }
    }
}

