/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CORBA.Any;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.openorb.iiop.CDRCodecFactory;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.iiop.IIOPAddress;
import org.openorb.iiop.IIOPClientChannel;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPServerProtocol;
import org.openorb.net.Address;
import org.openorb.net.ClientBinding;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientProtocol;
import org.openorb.net.RebindChannelException;
import org.openorb.net.ServerManager;
import org.openorb.net.Transport;
import org.openorb.net.TransportAssociationHolder;
import org.openorb.net.TransportClientInitializer;
import org.openorb.util.Trace;
import org.openorb.util.WeakValueHashMap;

public class IIOPClientProtocol
implements ClientProtocol {
    private ClientManager _clientManager;
    private ORB _orb;
    Codec _codec;
    private IIOPServerProtocol _serverProtocol = null;
    private ServerManager _serverManager = null;
    private Map _channels = new WeakValueHashMap();
    private CodeSetComponentInfo _codesetInfo;
    private TransportClientInitializer _tpInit;
    private ServiceContext _biDirSC;

    public IIOPClientProtocol(ClientManager clientManager, CDRCodecFactory cDRCodecFactory, CodeSetComponentInfo codeSetComponentInfo, TransportClientInitializer transportClientInitializer, ListenPoint[] listenPointArray) {
        try {
            this._codec = cDRCodecFactory.create_codec(new Encoding(0, 1, 2));
        }
        catch (UnknownEncoding unknownEncoding) {
            Trace.assert(false, "Could not find codec");
        }
        this._clientManager = clientManager;
        this._orb = this._clientManager.orb();
        this._codesetInfo = codeSetComponentInfo;
        this._tpInit = transportClientInitializer;
        if (listenPointArray != null) {
            try {
                BiDirIIOPServiceContext biDirIIOPServiceContext = new BiDirIIOPServiceContext(listenPointArray);
                Any any = this._orb.create_any();
                BiDirIIOPServiceContextHelper.insert(any, biDirIIOPServiceContext);
                byte[] byArray = this._codec.encode_value(any);
                this._biDirSC = new ServiceContext(5, byArray);
            }
            catch (UserException userException) {
                throw new INITIALIZE(userException.toString());
            }
        }
    }

    void setServerProtocol(IIOPServerProtocol iIOPServerProtocol) {
        this._serverProtocol = iIOPServerProtocol;
        this._serverManager = iIOPServerProtocol.getServerManager();
    }

    public ORB orb() {
        return this._orb;
    }

    public ClientManager getClientManager() {
        return this._clientManager;
    }

    public Address[] createAddresses(IORAddressingInfo iORAddressingInfo) {
        return this._tpInit.establishTransports(IIOPAddress.get_addresses(this._codec, iORAddressingInfo.ior, iORAddressingInfo.selected_profile_index));
    }

    public ClientBinding createBinding(Address address) {
        ClientBinding clientBinding;
        if (!(address instanceof IIOPAddress)) {
            return null;
        }
        IIOPAddress iIOPAddress = (IIOPAddress)address;
        Map map = this._channels;
        synchronized (map) {
            try {
                TransportAssociationHolder transportAssociationHolder = new TransportAssociationHolder();
                IIOPClientChannel iIOPClientChannel = this.findCreateChannel(iIOPAddress, null, transportAssociationHolder);
                clientBinding = this._serverManager == null || this._serverProtocol == null || !this._serverProtocol.servesAddress(iIOPAddress.get_hostname(), iIOPAddress.get_port()) ? new ClientBinding(iIOPAddress, iIOPClientChannel, transportAssociationHolder.value) : new ClientBinding(iIOPAddress, iIOPClientChannel, transportAssociationHolder.value, this._serverManager);
            }
            catch (SystemException systemException) {
                clientBinding = new ClientBinding(iIOPAddress, systemException);
            }
        }
        return clientBinding;
    }

    protected IIOPClientChannel findCreateChannel(IIOPAddress iIOPAddress, IIOPClientChannel iIOPClientChannel, TransportAssociationHolder transportAssociationHolder) {
        InetAddress inetAddress = iIOPAddress.get_host();
        if (inetAddress == null) {
            throw new COMM_FAILURE("Host not found", 1146056971, CompletionStatus.COMPLETED_NO);
        }
        LookupKey lookupKey = new LookupKey(iIOPAddress);
        IIOPClientChannel iIOPClientChannel2 = (IIOPClientChannel)this._channels.get(lookupKey);
        if (iIOPClientChannel2 == null || iIOPClientChannel == iIOPClientChannel2) {
            Object object;
            int n;
            int n2;
            if (iIOPAddress.get_port() == 0) {
                throw new NO_PERMISSION("Port number published in IOR is 0.", 1146056984, CompletionStatus.COMPLETED_NO);
            }
            CodeSetComponentInfo codeSetComponentInfo = iIOPAddress.getCodesetComponentInfo();
            if (codeSetComponentInfo == null) {
                n2 = 0;
                n = 0;
            } else {
                object = iIOPAddress.get_version();
                if (((Version)object).major == 1 && ((Version)object).minor == 0) {
                    codeSetComponentInfo.ForCharData.native_code_set = 65537;
                    codeSetComponentInfo.ForCharData.conversion_code_sets = new int[0];
                }
                n2 = IIOPClientProtocol.selectCodeset(this._codesetInfo.ForCharData, codeSetComponentInfo.ForCharData, true);
                n = IIOPClientProtocol.selectCodeset(this._codesetInfo.ForWcharData, codeSetComponentInfo.ForWcharData, false);
            }
            object = iIOPAddress.createTransport();
            object.establishAssociation(iIOPAddress, transportAssociationHolder);
            iIOPClientChannel2 = new IIOPClientChannel(this, (Transport)object, this._serverProtocol, n2, n);
            this._channels.put(new HostPortPair(inetAddress, iIOPAddress.get_port(), n2, n, (Transport)object), iIOPClientChannel2);
        } else {
            transportAssociationHolder.value = lookupKey.value;
        }
        return iIOPClientChannel2;
    }

    private static boolean checkCodeset(int n, CodeSetComponent codeSetComponent) {
        if (n == 0x5010001 || n == 65801) {
            return true;
        }
        if (codeSetComponent.native_code_set != n) {
            int n2 = 0;
            while (n2 < codeSetComponent.conversion_code_sets.length) {
                if (codeSetComponent.conversion_code_sets[n2] == n) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    private static int selectCodeset(CodeSetComponent codeSetComponent, CodeSetComponent codeSetComponent2, boolean bl) {
        int n;
        if (codeSetComponent.native_code_set == codeSetComponent2.native_code_set) {
            return codeSetComponent.native_code_set;
        }
        int n2 = 0;
        while (n2 < codeSetComponent.conversion_code_sets.length) {
            if (codeSetComponent2.native_code_set == codeSetComponent.conversion_code_sets[n2]) {
                return codeSetComponent2.native_code_set;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < codeSetComponent2.conversion_code_sets.length) {
            if (codeSetComponent.native_code_set == codeSetComponent2.conversion_code_sets[n3]) {
                return codeSetComponent.native_code_set;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < codeSetComponent2.conversion_code_sets.length) {
            int n5 = 0;
            while (n5 < codeSetComponent.conversion_code_sets.length) {
                if (codeSetComponent2.conversion_code_sets[n4] == codeSetComponent.conversion_code_sets[n5]) {
                    return codeSetComponent2.conversion_code_sets[n4];
                }
                ++n5;
            }
            ++n4;
        }
        int n6 = n = bl ? 0x5010001 : 65801;
        if (CodeSetDatabase.compatableCodesets(codeSetComponent.native_code_set, codeSetComponent2.native_code_set)) {
            return n;
        }
        int n7 = 0;
        while (n7 < codeSetComponent.conversion_code_sets.length) {
            if (CodeSetDatabase.compatableCodesets(codeSetComponent2.native_code_set, codeSetComponent.conversion_code_sets[n7])) {
                return n;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < codeSetComponent2.conversion_code_sets.length) {
            if (CodeSetDatabase.compatableCodesets(codeSetComponent.native_code_set, codeSetComponent2.conversion_code_sets[n8])) {
                return n;
            }
            ++n8;
        }
        int n9 = 0;
        while (n9 < codeSetComponent2.conversion_code_sets.length) {
            int n10 = 0;
            while (n10 < codeSetComponent.conversion_code_sets.length) {
                if (CodeSetDatabase.compatableCodesets(codeSetComponent2.conversion_code_sets[n9], codeSetComponent.conversion_code_sets[n10])) {
                    return n;
                }
                ++n10;
            }
            ++n9;
        }
        throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
    }

    void rebindBidirDelegate(IIOPClientChannel iIOPClientChannel, IIOPAddress iIOPAddress) throws RebindChannelException {
        IIOPClientChannel iIOPClientChannel2;
        TransportAssociationHolder transportAssociationHolder = new TransportAssociationHolder();
        Map map = this._channels;
        synchronized (map) {
            iIOPClientChannel2 = this.findCreateChannel(iIOPAddress, iIOPClientChannel, transportAssociationHolder);
        }
        throw new RebindChannelException(iIOPClientChannel2, transportAssociationHolder.value);
    }

    ServiceContext getBiDirSC() {
        return this._biDirSC;
    }

    IIOPClientChannel createBidirDelegate(IIOPServerChannel iIOPServerChannel, ListenPoint[] listenPointArray) {
        IIOPClientChannel iIOPClientChannel;
        Map map = this._channels;
        synchronized (map) {
            HostPortPair hostPortPair;
            HostPortPair[] hostPortPairArray = new HostPortPair[listenPointArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < listenPointArray.length) {
                block17: {
                    InetAddress inetAddress;
                    try {
                        inetAddress = InetAddress.getByName(listenPointArray[n2].host);
                    }
                    catch (UnknownHostException unknownHostException) {
                        break block17;
                    }
                    hostPortPair = new HostPortPair(inetAddress, listenPointArray[n2].port, iIOPServerChannel.getTCSC(), iIOPServerChannel.getTCSW(), null);
                    IIOPClientChannel iIOPClientChannel2 = (IIOPClientChannel)this._channels.get(hostPortPair);
                    if (iIOPClientChannel2 != null) {
                        switch (iIOPClientChannel2.state()) {
                            case 0x11000000: {
                                IIOPClientChannel iIOPClientChannel3 = null;
                                return iIOPClientChannel3;
                            }
                            case 0x12000000: {
                                if (!iIOPClientChannel2.isDelegated()) {
                                    IIOPClientChannel iIOPClientChannel4 = null;
                                    return iIOPClientChannel4;
                                }
                            }
                            case 0x13000000: {
                                iIOPClientChannel2 = null;
                            }
                        }
                    }
                    if (iIOPClientChannel2 == null) {
                        hostPortPairArray[n++] = new HostPortPair(inetAddress, listenPointArray[n2].port, iIOPServerChannel.getTCSC(), iIOPServerChannel.getTCSW(), iIOPServerChannel._socketQueue.getTransport());
                    }
                }
                ++n2;
            }
            if (n == 0) {
                hostPortPair = null;
                return hostPortPair;
            }
            iIOPClientChannel = new IIOPClientChannel(this, iIOPServerChannel);
            int n3 = 0;
            while (n3 < n) {
                if (hostPortPairArray[n3] != null) {
                    this._channels.put(hostPortPairArray[n3], iIOPClientChannel);
                }
                ++n3;
            }
        }
        return iIOPClientChannel;
    }

    private static class HostPortPair
    extends TransportAssociationHolder {
        private int _hash;
        private InetAddress _host;
        private int _port;
        private int _tcsc = -1;
        private int _tcsw = -1;
        private Transport _transport;

        public HostPortPair(InetAddress inetAddress, int n, int n2, int n3, Transport transport) {
            this._host = inetAddress;
            this._port = n;
            this._hash = inetAddress.hashCode() ^ n;
            this._tcsc = n2;
            this._tcsw = n3;
            this._transport = transport;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object object) {
            if (object instanceof LookupKey) {
                return object.equals(this);
            }
            HostPortPair hostPortPair = (HostPortPair)object;
            if (this._transport != null && hostPortPair._transport != null) {
                return this == hostPortPair;
            }
            return hostPortPair._hash == this._hash && hostPortPair._port == this._port && hostPortPair._host.equals(this._host) && this._tcsc == hostPortPair._tcsc && this._tcsw == hostPortPair._tcsw;
        }
    }

    private static class LookupKey
    extends TransportAssociationHolder {
        private int _hash;
        private InetAddress _host;
        private int _port;
        private CodeSetComponentInfo _csci;
        private IIOPAddress _addr;

        LookupKey(IIOPAddress iIOPAddress) {
            this._host = iIOPAddress.get_host();
            this._port = iIOPAddress.get_port();
            this._hash = this._host.hashCode() ^ this._port;
            this._addr = iIOPAddress;
            this._csci = iIOPAddress.getCodesetComponentInfo();
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HostPortPair)) {
                return false;
            }
            HostPortPair hostPortPair = (HostPortPair)object;
            if (hostPortPair._hash != this._hash || hostPortPair._port != this._port || !hostPortPair._host.equals(this._host)) {
                return false;
            }
            if (this._addr == null) {
                return true;
            }
            if (!(this._csci == null || IIOPClientProtocol.checkCodeset(hostPortPair._tcsc, this._csci.ForCharData) && IIOPClientProtocol.checkCodeset(hostPortPair._tcsw, this._csci.ForWcharData))) {
                return false;
            }
            return hostPortPair._transport.establishAssociation(this._addr, this);
        }
    }
}

