/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.IOException;
import java.util.TooManyListenersException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContext;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ObjectStub;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.ClientManager;
import org.openorb.PI.RequestCallback;
import org.openorb.iiop.CDROutputStream;
import org.openorb.iiop.IIOPClientChannel;
import org.openorb.io.BufferSource;
import org.openorb.net.AbstractClientRequest;
import org.openorb.net.Address;
import org.openorb.util.Trace;

class IIOPClientRequest
extends AbstractClientRequest {
    private IIOPClientChannel _channel;
    private boolean _responseExpected;
    private String _operation;
    private short _syncScope;
    private ClientManager _clientManager = null;
    private RequestCallback _callback = null;
    private java.lang.Object _syncState = new java.lang.Object();
    private int _state = 0;
    private OutputStream _requestStream;
    private short _replyStatus = Short.MIN_VALUE;
    private ServiceContext[] _replyServiceContexts;
    private InputStream _responseStream;
    private boolean _responseArrived = false;
    private boolean _lastResponseArrived = false;
    private Object _forwardReference;
    private IOR _forwardReferenceIOR;
    private SystemException _recievedSystemException;
    private Any _recievedSystemExceptionAny = null;
    private String _recievedExceptionID;
    private BufferSource _replySource = null;
    private static final short REPLY_STATUS_UNSET = Short.MIN_VALUE;

    IIOPClientRequest(int n, Object object, Address address, java.lang.Object object2, IIOPClientChannel iIOPClientChannel, String string, boolean bl) {
        super(n, object, address, object2, iIOPClientChannel);
        this._channel = iIOPClientChannel;
        this._operation = string;
        this._responseExpected = bl;
        this._syncScope = this._responseExpected ? (short)3 : (short)2;
        this._clientManager = (ClientManager)((ORB)this.orb()).getFeature("ClientInterceptorManager");
        if (this._clientManager != null) {
            this._callback = new IIOPRequestCallback();
        }
    }

    IIOPClientRequest(int n, Object object, Address address, java.lang.Object object2, IIOPClientChannel iIOPClientChannel) {
        super(n, object, address, object2, iIOPClientChannel);
        this._channel = iIOPClientChannel;
        this._operation = null;
        this._responseExpected = true;
        this._syncScope = (short)-1;
    }

    public int state() {
        return this._state;
    }

    public boolean is_request() {
        return this._operation != null;
    }

    public boolean is_locate() {
        return this._operation == null;
    }

    public boolean is_poll() {
        return false;
    }

    public short sync_scope() {
        return this._syncScope;
    }

    public boolean response_expected() {
        return this._responseExpected;
    }

    public String operation() {
        return this._operation == null ? "" : this._operation;
    }

    public boolean cancel(SystemException systemException) {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._state == 4) {
                boolean bl = false;
                return bl;
            }
            switch (this._state) {
                case 1: {
                    this._replyStatus = 1;
                    this._state = 4;
                    systemException.completed = CompletionStatus.COMPLETED_NO;
                    this.handle_system_exception(systemException);
                    if (this._clientManager != null) {
                        this._clientManager.receive_exception(this, this._callback);
                        this._clientManager = null;
                    }
                    if (this._requestStream instanceof CDROutputStream) {
                        try {
                            ((CDROutputStream)this._requestStream).cancel(systemException);
                        }
                        catch (SystemException systemException2) {}
                        break;
                    }
                    this._channel.cancel_request(this, true);
                    break;
                }
                case 2: {
                    if (this._replySource != null) {
                        systemException.completed = CompletionStatus.COMPLETED_YES;
                        this._replySource.setException(systemException);
                        break;
                    }
                    this._state = 4;
                    systemException.completed = this._channel.cancel_request(this, true) ? CompletionStatus.COMPLETED_MAYBE : CompletionStatus.COMPLETED_NO;
                    this.handle_system_exception(systemException);
                    if (this._clientManager != null) {
                        this._clientManager.receive_exception(this, this._callback);
                        this._clientManager = null;
                    }
                    this._syncState.notifyAll();
                    break;
                }
                case 3: {
                    systemException.completed = CompletionStatus.COMPLETED_YES;
                    this._replySource.setException(systemException);
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    public org.omg.CORBA.portable.OutputStream begin_marshal() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this._state) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    throw new BAD_INV_ORDER(83099658, this.state_completion_status());
                }
                case 4: {
                    org.omg.CORBA.portable.OutputStream outputStream = null;
                    return outputStream;
                }
                default: {
                    Trace.assert(false, "invalid state");
                }
            }
            if (this._clientManager != null) {
                this._clientManager.send_request(this, this._callback);
                if (this._replyStatus != Short.MIN_VALUE) {
                    this._state = 4;
                    this._channel.cancel_request(this, false);
                    org.omg.CORBA.portable.OutputStream outputStream = null;
                    return outputStream;
                }
            }
            try {
                this._requestStream = this._channel.begin_marshal(this);
            }
            catch (SystemException systemException) {
                this._state = 4;
                systemException.completed = CompletionStatus.COMPLETED_NO;
                this.handle_system_exception(systemException);
                if (this._clientManager != null) {
                    this._clientManager.receive_exception(this, this._callback);
                    this._clientManager = null;
                }
                org.omg.CORBA.portable.OutputStream outputStream = null;
                return outputStream;
            }
            if (this._state == 0) {
                this._state = 1;
                OutputStream outputStream = this._requestStream;
                return outputStream;
            }
            org.omg.CORBA.portable.OutputStream outputStream = null;
            return outputStream;
        }
    }

    public int send_request() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this._state) {
                case 1: {
                    break;
                }
                case 0: 
                case 3: {
                    throw new BAD_INV_ORDER(83099658, this.state_completion_status());
                }
                case 2: 
                case 4: {
                    int n = this._state;
                    return n;
                }
                default: {
                    Trace.assert(false, "invalid state");
                }
            }
            try {
                this._requestStream.close();
                this._state = 2;
            }
            catch (SystemException systemException) {
                if (this._state != 4) {
                    this._state = 4;
                    systemException.completed = CompletionStatus.COMPLETED_NO;
                    this.handle_system_exception((SystemException)systemException.fillInStackTrace());
                    if (this._clientManager != null) {
                        this._clientManager.receive_exception(this, this._callback);
                        this._clientManager = null;
                    }
                }
            }
            catch (IOException iOException) {
                Trace.assert(false, "invalid state");
            }
            if (this._syncScope != 0 || this._state == 4) {
                int n = this._state;
                return n;
            }
            this._state = 4;
            this._replyStatus = 0;
            if (this._clientManager != null) {
                this._clientManager.receive_reply(this, this._callback);
                this._clientManager = null;
            }
            this._responseStream = (InputStream)this.orb().create_output_stream().create_input_stream();
            this._replyServiceContexts = new ServiceContext[0];
        }
        this._channel.cancel_request(this, false);
        return 4;
    }

    public boolean poll_response() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this._state) {
                case 2: {
                    boolean bl = this._responseArrived;
                    return bl;
                }
                case 0: 
                case 1: {
                    throw new BAD_INV_ORDER(83099658, this.state_completion_status());
                }
                case 3: 
                case 4: {
                    boolean bl = true;
                    return bl;
                }
            }
            Trace.assert(false, "invalid state");
            boolean bl = false;
            return bl;
        }
    }

    public int wait_for_response(long l) {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this._state) {
                case 2: {
                    break;
                }
                case 0: 
                case 1: {
                    throw new BAD_INV_ORDER(83099658, this.state_completion_status());
                }
                case 3: 
                case 4: {
                    int n = this._state;
                    return n;
                }
                default: {
                    Trace.assert(false, "invalid state");
                }
            }
            if (!this._responseArrived) {
                try {
                    this._syncState.wait(l <= 0L ? 0L : l);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                switch (this._state) {
                    case 2: {
                        if (this._responseArrived) break;
                        int n = this._state;
                        return n;
                    }
                    case 3: 
                    case 4: {
                        int n = this._state;
                        return n;
                    }
                    default: {
                        Trace.assert(false, "invalid state");
                    }
                }
            }
            this._responseArrived = false;
            switch (this._replyStatus) {
                case 0: {
                    if (this._lastResponseArrived) break;
                    int n = this._state = 3;
                    return n;
                }
                case 2: {
                    this._responseStream.mark(0);
                    this._recievedExceptionID = this._responseStream.read_string();
                    try {
                        this._responseStream.reset();
                    }
                    catch (IOException iOException) {
                        Trace.assert(false, iOException.toString());
                    }
                    if (this._lastResponseArrived) break;
                    int n = this._state = 3;
                    return n;
                }
                case 1: {
                    this._recievedExceptionID = this._responseStream.read_string();
                    this._recievedSystemException = SystemExceptionHelper.create(this._recievedExceptionID, this._responseStream.read_ulong(), CompletionStatus.from_int(this._responseStream.read_ulong()));
                    this._recievedSystemExceptionAny = null;
                    break;
                }
                case 3: 
                case 4: {
                    this._forwardReferenceIOR = IORHelper.read(this._responseStream);
                    this._forwardReference = null;
                }
                case -2: 
                case -1: 
                case 5: {
                    break;
                }
                default: {
                    Trace.assert(false, "invalid state");
                }
            }
            Trace.assert(this._lastResponseArrived);
            this._state = 3;
            this.lastReplyMessage(this._replySource);
            int n = this._state;
            return n;
        }
    }

    public org.omg.CORBA.portable.InputStream receive_response() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this._state) {
                case 3: 
                case 4: {
                    InputStream inputStream = this._responseStream;
                    return inputStream;
                }
            }
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
    }

    private void handle_system_exception(SystemException systemException) {
        this._recievedSystemExceptionAny = null;
        this._recievedSystemException = systemException;
        this._recievedExceptionID = SystemExceptionHelper.id(systemException);
        this._replyStatus = 1;
    }

    private void handle_location_forward(Object object, boolean bl) {
        this._forwardReference = object;
        this._forwardReferenceIOR = null;
        this._replyStatus = (short)(bl ? 4 : 3);
    }

    void setReplySource(BufferSource bufferSource) {
        if (this._replySource != null) {
            this._replySource.setException(new MARSHAL("Multiple replies received", 0, CompletionStatus.COMPLETED_YES));
            return;
        }
        this._replySource = bufferSource;
        try {
            this._replySource.addLastMessageProcessedListener(new BufferSource.LastMessageProcessedListener(){

                public void lastMessageProcessed(BufferSource bufferSource) {
                    IIOPClientRequest.this.lastReplyMessage(bufferSource);
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            Trace.assert(false, "Unable to handle too many listeners");
        }
    }

    BufferSource getReplySource() {
        return this._replySource;
    }

    void handle_reply(int n, ServiceContext[] serviceContextArray, InputStream inputStream) {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            this._replyServiceContexts = serviceContextArray;
            this._responseStream = inputStream;
            this._responseArrived = true;
            if (this._operation == null) {
                switch (n) {
                    case 1: {
                        this._replyStatus = (short)-1;
                        break;
                    }
                    case 0: {
                        this._replyStatus = (short)-2;
                        break;
                    }
                    case 4: {
                        this._replyStatus = 1;
                        break;
                    }
                    case 2: {
                        this._replyStatus = (short)3;
                        break;
                    }
                    case 3: {
                        this._replyStatus = (short)4;
                        break;
                    }
                    case 5: {
                        this._replyStatus = (short)5;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        this._replyStatus = 0;
                        break;
                    }
                    case 1: {
                        this._replyStatus = (short)2;
                        break;
                    }
                    case 2: {
                        this._replyStatus = 1;
                        break;
                    }
                    case 3: {
                        this._replyStatus = (short)3;
                        break;
                    }
                    case 4: {
                        this._replyStatus = (short)4;
                        break;
                    }
                    case 5: {
                        this._replyStatus = (short)5;
                    }
                }
            }
            this._syncState.notifyAll();
        }
    }

    private void lastReplyMessage(BufferSource bufferSource) {
        SystemException systemException = bufferSource.getException();
        java.lang.Object object = this._syncState;
        synchronized (object) {
            boolean bl = false;
            this._lastResponseArrived = true;
            if (this._state == 2) {
                if (systemException == null) {
                    return;
                }
                bl = true;
            }
            this._state = 4;
            if (systemException != null) {
                this.handle_system_exception(systemException);
            }
            if (this._clientManager != null) {
                switch (this._replyStatus) {
                    case 0: {
                        this._clientManager.receive_reply(this, this._callback);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this._clientManager.receive_exception(this, this._callback);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this._clientManager.receive_other(this, this._callback);
                        break;
                    }
                    case -2: 
                    case -1: {
                        break;
                    }
                    default: {
                        Trace.assert(false, "invalid state");
                    }
                }
                if (this._replyStatus == 1) {
                    bufferSource.setException(this._recievedSystemException);
                }
            }
            if (bl) {
                this._responseArrived = true;
                this._syncState.notifyAll();
            }
        }
    }

    public short reply_status() {
        if (this._replyStatus == Short.MIN_VALUE) {
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
        return this._replyStatus;
    }

    public ServiceContext get_reply_service_context(int n) {
        if (this._replyServiceContexts == null) {
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
        switch (this._state) {
            case 3: 
            case 4: {
                int n2 = 0;
                while (n2 < this._replyServiceContexts.length) {
                    if (this._replyServiceContexts[n2].context_id == n) {
                        return this._replyServiceContexts[n2];
                    }
                    ++n2;
                }
                throw new BAD_PARAM(83099671, this.state_completion_status());
            }
        }
        throw new BAD_INV_ORDER(83099658, this.state_completion_status());
    }

    public Object forward_reference() {
        switch (this.reply_status()) {
            case 3: 
            case 4: {
                if (this._forwardReference == null) {
                    this._forwardReference = new ObjectStub(this.orb(), this._forwardReferenceIOR);
                }
                return this._forwardReference;
            }
        }
        throw new BAD_INV_ORDER(83099658, this.state_completion_status());
    }

    public IOR forward_reference_ior() {
        switch (this.reply_status()) {
            case 3: 
            case 4: {
                if (this._forwardReferenceIOR == null) {
                    if (this._forwardReference == null || !(this._forwardReference instanceof ObjectImpl)) {
                        throw new INTERNAL("Forward object is unknown type");
                    }
                    Delegate delegate = ((ObjectImpl)this._forwardReference)._get_delegate();
                    if (delegate == null || !(delegate instanceof org.openorb.CORBA.Delegate)) {
                        throw new INTERNAL("Object delegate is unknown type");
                    }
                    this._forwardReferenceIOR = ((org.openorb.CORBA.Delegate)delegate).ior();
                }
                return this._forwardReferenceIOR;
            }
        }
        throw new BAD_INV_ORDER(83099658, this.state_completion_status());
    }

    public SystemException received_system_exception() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this.reply_status() == 1) {
                SystemException systemException = this._recievedSystemException;
                return systemException;
            }
        }
        throw new BAD_INV_ORDER(83099658, this.state_completion_status());
    }

    public Any received_exception() {
        switch (this.reply_status()) {
            case 1: {
                if (this._recievedSystemExceptionAny == null) {
                    this._recievedSystemExceptionAny = this.orb().create_any();
                    SystemExceptionHelper.insert(this._recievedSystemExceptionAny, this._recievedSystemException);
                }
                return this._recievedSystemExceptionAny;
            }
            case 2: {
                throw new NO_RESOURCES(83099649, this.state_completion_status());
            }
        }
        throw new BAD_INV_ORDER(83099658, this.state_completion_status());
    }

    public String received_exception_id() {
        switch (this.reply_status()) {
            case 1: 
            case 2: {
                return this._recievedExceptionID;
            }
        }
        throw new BAD_INV_ORDER(83099658, this.state_completion_status());
    }

    protected void finalize() throws Throwable {
        this.cancel(new TIMEOUT());
    }

    private class IIOPRequestCallback
    implements RequestCallback {
        private IIOPRequestCallback() {
        }

        public void reply_system_exception(SystemException systemException) {
            IIOPClientRequest.this.handle_system_exception(systemException);
        }

        public void reply_location_forward(Object object, boolean bl) {
            IIOPClientRequest.this.handle_location_forward(object, bl);
        }

        public void reply_runtime_exception(RuntimeException runtimeException) {
            UnknownException unknownException = new UnknownException(runtimeException);
            unknownException.completed = IIOPClientRequest.this.state_completion_status();
            IIOPClientRequest.this.handle_system_exception(unknownException);
        }

        public void reply_error(Error error) {
            if (error instanceof ThreadDeath) {
                throw error;
            }
            if (error instanceof OutOfMemoryError) {
                IIOPClientRequest.this.handle_system_exception(new NO_MEMORY());
            } else if (error instanceof StackOverflowError) {
                IIOPClientRequest.this.handle_system_exception(new NO_RESOURCES("Stack Overflow", 1146056983, IIOPClientRequest.this.state_completion_status()));
            } else {
                UnknownException unknownException = new UnknownException(error);
                unknownException.completed = IIOPClientRequest.this.state_completion_status();
                IIOPClientRequest.this.handle_system_exception(unknownException);
            }
        }
    }
}

