/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.GIOP.Version;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.openorb.CORBA.ORB;
import org.openorb.iiop.CDRInputStream;
import org.openorb.iiop.CDROutputStream;
import org.openorb.iiop.HeaderBlock;
import org.openorb.iiop.IIOPClientChannel;
import org.openorb.iiop.IIOPClientProtocol;
import org.openorb.iiop.IIOPServerRequest;
import org.openorb.iiop.SocketQueue;
import org.openorb.io.BufferSource;
import org.openorb.io.MarshalBuffer;
import org.openorb.io.StorageBuffer;
import org.openorb.net.ClientRequest;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerChannel;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerRequest;
import org.openorb.net.Transport;
import org.openorb.util.Trace;

public class IIOPServerChannel
implements ServerChannel {
    private org.omg.CORBA.ORB _orb;
    ServerManager _serverManager;
    SocketQueue _socketQueue;
    Object _syncState;
    int _state = 0;
    boolean _pendClose = false;
    private boolean _codesets = false;
    int _tcsc = 0;
    int _tcsw = 0;
    private IIOPClientProtocol _clientProtocol = null;
    IIOPClientChannel _peer = null;
    private boolean _isDelegated = false;
    Map _activeRequests = new HashMap();
    int _channelAge;
    private Object _syncRecv = new Object();
    private boolean _inRecv = false;
    private Version _version = new Version(1, 2);
    private Constructor _os_ctor;
    private Codec _codec;
    private ListenPoint[] _pendingBidirEndpoints;
    private static final int CONN_SC_TOTAL = 2;
    private static final int CONN_SC_CODESETS = 0;
    private static final int CONN_SC_BIDIR = 1;
    private boolean[] _recvConnSC = new boolean[2];
    private MarshalBuffer.Listener marshallListener = new MarshalListener();
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$GIOP$Version;
    static /* synthetic */ Class class$org$openorb$io$MarshalBuffer;

    IIOPServerChannel(ServerManager serverManager, Transport transport, IIOPClientProtocol iIOPClientProtocol, Codec codec) {
        this._serverManager = serverManager;
        this._orb = this._serverManager.orb();
        try {
            Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPServerChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPServerChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPServerChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this._os_ctor = ((ORB)this._orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", classArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE("Unable to initialize output stream constructor");
        }
        this._socketQueue = new SocketQueue(transport);
        this._socketQueue.setServerChannel(this);
        this._clientProtocol = iIOPClientProtocol;
        this._codec = codec;
        this._syncState = new Object();
        Trace.high(this.toString(), "created");
        this._serverManager.register_channel(this);
    }

    IIOPServerChannel(ServerManager serverManager, IIOPClientChannel iIOPClientChannel, Codec codec) {
        this._serverManager = serverManager;
        this._orb = this._serverManager.orb();
        try {
            Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPServerChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPServerChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPServerChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this._os_ctor = ((ORB)this._orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", classArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE("Unable to initialize output stream constructor");
        }
        this._peer = iIOPClientChannel;
        this._socketQueue = this._peer._socketQueue;
        this._socketQueue.setServerChannel(this);
        this._isDelegated = true;
        this._codec = codec;
        this._syncState = this._peer._syncState;
        this._codesets = true;
        this._tcsc = this._peer._tcsc;
        this._tcsw = this._peer._tcsw;
    }

    public int getTCSC() {
        return this._tcsc;
    }

    public int getTCSW() {
        return this._tcsw;
    }

    public String toString() {
        return "ServerChannel: " + this._socketQueue.toString();
    }

    public org.omg.CORBA.ORB orb() {
        return this._orb;
    }

    public int state() {
        if (this._isDelegated) {
            Object object = this._syncState;
            synchronized (object) {
                if (this._peer != null) {
                    int n = 0;
                    return n;
                }
                int n = 1;
                return n;
            }
        }
        return this._state;
    }

    public int active_requests() {
        Object object = this._syncState;
        synchronized (object) {
            int n = this._activeRequests.size() + (this._peer != null ? this._peer._activeRequests.size() : 0);
            return n;
        }
    }

    public int channel_age() {
        Object object = this._syncState;
        synchronized (object) {
            if (!this._activeRequests.isEmpty() || this._peer != null && !this._peer._activeRequests.isEmpty()) {
                int n = RequestIDAllocator.peek_request_id();
                return n;
            }
            if (this._peer != null && this._channelAge < this._peer._channelAge) {
                int n = this._peer._channelAge;
                return n;
            }
            int n = this._channelAge;
            return n;
        }
    }

    public void close() {
        ClientRequest[] clientRequestArray;
        ServerRequest[] serverRequestArray;
        if (this._isDelegated) {
            this._peer.close(true, new BAD_INV_ORDER(0, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        Object object = this._syncState;
        synchronized (object) {
            if (this._state == 1) {
                return;
            }
            this._state = 1;
            this._pendClose = false;
            serverRequestArray = new ServerRequest[this._activeRequests.values().size()];
            this._activeRequests.values().toArray(serverRequestArray);
            this._activeRequests.clear();
            if (this._peer != null) {
                clientRequestArray = new ClientRequest[this._peer._activeRequests.values().size()];
                this._peer._activeRequests.values().toArray(clientRequestArray);
                this._peer._activeRequests.clear();
                this._peer._state = 0x13000000;
                this._peer._closeException = new BAD_INV_ORDER(0, CompletionStatus.COMPLETED_MAYBE);
                this._peer._peer = null;
                this._peer = null;
            } else {
                clientRequestArray = null;
            }
        }
        this._serverManager.unregister_channel(this);
        this._socketQueue.close();
        int n = 0;
        while (n < serverRequestArray.length) {
            serverRequestArray[n].client_cancel();
            ++n;
        }
        if (clientRequestArray != null) {
            int n2 = 0;
            while (n2 < clientRequestArray.length) {
                clientRequestArray[n2].cancel(new BAD_INV_ORDER("ORB shutdown", 0x4F40004, CompletionStatus.COMPLETED_MAYBE));
                ++n2;
            }
        }
        Trace.high(this.toString(), "closed");
    }

    public void soft_close(boolean bl) {
        if (this._isDelegated) {
            if (!bl) {
                this._peer.pause();
            } else {
                this._peer.close(false, new BAD_INV_ORDER(0x4F40004, CompletionStatus.COMPLETED_NO));
            }
            return;
        }
        Object object = this._syncState;
        synchronized (object) {
            if (this._state == 1) {
                return;
            }
            if (this.active_requests() > 0) {
                if (bl) {
                    this._pendClose = true;
                    if (this._peer != null) {
                        this._peer._pendClose = true;
                    }
                }
                return;
            }
            this._state = 1;
            this._pendClose = false;
            if (this._peer != null) {
                this._peer._state = 0x12000000;
                this._peer._peer = null;
                this._peer = null;
            }
        }
        this._serverManager.unregister_channel(this);
        this._socketQueue.close();
        Trace.high(this.toString(), "closed");
    }

    public void run_send() {
        if (this._isDelegated) {
            return;
        }
        Thread thread = Thread.currentThread();
        while (!Thread.interrupted() && this._socketQueue.send(0) >= 0) {
        }
    }

    public int send(int n) {
        if (this._isDelegated) {
            return -1;
        }
        return this._socketQueue.send(n);
    }

    public int send_pending() {
        if (this._isDelegated) {
            return -1;
        }
        return this._socketQueue.send_pending();
    }

    public boolean recv(int n) {
        boolean bl;
        Object object;
        boolean bl2;
        if (this._isDelegated) {
            return false;
        }
        Object object2 = this._syncRecv;
        synchronized (object2) {
            if (this._inRecv) {
                boolean bl3 = true;
                return bl3;
            }
            this._inRecv = true;
        }
        try {
            if (!this._socketQueue.process_or_enqueue(true, n)) break block14;
            bl2 = true;
            Object var6_7 = null;
            object = this._syncRecv;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Object object3 = this._syncRecv;
            synchronized (object3) {
                this._inRecv = false;
            }
            throw throwable;
        }
        synchronized (object) {
            this._inRecv = false;
        }
        {
            block14: {
                return bl2;
            }
            this.close();
            bl = false;
        }
        Object var6_8 = null;
        Object object4 = this._syncRecv;
        synchronized (object4) {
            this._inRecv = false;
        }
        return bl;
    }

    public void run_recv() {
        Object object;
        if (this._isDelegated) {
            return;
        }
        Object object2 = this._syncRecv;
        synchronized (object2) {
            if (this._inRecv) {
                return;
            }
            this._inRecv = true;
        }
        try {
            Thread thread = Thread.currentThread();
            while (!Thread.interrupted()) {
                if (this._socketQueue.process_or_enqueue(true, 1000)) continue;
                this.close();
                break;
            }
            Object var4_4 = null;
            object = this._syncRecv;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Object object3 = this._syncRecv;
            synchronized (object3) {
                this._inRecv = false;
            }
            throw throwable;
        }
        synchronized (object) {
            this._inRecv = false;
        }
    }

    int process_request(byte by, CDRInputStream cDRInputStream, byte by2, BufferSource bufferSource, Object object) {
        IIOPServerRequest iIOPServerRequest = null;
        int n = 0;
        byte[] byArray = null;
        switch (by2) {
            case 0: {
                switch (by) {
                    case 0: 
                    case 1: {
                        ServiceContext[] serviceContextArray = ServiceContextListHelper.read(cDRInputStream);
                        n = cDRInputStream.read_ulong();
                        byte by3 = cDRInputStream.read_boolean() ? (byte)3 : 2;
                        byArray = OctetSeqHelper.read(cDRInputStream);
                        String string = cDRInputStream.read_string();
                        OctetSeqHelper.read(cDRInputStream);
                        iIOPServerRequest = new IIOPServerRequest(this._serverManager, this, object, n, cDRInputStream, byArray, string, by3, serviceContextArray, new Version(1, by));
                        this.checkConnectionSCs(serviceContextArray);
                        if (this._recvConnSC == null || this._recvConnSC[0]) {
                            cDRInputStream.setCodesets(this._tcsc, this._tcsw);
                        }
                        if (this.addRequest(iIOPServerRequest)) break;
                        return 0;
                    }
                    case 2: {
                        n = cDRInputStream.read_ulong();
                        iIOPServerRequest = new IIOPServerRequest(this._serverManager, this, object, n, cDRInputStream, new Version(1, by));
                        iIOPServerRequest.request_source = bufferSource;
                        if (!this.addRequest(iIOPServerRequest)) {
                            return 0;
                        }
                        byte by4 = cDRInputStream.read_octet();
                        cDRInputStream.skip(3L);
                        byArray = this.read_target_address(cDRInputStream.read_short(), cDRInputStream);
                        String string = cDRInputStream.read_string();
                        ServiceContext[] serviceContextArray = ServiceContextListHelper.read(cDRInputStream);
                        try {
                            cDRInputStream.alignment(8);
                        }
                        catch (SystemException systemException) {
                            // empty catch block
                        }
                        if (!this._isDelegated) {
                            this.checkConnectionSCs(serviceContextArray);
                        }
                        if (this._recvConnSC == null || this._recvConnSC[0]) {
                            cDRInputStream.setCodesets(this._tcsc, this._tcsw);
                        }
                        iIOPServerRequest.init(byArray, string, by4, serviceContextArray);
                    }
                }
                bufferSource.removeWaitingForBufferListener(null);
                Trace.medium(this.toString(), "incoming request #" + n);
                this._serverManager.enqueue_request(iIOPServerRequest);
                break;
            }
            case 3: {
                switch (by) {
                    case 0: 
                    case 1: {
                        n = cDRInputStream.read_ulong();
                        byArray = OctetSeqHelper.read(cDRInputStream);
                        iIOPServerRequest = new IIOPServerRequest(this._serverManager, this, object, n, byArray, new Version(1, by));
                        if (this.addRequest(iIOPServerRequest)) break;
                        return 0;
                    }
                    case 2: {
                        n = cDRInputStream.read_ulong();
                        iIOPServerRequest = new IIOPServerRequest(this._serverManager, this, object, n, new Version(1, by));
                        iIOPServerRequest.request_source = bufferSource;
                        if (!this.addRequest(iIOPServerRequest)) {
                            return 0;
                        }
                        byArray = this.read_target_address(cDRInputStream.read_short(), cDRInputStream);
                        iIOPServerRequest.init(byArray);
                    }
                }
                bufferSource.removeWaitingForBufferListener(null);
                Trace.medium(this.toString(), "incoming locate request #" + n);
                this._serverManager.enqueue_request(iIOPServerRequest);
                break;
            }
            case 2: {
                n = cDRInputStream.read_ulong();
                Object object2 = this._syncState;
                synchronized (object2) {
                    iIOPServerRequest = (IIOPServerRequest)this._activeRequests.remove(new Integer(n));
                }
                if (iIOPServerRequest == null) break;
                Trace.medium(this.toString(), "request #" + n + " canceled by client");
                iIOPServerRequest.client_cancel();
            }
        }
        return n;
    }

    void process_fragment(int n, StorageBuffer storageBuffer, boolean bl, Object object) {
        IIOPServerRequest iIOPServerRequest;
        Object object2 = this._syncState;
        synchronized (object2) {
            iIOPServerRequest = (IIOPServerRequest)this._activeRequests.get(new Integer(n));
        }
        if (iIOPServerRequest != null && iIOPServerRequest.checkRequestTransportAssoc(object)) {
            if (bl) {
                Trace.medium(this.toString(), "request #" + n + " request fragment");
            } else {
                Trace.medium(this.toString(), "request #" + n + " last request fragment");
            }
            iIOPServerRequest.request_source.addLast(storageBuffer, !bl);
        }
    }

    protected void checkConnectionSCs(ServiceContext[] serviceContextArray) {
        if (this._recvConnSC == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        while (n2 < serviceContextArray.length) {
            if (serviceContextArray[n2].context_id == 1) {
                bl2 = true;
                n = n2;
                break;
            }
            ++n2;
        }
        while (n < serviceContextArray.length) {
            switch (serviceContextArray[n].context_id) {
                case 1: {
                    if (this._recvConnSC[0]) break;
                    byte[] byArray = serviceContextArray[n].context_data;
                    if (byArray[0] == 0) {
                        this._tcsc = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
                        this._tcsw = (byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
                    } else {
                        this._tcsc = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
                        this._tcsw = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
                    }
                    if (this._peer != null) {
                        this._peer._tcsc = this._tcsc;
                        this._peer._tcsw = this._tcsw;
                    }
                    this._recvConnSC[0] = true;
                    bl = true;
                    break;
                }
                case 5: {
                    if (this._recvConnSC[1]) break;
                    try {
                        if (this._clientProtocol != null) {
                            Any any = this._codec.decode_value(serviceContextArray[n].context_data, BiDirIIOPServiceContextHelper.type());
                            this._pendingBidirEndpoints = BiDirIIOPServiceContextHelper.extract((Any)any).listen_points;
                        }
                        this._recvConnSC[1] = true;
                        bl = true;
                        break;
                    }
                    catch (UserException userException) {
                        Trace.assert(false, "unexpected exception:" + userException.toString());
                    }
                }
            }
            if (bl2) {
                n = -1;
                bl2 = false;
            }
            ++n;
        }
        if (bl) {
            int n3 = 0;
            while (n3 < this._recvConnSC.length) {
                bl = bl && this._recvConnSC[n3];
                ++n3;
            }
            if (bl) {
                this._recvConnSC = null;
            }
        }
    }

    void checkBiDirActivation(IIOPServerRequest iIOPServerRequest) {
        if (this._pendingBidirEndpoints != null && this._peer == null) {
            BidirectionalPolicy bidirectionalPolicy = null;
            try {
                bidirectionalPolicy = BidirectionalPolicyHelper.narrow(iIOPServerRequest.get_server_policy(37));
            }
            catch (INV_POLICY iNV_POLICY) {
                // empty catch block
            }
            if (bidirectionalPolicy != null && bidirectionalPolicy.value() == 1) {
                Object object = this._syncState;
                synchronized (object) {
                    if (this._state == 0 && this._peer == null) {
                        this._peer = this._clientProtocol.createBidirDelegate(this, this._pendingBidirEndpoints);
                        this._pendingBidirEndpoints = null;
                        if (this._peer != null) {
                            Trace.high(this.toString(), "became bidirectional with peer " + this._peer.toString());
                        }
                    }
                }
            }
        }
    }

    private boolean addRequest(IIOPServerRequest iIOPServerRequest) {
        Object object = this._syncState;
        synchronized (object) {
            if (this._state == 1 || this._pendClose) {
                boolean bl = false;
                return bl;
            }
            this._activeRequests.put(new Integer(iIOPServerRequest.request_id()), iIOPServerRequest);
        }
        return true;
    }

    private byte[] read_target_address(short s, CDRInputStream cDRInputStream) {
        byte[] byArray = null;
        switch (s) {
            case 0: {
                byArray = OctetSeqHelper.read(cDRInputStream);
                break;
            }
            case 1: {
                if (cDRInputStream.read_ulong() != 0) {
                    return null;
                }
                cDRInputStream.begin_encapsulation();
                cDRInputStream.skip(2L);
                cDRInputStream.skip(cDRInputStream.read_long());
                cDRInputStream.skip(2L);
                byArray = OctetSeqHelper.read(cDRInputStream);
                cDRInputStream.end_encapsulation();
                break;
            }
            case 2: {
                int n = cDRInputStream.read_ulong();
                int n2 = cDRInputStream.read_ulong();
                int n3 = 0;
                while (n3 < n2) {
                    if (n3 == n) {
                        byArray = this.read_target_address((short)1, cDRInputStream);
                    } else {
                        cDRInputStream.skip(4L);
                        cDRInputStream.skip(cDRInputStream.read_ulong());
                    }
                    ++n3;
                }
                break;
            }
        }
        return byArray;
    }

    CDROutputStream create_reply_stream(IIOPServerRequest iIOPServerRequest, int n) {
        CDROutputStream cDROutputStream;
        if (!this._socketQueue.isOpen()) {
            throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
        }
        Version version = iIOPServerRequest.version();
        int n2 = iIOPServerRequest.request_id();
        ServiceContext[] serviceContextArray = iIOPServerRequest.get_reply_service_contexts();
        MarshalBuffer marshalBuffer = new MarshalBuffer(this.marshallListener, iIOPServerRequest);
        try {
            Object[] objectArray = new Object[]{this._orb, version, marshalBuffer};
            cDROutputStream = (CDROutputStream)this._os_ctor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new INITIALIZE("Unable to create CDROutputStream class");
        }
        if (this._recvConnSC == null || this._recvConnSC[0]) {
            cDROutputStream.setCodesets(this._tcsc, this._tcsw);
        }
        new HeaderBlock(1, n2, cDROutputStream);
        switch (version.minor) {
            case 0: 
            case 1: {
                ServiceContextListHelper.write(cDROutputStream, serviceContextArray);
                cDROutputStream.write_ulong(n2);
                cDROutputStream.write_ulong(n);
                break;
            }
            case 2: {
                cDROutputStream.write_ulong(n2);
                cDROutputStream.allowFragment();
                cDROutputStream.write_ulong(n);
                ServiceContextListHelper.write(cDROutputStream, serviceContextArray);
                cDROutputStream.pending_alignment(8);
            }
        }
        Trace.medium(this.toString(), "request #" + n2 + " reply stream created. Reply status: " + n);
        return cDROutputStream;
    }

    CDROutputStream create_locate_reply_stream(IIOPServerRequest iIOPServerRequest, int n) {
        CDROutputStream cDROutputStream;
        if (!this._socketQueue.isOpen()) {
            throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
        }
        Version version = iIOPServerRequest.version();
        int n2 = iIOPServerRequest.request_id();
        MarshalBuffer marshalBuffer = new MarshalBuffer(this.marshallListener, iIOPServerRequest);
        try {
            Object[] objectArray = new Object[]{this._orb, version, marshalBuffer};
            cDROutputStream = (CDROutputStream)this._os_ctor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new INITIALIZE("Unable to create CDROutputStream class");
        }
        new HeaderBlock(4, n2, cDROutputStream);
        cDROutputStream.write_ulong(n2);
        if (version.minor == 2) {
            cDROutputStream.allowFragment();
        }
        cDROutputStream.write_ulong(n);
        Trace.medium(this.toString(), "request #" + n2 + " locate reply stream created. Reply status: " + n);
        return cDROutputStream;
    }

    void release_request(IIOPServerRequest iIOPServerRequest) {
        Object object = this._syncState;
        synchronized (object) {
            int n = iIOPServerRequest.request_id();
            this._activeRequests.remove(new Integer(n));
            Trace.medium(this.toString(), "request #" + n + " completed");
            if (!this._activeRequests.isEmpty()) {
                return;
            }
            this._channelAge = RequestIDAllocator.peek_request_id();
        }
        if (this._pendClose) {
            this.soft_close(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MarshalListener
    implements MarshalBuffer.Listener {
        private MarshalListener() {
        }

        public void availIncreaced(MarshalBuffer marshalBuffer, int n, Object object) {
            if (n > 120000) {
                IIOPServerRequest iIOPServerRequest = (IIOPServerRequest)object;
                if (!IIOPServerChannel.this._socketQueue.enqueue(marshalBuffer.fragment(120000), iIOPServerRequest.get_transport_association())) {
                    throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
                }
                Trace.medium(IIOPServerChannel.this.toString(), "request #" + iIOPServerRequest.request_id() + " last fragment sent");
            }
        }

        public void bufferClosed(MarshalBuffer marshalBuffer, int n, Object object) {
            IIOPServerRequest iIOPServerRequest;
            StorageBuffer storageBuffer = marshalBuffer.lastFragment();
            if (!IIOPServerChannel.this._socketQueue.enqueue(storageBuffer, (iIOPServerRequest = (IIOPServerRequest)object).get_transport_association())) {
                throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
            }
            Trace.medium(IIOPServerChannel.this.toString(), "request #" + iIOPServerRequest.request_id() + " last fragment sent");
        }

        public void bufferCanceled(MarshalBuffer marshalBuffer, SystemException systemException, Object object) {
            systemException.completed = CompletionStatus.COMPLETED_YES;
            throw systemException;
        }
    }
}

