/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedProfile;
import org.openorb.PI.ComponentSet;
import org.openorb.iiop.CDRCodecFactory;
import org.openorb.iiop.IIOPClientProtocol;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPTransportServerInitializer;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerProtocol;
import org.openorb.net.Transport;
import org.openorb.util.Trace;

public class IIOPServerProtocol
implements ServerProtocol {
    private ServerManager _serverManager;
    private ListenPoint _primaryEndpoint;
    private Codec _codec;
    private ORB _orb;
    private IIOPClientProtocol _clientProtocol = null;
    private Object _syncState = new Object();
    private int _state = 2;
    private IIOPTransportServerInitializer _trans;

    public IIOPServerProtocol(ServerManager serverManager, CDRCodecFactory cDRCodecFactory, IIOPTransportServerInitializer iIOPTransportServerInitializer) {
        this._serverManager = serverManager;
        try {
            this._codec = cDRCodecFactory.create_codec(new Encoding(0, 1, 2));
        }
        catch (UnknownEncoding unknownEncoding) {
            Trace.assert(false, "Could not find codec");
        }
        this._trans = iIOPTransportServerInitializer;
        this._orb = this._serverManager.orb();
        this._state = 2;
        this._primaryEndpoint = this._trans.getPrimaryEndpoint();
        Trace.high(this.toString(), "created");
    }

    public String toString() {
        return "ServerProtocol: " + this._trans.toString();
    }

    void setClientProtocol(IIOPClientProtocol iIOPClientProtocol) {
        this._clientProtocol = iIOPClientProtocol;
    }

    public ORB orb() {
        return this._orb;
    }

    public ServerManager getServerManager() {
        return this._serverManager;
    }

    public boolean servesAddress(String string, int n) {
        if ((this._primaryEndpoint.port & 0xFFFF) == n && string.equals(this._primaryEndpoint.host)) {
            return true;
        }
        ListenPoint[] listenPointArray = this._trans.getBiDirEndpoints();
        if (listenPointArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < listenPointArray.length) {
            if ((listenPointArray[n2].port & 0xFFFF) == n && string.equals(listenPointArray[n2].host)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int state() {
        return this._state;
    }

    public boolean open() {
        Object object = this._syncState;
        synchronized (object) {
            switch (this._state) {
                case 1: {
                    this._state = 0;
                    this._syncState.notifyAll();
                    break;
                }
                case 2: {
                    try {
                        this._trans.open();
                    }
                    catch (SystemException systemException) {
                        boolean bl = false;
                        return bl;
                    }
                    this._primaryEndpoint = this._trans.getPrimaryEndpoint();
                    this._state = 0;
                    this._serverManager.protocol_listening(this);
                }
            }
            Trace.high(this.toString(), "listening");
            boolean bl = true;
            return bl;
        }
    }

    public boolean pause() {
        Object object = this._syncState;
        synchronized (object) {
            if (this._state != 2) {
                this._serverManager.protocol_not_listening(this, true);
                this._state = 1;
                Trace.high(this.toString(), "paused");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void close() {
        Object object = this._syncState;
        synchronized (object) {
            if (this._state == 2) {
                return;
            }
            this._serverManager.protocol_not_listening(this, false);
            this._state = 2;
            this._trans.close();
            Trace.high(this.toString(), "closed");
        }
    }

    public void listen(int n) {
        Transport transport = null;
        if (this._state != 0) {
            return;
        }
        try {
            transport = this._trans.accept(n);
        }
        catch (SystemException systemException) {
            System.out.println("Fatal error while accepting connection.");
            System.out.println(systemException);
            System.exit(1);
        }
        if (transport != null) {
            new IIOPServerChannel(this._serverManager, transport, this._clientProtocol, this._codec);
        }
    }

    public void run_listen() {
        Thread thread = Thread.currentThread();
        while (!thread.isInterrupted() && this._state == 0) {
            this.listen(0);
        }
    }

    public TaggedProfile create_profile(int n, ComponentSet componentSet, byte[] byArray) {
        if (n != 0) {
            return null;
        }
        ProfileBody_1_1 profileBody_1_1 = new ProfileBody_1_1();
        profileBody_1_1.iiop_version = new Version(1, 2);
        profileBody_1_1.host = this._primaryEndpoint.host;
        profileBody_1_1.port = this._primaryEndpoint.port;
        profileBody_1_1.object_key = byArray;
        profileBody_1_1.components = componentSet.getComponents(n);
        Any any = this._orb.create_any();
        ProfileBody_1_1Helper.insert(any, profileBody_1_1);
        try {
            return new TaggedProfile(n, this._codec.encode_value(any));
        }
        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
            Trace.assert(false, invalidTypeForEncoding.toString());
            return null;
        }
    }
}

