/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.openorb.io.StorageBuffer;
import org.openorb.net.Address;
import org.openorb.net.Transport;
import org.openorb.net.TransportAssociationHolder;

public class IIOPTransport
implements Transport {
    private InetAddress _host = null;
    private int _port = -1;
    private String _connString;
    private Socket _sock;
    private InputStream _is;
    private OutputStream _os;
    private byte[] _header = null;
    private boolean _msgError = false;
    private boolean _remoteClose = false;
    private int _minorVersion = 0;
    private boolean _open = false;
    private static final byte[][] MESSAGE_ERROR = new byte[][]{{71, 73, 79, 80, 1, 0, 0, 6, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 1, 0, 6, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 2, 0, 6, 0, 0, 0, 0}};
    private static final byte[][] CLOSE_CONNECTION = new byte[][]{{71, 73, 79, 80, 1, 0, 0, 5, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 1, 0, 5, 0, 0, 0, 0}, {71, 73, 79, 80, 1, 2, 0, 5, 0, 0, 0, 0}};
    private static final long MAX_CLOSE_LINGER = 1000L;

    public IIOPTransport(InetAddress inetAddress, int n) {
        this._host = inetAddress;
        this._port = n;
        this._connString = this._host.getHostName() + ":" + this._port;
    }

    public IIOPTransport(Socket socket, int n) {
        this._sock = socket;
        this._port = n;
        try {
            this._is = this._sock.getInputStream();
            this._os = this._sock.getOutputStream();
        }
        catch (IOException iOException) {
            this._sock = null;
            throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
        }
        this._open = true;
        this._connString = n + " (" + this._sock.getLocalPort() + " <- " + this._sock.getInetAddress().getHostName() + ":" + this._sock.getPort() + ")";
    }

    public void open() {
        if (this._host == null) {
            throw new BAD_INV_ORDER();
        }
        if (this._open) {
            return;
        }
        this._msgError = false;
        this._remoteClose = false;
        try {
            this._sock = this.createSocket(this._host, this._port);
            this._is = this._sock.getInputStream();
            this._os = this._sock.getOutputStream();
        }
        catch (NoRouteToHostException noRouteToHostException) {
            throw new COMM_FAILURE(1146056969, CompletionStatus.COMPLETED_NO);
        }
        catch (ConnectException connectException) {
            throw new COMM_FAILURE(1146056970, CompletionStatus.COMPLETED_NO);
        }
        catch (IOException iOException) {
            throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
        }
        this._open = true;
        this._connString = this._host.getHostName() + ":" + this._port + " (" + this._sock.getLocalPort() + " -> " + this._sock.getPort() + ")";
    }

    protected Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return new Socket(inetAddress, n);
    }

    public void close() {
        if (this._open) {
            boolean bl = Thread.interrupted();
            if (!this._remoteClose) {
                try {
                    this.writeCloseMessage();
                    try {
                        this._sock.getClass().getMethod("shutdownOutput", null).invoke((Object)this._sock, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this._msgError || this._minorVersion == 2 || this._host == null) {
                        StorageBuffer storageBuffer;
                        TransportAssociationHolder transportAssociationHolder = new TransportAssociationHolder();
                        do {
                            transportAssociationHolder.value = null;
                            storageBuffer = this.recvMessage(1000, transportAssociationHolder);
                            boolean bl2 = bl = Thread.interrupted() || bl;
                        } while (storageBuffer != null);
                    }
                }
                catch (SystemException systemException) {
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            this._open = false;
            try {
                this._sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            this._connString = this._host != null ? this._host.getHostName() + ":" + this._port : Integer.toString(this._port);
        }
    }

    protected void writeCloseMessage() {
        if (this._msgError) {
            this.write(MESSAGE_ERROR[this._minorVersion], 0, 12);
        } else if (this._minorVersion == 2 || this._host == null) {
            this.write(CLOSE_CONNECTION[this._minorVersion], 0, 12);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void sendMessage(StorageBuffer storageBuffer, Object object) {
        if (!this._open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            storageBuffer.writeTo(this._os);
        }
        catch (IOException iOException) {
            throw new COMM_FAILURE();
        }
    }

    protected void write(byte[] byArray, int n, int n2) {
        InterruptedIOException interruptedIOException2;
        boolean bl = Thread.interrupted();
        do {
            try {
                this._os.write(byArray, n, n2);
                break;
            }
            catch (InterruptedIOException interruptedIOException2) {
                bl = true;
                n += interruptedIOException2.bytesTransferred;
            }
            catch (IOException iOException) {
                throw new COMM_FAILURE();
            }
        } while ((n2 -= interruptedIOException2.bytesTransferred) > 0);
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    public StorageBuffer recvMessage(int n, TransportAssociationHolder transportAssociationHolder) throws EOFException {
        Thread thread;
        if (!this._open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        if (this._header == null) {
            this._header = new byte[12];
        }
        if (transportAssociationHolder.value == null) {
            transportAssociationHolder.value = TransportAssociationHolder.EMPTY_ASSOCIATION;
        }
        if ((thread = Thread.currentThread()).isInterrupted()) {
            return null;
        }
        if (!this.readMagic(n, this._header, 0)) {
            return null;
        }
        boolean bl = Thread.interrupted();
        this.read(this._header, 4, 8);
        int n2 = this.checkGIOPHeader(this._header, 0);
        bl = bl || Thread.interrupted();
        StorageBuffer storageBuffer = this.readBuffer(this._header, 0, 12, n2 + 12);
        if (bl) {
            thread.interrupt();
        }
        return storageBuffer;
    }

    public void setMessageError() {
        this._msgError = true;
    }

    public boolean isMessageError() {
        return this._msgError;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean readMagic(int var1_1, byte[] var2_2, int var3_3) throws EOFException {
        block31: {
            if (!this._open) {
                throw new COMM_FAILURE("Transport is closed");
            }
            try {
                block28: {
                    var5_4 = false;
                    try {
                        if (var1_1 > 0) {
                            this._sock.setSoTimeout(var1_1);
                        }
                        var4_6 = this._is.read(var2_2, var3_3, 4);
                        var10_7 = null;
                        ** if (var1_1 <= 0) goto lbl-1000
                    }
                    catch (Throwable var9_20) {
                        var10_10 = null;
                        if (var1_1 > 0) {
                            try {
                                this._sock.setSoTimeout(0);
                            }
                            catch (IOException var11_14) {
                                // empty catch block
                            }
                        }
                        throw var9_20;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this._sock.setSoTimeout(0);
                        }
                        catch (IOException var11_11) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block28;
                        catch (InterruptedIOException var6_15) {
                            if (var1_1 > 0 && var6_15.getMessage().equals("Read timed out")) {
                                var7_17 = false;
                                var10_8 = null;
                                if (var1_1 > 0) {
                                    try {
                                        this._sock.setSoTimeout(0);
                                    }
                                    catch (IOException var11_12) {
                                        // empty catch block
                                    }
                                }
                                return var7_17;
                            }
                            var4_6 = var6_15.bytesTransferred;
                            if (var4_6 == 0) {
                                Thread.currentThread().interrupt();
                                var8_19 = false;
                                var10_9 = null;
                                if (var1_1 > 0) {
                                    try {
                                        this._sock.setSoTimeout(0);
                                    }
                                    catch (IOException var11_13) {
                                        // empty catch block
                                    }
                                }
                                return var8_19;
                            }
                            var5_4 = true;
                            var10_7 = null;
                            if (var1_1 > 0) {
                                try {
                                    this._sock.setSoTimeout(0);
                                }
                                catch (IOException var11_11) {}
                            }
                        }
                    }
                }
                if (var4_6 == 0) {
                    return false;
                }
                if (var4_6 == 4) {
                    return true;
                }
                if (var4_6 <= 0) break block31;
                var6_16 = var4_6;
                while (var6_16 < 4) {
                    try {
                        var4_6 = this._is.read(var2_2, var3_3 + var6_16, 4 - var6_16);
                        if (var4_6 < 0) {
                            throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
                        }
                    }
                    catch (InterruptedIOException var7_18) {
                        var4_6 = var7_18.bytesTransferred;
                        var5_4 = true;
                    }
                    var6_16 += var4_6;
                }
                if (var5_4) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            catch (IOException var5_5) {
                throw new COMM_FAILURE(var5_5.toString(), 1146056972, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        throw new EOFException();
    }

    protected int checkGIOPHeader(byte[] byArray, int n) throws EOFException {
        if (byArray[n + 0] != 71 || byArray[n + 1] != 73 || byArray[n + 2] != 79 || byArray[n + 3] != 80 || byArray[n + 4] != 1 || byArray[n + 5] > 2) {
            this._msgError = true;
            throw new COMM_FAILURE("Bad magic", 1146056974, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this._minorVersion < byArray[n + 5]) {
            this._minorVersion = byArray[n + 5];
        }
        switch (byArray[n + 7]) {
            case 5: {
                this._remoteClose = true;
                throw new EOFException();
            }
            case 6: {
                this._remoteClose = true;
                throw new COMM_FAILURE("Message Error recieved from remote", 1146056974, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        boolean bl = (byArray[n + 6] & 1) == 1;
        return (byArray[n + 8] & 0xFF) << (bl ? 0 : 24) | (byArray[n + 9] & 0xFF) << (bl ? 8 : 16) | (byArray[n + 10] & 0xFF) << (bl ? 16 : 8) | (byArray[n + 11] & 0xFF) << (bl ? 24 : 0);
    }

    protected final void read(byte[] byArray, int n, int n2) {
        if (!this._open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            boolean bl = false;
            while (n2 > 0) {
                int n3;
                try {
                    n3 = this._is.read(byArray, n, n2);
                    if (n3 < 0) {
                        throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = true;
                    n3 = interruptedIOException.bytesTransferred;
                }
                n += n3;
                n2 -= n3;
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException iOException) {
            throw new COMM_FAILURE(iOException.toString(), 1146056972, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected StorageBuffer readBuffer(byte[] byArray, int n, int n2, int n3) {
        if (!this._open) {
            throw new COMM_FAILURE("Transport is closed");
        }
        try {
            return new StorageBuffer(byArray, n, n2, this._is, n3);
        }
        catch (EOFException eOFException) {
            throw new COMM_FAILURE("Unexpected end of stream", 1146056973, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (IOException iOException) {
            throw new COMM_FAILURE(iOException.toString(), 1146056972, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public boolean establishAssociation(Address address, TransportAssociationHolder transportAssociationHolder) {
        transportAssociationHolder.value = TransportAssociationHolder.EMPTY_ASSOCIATION;
        return true;
    }

    public String toString() {
        return "(iiop) " + this.getConnString();
    }

    protected String getConnString() {
        return this._connString;
    }
}

