/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.IIOP.ListenPoint;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.iiop.IIOPTransport;
import org.openorb.net.Transport;
import org.openorb.net.TransportServerInitializer;

public class IIOPTransportServerInitializer
implements TransportServerInitializer {
    private ListenPoint _primaryEndpoint = new ListenPoint();
    private ListenPoint[] _biDirEndpoints = new ListenPoint[]{this._primaryEndpoint};
    private InetAddress _host;
    private ServerSocket _svrSocket;
    private boolean _closed = true;
    private static final int MAX_TIMEOUT = 250;

    public IIOPTransportServerInitializer(ORBInitInfo oRBInitInfo, FeatureInitInfo featureInitInfo) {
        int n;
        ORBLoader oRBLoader = featureInitInfo.getLoader();
        this._primaryEndpoint.host = oRBLoader.getStringProperty("iiop.hostname", "");
        if (this._primaryEndpoint.host.length() == 0) {
            try {
                String string = oRBLoader.getStringProperty("iiop.publishIP", "auto");
                if (string.equalsIgnoreCase("auto")) {
                    this._primaryEndpoint.host = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                    if (this._primaryEndpoint.host.indexOf(46) < 0) {
                        this._primaryEndpoint.host = InetAddress.getLocalHost().getHostAddress();
                    }
                } else {
                    this._primaryEndpoint.host = string.equalsIgnoreCase("true") ? InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName() : InetAddress.getLocalHost().getHostAddress();
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new INITIALIZE("Unable to find hostname for local host", 0, CompletionStatus.COMPLETED_NO);
            }
        }
        if ((n = oRBLoader.getIntProperty("iiop.port", 0)) > 65535 || n < 0) {
            throw new INITIALIZE("Value for server port " + n + " is out of range");
        }
        this._primaryEndpoint.port = (short)n;
        try {
            this._host = InetAddress.getByName(oRBLoader.getStringProperty("iiop.listenAddress", "0.0.0.0"));
        }
        catch (UnknownHostException unknownHostException) {
            throw new INITIALIZE("Unable to find address for local listen port", 0, CompletionStatus.COMPLETED_NO);
        }
    }

    public void open() {
        if (this._svrSocket != null) {
            return;
        }
        this.open_port();
    }

    private void open_port() {
        try {
            int n = this._primaryEndpoint.port & 0xFFFF;
            this._svrSocket = new ServerSocket(n, 50, this._host);
        }
        catch (IOException iOException) {
            throw new COMM_FAILURE("Unable to listen on " + this.svrString());
        }
        catch (SecurityException securityException) {
            throw new NO_PERMISSION("Access denied for " + this.svrString());
        }
        this._closed = false;
        if (this._primaryEndpoint.port == 0) {
            this._primaryEndpoint.port = (short)this._svrSocket.getLocalPort();
        }
    }

    public ListenPoint getPrimaryEndpoint() {
        return this._primaryEndpoint;
    }

    public ListenPoint[] getBiDirEndpoints() {
        return this._biDirEndpoints;
    }

    protected InetAddress getListenHost() {
        return this._host;
    }

    public void close() {
        if (this._closed || this._svrSocket == null) {
            return;
        }
        this._closed = true;
        try {
            this._svrSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._svrSocket = null;
    }

    public boolean isOpen() {
        return !this._closed;
    }

    public Transport accept(int n) {
        try {
            Socket socket;
            if (n <= 0 || n > 250) {
                n = 250;
            }
            this._svrSocket.setSoTimeout(n);
            try {
                socket = this._svrSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                return null;
            }
            return new IIOPTransport(socket, this._primaryEndpoint.port & 0xFFFF);
        }
        catch (IOException iOException) {
            if (this._closed) {
                return null;
            }
            throw new COMM_FAILURE();
        }
    }

    public String toString() {
        return "(iiop) " + this.svrString();
    }

    protected String svrString() {
        return this._host.getHostAddress() + ":" + (this._primaryEndpoint.port & 0xFFFF);
    }
}

