/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.IOException;
import java.math.BigDecimal;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA_2_3.portable.InputStream;
import org.openorb.io.BufferSource;
import org.openorb.io.ExtendedInputStream;
import org.openorb.io.StorageBuffer;
import org.openorb.util.Trace;

public abstract class AbstractInputStream
extends InputStream
implements ExtendedInputStream {
    private StorageBuffer currbuf;
    private BufferSource source = null;
    private int overread = 0;
    private SystemException cancelException = null;

    public AbstractInputStream(StorageBuffer storageBuffer) {
        this.currbuf = storageBuffer;
        this.source = this.source;
    }

    public AbstractInputStream(BufferSource bufferSource) {
        this.currbuf = bufferSource.next();
        this.source = bufferSource;
    }

    public String get_codebase() {
        return null;
    }

    public int read() throws IOException {
        if (this.overread > 0) {
            return -1;
        }
        if (this.cancelException != null) {
            throw this.cancelException;
        }
        try {
            return this.read_octet();
        }
        catch (MARSHAL mARSHAL) {
            if (this.overread > 0) {
                return -1;
            }
            throw mARSHAL;
        }
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.overread > 0) {
            return -1;
        }
        if (this.cancelException != null) {
            throw this.cancelException;
        }
        try {
            this.read_octet_array(byArray, n, n2);
            return n2;
        }
        catch (MARSHAL mARSHAL) {
            if (this.overread > 0) {
                int n3 = n2 - this.overread;
                return n3 == 0 ? -1 : n3;
            }
            throw mARSHAL;
        }
    }

    protected void force_skip(int n) {
        if ((n = (int)((long)n - this.skip(n))) != 0) {
            this.overread = n;
            throw new MARSHAL("Buffer overread by " + n + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected void cancel(SystemException systemException) {
        if (this.source == null) {
            this.cancelException = systemException;
            throw this.cancelException;
        }
        this.source.setException(systemException);
        try {
            this.source.next();
        }
        catch (SystemException systemException2) {
            this.cancelException = systemException2;
            throw systemException2;
        }
        Trace.assert(false, "Invalid state");
    }

    public int available() {
        return this.currbuf.available() + (this.source != null ? this.source.available() : 0);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        if (this.source != null) {
            this.source.mark();
        } else {
            this.currbuf.mark();
        }
    }

    public void reset() throws IOException {
        if (this.source != null) {
            StorageBuffer storageBuffer = this.source.reset();
            if (storageBuffer == null) {
                throw new IOException("No marked position to reset to");
            }
            this.currbuf = storageBuffer;
        } else if (!this.currbuf.reset()) {
            throw new IOException("No marked position to reset to");
        }
        this.overread = 0;
    }

    /*
     * Unable to fully structure code
     */
    public long skip(long var1_1) {
        block8: {
            block7: {
                if (this.cancelException != null) {
                    throw this.cancelException;
                }
                var3_2 = var1_1;
                if (this.source == null) break block7;
                if (this.currbuf != null) ** GOTO lbl16
                return 0L;
lbl-1000:
                // 1 sources

                {
                    var1_1 -= (long)this.currbuf.available();
                    try {
                        this.currbuf = this.source.next();
                    }
                    catch (SystemException var5_3) {
                        this.cancelException = var5_3;
                        throw var5_3;
                    }
                    if (this.currbuf != null) continue;
                    return var3_2 - var1_1;
lbl16:
                    // 2 sources

                    ** while (var1_1 > (long)this.currbuf.available())
                }
lbl17:
                // 1 sources

                var5_4 = new IntHolder((int)var1_1);
                var1_1 -= (long)this.currbuf.skip(var5_4);
                if (this.currbuf.available() == 0) {
                    try {
                        this.currbuf = this.source.next();
                    }
                    catch (SystemException var6_6) {
                        this.cancelException = var6_6;
                        throw var6_6;
                    }
                }
                break block8;
            }
            var5_5 = new IntHolder((int)var1_1);
            var1_1 -= (long)this.currbuf.skip(var5_5);
        }
        return var3_2 - var1_1;
    }

    protected int next(OctetSeqHolder octetSeqHolder, IntHolder intHolder, IntHolder intHolder2) {
        if (this.cancelException != null) {
            throw this.cancelException;
        }
        if (intHolder2.value == 0) {
            return 0;
        }
        if (this.currbuf == null) {
            this.overread = intHolder2.value;
            throw new MARSHAL("Buffer overread by " + intHolder2.value + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
        }
        int n = this.currbuf.next(octetSeqHolder, intHolder, intHolder2);
        if (this.currbuf.available() == 0) {
            if (this.source != null) {
                try {
                    this.currbuf = this.source.next();
                }
                catch (SystemException systemException) {
                    this.cancelException = systemException;
                    throw systemException;
                }
            } else if (n < 0) {
                this.overread = intHolder2.value;
                throw new MARSHAL("Buffer overread by " + intHolder2.value + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return n;
    }

    public abstract BigDecimal read_fixed(short var1, short var2);

    public abstract BigDecimal read_fixed(TypeCode var1);
}

