/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.util.EventListener;
import java.util.LinkedList;
import java.util.TooManyListenersException;
import org.omg.CORBA.SystemException;
import org.openorb.io.StorageBuffer;
import org.openorb.util.Trace;

public class BufferSource {
    private int _avail = 0;
    private LinkedList _buffers = new LinkedList();
    private SystemException _exception = null;
    private boolean _lastReceived = false;
    private boolean _lastNotified = false;
    private int _markAvail = -1;
    private LinkedList _prev;
    private StorageBuffer _curr;
    private transient WaitingForBufferListener _waitingForBufferListener = null;
    private transient LastMessageProcessedListener _lastMessageProcessedListener = null;

    public BufferSource() {
    }

    public BufferSource(StorageBuffer storageBuffer, boolean bl) {
        this._buffers.addLast(storageBuffer);
        this._lastReceived = bl;
        this._avail += storageBuffer.available();
    }

    public synchronized int available() {
        return this._avail;
    }

    public synchronized StorageBuffer next() {
        while (true) {
            if (this._exception != null) {
                this.lastMessageProcessed();
                throw this._exception;
            }
            if (this._buffers.size() > 0) {
                StorageBuffer storageBuffer = (StorageBuffer)this._buffers.removeFirst();
                this._avail -= storageBuffer.available();
                if (this._markAvail >= 0) {
                    this._prev.addLast(this._curr);
                    storageBuffer.mark();
                }
                this._curr = storageBuffer;
                return storageBuffer;
            }
            if (this._lastReceived) {
                this.lastMessageProcessed();
                return null;
            }
            this.waitingForBuffer();
        }
    }

    public synchronized void mark() {
        if (this._prev == null) {
            this._prev = new LinkedList();
        } else {
            this._prev.clear();
        }
        this._curr.mark();
        this._markAvail = this._avail;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized StorageBuffer reset() {
        if (this._markAvail != -1) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            Trace.assert(this._curr.reset(), "Unable to reset body buffer");
            this._buffers.addFirst(this._curr);
            this._curr = (StorageBuffer)this._prev.removeLast();
lbl6:
            // 2 sources

            ** while (!this._prev.isEmpty())
        }
lbl7:
        // 1 sources

        Trace.assert(this._curr.reset(), "Unable to reset head buffer");
        this._avail = this._markAvail;
        this._markAvail = -1;
        return this._curr;
    }

    private void waitingForBuffer() {
        if (this._waitingForBufferListener != null && !this._waitingForBufferListener.waitForBuffer(this)) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void lastMessageProcessed() {
        if (!this._lastNotified && this._lastMessageProcessedListener != null) {
            this._lastNotified = true;
            this._lastMessageProcessedListener.lastMessageProcessed(this);
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public synchronized void setException(SystemException systemException) {
        if (systemException == null) {
            throw new NullPointerException();
        }
        this._exception = systemException;
        this._buffers = null;
        this.notify();
    }

    public synchronized SystemException getException() {
        return this._exception;
    }

    public synchronized void addLast(StorageBuffer storageBuffer, boolean bl) {
        if (this._exception != null) {
            return;
        }
        this._buffers.addLast(storageBuffer);
        this._lastReceived = bl;
        this._avail += storageBuffer.available();
        this.notify();
    }

    public synchronized void addWaitingForBufferListener(WaitingForBufferListener waitingForBufferListener) throws TooManyListenersException {
        if (this._waitingForBufferListener != null) {
            throw new TooManyListenersException();
        }
        this._waitingForBufferListener = waitingForBufferListener;
    }

    public synchronized void removeWaitingForBufferListener(WaitingForBufferListener waitingForBufferListener) {
        this._waitingForBufferListener = null;
    }

    public synchronized void addLastMessageProcessedListener(LastMessageProcessedListener lastMessageProcessedListener) throws TooManyListenersException {
        if (this._lastMessageProcessedListener != null) {
            throw new TooManyListenersException();
        }
        this._lastMessageProcessedListener = lastMessageProcessedListener;
    }

    public synchronized void removeLastMessageProcessedListener(LastMessageProcessedListener lastMessageProcessedListener) {
        this._lastMessageProcessedListener = null;
    }

    public static interface LastMessageProcessedListener
    extends EventListener {
        public void lastMessageProcessed(BufferSource var1);
    }

    public static interface WaitingForBufferListener
    extends EventListener {
        public boolean waitForBuffer(BufferSource var1);
    }
}

