/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HexPrintStream
extends FilterOutputStream {
    public static final int FORMAT_SIMPLE = 0;
    public static final int FORMAT_HEXONLY = 1;
    public static final int FORMAT_MIXED = 2;
    public static final int FORMAT_MIXED_TWOLINE = 3;
    private byte[] store = null;
    private int stoff = 0;
    private int format;
    private byte[] hexbuf = null;
    private static final byte[] endline = System.getProperty("line.separator").getBytes();

    public HexPrintStream(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public HexPrintStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.setFormat(n);
    }

    public void write(int n) throws IOException {
        if (this.store == null) {
            this.store = new byte[0];
            this.store[0] = (byte)n;
            this.stoff = 1;
            this.flush();
            this.store = null;
        } else {
            this.store[++this.stoff] = (byte)n;
            if (this.stoff >= this.store.length) {
                this.flush();
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.store == null) {
            if (n == 0) {
                this.store = byArray;
            } else {
                this.store = new byte[n2];
                System.arraycopy(byArray, n, this.store, 0, n2);
            }
            this.stoff = n2;
            this.flush();
            this.store = null;
            return;
        }
        if (n2 < this.store.length - this.stoff) {
            System.arraycopy(byArray, n, this.store, this.stoff, n2);
            this.stoff += n2;
            return;
        }
        if (this.stoff > 0) {
            System.arraycopy(byArray, n, this.store, this.stoff, this.store.length - this.stoff);
            n += this.store.length - this.stoff;
            n2 -= this.store.length - this.stoff;
            this.stoff = this.store.length;
            this.flush();
        }
        while (n2 >= this.store.length) {
            System.arraycopy(byArray, n, this.store, 0, this.store.length);
            n += this.store.length;
            n2 -= this.store.length;
            this.stoff = this.store.length;
            this.flush();
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.store, 0, n2);
            this.stoff = n2;
        }
    }

    public void flush() throws IOException {
        int n;
        int n2;
        if (this.stoff == 0) {
            return;
        }
        if (this.hexbuf == null || this.hexbuf.length < this.stoff * 2) {
            this.hexbuf = new byte[this.stoff * 2];
        }
        int n3 = 0;
        while (n3 < this.stoff) {
            n2 = this.store[n3] & 0xF;
            n = this.store[n3] >>> 4 & 0xF;
            this.hexbuf[n3 * 2] = n < 10 ? (byte)(48 + n) : (byte)(65 + n - 10);
            this.hexbuf[n3 * 2 + 1] = n2 < 10 ? (byte)(48 + n2) : (byte)(65 + n2 - 10);
            ++n3;
        }
        switch (this.format) {
            case 0: {
                this.out.write(this.hexbuf, 0, 2 * this.stoff);
                break;
            }
            case 2: {
                n2 = 0;
                while (n2 < this.stoff) {
                    if (Character.isISOControl((char)(this.store[n2] & 0x7F))) {
                        this.store[n2] = 46;
                    }
                    ++n2;
                }
                n = this.stoff;
                while (n < this.store.length) {
                    this.store[n] = 32;
                    ++n;
                }
                this.out.write(this.store, 0, 8);
                this.out.write(32);
                this.out.write(this.store, 8, 8);
                this.out.write(32);
                this.out.write(32);
            }
            case 1: {
                int n4 = 0;
                while (n4 < this.stoff - 3) {
                    this.out.write(this.hexbuf, n4 * 2, 8);
                    this.out.write(32);
                    n4 += 4;
                }
                if (this.stoff % 4 != 0) {
                    this.out.write(this.hexbuf, this.stoff / 4 * 8, this.stoff % 4 * 2);
                }
                this.out.write(endline);
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < this.stoff) {
                    if (Character.isISOControl((char)(this.store[n5] & 0x7F))) {
                        this.out.write(45);
                        this.out.write(45);
                    } else {
                        this.out.write(this.store[n5]);
                        this.out.write(32);
                    }
                    if ((n5 + 1) % 4 == 0) {
                        this.out.write(32);
                    }
                    ++n5;
                }
                this.out.write(endline);
                int n6 = 0;
                while (n6 < this.stoff - 3) {
                    this.out.write(this.hexbuf, n6 * 2, 8);
                    this.out.write(32);
                    n6 += 4;
                }
                if (this.stoff % 4 != 0) {
                    this.out.write(this.hexbuf, this.stoff / 4 * 8, this.stoff % 4 * 2);
                }
                this.out.write(endline);
            }
        }
        this.stoff = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.format = n;
        switch (n) {
            case 0: {
                this.store = null;
                break;
            }
            case 2: {
                this.store = new byte[16];
                break;
            }
            case 1: 
            case 3: {
                this.store = new byte[32];
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            byte[] byArray = new byte[256];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)n;
                ++n;
            }
            HexPrintStream hexPrintStream = new HexPrintStream(System.out);
            int n2 = 0;
            while (n2 < 4) {
                hexPrintStream.setFormat(n2);
                hexPrintStream.write(byArray);
                System.out.println();
                ++n2;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private static boolean isPrintable(byte by) {
        switch (Character.getType((char)by)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }
}

