/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.CORBA.DataInputStream;
import org.openorb.CORBA.DataOutputStream;
import org.openorb.io.ExtendedInputStream;
import org.openorb.io.ListOutputStream;
import org.openorb.util.RepoIDHelper;

public class ListInputStream
extends InputStream
implements ExtendedInputStream {
    private List _source;
    private ListIterator _itter = null;
    private int _ittpos = 0;
    private int _markpos = 0;
    private ORB _orb;

    public ListInputStream(ORB oRB, List list) {
        this._source = list;
        this._orb = oRB;
    }

    public ORB orb() {
        return this._orb;
    }

    public String get_codebase() {
        return null;
    }

    public List getSource() {
        return this._source;
    }

    public List getSourceTail() {
        return this._source.subList(this._ittpos, this._source.size());
    }

    public int getIndex() {
        return this._ittpos;
    }

    public void setIndex(int n) {
        if (n > this._source.size() || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this._ittpos = n;
        this._itter = null;
    }

    public int skip() {
        throw new NO_IMPLEMENT();
    }

    public int available() {
        throw new NO_IMPLEMENT();
    }

    public boolean markAvailable() {
        return true;
    }

    public void mark(int n) {
        this._markpos = this._ittpos;
    }

    public void reset() {
        this._ittpos = this._markpos;
        this._itter = null;
    }

    /*
     * Loose catch block
     */
    public java.lang.Object next() {
        while (true) {
            try {
                if (this._itter == null) {
                    this._itter = this._source.listIterator(this._ittpos);
                }
                java.lang.Object e = this._itter.next();
                ++this._ittpos;
                return e;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this._itter = null;
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new MARSHAL("Overread on list stream", 1146056726, CompletionStatus.COMPLETED_MAYBE);
            }
            break;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new MARSHAL("Overread on list stream", 1146056726, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public java.lang.Object peek() {
        return this._source.get(this._ittpos);
    }

    public boolean read_boolean() {
        try {
            if ((TCKind)this.next() != TCKind.tk_boolean) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Boolean)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_boolean) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, blArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public byte read_octet() {
        try {
            if ((TCKind)this.next() != TCKind.tk_octet) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Byte)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_octet) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, byArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public short read_short() {
        try {
            if ((TCKind)this.next() != TCKind.tk_short) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Short)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_short) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, sArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public short read_ushort() {
        try {
            if ((TCKind)this.next() != TCKind.tk_ushort) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Short)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_ushort) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, sArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public int read_long() {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind != TCKind.tk_ulong) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Integer)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_long) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, nArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public int read_ulong() {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind != TCKind.tk_ulong) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Integer)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_ulong) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, nArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public long read_longlong() {
        try {
            if ((TCKind)this.next() != TCKind.tk_longlong) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Long)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_longlong) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, lArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public long read_ulonglong() {
        try {
            if ((TCKind)this.next() != TCKind.tk_ulonglong) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Long)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_ulonglong) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, lArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public char read_char() {
        try {
            if ((TCKind)this.next() != TCKind.tk_char) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return ((Character)this.next()).charValue();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_char) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, cArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public char read_wchar() {
        try {
            if ((TCKind)this.next() != TCKind.tk_wchar) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return ((Character)this.next()).charValue();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_wchar) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, cArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public float read_float() {
        try {
            if ((TCKind)this.next() != TCKind.tk_float) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return ((Float)this.next()).floatValue();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_float) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, fArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public double read_double() {
        try {
            if ((TCKind)this.next() != TCKind.tk_double) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Double)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock arrayBlock = (ListOutputStream.ArrayBlock)this.next();
            if (arrayBlock.getContentKind() != TCKind.tk_double) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (arrayBlock.len != n2) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(arrayBlock.array, arrayBlock.off, dArray, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public String read_string() {
        try {
            if ((TCKind)this.next() != TCKind.tk_string) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (String)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public String read_wstring() {
        try {
            if ((TCKind)this.next() != TCKind.tk_wstring) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (String)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public Object read_Object() {
        try {
            if ((TCKind)this.next() != TCKind.tk_objref) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Object)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public Object read_Object(Class clazz) {
        ObjectImpl objectImpl;
        java.lang.Object object;
        try {
            if ((TCKind)this.next() != TCKind.tk_objref) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            object = this.next();
            if (object == null || clazz.isInstance(object)) {
                return (Object)object;
            }
            objectImpl = (ObjectImpl)object;
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        try {
            object = (ObjectImpl)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new BAD_PARAM("Bad object type", 1146056711, CompletionStatus.COMPLETED_MAYBE);
        }
        ((ObjectImpl)object)._set_delegate(objectImpl._get_delegate());
        return object;
    }

    public TypeCode read_TypeCode() {
        try {
            if ((TCKind)this.next() != TCKind.tk_TypeCode) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (TypeCode)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public Any read_any() {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind == TCKind.tk_any) {
                return (Any)this.next();
            }
            if (tCKind == TCKind.tk_TypeCode) {
                Any any = this._orb.create_any();
                any.read_value(this, (TypeCode)this.next());
                return any;
            }
            throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public Context read_Context() {
        java.lang.Object object;
        NVList nVList = this._orb.create_list(0);
        int n = this.read_ulong() / 2;
        int n2 = 0;
        while (n2 < n) {
            object = this._orb.create_any();
            String string = this.read_string();
            ((Any)object).insert_string(this.read_string());
            nVList.add_value(string, (Any)object, 0);
            ++n2;
        }
        object = new org.openorb.CORBA.dii.Context("", null, this._orb);
        ((Context)object).set_values(nVList);
        return object;
    }

    public Principal read_Principal() {
        try {
            if ((TCKind)this.next() != TCKind.tk_Principal) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (Principal)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public BigDecimal read_fixed() {
        try {
            if ((TCKind)this.next() != TCKind.tk_fixed) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (BigDecimal)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public BigDecimal read_fixed(TypeCode typeCode) {
        try {
            return this.read_fixed(typeCode.fixed_digits(), typeCode.fixed_scale());
        }
        catch (BadKind badKind) {
            throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public BigDecimal read_fixed(short s, short s2) {
        BigDecimal bigDecimal;
        try {
            if ((TCKind)this.next() != TCKind.tk_fixed) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            bigDecimal = (BigDecimal)this.next();
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
        String string = bigDecimal.toString();
        int n = string.length();
        if (string.charAt(0) == '-') {
            --n;
        }
        if (string.indexOf(46) >= 0) {
            --n;
        }
        if (n > s) {
            throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
        }
        if (bigDecimal.scale() != s2) {
            throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
        }
        return bigDecimal;
    }

    public Serializable read_value() {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind == TCKind.tk_value) {
                return (Serializable)this.next();
            }
            if (tCKind == TCKind.tk_value_box) {
                BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.next();
                return boxedValueHelper.read_value(this);
            }
            throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public Serializable read_value(String string) {
        try {
            TCKind tCKind = (TCKind)this.next();
            if (tCKind == TCKind.tk_value) {
                Serializable serializable = (Serializable)this.next();
                if (serializable != null) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(RepoIDHelper.idToClass(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (clazz != null && !clazz.isInstance(serializable)) {
                        throw new BAD_PARAM("Bad object type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                return serializable;
            }
            if (tCKind == TCKind.tk_value_box) {
                BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.next();
                if (!boxedValueHelper.get_id().equals(string)) {
                    throw new BAD_PARAM("Bad object type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
                }
                return boxedValueHelper.read_value(this);
            }
            throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public Serializable read_value(Class clazz) {
        Serializable serializable;
        block5: {
            try {
                TCKind tCKind = (TCKind)this.next();
                if (tCKind == TCKind.tk_value) {
                    serializable = (Serializable)this.next();
                    break block5;
                }
                if (tCKind == TCKind.tk_value_box) {
                    BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.next();
                    serializable = boxedValueHelper.read_value(this);
                    break block5;
                }
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            catch (ClassCastException classCastException) {
                throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (clazz != null && serializable != null && !clazz.isInstance(serializable)) {
            throw new BAD_PARAM("Bad object type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
        }
        return serializable;
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        try {
            if ((TCKind)this.next() != TCKind.tk_value_box) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            BoxedValueHelper boxedValueHelper2 = (BoxedValueHelper)this.next();
            if (!boxedValueHelper2.get_id().equals(boxedValueHelper.get_id())) {
                throw new BAD_PARAM("Bad factory type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
            }
            return boxedValueHelper.read_value(this);
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public Serializable read_value(Serializable serializable) {
        try {
            if ((TCKind)this.next() != TCKind.tk_value) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (serializable instanceof CustomValue) {
                CustomValue customValue = (CustomValue)this.next();
                CustomValue customValue2 = (CustomValue)serializable;
                if (!customValue._truncatable_ids()[0].equals(customValue2._truncatable_ids()[0])) {
                    throw new BAD_PARAM("Bad target type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
                }
                OutputStream outputStream = (OutputStream)this._orb.create_output_stream();
                customValue.marshal(new DataOutputStream(outputStream));
                customValue2.unmarshal(new DataInputStream(outputStream.create_input_stream()));
                return customValue2;
            }
            if (serializable instanceof StreamableValue) {
                StreamableValue streamableValue = (StreamableValue)this.next();
                StreamableValue streamableValue2 = (StreamableValue)serializable;
                String[] stringArray = streamableValue._truncatable_ids();
                String string = streamableValue2._truncatable_ids()[0];
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string)) {
                        stringArray = null;
                        break;
                    }
                    ++n;
                }
                if (stringArray != null) {
                    throw new BAD_PARAM("Bad target type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
                }
                OutputStream outputStream = (OutputStream)this._orb.create_output_stream();
                streamableValue._write(outputStream);
                streamableValue2._read(outputStream.create_input_stream());
                return streamableValue2;
            }
            throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public java.lang.Object read_abstract_interface() {
        try {
            if ((TCKind)this.next() != TCKind.tk_abstract_interface) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            TCKind tCKind = (TCKind)this.peek();
            if (tCKind == TCKind.tk_objref) {
                return this.read_Object();
            }
            if (tCKind == TCKind.tk_value) {
                return this.read_value();
            }
            throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        try {
            if ((TCKind)this.next() != TCKind.tk_abstract_interface) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            TCKind tCKind = (TCKind)this.peek();
            if (tCKind == TCKind.tk_objref) {
                return this.read_Object(clazz);
            }
            if (tCKind == TCKind.tk_value) {
                return this.read_value(clazz);
            }
            throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ClassCastException classCastException) {
            throw new MARSHAL("Buffer position or format problem.", 1146056728, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(java.lang.Object object) {
        if (object instanceof OutputStream) {
            return this.equals(((OutputStream)object).create_input_stream());
        }
        if (object instanceof ListInputStream) {
            boolean bl;
            ListInputStream listInputStream;
            block26: {
                boolean bl2;
                block17: {
                    boolean bl3;
                    block25: {
                        boolean bl4;
                        block24: {
                            boolean bl5;
                            block23: {
                                boolean bl6;
                                block22: {
                                    boolean bl7;
                                    block21: {
                                        boolean bl8;
                                        block20: {
                                            boolean bl9;
                                            block19: {
                                                boolean bl10;
                                                block18: {
                                                    listInputStream = (ListInputStream)object;
                                                    if (this._source.size() - this._ittpos != listInputStream._source.size() - listInputStream._ittpos) {
                                                        return false;
                                                    }
                                                    this.mark(0);
                                                    listInputStream.mark(0);
                                                    try {
                                                        block16: {
                                                            while (true) {
                                                                ListOutputStream listOutputStream;
                                                                ListOutputStream listOutputStream2;
                                                                java.lang.Object object2;
                                                                if (this._ittpos >= this._source.size()) {
                                                                    if (!listInputStream._itter.hasNext()) break block16;
                                                                    bl2 = false;
                                                                    break block17;
                                                                }
                                                                java.lang.Object object3 = this.next();
                                                                if (object3 == null != ((object2 = listInputStream.next()) == null)) {
                                                                    boolean bl11 = false;
                                                                    java.lang.Object var12_10 = null;
                                                                    this.reset();
                                                                    listInputStream.reset();
                                                                    return bl11;
                                                                }
                                                                if (object3 == null || object3 == object2) continue;
                                                                if (object3 instanceof Object) {
                                                                    if (!(object2 instanceof Object)) {
                                                                        bl10 = false;
                                                                        break block18;
                                                                    }
                                                                    if (((Object)object3)._is_equivalent((Object)object2)) continue;
                                                                    bl9 = false;
                                                                    break block19;
                                                                }
                                                                if (!object3.getClass().isInstance(object2)) {
                                                                    bl8 = false;
                                                                    break block20;
                                                                }
                                                                if (object3 instanceof StreamableValue) {
                                                                    if (!(object2 instanceof StreamableValue)) {
                                                                        bl7 = false;
                                                                        break block21;
                                                                    }
                                                                    listOutputStream2 = new ListOutputStream(this._orb);
                                                                    listOutputStream = new ListOutputStream(this._orb);
                                                                    ((StreamableValue)object3)._write(listOutputStream2);
                                                                    ((StreamableValue)object2)._write(listOutputStream);
                                                                    if (listOutputStream2.create_input_stream().equals(listOutputStream.create_input_stream())) continue;
                                                                    bl6 = false;
                                                                    break block22;
                                                                }
                                                                if (object3 instanceof CustomValue) {
                                                                    if (!(object2 instanceof CustomValue)) {
                                                                        bl5 = false;
                                                                        break block23;
                                                                    }
                                                                    listOutputStream2 = new ListOutputStream(this._orb);
                                                                    listOutputStream = new ListOutputStream(this._orb);
                                                                    ((CustomValue)object3).marshal(new DataOutputStream(listOutputStream2));
                                                                    ((CustomValue)object2).marshal(new DataOutputStream(listOutputStream));
                                                                    if (listOutputStream2.create_input_stream().equals(listOutputStream.create_input_stream())) continue;
                                                                    bl4 = false;
                                                                    break block24;
                                                                }
                                                                if (!object3.equals(object2)) break;
                                                            }
                                                            bl3 = false;
                                                            break block25;
                                                        }
                                                        bl = true;
                                                        break block26;
                                                    }
                                                    catch (Throwable throwable) {
                                                        java.lang.Object var12_21 = null;
                                                        this.reset();
                                                        listInputStream.reset();
                                                        throw throwable;
                                                    }
                                                }
                                                java.lang.Object var12_11 = null;
                                                this.reset();
                                                listInputStream.reset();
                                                return bl10;
                                            }
                                            java.lang.Object var12_12 = null;
                                            this.reset();
                                            listInputStream.reset();
                                            return bl9;
                                        }
                                        java.lang.Object var12_13 = null;
                                        this.reset();
                                        listInputStream.reset();
                                        return bl8;
                                    }
                                    java.lang.Object var12_14 = null;
                                    this.reset();
                                    listInputStream.reset();
                                    return bl7;
                                }
                                java.lang.Object var12_15 = null;
                                this.reset();
                                listInputStream.reset();
                                return bl6;
                            }
                            java.lang.Object var12_16 = null;
                            this.reset();
                            listInputStream.reset();
                            return bl5;
                        }
                        java.lang.Object var12_17 = null;
                        this.reset();
                        listInputStream.reset();
                        return bl4;
                    }
                    java.lang.Object var12_18 = null;
                    this.reset();
                    listInputStream.reset();
                    return bl3;
                }
                java.lang.Object var12_19 = null;
                this.reset();
                listInputStream.reset();
                return bl2;
            }
            java.lang.Object var12_20 = null;
            this.reset();
            listInputStream.reset();
            return bl;
        }
        if (object instanceof OutputStream) {
            throw new NO_IMPLEMENT();
        }
        return false;
    }
}

