/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.io.ExtendedOutputStream;
import org.openorb.io.ListInputStream;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class ListOutputStream
extends OutputStream
implements ExtendedOutputStream {
    private List _contents;
    private ORB _orb;

    public ListOutputStream(ORB oRB) {
        this._orb = oRB;
        this._contents = new ArrayList();
    }

    public ListOutputStream(ORB oRB, List list) {
        this._orb = oRB;
        this._contents = list;
    }

    public ORB orb() {
        return this._orb;
    }

    public InputStream create_input_stream() {
        return new ListInputStream(this._orb, this._contents);
    }

    public List getContents() {
        return this._contents;
    }

    public int getIndex() {
        return this._contents.size();
    }

    public void write_boolean(boolean bl) {
        this._contents.add(TCKind.tk_boolean);
        this._contents.add(new Boolean(bl));
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(blArray, n, n2, TCKind.tk_boolean));
    }

    public void write_octet(byte by) {
        this._contents.add(TCKind.tk_octet);
        this._contents.add(new Byte(by));
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(byArray, n, n2, TCKind.tk_octet));
    }

    public void write_short(short s) {
        this._contents.add(TCKind.tk_short);
        this._contents.add(new Short(s));
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(sArray, n, n2, TCKind.tk_short));
    }

    public void write_ushort(short s) {
        this._contents.add(TCKind.tk_ushort);
        this._contents.add(new Short(s));
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(sArray, n, n2, TCKind.tk_ushort));
    }

    public void write_long(int n) {
        this._contents.add(TCKind.tk_ulong);
        this._contents.add(new Integer(n));
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(nArray, n, n2, TCKind.tk_long));
    }

    public void write_ulong(int n) {
        this._contents.add(TCKind.tk_ulong);
        this._contents.add(new Integer(n));
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(nArray, n, n2, TCKind.tk_ulong));
    }

    public void write_longlong(long l) {
        this._contents.add(TCKind.tk_longlong);
        this._contents.add(new Long(l));
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(lArray, n, n2, TCKind.tk_longlong));
    }

    public void write_ulonglong(long l) {
        this._contents.add(TCKind.tk_ulonglong);
        this._contents.add(new Long(l));
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(lArray, n, n2, TCKind.tk_ulonglong));
    }

    public void write_float(float f) {
        this._contents.add(TCKind.tk_float);
        this._contents.add(new Float(f));
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(fArray, n, n2, TCKind.tk_float));
    }

    public void write_double(double d) {
        this._contents.add(TCKind.tk_double);
        this._contents.add(new Double(d));
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(dArray, n, n2, TCKind.tk_double));
    }

    public void write_char(char c) {
        this._contents.add(TCKind.tk_char);
        this._contents.add(new Character(c));
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(cArray, n, n2, TCKind.tk_char));
    }

    public void write_wchar(char c) {
        this._contents.add(TCKind.tk_wchar);
        this._contents.add(new Character(c));
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        this._contents.add(TCKind.tk_array);
        this._contents.add(new ArrayBlock(cArray, n, n2, TCKind.tk_wchar));
    }

    public void write_string(String string) {
        this._contents.add(TCKind.tk_string);
        this._contents.add(string);
    }

    public void write_wstring(String string) {
        this._contents.add(TCKind.tk_wstring);
        this._contents.add(string);
    }

    public void write_Object(Object object) {
        this._contents.add(TCKind.tk_objref);
        this._contents.add(object);
    }

    public void write_TypeCode(TypeCode typeCode) {
        this._contents.add(TCKind.tk_TypeCode);
        this._contents.add(typeCode);
    }

    public void write_any(Any any) {
        this._contents.add(TCKind.tk_any);
        this._contents.add(any);
    }

    public void write_Context(Context context, ContextList contextList) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < contextList.count()) {
            try {
                NVList nVList = context.get_values("", 0, contextList.item(n));
                int n2 = 0;
                while (n2 < nVList.count()) {
                    vector.addElement(nVList.item(n2).name());
                    vector.addElement(nVList.item(n2).value().extract_string());
                    ++n2;
                }
            }
            catch (Bounds bounds) {
                // empty catch block
            }
            ++n;
        }
        if (vector.size() != 0) {
            this.write_ulong(vector.size());
            int n3 = 0;
            while (n3 < vector.size()) {
                this.write_string((String)vector.elementAt(n3));
                ++n3;
            }
        } else if (contextList.count() != 0) {
            this.write_ulong(0);
        }
    }

    public void write_Principal(Principal principal) {
        this._contents.add(TCKind.tk_Principal);
        this._contents.add(principal);
    }

    public void write_fixed(BigDecimal bigDecimal) {
        this._contents.add(TCKind.tk_fixed);
        this._contents.add(bigDecimal);
    }

    public void write_fixed(BigDecimal bigDecimal, TypeCode typeCode) {
        try {
            this.write_fixed(bigDecimal, typeCode.fixed_digits(), typeCode.fixed_scale());
        }
        catch (BadKind badKind) {
            throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void write_fixed(BigDecimal bigDecimal, short s, short s2) {
        if (s2 >= 0 && bigDecimal.scale() != s2) {
            bigDecimal = bigDecimal.setScale((int)s2, 6);
        }
        if (s >= 0) {
            String string = bigDecimal.toString();
            int n = string.length();
            if (string.charAt(0) == '-') {
                --n;
            }
            if (string.indexOf(46) != -1) {
                --n;
            }
            if (n > s) {
                throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        this._contents.add(TCKind.tk_fixed);
        this._contents.add(bigDecimal);
    }

    public void write_value(Serializable serializable) {
        if (serializable instanceof StreamableValue || serializable instanceof CustomValue) {
            this._contents.add(TCKind.tk_value);
            this._contents.add(serializable);
        } else if (serializable instanceof ValueBase) {
            BoxedValueHelper boxedValueHelper;
            String string = ((ValueBase)serializable)._truncatable_ids()[0];
            String string2 = RepoIDHelper.idToClass(string, 2);
            try {
                boxedValueHelper = (BoxedValueHelper)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                throw new MARSHAL("Unable to locate valuebox helper", 83099649, CompletionStatus.COMPLETED_NO);
            }
            this._contents.add(TCKind.tk_value_box);
            this._contents.add(boxedValueHelper);
        } else {
            if (serializable.getClass().isArray()) {
                throw new MARSHAL("Unable to locate valuebox helper", 83099649, CompletionStatus.COMPLETED_NO);
            }
            this._contents.add(TCKind.tk_value);
            this._contents.add(serializable);
        }
    }

    public void write_value(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue || serializable instanceof CustomValue) {
            this._contents.add(TCKind.tk_value);
            this._contents.add(serializable);
        } else if (serializable instanceof ValueBase || serializable.getClass().isArray()) {
            BoxedValueHelper boxedValueHelper;
            String string2 = RepoIDHelper.idToClass(string, 2);
            try {
                boxedValueHelper = (BoxedValueHelper)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                throw new MARSHAL("Unable to locate valuebox helper", 83099649, CompletionStatus.COMPLETED_NO);
            }
            this._contents.add(TCKind.tk_value_box);
            this._contents.add(boxedValueHelper);
            boxedValueHelper.write_value(this, serializable);
        } else {
            this._contents.add(TCKind.tk_value);
            this._contents.add(serializable);
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        if (serializable instanceof StreamableValue || serializable instanceof CustomValue) {
            this._contents.add(TCKind.tk_value);
            this._contents.add(serializable);
        } else if (serializable instanceof ValueBase) {
            BoxedValueHelper boxedValueHelper;
            String string = ((ValueBase)serializable)._truncatable_ids()[0];
            String string2 = RepoIDHelper.idToClass(string, 2);
            try {
                boxedValueHelper = (BoxedValueHelper)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                throw new MARSHAL("Unable to locate valuebox helper", 83099649, CompletionStatus.COMPLETED_NO);
            }
            this._contents.add(TCKind.tk_value_box);
            this._contents.add(boxedValueHelper);
            boxedValueHelper.write_value(this, serializable);
        } else {
            if (serializable.getClass().isArray()) {
                throw new MARSHAL("Unable to locate valuebox helper", 83099649, CompletionStatus.COMPLETED_NO);
            }
            this._contents.add(TCKind.tk_value);
            this._contents.add(serializable);
        }
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        this._contents.add(TCKind.tk_value_box);
        this._contents.add(boxedValueHelper);
        boxedValueHelper.write_value(this, serializable);
    }

    public void write_abstract_interface(java.lang.Object object) {
        this._contents.add(TCKind.tk_abstract_interface);
        if (object instanceof Object) {
            this.write_Object((Object)object);
        } else if (object instanceof Serializable) {
            this.write_value((Serializable)object);
        } else {
            throw new BAD_PARAM("Attempt to marshal unknown interface type", 1146056716, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public boolean equals(java.lang.Object object) {
        return this.create_input_stream().equals(object);
    }

    public static class ArrayBlock {
        java.lang.Object array;
        int off;
        int len;
        TCKind kind;

        ArrayBlock(java.lang.Object object, int n, int n2, TCKind tCKind) {
            this.array = object;
            this.off = n;
            this.len = n2;
            this.kind = tCKind;
        }

        public int getLength() {
            return this.len;
        }

        public TCKind getContentKind() {
            return this.kind;
        }

        public java.lang.Object getContents() {
            if (this.off != 0) {
                java.lang.Object object = Array.newInstance(this.array.getClass().getSuperclass(), this.len);
                System.arraycopy(this.array, this.off, object, 0, this.len);
                this.array = object;
            }
            return this.array;
        }

        public boolean equals(java.lang.Object object) {
            if (!(object instanceof ArrayBlock)) {
                return false;
            }
            ArrayBlock arrayBlock = (ArrayBlock)object;
            if (this.len != arrayBlock.len || this.kind != arrayBlock.kind) {
                return false;
            }
            switch (this.kind.value()) {
                case 8: {
                    boolean[] blArray = (boolean[])this.array;
                    boolean[] blArray2 = (boolean[])arrayBlock.array;
                    int n = 0;
                    while (n < this.len) {
                        if (blArray[this.off + n] != blArray2[arrayBlock.off + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 10: {
                    byte[] byArray = (byte[])this.array;
                    byte[] byArray2 = (byte[])arrayBlock.array;
                    int n = 0;
                    while (n < this.len) {
                        if (byArray[this.off + n] != byArray2[arrayBlock.off + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 2: 
                case 4: {
                    short[] sArray = (short[])this.array;
                    short[] sArray2 = (short[])arrayBlock.array;
                    int n = 0;
                    while (n < this.len) {
                        if (sArray[this.off + n] != sArray2[arrayBlock.off + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 3: 
                case 5: {
                    int[] nArray = (int[])this.array;
                    int[] nArray2 = (int[])arrayBlock.array;
                    int n = 0;
                    while (n < this.len) {
                        if (nArray[this.off + n] != nArray2[arrayBlock.off + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 23: 
                case 24: {
                    long[] lArray = (long[])this.array;
                    long[] lArray2 = (long[])arrayBlock.array;
                    int n = 0;
                    while (n < this.len) {
                        if (lArray[this.off + n] != lArray2[arrayBlock.off + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 6: {
                    float[] fArray = (float[])this.array;
                    float[] fArray2 = (float[])arrayBlock.array;
                    int n = 0;
                    while (n < this.len) {
                        if (fArray[this.off + n] != fArray2[arrayBlock.off + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 7: {
                    double[] dArray = (double[])this.array;
                    double[] dArray2 = (double[])arrayBlock.array;
                    int n = 0;
                    while (n < this.len) {
                        if (dArray[this.off + n] != dArray2[arrayBlock.off + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 9: 
                case 26: {
                    char[] cArray = (char[])this.array;
                    char[] cArray2 = (char[])arrayBlock.array;
                    int n = 0;
                    while (n < this.len) {
                        if (cArray[this.off + n] != cArray2[arrayBlock.off + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
            }
            Trace.assert(false, "Unexpected case");
            return false;
        }
    }
}

