/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.util.EventListener;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.SystemException;
import org.openorb.io.Scrap;
import org.openorb.io.StorageBuffer;

public class MarshalBuffer {
    private SystemException _cancelException = null;
    private Scrap _head = this._tail = new Scrap();
    private Scrap _tail;
    private OctetSeqHolder _lastBuf = null;
    private boolean _allowFragment = false;
    private boolean _inFragment = false;
    private boolean _hdrFrag = true;
    private HeaderData _lastHeader = null;
    private boolean _blockFrag = true;
    private BlockData _lastBlock = null;
    private Listener _listener = null;
    private Object _listenerCookie = null;
    private boolean _inListener = false;
    private byte[] _ignoreBuf = null;

    public MarshalBuffer() {
        this._tail.buf = new byte[2048];
        this._tail.off = 0;
        this._tail.len = 0;
        this._tail.mode = 0;
        this._tail.pos = 0;
    }

    public MarshalBuffer(Listener listener, Object object) {
        this();
        this._listener = listener;
        this._listenerCookie = object;
    }

    public boolean isStandalone() {
        return this._listener == null;
    }

    public int size() {
        if (!this.prealloc()) {
            return -1;
        }
        return this._tail.pos;
    }

    public int available() {
        if (!this.prealloc()) {
            return -1;
        }
        return this._tail.pos - this._head.pos + this._head.len;
    }

    public void setAllowFragment(boolean bl) {
        this._allowFragment = bl;
    }

    public boolean getAllowFragment() {
        return this._allowFragment && this._hdrFrag && this._blockFrag && !this._inFragment;
    }

    public void alloc(OctetSeqHolder octetSeqHolder, IntHolder intHolder, int n) {
        if (!this.prealloc()) {
            if (this._ignoreBuf == null || this._ignoreBuf.length < n) {
                this._ignoreBuf = new byte[n];
            }
            octetSeqHolder.value = this._ignoreBuf;
            intHolder.value = 0;
            return;
        }
        if (this._inListener && !this._inFragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (this._tail.buf.length - this._tail.len - this._tail.off >= n) {
            octetSeqHolder.value = this._tail.buf;
            intHolder.value = this._tail.off + this._tail.len;
            this._tail.len += n;
            this._tail.pos += n;
        } else {
            Scrap scrap = new Scrap();
            scrap.buf = n > 2048 ? new byte[n] : new byte[2048];
            scrap.off = 0;
            scrap.len = n;
            scrap.mode = 0;
            scrap.pos = this._tail.pos + n;
            octetSeqHolder.value = scrap.buf;
            intHolder.value = 0;
            this._tail.next = scrap;
            this._tail = scrap;
        }
        this._lastBuf = octetSeqHolder;
    }

    public void append(byte[] byArray, int n, int n2) {
        if (!this.prealloc()) {
            return;
        }
        if (this._inListener && !this._inFragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (n2 == 0) {
            return;
        }
        if (n2 < 2048) {
            if (this._tail.buf.length - this._tail.len - this._tail.off >= n2) {
                System.arraycopy(byArray, n, this._tail.buf, this._tail.off + this._tail.len, n2);
                this._tail.len += n2;
                this._tail.pos += n2;
            } else {
                int n3 = this._tail.buf.length - this._tail.len - this._tail.off;
                System.arraycopy(byArray, n, this._tail.buf, this._tail.off + this._tail.len, n3);
                this._tail.len += n3;
                this._tail.pos += n3;
                Scrap scrap = new Scrap();
                scrap.buf = new byte[2048];
                scrap.off = 0;
                scrap.len = n2 - n3;
                scrap.mode = 0;
                scrap.pos = this._tail.pos + n2 - n3;
                System.arraycopy(byArray, n + n3, scrap.buf, 0, n2 - n3);
                this._tail.next = scrap;
                this._tail = scrap;
            }
            return;
        }
        if (this._tail.len == 0) {
            Scrap scrap = new Scrap();
            scrap.buf = this._tail.buf;
            scrap.off = this._tail.off;
            scrap.len = 0;
            scrap.mode = 0;
            scrap.pos = this._tail.pos + n2;
            this._tail.buf = byArray;
            this._tail.off = n;
            this._tail.len = n2;
            this._tail.mode = 3;
            this._tail.pos = scrap.pos;
            this._tail.next = scrap;
            this._tail = scrap;
        } else {
            this._tail.mode = 1;
            Scrap scrap = new Scrap();
            scrap.buf = byArray;
            scrap.off = n;
            scrap.len = n2;
            scrap.mode = 3;
            scrap.pos = this._tail.pos + n2;
            Scrap scrap2 = new Scrap();
            scrap2.buf = this._tail.buf;
            scrap2.off = this._tail.off + this._tail.len;
            scrap2.len = 0;
            scrap2.pos = scrap.pos;
            scrap2.mode = 0;
            this._tail.next = scrap;
            scrap.next = scrap2;
            this._tail = scrap2;
        }
        this.postalloc();
    }

    public void pad(int n) {
        if (!this.prealloc()) {
            return;
        }
        if (this._inListener && !this._inFragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (n == 0) {
            return;
        }
        int n2 = this._tail.buf.length - this._tail.len + this._tail.off;
        if (n2 >= n) {
            this._tail.len += n;
            this._tail.pos += n;
        } else {
            this._tail.len += n2;
            this._tail.pos += n2;
            Scrap scrap = new Scrap();
            scrap.buf = new byte[2048];
            scrap.off = 0;
            scrap.len = n - n2;
            scrap.mode = 0;
            scrap.pos = this._tail.pos + scrap.len;
            this._tail.next = scrap;
            this._tail = scrap;
        }
        this.postalloc();
    }

    public void addHeader(HeaderGenerator headerGenerator, int n, boolean bl, Object object) {
        if (this._inListener && !this._inFragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (headerGenerator == null) {
            throw new NullPointerException();
        }
        if (!this.prealloc()) {
            return;
        }
        HeaderData headerData = new HeaderData();
        headerData.prev = this._lastHeader;
        this._lastHeader = headerData;
        headerData.lastHdrFrag = this._hdrFrag;
        headerData.pos = this.size();
        headerData.gen = headerGenerator;
        headerData.cookie = object;
        if (n != 0) {
            this._hdrFrag = false;
            OctetSeqHolder octetSeqHolder = new OctetSeqHolder();
            IntHolder intHolder = new IntHolder();
            this.alloc(octetSeqHolder, intHolder, n);
            headerData.buf = octetSeqHolder.value;
            headerData.off = intHolder.value;
            headerData.len = n;
        }
        this._hdrFrag = headerData.lastHdrFrag && bl;
    }

    public void beginBlock(BlockGenerator blockGenerator, int n, boolean bl, Object object) {
        if (this._inListener && !this._inFragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (blockGenerator == null) {
            throw new NullPointerException();
        }
        if (!this.prealloc()) {
            return;
        }
        BlockData blockData = new BlockData();
        blockData.prev = this._lastBlock;
        blockData.isFrag = this._lastBlock == null ? bl : false;
        this._lastBlock = blockData;
        blockData.pos = this.size();
        blockData.gen = blockGenerator;
        blockData.cookie = object;
        if (n != 0) {
            this._blockFrag = false;
            OctetSeqHolder octetSeqHolder = new OctetSeqHolder();
            IntHolder intHolder = new IntHolder();
            this.alloc(octetSeqHolder, intHolder, n);
            blockData.buf = octetSeqHolder.value;
            blockData.off = intHolder.value;
            blockData.len = n;
        }
        this._blockFrag = blockData.isFrag;
    }

    public void endBlock() {
        if (this._inListener && !this._inFragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (this._lastBlock == null) {
            throw new IllegalStateException("End block without begin block");
        }
        this._lastBlock.gen.endBlock(this._lastBlock.buf, this._lastBlock.off, this._lastBlock.len, this.size() - this._lastBlock.pos, this._lastBlock.cookie);
        this._lastBlock = this._lastBlock.prev;
        this._blockFrag = this._lastBlock == null ? true : this._lastBlock.isFrag;
    }

    public void close() {
        if (this._inListener) {
            throw new IllegalStateException("Cannot close buffer while calling listener.");
        }
        if (this._lastBlock != null) {
            throw new IllegalStateException("All blocks must be closed before closing buffer");
        }
        if (!this.prealloc()) {
            return;
        }
        if (this._listener != null) {
            this._inListener = true;
            this._listener.bufferClosed(this, this._tail.pos, this._listenerCookie);
            this._inListener = false;
        }
        this._tail = null;
        this._head = null;
        this._lastHeader = null;
    }

    public void cancel(SystemException systemException) {
        if (!this.prealloc()) {
            return;
        }
        if (this._listener != null) {
            this._inListener = true;
            try {
                this._listener.bufferCanceled(this, systemException, this._listenerCookie);
            }
            catch (SystemException systemException2) {
                this._cancelException = systemException2;
            }
            this._inListener = false;
        } else {
            this._cancelException = systemException;
        }
        this._tail = null;
        this._head = null;
        this._lastHeader = null;
        this._lastBlock = null;
        if (this._cancelException != null) {
            throw this._cancelException;
        }
    }

    public StorageBuffer fragment(int n) {
        Scrap scrap;
        Scrap scrap2;
        if (!this.prealloc()) {
            return null;
        }
        if (this._listener != null && !this._inListener) {
            throw new IllegalStateException("Operation disallowed, must be called from listener");
        }
        if (!this.getAllowFragment()) {
            throw new IllegalStateException("Buffer cannot currently be fragmented");
        }
        if (n > this._tail.pos - this._head.pos + this._head.len) {
            throw new IndexOutOfBoundsException();
        }
        this._inFragment = true;
        if (this._lastBlock != null) {
            BlockData blockData = this._lastBlock;
            this._lastBlock = null;
            blockData.gen.fragmentBlock(blockData.buf, blockData.off, blockData.len, this.size() - blockData.pos, this, blockData.cookie);
        }
        int n2 = n + this._head.pos - this._head.len;
        HeaderData headerData = null;
        while (this._lastHeader != null) {
            this._lastHeader.gen.endMessage(this._lastHeader.buf, this._lastHeader.off, this._lastHeader.len, true, n2 - this._lastHeader.pos, this._lastHeader.cookie);
            HeaderData headerData2 = this._lastHeader.prev;
            this._lastHeader.prev = headerData;
            headerData = this._lastHeader;
            this._lastHeader = headerData2;
        }
        if (this._tail.pos - this._tail.len < n2) {
            scrap2 = this._tail;
        } else {
            scrap2 = this._head;
            while (scrap2.pos < n2) {
                scrap2 = scrap2.next;
            }
        }
        if (scrap2.pos == n2) {
            scrap = scrap2.next;
            scrap2.next = null;
        } else {
            int n3 = scrap2.pos - n2;
            scrap = new Scrap();
            scrap.mode = 1 | scrap2.mode;
            scrap.buf = scrap2.buf;
            scrap.pos = scrap2.pos;
            scrap.off = scrap2.off + scrap2.len - n3;
            scrap.len = n3;
            scrap.next = scrap2.next;
            scrap2.len -= n3;
            scrap2.pos = n2;
            scrap2.next = null;
            scrap2.mode = 1 | scrap2.mode;
        }
        scrap2 = null;
        StorageBuffer storageBuffer = new StorageBuffer(this._head, n);
        this._head = this._tail = new Scrap();
        this._tail.buf = new byte[2048];
        this._tail.off = 0;
        this._tail.len = 0;
        this._tail.mode = 0;
        this._tail.pos = n2;
        while (headerData != null) {
            headerData.gen.beginMessage(this, headerData.cookie);
            headerData = headerData.prev;
        }
        this.prealloc();
        int n4 = 0;
        if (scrap != null) {
            n4 = this._tail.pos + scrap.len - scrap.pos;
            if (this._tail.len == 0) {
                this._tail.buf = scrap.buf;
                this._tail.len = scrap.len;
                this._tail.off = scrap.off;
                this._tail.mode = scrap.mode;
                this._tail.next = scrap.next;
                this._tail.pos += scrap.len;
                scrap = scrap.next;
            } else {
                this._tail.next = scrap;
            }
            while (scrap != null) {
                scrap.pos += n4;
                this._tail = scrap;
                scrap = scrap.next;
            }
        }
        BlockData blockData = this._lastBlock;
        while (blockData != null) {
            blockData.pos += n4;
            blockData = blockData.prev;
        }
        this._inFragment = false;
        return storageBuffer;
    }

    /*
     * Unable to fully structure code
     */
    public StorageBuffer lastFragment() {
        if (!this.prealloc()) {
            return null;
        }
        if (this._listener != null && !this._inListener) {
            throw new IllegalStateException("Operation disallowed, must be called from listener. Call close operation");
        }
        if (this._lastBlock == null) ** GOTO lbl9
        throw new IllegalStateException("Attempt to close buffer without closing all blocks");
lbl-1000:
        // 1 sources

        {
            this._lastHeader.gen.endMessage(this._lastHeader.buf, this._lastHeader.off, this._lastHeader.len, false, this._tail.pos - this._lastHeader.pos, this._lastHeader.cookie);
            this._lastHeader = this._lastHeader.prev;
lbl9:
            // 2 sources

            ** while (this._lastHeader != null)
        }
lbl10:
        // 1 sources

        var1_1 = this._head;
        var2_2 = this._tail.pos;
        this._tail = null;
        this._head = null;
        return new StorageBuffer(var1_1, var2_2);
    }

    private boolean prealloc() {
        if (this._cancelException != null) {
            throw this._cancelException;
        }
        if (this._head == null) {
            return false;
        }
        if (this._lastBuf != null) {
            this._lastBuf.value = null;
            this._lastBuf = null;
            this.postalloc();
        }
        return true;
    }

    private void postalloc() {
        if (this._listener != null && this._allowFragment && this._hdrFrag && this._blockFrag && !this._inFragment) {
            this._inListener = true;
            this._listener.availIncreaced(this, this._tail.pos - this._head.pos + this._head.len, this._listenerCookie);
            this._inListener = false;
        }
    }

    public static void main(String[] stringArray) {
        MarshalBuffer marshalBuffer = new MarshalBuffer();
        OctetSeqHolder octetSeqHolder = new OctetSeqHolder();
        IntHolder intHolder = new IntHolder();
        int n = 1;
        int n2 = 0;
        while (n2 < 3000) {
            marshalBuffer.alloc(octetSeqHolder, intHolder, n);
            int n3 = 0;
            while (n3 < n) {
                octetSeqHolder.value[intHolder.value + n3] = (byte)((n2 + n3) % 121);
                ++n3;
            }
            n2 += n;
        }
        StorageBuffer storageBuffer = marshalBuffer.lastFragment();
        System.out.println("available = " + storageBuffer.available());
        System.out.println("available = " + storageBuffer.available());
        byte[] byArray = storageBuffer.linearize();
        int n4 = 0;
        while (n4 < byArray.length) {
            if (byArray[n4] != (byte)(n4 % 121)) {
                System.out.println("Error at index " + n4);
            }
            ++n4;
        }
    }

    private static class BlockData {
        BlockData prev;
        boolean isFrag;
        int pos;
        BlockGenerator gen;
        Object cookie;
        byte[] buf;
        int off;
        int len;

        private BlockData() {
        }
    }

    private static class HeaderData {
        HeaderData prev;
        boolean lastHdrFrag;
        int pos;
        HeaderGenerator gen;
        Object cookie;
        byte[] buf;
        int off;
        int len;

        private HeaderData() {
        }
    }

    public static interface Listener
    extends EventListener {
        public void availIncreaced(MarshalBuffer var1, int var2, Object var3);

        public void bufferClosed(MarshalBuffer var1, int var2, Object var3);

        public void bufferCanceled(MarshalBuffer var1, SystemException var2, Object var3);
    }

    public static interface BlockGenerator {
        public void endBlock(byte[] var1, int var2, int var3, int var4, Object var5);

        public void fragmentBlock(byte[] var1, int var2, int var3, int var4, MarshalBuffer var5, Object var6);
    }

    public static interface HeaderGenerator {
        public void endMessage(byte[] var1, int var2, int var3, boolean var4, int var5, Object var6);

        public void beginMessage(MarshalBuffer var1, Object var2);
    }
}

