/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.openorb.io.Scrap;

public class StorageBuffer {
    private int avail;
    private Scrap mark = null;
    private int markavail = 0;
    private Scrap head;
    private Scrap temphead = new Scrap();
    private Scrap tail = null;
    private boolean readWriteMode = false;

    public StorageBuffer(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n2 + n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.head = new Scrap();
        this.avail = n2;
        this.head.buf = byArray;
        this.head.off = n;
        this.head.len = n2;
        this.head.pos = n2;
        this.head.mode = 3;
    }

    public StorageBuffer(InputStream inputStream, int n) throws IOException {
        this(null, 0, 0, inputStream, n);
    }

    public StorageBuffer(byte[] byArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4;
        int n5;
        Scrap scrap;
        if (byArray != null && (n < 0 || n2 < 0 || n2 + n > byArray.length || inputStream != null && n2 > n3)) {
            throw new IndexOutOfBoundsException();
        }
        Scrap scrap2 = scrap = new Scrap();
        boolean bl = false;
        this.avail = n3;
        if (byArray == null || n2 == 0) {
            scrap.pos = 0;
            scrap.buf = null;
        } else {
            if (inputStream == null) {
                scrap.buf = new byte[n2];
                scrap.off = 0;
                scrap.len = n2;
                scrap.pos = n2;
                scrap.mode = 0;
                System.arraycopy(byArray, n, scrap.buf, 0, n2);
                this.head = scrap2;
                this.avail = n2;
                return;
            }
            n5 = n3 > 2048 ? 2048 : n3;
            scrap.buf = new byte[n5];
            scrap.off = 0;
            scrap.len = n5;
            scrap.pos = n5;
            scrap.mode = 0;
            System.arraycopy(byArray, n, scrap.buf, 0, n2);
            n5 -= n2;
            n3 -= n2;
            int n6 = n2;
            while (n5 > 0) {
                try {
                    n4 = inputStream.read(scrap.buf, n6, n5);
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = true;
                    n4 = interruptedIOException.bytesTransferred;
                }
                if (n4 >= 0) {
                    n6 += n4;
                    n5 -= n4;
                    n3 -= n4;
                    continue;
                }
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                throw new EOFException("error: EOF reached when reading message");
            }
        }
        while (n3 > 0) {
            n5 = n3 > 2048 ? 2048 : n3;
            Scrap scrap3 = new Scrap();
            scrap3.buf = new byte[n5];
            scrap3.off = 0;
            scrap3.len = n5;
            scrap3.pos = scrap.pos + n5;
            scrap3.mode = 0;
            n4 = 0;
            while (n5 > 0) {
                int n7;
                try {
                    n7 = inputStream.read(scrap3.buf, n4, n5);
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = true;
                    n7 = interruptedIOException.bytesTransferred;
                }
                if (n7 >= 0) {
                    n4 += n7;
                    n5 -= n7;
                    n3 -= n7;
                    continue;
                }
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                throw new EOFException("error: EOF reached when reading message");
            }
            scrap.next = scrap3;
            scrap = scrap3;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        this.head = scrap2.buf == null ? scrap2.next : scrap2;
    }

    StorageBuffer(Scrap scrap, int n) {
        this.head = scrap;
        this.tail = null;
        this.avail = n;
    }

    StorageBuffer(Scrap scrap, Scrap scrap2) {
        this.head = scrap;
        this.tail = scrap2;
        this.avail = scrap2.pos - scrap2.len - scrap.pos + scrap.len;
    }

    public int available() {
        return this.avail;
    }

    /*
     * Unable to fully structure code
     */
    public void writeTo(OutputStream var1_1) throws IOException {
        block11: {
            if (this.head == null) {
                throw new EOFException("error: buffer is empty");
            }
            var2_2 = Thread.interrupted();
            if (!this.readWriteMode) ** GOTO lbl34
            while (this.head != this.tail) {
                if (this.head.mode == 3) {
                    var3_4 = new byte[this.head.len];
                    System.arraycopy(this.head.buf, this.head.off, var3_4, 0, this.head.len);
                    this.head.buf = var3_4;
                    this.head.off = 0;
                    this.head.mode = 0;
                }
                var3_3 = 0;
                while (var3_3 < this.head.len) {
                    try {
                        var1_1.write(this.head.buf, this.head.off + var3_3, this.head.len - var3_3);
                        break;
                    }
                    catch (InterruptedIOException var4_6) {
                        var2_2 = true;
                        var3_3 += var4_6.bytesTransferred;
                    }
                }
                this.head = this.head.next;
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                var3_5 = 0;
                while (var3_5 < this.head.len) {
                    try {
                        var1_1.write(this.head.buf, this.head.off + var3_5, this.head.len - var3_5);
                        break;
                    }
                    catch (InterruptedIOException var4_7) {
                        var2_2 = true;
                        var3_5 += var4_7.bytesTransferred;
                    }
                }
                this.head = this.head.next;
lbl34:
                // 2 sources

                ** while (this.head != this.tail)
            }
        }
        this.head = null;
        this.avail = 0;
        if (var2_2) {
            Thread.currentThread().interrupt();
        }
    }

    public int next(OctetSeqHolder octetSeqHolder, IntHolder intHolder, IntHolder intHolder2) {
        if (this.head == null) {
            octetSeqHolder.value = null;
            intHolder.value = 0;
            return -1;
        }
        if (intHolder2.value < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readWriteMode && this.head.mode == 3) {
            byte[] byArray = new byte[this.head.len];
            System.arraycopy(this.head.buf, this.head.off, byArray, 0, this.head.len);
            this.head.buf = byArray;
            this.head.off = 0;
            this.head.mode = 0;
        }
        octetSeqHolder.value = this.head.buf;
        intHolder.value = this.head.off;
        if (intHolder2.value < this.head.len) {
            int n = intHolder2.value;
            intHolder2.value = 0;
            if (this.mark == null && this.tail == null || this.head == this.temphead) {
                this.head.off += n;
                this.head.len -= n;
            } else {
                this.temphead.buf = this.head.buf;
                this.temphead.off = this.head.off + n;
                this.temphead.len = this.head.len - n;
                this.temphead.mode = this.head.mode | 1;
                this.temphead.pos = this.head.pos;
                this.temphead.next = this.head.next;
                this.head = this.temphead;
            }
            this.avail -= n;
            return n;
        }
        int n = this.head.len;
        intHolder2.value -= n;
        this.head = this.head.next;
        if (this.head == this.tail) {
            this.head = null;
        }
        this.avail -= n;
        return n;
    }

    public int skip(IntHolder intHolder) {
        if (this.head == null) {
            return -1;
        }
        int n = 0;
        while (this.head != null && intHolder.value >= this.head.len) {
            intHolder.value -= this.head.len;
            this.avail -= this.head.len;
            n += this.head.len;
            this.head = this.head.next;
            if (this.head != this.tail) continue;
            this.head = null;
        }
        if (this.head != null && intHolder.value > 0) {
            if (this.mark == null && this.tail == null || this.head == this.temphead) {
                this.head.off += intHolder.value;
                this.head.len -= intHolder.value;
            } else {
                this.temphead.buf = this.head.buf;
                this.temphead.off = this.head.off + intHolder.value;
                this.temphead.len = this.head.len - intHolder.value;
                this.temphead.mode = this.head.mode | 1;
                this.temphead.pos = this.head.pos;
                this.temphead.next = this.head.next;
                this.head = this.temphead;
            }
            n += intHolder.value;
            this.avail -= intHolder.value;
            intHolder.value = 0;
        }
        return n;
    }

    public byte[] linearize() {
        if (this.head == null) {
            return new byte[0];
        }
        if (this.head.len != this.head.buf.length || this.head.next != this.tail || this.head.mode != 0 || this.head.off != 0) {
            byte[] byArray = new byte[this.avail];
            Scrap scrap = this.head;
            int n = this.head.pos - this.head.len;
            while (scrap != this.tail) {
                System.arraycopy(scrap.buf, scrap.off, byArray, n, scrap.len);
                n += scrap.len;
                scrap = scrap.next;
            }
            this.head.buf = byArray;
            this.head.off = 0;
            this.head.len = this.avail;
            this.head.mode = 0;
            this.head.pos = this.head.pos - this.head.len + this.avail;
            this.head.next = this.tail;
        }
        return this.head.buf;
    }

    public boolean isReadWriteMode() {
        return this.readWriteMode;
    }

    public void setReadWriteMode(boolean bl) {
        this.readWriteMode = bl;
    }

    public boolean mark() {
        if (this.mark == null) {
            this.mark = this.head;
            this.markavail = this.avail;
            return true;
        }
        return false;
    }

    public boolean reset() {
        if (this.mark != null) {
            this.head = this.mark;
            this.avail = this.markavail;
            this.mark = null;
            return true;
        }
        return false;
    }
}

