/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.openorb.io.HexPrintStream;
import org.openorb.net.Address;
import org.openorb.net.Transport;
import org.openorb.util.NamingUtils;

public abstract class AbstractAddress
implements Address,
Cloneable {
    private TargetAddress key_addr = null;
    private TargetAddress profile_addr = null;
    private TargetAddress reference_addr = null;
    private PolicyManagerOperations policies = null;
    private TaggedComponent[] components = null;
    private Object[] component_data = null;
    private int _fromThisProfile;
    private Constructor _ctor = null;
    private Object[] _args = null;
    private short _priority = 0;

    protected void set_ior(IOR iOR, int n) {
        if (iOR != null) {
            this.reference_addr = new TargetAddress();
            this.reference_addr.ior(new IORAddressingInfo(n, iOR));
            this.profile_addr = new TargetAddress();
            this.profile_addr.profile(iOR.profiles[n]);
        }
    }

    protected void set_oid(byte[] byArray) {
        if (byArray != null) {
            this.key_addr = new TargetAddress();
            this.key_addr.object_key(byArray);
        }
    }

    protected void set_policies(PolicyManagerOperations policyManagerOperations) {
        this.policies = policyManagerOperations;
    }

    protected void set_components(TaggedComponent[] taggedComponentArray, int n) {
        this.components = taggedComponentArray;
        this._fromThisProfile = n;
        this.component_data = new Object[taggedComponentArray.length];
    }

    public TargetAddress getTargetAddress(short s) {
        switch (s) {
            case 2: {
                if (this.reference_addr == null) break;
                return this.reference_addr;
            }
            case 1: {
                if (this.profile_addr == null) break;
                return this.profile_addr;
            }
            case 0: {
                if (this.key_addr == null) break;
                return this.key_addr;
            }
        }
        throw new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO);
    }

    public Policy[] get_target_policies(int[] nArray) {
        if (this.policies == null) {
            return new Policy[0];
        }
        return this.policies.get_policy_overrides(nArray);
    }

    public TaggedComponent[] get_components() {
        if (this.components == null) {
            return new TaggedComponent[0];
        }
        return this.components;
    }

    public int get_profile_components() {
        return this._fromThisProfile;
    }

    public TaggedComponent[] get_components(int n) {
        if (this.components == null) {
            return new TaggedComponent[0];
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.components.length) {
            if (this.components[n3].tag == n) {
                ++n2;
            }
            ++n3;
        }
        TaggedComponent[] taggedComponentArray = new TaggedComponent[n2];
        int n4 = this.components.length - 1;
        while (n4 >= 0 && n2 > 0) {
            if (this.components[n4].tag == n) {
                taggedComponentArray[--n2] = this.components[n4];
            }
            --n4;
        }
        return taggedComponentArray;
    }

    public TaggedComponent get_component(int n) {
        if (this.components == null || n < 0 || n >= this.components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        return this.components[n];
    }

    public Object get_component_data(int n) {
        if (this.components == null || n < 0 || n >= this.components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        return this.component_data[n];
    }

    public void set_component_data(int n, Object object) {
        if (this.components == null || n < 0 || n >= this.components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        this.component_data[n] = object;
    }

    public void setTransportConstructor(Constructor constructor, Object[] objectArray) {
        this._ctor = constructor;
        this._args = objectArray;
    }

    public Transport createTransport() {
        try {
            return (Transport)this._ctor.newInstance(this._args);
        }
        catch (Exception exception) {
            throw new INTERNAL();
        }
    }

    public short getPriority() {
        return this._priority;
    }

    public short getPriority(short s) {
        return (short)(this._priority & s);
    }

    public void setPriority(short s) {
        this._priority = (short)(s & 0xFFF);
    }

    public short setPriority(short s, short s2) {
        this._priority = (short)(this._priority & ~s2 | s & 0xFFF & s2);
        return this._priority;
    }

    public String getObjectKeyString() {
        byte[] byArray = this.key_addr.object_key();
        try {
            String string = new String(byArray, "UTF-8");
            return NamingUtils.encodeRFC2396(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unexpected exception" + unsupportedEncodingException.toString());
        }
    }

    public String getObjectKeyDescription() {
        String string = this.getObjectKeyString();
        if (string.indexOf("%") < 0) {
            return "Corbaloc Object Key: " + string + "\n";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HexPrintStream hexPrintStream = new HexPrintStream(byteArrayOutputStream, 2);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        byte[] byArray = this.key_addr.object_key();
        if (byArray[0] != 0 || byArray[1] != 79 || byArray[2] != 79) {
            printStream.println("Non OpenORB Object Key:");
        } else if ((byArray[3] & 1) == 0) {
            printStream.println("OpenORB Persistent Object Key:");
        } else {
            printStream.println("OpenORB Nonpersistent Object Key:");
        }
        printStream.flush();
        try {
            hexPrintStream.write(byArray);
            hexPrintStream.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected exception" + iOException.toString());
        }
        return byteArrayOutputStream.toString();
    }

    public int hashCode() {
        byte[] byArray = this.key_addr.object_key();
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = 311 * n + byArray[n2];
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Address) || this.hashCode() != object.hashCode()) {
            return false;
        }
        if (!(object instanceof AbstractAddress)) {
            return false;
        }
        AbstractAddress abstractAddress = (AbstractAddress)object;
        if (this.key_addr != abstractAddress.key_addr && !Arrays.equals(this.key_addr.object_key(), abstractAddress.key_addr.object_key())) {
            return false;
        }
        abstractAddress.key_addr = this.key_addr;
        if (!this._ctor.equals(abstractAddress._ctor) || this._args.length != abstractAddress._args.length) {
            return false;
        }
        int n = 0;
        while (n < this._args.length) {
            if ((this._args[n] instanceof String || this._args[n] instanceof Number) && !this._args[n].equals(abstractAddress._args[n])) {
                return false;
            }
            ++n;
        }
        if (this.components.length != abstractAddress.components.length) {
            return false;
        }
        if (this.components != abstractAddress.components) {
            int n2;
            boolean[] blArray = new boolean[this.components.length];
            int n3 = 0;
            while (n3 < this.components.length) {
                n2 = 0;
                int n4 = 0;
                while (n4 < this.components.length) {
                    if (this.components[n3] == this.components[n4] || this.components[n3].tag == abstractAddress.components[n4].tag && Arrays.equals(this.components[n3].component_data, abstractAddress.components[n4].component_data)) {
                        abstractAddress.components[n4] = this.components[n3];
                        blArray[n4] = true;
                        n2 = 1;
                        break;
                    }
                    ++n4;
                }
                if (n2 == 0) {
                    return false;
                }
                ++n3;
            }
            n2 = 0;
            while (n2 < blArray.length) {
                if (!blArray[n2]) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public abstract String getEndpointDescription();

    public abstract String getEndpointString();

    public abstract String getProtocol();
}

