/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.InvalidSlot;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ObjectStub;
import org.openorb.PI.CurrentImpl;
import org.openorb.net.Address;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientRequest;
import org.openorb.policy.PolicyReconciler;

public abstract class AbstractClientRequest
extends LocalObject
implements ClientRequest {
    private org.omg.CORBA.ORB orb;
    private Object target;
    private Delegate target_deleg;
    private IOR target_ior;
    private Object effective_target;
    private IOR effective_target_ior;
    private java.lang.Object _transportAssociation;
    private ClientChannel channel;
    private Address address;
    private CurrentImpl piCurrent;
    private CurrentOperations piCurrEntry;
    private PolicyReconciler orb_reconciler = null;
    private Map service_contexts = new HashMap();
    private int request_id;

    public AbstractClientRequest(int n, Object object, Address address, java.lang.Object object2, ClientChannel clientChannel) {
        this.address = address;
        this.channel = clientChannel;
        this.target = object;
        this.request_id = n;
        this._transportAssociation = object2;
        this.target_deleg = (Delegate)((ObjectImpl)object)._get_delegate();
        this.target_ior = this.target_deleg.ior();
        this.orb = ((ObjectImpl)object)._orb();
        this.piCurrent = ((ORB)this.orb).getPICurrent();
        this.piCurrEntry = this.piCurrent.copy(this.piCurrent.get());
    }

    public ClientChannel channel() {
        return this.channel;
    }

    public Address address() {
        return this.address;
    }

    public int request_id() {
        return this.request_id;
    }

    public boolean equals(java.lang.Object object) {
        if (object instanceof Integer) {
            return this.request_id == (Integer)object;
        }
        if (object instanceof ClientRequest) {
            return this.request_id == ((ClientRequest)object).request_id();
        }
        return false;
    }

    public IOR target_ior() {
        return this.target_ior;
    }

    public Object target() {
        return this.target;
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public IOR effective_target_ior() {
        if (this.effective_target_ior == null) {
            this.effective_target_ior = this.address.getTargetAddress((short)2).ior().ior;
        }
        return this.effective_target_ior;
    }

    public Object effective_target() {
        if (this.effective_target == null) {
            this.effective_target = new ObjectStub(this.orb, this.effective_target_ior());
        }
        return this.effective_target;
    }

    public java.lang.Object get_transport_association() {
        return this._transportAssociation;
    }

    public boolean checkReplyTransportAssoc(java.lang.Object object) {
        return this._transportAssociation.equals(object);
    }

    public TaggedProfile effective_profile() {
        return this.address.getTargetAddress((short)1).profile();
    }

    public TaggedComponent get_effective_component(int n) {
        return this.get_effective_components(n)[0];
    }

    public TaggedComponent[] get_effective_components(int n) {
        TaggedComponent[] taggedComponentArray = this.address.get_components(n);
        if (taggedComponentArray == null || taggedComponentArray.length == 0) {
            throw new BAD_PARAM(83099673, this.state_completion_status());
        }
        return taggedComponentArray;
    }

    public Policy get_request_policy(int n) {
        Policy policy = null;
        try {
            policy = this.target_deleg.get_client_policy(this.target, n);
        }
        catch (INV_POLICY iNV_POLICY) {
            // empty catch block
        }
        Policy policy2 = null;
        int[] nArray = new int[]{n};
        Policy[] policyArray = this.address.get_target_policies(nArray);
        if (policyArray.length > 0) {
            policy2 = policyArray[0];
        }
        if (policy == null && policy2 == null) {
            throw new INV_POLICY("Policy type not found", 83099649, this.state_completion_status());
        }
        if (this.orb_reconciler == null) {
            this.orb_reconciler = (PolicyReconciler)((ORB)this.orb).getFeature("PolicyReconciler");
            if (this.orb_reconciler == null) {
                throw new INTERNAL();
            }
        }
        return this.orb_reconciler.reconcile_policies(n, policy, policy2, null);
    }

    public Parameter[] arguments() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public TypeCode[] exceptions() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public String[] contexts() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public String[] operation_context() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public Any result() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public Any get_slot(int n) throws InvalidSlot {
        if (this.piCurrEntry == null) {
            Map map = this.service_contexts;
            synchronized (map) {
                if (this.piCurrEntry == null) {
                    this.piCurrEntry = this.piCurrent.create();
                }
            }
        }
        return this.piCurrEntry.get_slot(n);
    }

    public void add_request_service_context(ServiceContext serviceContext, boolean bl) {
        if (this.state() != 0) {
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
        Integer n = new Integer(serviceContext.context_id);
        Map map = this.service_contexts;
        synchronized (map) {
            if (!bl && this.service_contexts.containsKey(n)) {
                throw new BAD_INV_ORDER(83099659, this.state_completion_status());
            }
            this.service_contexts.put(n, serviceContext);
        }
    }

    public ServiceContext get_request_service_context(int n) {
        ServiceContext serviceContext = null;
        Map map = this.service_contexts;
        synchronized (map) {
            serviceContext = (ServiceContext)this.service_contexts.get(new Integer(n));
        }
        if (serviceContext == null) {
            throw new BAD_PARAM(83099671, this.state_completion_status());
        }
        return serviceContext;
    }

    public ServiceContext[] get_request_service_contexts() {
        Map map = this.service_contexts;
        synchronized (map) {
            ServiceContext[] serviceContextArray = this.service_contexts.values().toArray(new ServiceContext[this.service_contexts.size()]);
            return serviceContextArray;
        }
    }

    public CompletionStatus state_completion_status() {
        switch (this.state()) {
            case 0: 
            case 1: {
                return CompletionStatus.COMPLETED_NO;
            }
            case 2: {
                return CompletionStatus.COMPLETED_MAYBE;
            }
            case 3: {
                return CompletionStatus.COMPLETED_YES;
            }
            case 4: {
                switch (this.reply_status()) {
                    case -2: 
                    case -1: 
                    case 0: 
                    case 2: {
                        return CompletionStatus.COMPLETED_YES;
                    }
                    case 1: {
                        return this.received_system_exception().completed;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        return CompletionStatus.COMPLETED_NO;
                    }
                }
            }
        }
        throw new Error("assert failed");
    }

    public abstract String received_exception_id();

    public abstract SystemException received_system_exception();

    public abstract IOR forward_reference_ior();

    public abstract InputStream receive_response();

    public abstract int wait_for_response(long var1);

    public abstract boolean poll_response();

    public abstract int send_request();

    public abstract OutputStream begin_marshal();

    public abstract boolean is_locate();

    public abstract boolean is_poll();

    public abstract boolean is_request();

    public abstract boolean cancel(SystemException var1);

    public abstract int state();

    public abstract Any received_exception();

    public abstract ServiceContext get_reply_service_context(int var1);

    public abstract Object forward_reference();

    public abstract short reply_status();

    public abstract short sync_scope();

    public abstract boolean response_expected();

    public abstract String operation();
}

