/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.RequestCallback;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.adapter.TargetInfo;
import org.openorb.net.AdapterHoldingException;
import org.openorb.net.ServerChannel;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerRequest;
import org.openorb.util.Trace;

public abstract class AbstractServerRequest
extends LocalObject
implements ServerRequest {
    private org.omg.CORBA.ORB _orb;
    private ServerManager _serverManager;
    private ServerChannel _channel;
    private java.lang.Object _transportAssociation;
    private int _requestID;
    private byte[] _objectKey;
    private String _operation;
    private byte _syncScope;
    private ServiceContext[] _requestServiceContexts;
    private InputStream _argumentStream;
    private CurrentImpl _piCurrent;
    private CurrentOperations _rsPICurrEntry;
    private CurrentOperations _tsPICurrEntry;
    private Map _serviceContexts = new HashMap();
    private org.openorb.PI.ServerManager _interceptorManager = null;
    private RequestCallback _callback = null;
    private java.lang.Object _syncState = new java.lang.Object();
    private int _state = -1;
    private short _replyStatus = Short.MIN_VALUE;
    private ObjectAdapter _adapter = null;
    private TargetInfo _target;
    private OutputStream _replyStream;
    private Object _forwardReference;
    private IOR _forwardReferenceIOR;
    private SystemException _sendingSystemException;
    private Any _sendingSystemExceptionAny = null;
    private String _sendingSystemExceptionID;
    private static final short REPLY_STATUS_UNSET = Short.MIN_VALUE;

    public AbstractServerRequest(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n, InputStream inputStream, byte[] byArray, String string, byte by, ServiceContext[] serviceContextArray) {
        this.init_one(serverManager, serverChannel, object, n, inputStream);
        this.init(byArray, string, by, serviceContextArray);
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n, InputStream inputStream) {
        this.init_one(serverManager, serverChannel, object, n, inputStream);
    }

    private void init_one(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n, InputStream inputStream) {
        this._serverManager = serverManager;
        this._channel = serverChannel;
        this._transportAssociation = object;
        this._requestID = n;
        this._argumentStream = inputStream;
        this._orb = this._serverManager.orb();
        this._piCurrent = ((ORB)this._orb).getPICurrent();
    }

    public void init(byte[] byArray, String string, byte by, ServiceContext[] serviceContextArray) {
        if (this._state >= 0) {
            Trace.assert(false);
        }
        this._objectKey = byArray;
        this._operation = string;
        this._syncScope = by;
        this._requestServiceContexts = serviceContextArray;
        if (this._operation != null) {
            this._interceptorManager = (org.openorb.PI.ServerManager)((ORB)this._orb).getFeature("ServerInterceptorManager");
            if (this._interceptorManager != null) {
                this._callback = new RequestCallback(){

                    public void reply_system_exception(SystemException systemException) {
                        AbstractServerRequest.this.handle_system_exception(systemException);
                    }

                    public void reply_runtime_exception(RuntimeException runtimeException) {
                        AbstractServerRequest.this.handle_runtime_exception(runtimeException);
                    }

                    public void reply_error(Error error) {
                        AbstractServerRequest.this.handle_error(error);
                    }

                    public void reply_location_forward(Object object, boolean bl) {
                        AbstractServerRequest.this.handle_location_forward(object, bl);
                    }
                };
            }
        }
        this._state = 0;
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n, byte[] byArray) {
        this.init_one(serverManager, serverChannel, object, n, null);
        this.init(byArray, null, (byte)3, null);
    }

    public AbstractServerRequest(ServerManager serverManager, ServerChannel serverChannel, java.lang.Object object, int n) {
        this.init_one(serverManager, serverChannel, object, n, null);
    }

    public void init(byte[] byArray) {
        this.init(byArray, null, (byte)3, null);
    }

    public org.omg.CORBA.ORB orb() {
        return this._orb;
    }

    public ServerChannel channel() {
        return this._channel;
    }

    public java.lang.Object get_transport_association() {
        return this._transportAssociation;
    }

    public boolean checkRequestTransportAssoc(java.lang.Object object) {
        return this._transportAssociation.equals(object);
    }

    public int state() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            int n = this._state;
            return n;
        }
    }

    protected CompletionStatus state_completion_status() {
        switch (this._state) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                return CompletionStatus.COMPLETED_NO;
            }
            case 3: {
                return CompletionStatus.COMPLETED_MAYBE;
            }
            case 4: 
            case 5: {
                return CompletionStatus.COMPLETED_YES;
            }
        }
        throw new Error("assert failed");
    }

    public boolean is_locate() {
        return this._operation == null;
    }

    public byte[] object_key() {
        return this._objectKey;
    }

    public int request_id() {
        return this._requestID;
    }

    public boolean equals(java.lang.Object object) {
        if (object instanceof Integer) {
            return this._requestID == (Integer)object;
        }
        if (object instanceof ServerRequest) {
            ServerRequest serverRequest = (ServerRequest)object;
            return this._requestID == serverRequest.request_id() && this._channel == serverRequest.channel();
        }
        return false;
    }

    public String operation() {
        return this._operation;
    }

    public boolean response_expected() {
        return this._syncScope == 3;
    }

    public short sync_scope() {
        return this._syncScope;
    }

    public Parameter[] arguments() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public TypeCode[] exceptions() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public String[] contexts() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public String[] operation_context() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public Any result() {
        throw new NO_RESOURCES(83099649, this.state_completion_status());
    }

    public Any get_slot(int n) throws InvalidSlot {
        java.lang.Object object;
        if (this._rsPICurrEntry == null) {
            object = this._syncState;
            synchronized (object) {
                if (this._rsPICurrEntry == null) {
                    this._rsPICurrEntry = this._piCurrent.create();
                }
            }
        }
        object = this._rsPICurrEntry;
        synchronized (object) {
            Any any = this._rsPICurrEntry.get_slot(n);
            return any;
        }
    }

    public void set_slot(int n, Any any) throws InvalidSlot {
        java.lang.Object object;
        if (this._rsPICurrEntry == null) {
            object = this._syncState;
            synchronized (object) {
                if (this._rsPICurrEntry == null) {
                    this._rsPICurrEntry = this._piCurrent.create();
                }
            }
        }
        object = this._rsPICurrEntry;
        synchronized (object) {
            this._rsPICurrEntry.set_slot(n, any);
        }
    }

    public ServiceContext get_request_service_context(int n) {
        int n2 = 0;
        while (n2 < this._requestServiceContexts.length) {
            if (this._requestServiceContexts[n2].context_id == n) {
                return this._requestServiceContexts[n2];
            }
            ++n2;
        }
        throw new BAD_PARAM(83099671, this.state_completion_status());
    }

    public void client_cancel() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._state == 5) {
                return;
            }
            if (this._syncScope != 3) {
                switch (this._state) {
                    case 3: 
                    case 4: {
                        return;
                    }
                }
            }
            this.handle_system_exception(new TRANSIENT(83099650, this.state_completion_status()));
            if (this._state != 0 && this._interceptorManager != null) {
                this._interceptorManager.send_exception(this, this._callback);
                this._interceptorManager = null;
            }
            this._state = 5;
            if (this._target != null) {
                this._adapter.cancel_dispatch(this, this._target);
            }
            this.release_request();
        }
    }

    public void server_cancel(SystemException systemException) {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._state == 5) {
                return;
            }
            this.handle_system_exception(systemException);
            if (this._target != null) {
                this._adapter.cancel_dispatch(this, this._target);
            }
            this.complete_request();
        }
    }

    public ObjectAdapter find_adapter() throws AdapterDestroyedException, AdapterHoldingException {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this._state) {
                case 5: {
                    ObjectAdapter objectAdapter = this._adapter;
                    return objectAdapter;
                }
                case 2: {
                    ObjectAdapter objectAdapter = this._adapter;
                    return objectAdapter;
                }
                case 0: {
                    if (this._interceptorManager != null) {
                        this._interceptorManager.receive_request_service_contexts(this, this._callback);
                        if (this._replyStatus != Short.MIN_VALUE) {
                            this._interceptorManager = null;
                            this.complete_request();
                            ObjectAdapter objectAdapter = null;
                            return objectAdapter;
                        }
                    }
                    this._state = 1;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new BAD_INV_ORDER(83099658, this.state_completion_status());
                }
            }
            this._tsPICurrEntry = this._piCurrent.copy(this._rsPICurrEntry);
            this._piCurrent.set(this._tsPICurrEntry);
            try {
                this._adapter = this._serverManager.find_adapter(this._objectKey, false);
            }
            catch (SystemException systemException) {
                systemException.completed = CompletionStatus.COMPLETED_NO;
                this.handle_system_exception(systemException);
            }
            catch (Error error) {
                this.handle_error(error);
            }
            catch (RuntimeException runtimeException) {
                this.handle_runtime_exception(runtimeException);
            }
            if (this._adapter != null) {
                this._state = 2;
                ObjectAdapter objectAdapter = this._adapter;
                return objectAdapter;
            }
            if (this._replyStatus == Short.MIN_VALUE) {
                this.handle_system_exception(new OBJECT_NOT_EXIST(83099650, CompletionStatus.COMPLETED_NO));
            }
            this.complete_request();
            ObjectAdapter objectAdapter = null;
            return objectAdapter;
        }
    }

    public ObjectAdapter adapter() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._adapter == null) {
                throw new BAD_INV_ORDER(83099658, this.state_completion_status());
            }
            ObjectAdapter objectAdapter = this._adapter;
            return objectAdapter;
        }
    }

    public byte[] adapter_id() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._target == null) {
                throw new BAD_INV_ORDER(83099658, this.state_completion_status());
            }
            byte[] byArray = this._target.getAdapterID();
            return byArray;
        }
    }

    public byte[] object_id() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._target == null) {
                throw new BAD_INV_ORDER(83099658, this.state_completion_status());
            }
            byte[] byArray = this._target.getObjectID();
            return byArray;
        }
    }

    public String target_most_derived_interface() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._target == null) {
                throw new BAD_INV_ORDER(83099658, this.state_completion_status());
            }
            String string = this._target.getRepositoryID();
            return string;
        }
    }

    public Policy get_server_policy(int n) {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._adapter == null) {
                throw new BAD_INV_ORDER(83099658, this.state_completion_status());
            }
            int[] nArray = new int[]{n};
            Policy[] policyArray = this._adapter.get_server_policies(nArray);
            if (policyArray.length >= 1) {
                Policy policy = policyArray[0];
                return policy;
            }
            throw new INV_POLICY(83099649, this.state_completion_status());
        }
    }

    public boolean target_is_a(String string) {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            boolean bl = this._target.targetIsA(string);
            return bl;
        }
    }

    public void dispatch() throws AdapterDestroyedException {
        int n;
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this._state) {
                case 5: {
                    return;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new BAD_INV_ORDER(83099658, this.state_completion_status());
                }
            }
            this._piCurrent.set(this._tsPICurrEntry);
            try {
                this._target = this._adapter.predispatch(this);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                this._state = 1;
                throw adapterDestroyedException;
            }
            catch (ForwardRequest forwardRequest) {
                this.handle_location_forward(forwardRequest.forward, forwardRequest.permanent);
            }
            catch (SystemException systemException) {
                systemException.completed = CompletionStatus.COMPLETED_NO;
                this.handle_system_exception(systemException);
            }
            catch (Error error) {
                this.handle_error(error);
            }
            catch (RuntimeException runtimeException) {
                this.handle_runtime_exception(runtimeException);
            }
            if (this._replyStatus != Short.MIN_VALUE) {
                this.complete_request();
                return;
            }
            if (this._interceptorManager != null) {
                this._interceptorManager.receive_request(this, this._callback);
                if (this._replyStatus != Short.MIN_VALUE) {
                    this._interceptorManager = null;
                    this._adapter.cancel_dispatch(this, this._target);
                    this.complete_request();
                    return;
                }
            }
            this._rsPICurrEntry = this._tsPICurrEntry;
            switch (this._syncScope) {
                case 0: {
                    this.release_request();
                    break;
                }
                case 1: 
                case 2: {
                    try {
                        this._replyStream = this.begin_marshal_reply();
                        this.complete_reply(this._replyStream);
                    }
                    catch (SystemException systemException) {
                        systemException.completed = CompletionStatus.COMPLETED_NO;
                        this.handle_system_exception(systemException);
                    }
                    catch (Error error) {
                        this.handle_error(error);
                    }
                    catch (RuntimeException runtimeException) {
                        this.handle_runtime_exception(runtimeException);
                    }
                    this.release_request();
                    if (this._replyStatus == Short.MIN_VALUE) break;
                    this._state = 5;
                    this._adapter.cancel_dispatch(this, this._target);
                    if (this._interceptorManager != null) {
                        this._interceptorManager.send_exception(this, this._callback);
                    }
                    return;
                }
            }
            this._state = 3;
        }
        Throwable throwable = null;
        try {
            this._adapter.dispatch(this, this._target);
            n = 0;
        }
        catch (SystemException systemException) {
            throwable = systemException;
            n = 1;
        }
        catch (Error error) {
            throwable = error;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
            n = 3;
        }
        java.lang.Object object2 = this._syncState;
        synchronized (object2) {
            if (this._state == 5) {
                return;
            }
            switch (n) {
                case 0: {
                    if (this._state != 3) break;
                    if (this.is_locate()) {
                        this._replyStatus = (short)-1;
                        break;
                    }
                    if (this._syncScope == 3) {
                        try {
                            this.createReply();
                        }
                        catch (SystemException systemException) {
                            systemException.completed = CompletionStatus.COMPLETED_YES;
                            this.handle_system_exception(systemException);
                        }
                        catch (Error error) {
                            this.handle_error(error);
                        }
                        catch (RuntimeException runtimeException) {
                            this.handle_runtime_exception(runtimeException);
                        }
                        break;
                    }
                    this._replyStatus = 0;
                    break;
                }
                case 1: {
                    if (this._state == 4) {
                        throwable.completed = CompletionStatus.COMPLETED_YES;
                    }
                    this.handle_system_exception((SystemException)throwable);
                    break;
                }
                case 2: {
                    this.handle_error((Error)throwable);
                    break;
                }
                case 3: {
                    this.handle_runtime_exception((RuntimeException)throwable);
                }
            }
            this.complete_request();
        }
    }

    public InputStream argument_stream() {
        return this._argumentStream;
    }

    public void add_reply_service_context(ServiceContext serviceContext, boolean bl) {
        Integer n = new Integer(serviceContext.context_id);
        Map map = this._serviceContexts;
        synchronized (map) {
            if (!bl && this._serviceContexts.containsKey(n)) {
                throw new BAD_INV_ORDER(83099659, this.state_completion_status());
            }
            this._serviceContexts.put(n, serviceContext);
        }
    }

    public ServiceContext get_reply_service_context(int n) {
        ServiceContext serviceContext = null;
        Map map = this._serviceContexts;
        synchronized (map) {
            serviceContext = (ServiceContext)this._serviceContexts.get(new Integer(n));
        }
        if (serviceContext == null) {
            throw new BAD_PARAM(83099671, this.state_completion_status());
        }
        return serviceContext;
    }

    public ServiceContext[] get_reply_service_contexts() {
        Map map = this._serviceContexts;
        synchronized (map) {
            ServiceContext[] serviceContextArray = this._serviceContexts.values().toArray(new ServiceContext[this._serviceContexts.size()]);
            return serviceContextArray;
        }
    }

    public short reply_status() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._replyStatus == Short.MIN_VALUE) {
                throw new BAD_INV_ORDER(83099658, this.state_completion_status());
            }
            short s = this._replyStatus;
            return s;
        }
    }

    public Object forward_reference() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this.reply_status()) {
                case 3: 
                case 4: {
                    Object object2 = this._forwardReference;
                    return object2;
                }
            }
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
    }

    public IOR forward_reference_ior() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this.reply_status()) {
                case 3: 
                case 4: {
                    if (this._forwardReferenceIOR == null) {
                        this._forwardReferenceIOR = ((Delegate)((ObjectImpl)this._forwardReference)._get_delegate()).ior();
                    }
                    IOR iOR = this._forwardReferenceIOR;
                    return iOR;
                }
            }
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
    }

    public Any sending_exception() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            switch (this.reply_status()) {
                case 1: {
                    if (this._sendingSystemExceptionAny == null) {
                        this._sendingSystemExceptionAny = this._orb.create_any();
                        SystemExceptionHelper.insert(this._sendingSystemExceptionAny, this._sendingSystemException);
                    }
                    Any any = this._sendingSystemExceptionAny;
                    return any;
                }
                case 2: {
                    throw new NO_RESOURCES(83099649, this.state_completion_status());
                }
            }
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
    }

    public SystemException sending_system_exception() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this.reply_status() == 1) {
                SystemException systemException = this._sendingSystemException;
                return systemException;
            }
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
    }

    public String sending_system_exception_id() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this.reply_status() == 1) {
                String string = this._sendingSystemExceptionID;
                return string;
            }
            throw new BAD_INV_ORDER(83099658, this.state_completion_status());
        }
    }

    private void handle_system_exception(SystemException systemException) {
        this._sendingSystemExceptionAny = null;
        this._sendingSystemException = systemException;
        this._sendingSystemExceptionID = SystemExceptionHelper.id(systemException);
        this._replyStatus = 1;
    }

    private void handle_error(Error error) {
        if (error instanceof ThreadDeath) {
            throw error;
        }
        if (error instanceof OutOfMemoryError) {
            this.handle_system_exception(new NO_MEMORY(0, this.state_completion_status()));
        } else if (error instanceof StackOverflowError) {
            this.handle_system_exception(new NO_RESOURCES(0, this.state_completion_status()));
        } else {
            Trace.exception("Intercepted in AbstractServerRequest", error);
            UnknownException unknownException = new UnknownException(error);
            unknownException.completed = this.state_completion_status();
            this.handle_system_exception(unknownException);
        }
    }

    private void handle_runtime_exception(RuntimeException runtimeException) {
        Trace.exception("Handle runtime exception", runtimeException);
        UnknownException unknownException = new UnknownException(runtimeException);
        unknownException.completed = this.state_completion_status();
        this.handle_system_exception(unknownException);
    }

    private void handle_location_forward(Object object, boolean bl) {
        this._forwardReference = object;
        this._forwardReferenceIOR = null;
        this._replyStatus = (short)(bl ? 4 : 3);
    }

    public OutputStream createReply() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this.is_locate()) {
                throw new BAD_INV_ORDER(1146056709, this.state_completion_status());
            }
            if (this._replyStatus == 1) {
                throw this._sendingSystemException;
            }
            if (this._syncScope != 3) {
                OutputStream outputStream = this._orb.create_output_stream();
                return outputStream;
            }
            this._replyStatus = 0;
            if (this._interceptorManager != null) {
                this._interceptorManager.send_reply(this, this._callback);
                this._interceptorManager = null;
                if (this._replyStatus == 1) {
                    throw this._sendingSystemException;
                }
            }
            this._state = 4;
            OutputStream outputStream = this._replyStream = this.begin_marshal_reply();
            return outputStream;
        }
    }

    public OutputStream createExceptionReply() {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this.is_locate()) {
                throw new BAD_INV_ORDER(1146056709, this.state_completion_status());
            }
            if (this._state == 5 || this._syncScope != 3) {
                if (this._replyStatus == 1) {
                    throw this._sendingSystemException;
                }
                OutputStream outputStream = this._orb.create_output_stream();
                return outputStream;
            }
            this._replyStatus = (short)2;
            if (this._interceptorManager != null) {
                this._interceptorManager.send_exception(this, this._callback);
                this._interceptorManager = null;
                if (this._replyStatus == 1) {
                    throw this._sendingSystemException;
                }
            }
            this._state = 4;
            OutputStream outputStream = this._replyStream = this.begin_marshal_user_exception();
            return outputStream;
        }
    }

    private void complete_request() {
        Trace.assert(this._replyStatus != Short.MIN_VALUE, "Completing request without setting reply status.");
        if (this._state != 0 && this._interceptorManager != null) {
            switch (this._replyStatus) {
                case 0: {
                    this._interceptorManager.send_reply(this, this._callback);
                    break;
                }
                case 1: {
                    this._interceptorManager.send_exception(this, this._callback);
                    break;
                }
                case 3: 
                case 4: {
                    this._interceptorManager.send_other(this, this._callback);
                }
            }
        }
        if (this._syncScope != 3) {
            this._state = 5;
            return;
        }
        try {
            switch (this._replyStatus) {
                case -1: {
                    this.marshal_locate_reply(true);
                    break;
                }
                case -2: {
                    this.marshal_locate_reply(false);
                    break;
                }
                case 0: 
                case 2: {
                    this.complete_reply(this._replyStream);
                    break;
                }
                case 1: {
                    this.marshal_system_exception(this._sendingSystemExceptionID, this._sendingSystemException);
                    break;
                }
                case 3: {
                    this.marshal_forward_request(this._forwardReference, false);
                    break;
                }
                case 4: {
                    this.marshal_forward_request(this._forwardReference, true);
                }
            }
        }
        catch (SystemException systemException) {
            Trace.high(this.toString(), "Transport failure while replying to request: " + systemException.toString());
        }
        catch (Error error) {
            Trace.high(this.toString(), "Java error while replying to request" + error.toString());
        }
        catch (RuntimeException runtimeException) {
            Trace.high(this.toString(), "Java runtime exception while replying to request" + runtimeException.toString());
        }
        this._state = 5;
        this.release_request();
    }

    protected abstract void marshal_system_exception(String var1, SystemException var2);

    protected abstract void marshal_forward_request(Object var1, boolean var2);

    protected abstract void marshal_locate_reply(boolean var1);

    protected abstract OutputStream begin_marshal_reply();

    protected abstract OutputStream begin_marshal_user_exception();

    protected abstract void complete_reply(OutputStream var1);

    protected abstract void release_request();
}

