/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.util.Comparator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.net.Address;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientRequest;
import org.openorb.net.RebindChannelException;
import org.openorb.net.ServerManager;

public class ClientBinding {
    public static final int DEAD_PRIORITY = Integer.MAX_VALUE;
    private Address _address;
    private ClientChannel _channel;
    private java.lang.Object _transportAssociation;
    private ObjectAdapter _adapter = null;
    private SystemException _exception;
    private int _priority = 0;
    private byte[] _oid = null;
    private int _forcedMarshal;
    private ServerManager _serverManager;
    private static final int FORCE_UNSET = -1;
    private static final int FORCE_FALSE = 0;
    private static final int FORCE_TRUE = 1;
    public static final int MASK_ADDRESS_PRIORITY = 4095;
    public static final int MASK_PROFILE_PRIORITY = 61440;
    public static final int MASK_IOR_PRIORITY = 0xFF0000;
    public static final Comparator priorityComp = new PriorityComparator();

    protected ClientBinding(Address address) {
        this._address = address;
        this._forcedMarshal = -1;
        this._priority = address.getPriority();
    }

    public ClientBinding(Address address, ClientChannel clientChannel, java.lang.Object object) {
        this._address = address;
        this._channel = clientChannel;
        this._transportAssociation = object;
        this._forcedMarshal = 1;
        this._priority = address.getPriority();
    }

    public ClientBinding(Address address, ClientChannel clientChannel, java.lang.Object object, ServerManager serverManager) {
        this._address = address;
        this._channel = clientChannel;
        this._transportAssociation = object;
        this._serverManager = serverManager;
        this._forcedMarshal = -1;
        this._priority = address.getPriority();
    }

    public ClientBinding(Address address, SystemException systemException) {
        this._address = address;
        this._exception = systemException;
        this._priority = Integer.MAX_VALUE;
        this._forcedMarshal = 0;
    }

    public Address getAddress() {
        return this._address;
    }

    public ClientChannel getClientChannel() {
        return this._channel;
    }

    /*
     * Unable to fully structure code
     */
    public ObjectAdapter getObjectAdapter() {
        if (this._serverManager != null) ** GOTO lbl13
        return null;
lbl-1000:
        // 1 sources

        {
            if (this._oid == null) {
                this._oid = this._address.getTargetAddress((short)0).object_key();
            }
            try {
                this._adapter = this._serverManager.find_adapter(this._oid);
                if (this._adapter == null) {
                    return null;
                }
                this._forcedMarshal = -1;
                continue;
            }
            catch (AdapterDestroyedException var1_1) {
                var1_1.getObjectAdapter().wait_for_destroy();
            }
lbl13:
            // 3 sources

            ** while (this._adapter == null)
        }
lbl14:
        // 1 sources

        return this._adapter;
    }

    public int getPriority() {
        if (this._exception != null) {
            return Integer.MAX_VALUE;
        }
        if (this._adapter != null) {
            return this._priority | this._adapter.cache_priority() & 0xFF000000;
        }
        return this._priority | this._channel.state();
    }

    public void setPriority(int n) {
        this._priority = n > 0 ? n & 0xFFF000 | this._priority & 0xFF000FFF : n;
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public boolean equals(java.lang.Object object) {
        if (!(object instanceof ClientBinding)) {
            return false;
        }
        return this._address.equals(((ClientBinding)object)._address);
    }

    public boolean local_invoke() {
        if (this._forcedMarshal == -1) {
            while (true) {
                this.getObjectAdapter();
                if (this._adapter == null) {
                    this._forcedMarshal = 1;
                    break;
                }
                try {
                    this._forcedMarshal = this._adapter.forced_marshal(this._oid) ? 1 : 0;
                }
                catch (AdapterDestroyedException adapterDestroyedException) {
                    this._adapter = null;
                    continue;
                }
                break;
            }
        }
        return this._forcedMarshal == 0;
    }

    public ClientRequest create_request(Object object, String string, boolean bl) {
        if (this._exception != null) {
            throw this._exception;
        }
        while (this._channel != null) {
            try {
                return this._channel.create_request(object, this._address, this._transportAssociation, string, bl);
            }
            catch (RebindChannelException rebindChannelException) {
                this._channel = rebindChannelException.getClientChannel();
                this._transportAssociation = rebindChannelException.getTransportAssociation();
                continue;
            }
            break;
        }
        return null;
    }

    public ClientRequest create_locate_request(Object object) {
        if (this._exception != null) {
            throw this._exception;
        }
        while (this._channel != null) {
            try {
                return this._channel.create_locate_request(object, this._address, this._transportAssociation);
            }
            catch (RebindChannelException rebindChannelException) {
                this._channel = rebindChannelException.getClientChannel();
                this._transportAssociation = rebindChannelException.getTransportAssociation();
                continue;
            }
            break;
        }
        return null;
    }

    public ServantObject servant_preinvoke(String string, Class clazz) throws ForwardRequest {
        ServantObject servantObject;
        ObjectAdapter objectAdapter;
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._serverManager == null) {
            throw new INTERNAL();
        }
        while (true) {
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                return null;
            }
            try {
                servantObject = objectAdapter.servant_preinvoke(this._oid, string, clazz);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
        if (servantObject == null) {
            this._forcedMarshal = -1;
            return null;
        }
        LocalServant localServant = new LocalServant();
        localServant.adapter = objectAdapter;
        localServant.orig_serv = servantObject;
        localServant.servant = servantObject.servant;
        return localServant;
    }

    public void servant_postinvoke(ServantObject servantObject) {
        if (this._exception != null) {
            throw this._exception;
        }
        if (!(servantObject instanceof LocalServant)) {
            throw new INTERNAL();
        }
        LocalServant localServant = (LocalServant)servantObject;
        localServant.adapter.servant_postinvoke(this._oid, localServant.orig_serv);
    }

    public boolean locate() throws ForwardRequest {
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._serverManager == null) {
            throw new INTERNAL();
        }
        ObjectAdapter objectAdapter;
        while ((objectAdapter = this.getObjectAdapter()) != null) {
            try {
                return objectAdapter.locate(this._oid);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
        return false;
    }

    public boolean is_a(String string) throws ForwardRequest {
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._serverManager == null) {
            throw new INTERNAL();
        }
        while (true) {
            ObjectAdapter objectAdapter;
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return objectAdapter.is_a(this._oid, string);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
    }

    public Object get_interface_def() throws ForwardRequest {
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._serverManager == null) {
            throw new INTERNAL();
        }
        while (true) {
            ObjectAdapter objectAdapter;
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return objectAdapter.get_interface_def(this._oid);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
    }

    public DomainManager[] get_domain_managers() throws ForwardRequest {
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._serverManager == null) {
            throw new INTERNAL();
        }
        while (true) {
            ObjectAdapter objectAdapter;
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return objectAdapter.get_domain_managers(this._oid);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
    }

    public Object get_component() throws ForwardRequest {
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._serverManager == null) {
            throw new INTERNAL();
        }
        while (true) {
            ObjectAdapter objectAdapter;
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return objectAdapter.get_component(this._oid);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
    }

    private static class PriorityComparator
    implements Comparator {
        private PriorityComparator() {
        }

        public int compare(java.lang.Object object, java.lang.Object object2) {
            if (object == null) {
                if (object2 == null) {
                    return 0;
                }
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
            int n = ((ClientBinding)object).getPriority();
            int n2 = ((ClientBinding)object2).getPriority();
            if (n < 0) {
                if (n2 < 0) {
                    return 0;
                }
                return -1;
            }
            if (n2 < 0) {
                return 1;
            }
            int n3 = n2 - n;
            return n > n2 ? 1 : (n < n2 ? -1 : 0);
        }

        public boolean equals(java.lang.Object object) {
            return object == this;
        }
    }

    private static class LocalServant
    extends ServantObject {
        ObjectAdapter adapter;
        ServantObject orig_serv;

        private LocalServant() {
        }
    }
}

