/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.IOP.IOR;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.net.Address;
import org.openorb.net.Channel;
import org.openorb.net.ClientBinding;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientProtocol;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerManager;
import org.openorb.policy.ProfilePriorityPolicy;
import org.openorb.policy.ProfilePriorityPolicyHelper;

public class ClientManagerImpl
implements ClientManager {
    private org.omg.CORBA.ORB _orb;
    private Map _protocols = new HashMap();
    private Map _channels = new HashMap();
    private ServerManager _serverManager;
    private java.lang.Object _syncState = new java.lang.Object();
    private ThreadGroup _rootGroup;
    private boolean _useStaticThreadGroup = false;
    private static ThreadGroup _staticWorkThreads;
    private ThreadGroup _workThreads;
    private Thread _channelReaper;
    private boolean _shutdown = false;
    private int _pause;
    private static final int DEFAULT_PAUSE_TIME = 120000;

    public ClientManagerImpl(org.omg.CORBA.ORB oRB) {
        this(oRB, null);
    }

    public ClientManagerImpl(org.omg.CORBA.ORB oRB, ServerManager serverManager) {
        this._orb = oRB;
        this._serverManager = serverManager;
        this._rootGroup = Thread.currentThread().getThreadGroup();
        this._pause = ((ORB)oRB).getLoader().getIntProperty("openorb.client.reapPauseDelay", 120000);
        this._useStaticThreadGroup = ((ORB)oRB).getLoader().getBooleanProperty("openorb.useStaticThreadGroup", false);
    }

    public org.omg.CORBA.ORB orb() {
        return this._orb;
    }

    public ServerManager getServerManager() {
        return this._serverManager;
    }

    public ClientBinding[] create_bindings(Object object, IOR iOR) {
        int n = iOR.profiles.length;
        IORAddressingInfo iORAddressingInfo = new IORAddressingInfo(0, iOR);
        ProfilePriorityPolicy profilePriorityPolicy = null;
        try {
            Delegate delegate = (Delegate)((ObjectImpl)object)._get_delegate();
            profilePriorityPolicy = ProfilePriorityPolicyHelper.narrow(delegate.get_client_policy(object, 1146057217));
        }
        catch (INV_POLICY iNV_POLICY) {
            // empty catch block
        }
        ArrayList<ClientBinding> arrayList = new ArrayList<ClientBinding>(8);
        int n2 = 0;
        while (n2 < n) {
            ClientProtocol clientProtocol;
            int n3;
            int n4 = iOR.profiles[n2].tag;
            int n5 = n3 = profilePriorityPolicy == null ? 8 : (int)profilePriorityPolicy.find_priority(n4);
            if (n3 != -1 && (clientProtocol = (ClientProtocol)this._protocols.get(new Integer(n4))) != null) {
                iORAddressingInfo.selected_profile_index = n2;
                Address[] addressArray = clientProtocol.createAddresses(iORAddressingInfo);
                int n6 = 0;
                while (n6 < addressArray.length) {
                    ClientBinding clientBinding = clientProtocol.createBinding(addressArray[n6]);
                    clientBinding.setPriority(clientBinding.getPriority() & 0xFFFF0FFF | n3 << 12 & 0xF000);
                    arrayList.add(clientBinding);
                    ++n6;
                }
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            throw new INV_OBJREF();
        }
        ClientBinding[] clientBindingArray = new ClientBinding[arrayList.size()];
        clientBindingArray = arrayList.toArray(clientBindingArray);
        return clientBindingArray;
    }

    public void register_protocol(int n, ClientProtocol clientProtocol) {
        this._protocols.put(new Integer(n), clientProtocol);
    }

    public boolean register_channel(ClientChannel clientChannel) {
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (this._shutdown) {
                boolean bl = false;
                return bl;
            }
            Map map = this._channels;
            synchronized (map) {
                if (this._channels.containsKey(clientChannel)) {
                    boolean bl = true;
                    return bl;
                }
                if (this._workThreads == null || this._workThreads.isDestroyed()) {
                    if (this._useStaticThreadGroup) {
                        if (_staticWorkThreads == null || _staticWorkThreads.isDestroyed()) {
                            _staticWorkThreads = new ThreadGroup(this._rootGroup, "Client IO");
                        }
                        this._workThreads = _staticWorkThreads;
                    } else {
                        this._workThreads = new ThreadGroup(this._rootGroup, "Client IO");
                    }
                }
                if (this._channelReaper == null && this._pause > 0) {
                    this._channelReaper = new Thread(this._workThreads, new Runnable(){

                        public void run() {
                            ClientManagerImpl.this.channel_reaper();
                        }
                    }, "Channel Reaper");
                    this._channelReaper.setDaemon(true);
                    this._channelReaper.start();
                }
                Thread[] threadArray = new Thread[2];
                threadArray[0] = new Thread(this._workThreads, new ChannelRecvRunnable(clientChannel), "Recieve Worker for " + clientChannel.toString());
                threadArray[0].setDaemon(true);
                threadArray[0].start();
                threadArray[1] = new Thread(this._workThreads, new ChannelSendRunnable(clientChannel), "Send Worker for " + clientChannel.toString());
                threadArray[1].setDaemon(true);
                threadArray[1].start();
                this._channels.put(clientChannel, threadArray);
                boolean bl = true;
                return bl;
            }
        }
    }

    public void unregister_channel(ClientChannel clientChannel) {
        Thread[] threadArray;
        Map map = this._channels;
        synchronized (map) {
            threadArray = (Thread[])this._channels.remove(clientChannel);
        }
        if (threadArray != null) {
            Thread thread = Thread.currentThread();
            threadArray[0].interrupt();
            while (threadArray[0] != thread && threadArray[0].isAlive()) {
                try {
                    threadArray[0].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threadArray[1].interrupt();
            while (threadArray[1] != thread && threadArray[1].isAlive()) {
                try {
                    threadArray[1].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdown(boolean bl, boolean bl2) {
        boolean bl3 = false;
        Thread thread = null;
        java.lang.Object object = this._syncState;
        synchronized (object) {
            if (!this._shutdown) {
                this._shutdown = true;
                bl3 = true;
                if (this._channelReaper != null) {
                    this._channelReaper.interrupt();
                    thread = this._channelReaper;
                }
            }
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (bl3) {
            ClientChannel[] clientChannelArray;
            Map map = this._channels;
            synchronized (map) {
                clientChannelArray = new ClientChannel[this._channels.size()];
                this._channels.keySet().toArray(clientChannelArray);
            }
            int n = 0;
            while (n < clientChannelArray.length) {
                clientChannelArray[n].close(bl2, new BAD_INV_ORDER(0x4F40004, CompletionStatus.COMPLETED_MAYBE));
                ++n;
            }
        }
        if (!this._useStaticThreadGroup && this._workThreads != null) {
            this._workThreads.setDaemon(true);
            try {
                this._workThreads.destroy();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    private void channel_reaper() {
        int n = RequestIDAllocator.get_request_id();
        ClientChannel[] clientChannelArray = null;
        while (!this._shutdown) {
            try {
                Thread.sleep(this._pause);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            Map map = this._channels;
            synchronized (map) {
                if (this._channels.isEmpty()) {
                    this._channelReaper = null;
                    break;
                }
                if (clientChannelArray == null || clientChannelArray.length < this._channels.size()) {
                    clientChannelArray = new ClientChannel[this._channels.size()];
                }
                clientChannelArray = this._channels.keySet().toArray(clientChannelArray);
            }
            int n2 = 0;
            while (n2 < clientChannelArray.length && clientChannelArray[n2] != null) {
                if (clientChannelArray[n2].state() == 0x11000000 && clientChannelArray[n2].channel_age() < n) {
                    clientChannelArray[n2].pause();
                }
                clientChannelArray[n2] = null;
                ++n2;
            }
            n = RequestIDAllocator.get_request_id();
        }
    }

    private static class ChannelSendRunnable
    implements Runnable {
        Channel _chan;

        public ChannelSendRunnable(Channel channel) {
            this._chan = channel;
        }

        public void run() {
            this._chan.run_send();
        }
    }

    private class ChannelRecvRunnable
    implements Runnable {
        ClientChannel _chan;

        public ChannelRecvRunnable(ClientChannel clientChannel) {
            this._chan = clientChannel;
        }

        public void run() {
            this._chan.run_recv();
        }
    }
}

