/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.ComponentSet;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.net.AdapterHoldingException;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerChannel;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerProtocol;
import org.openorb.net.ServerRequest;
import org.openorb.util.Trace;

public class ServerManagerImpl
implements ServerManager {
    protected static final byte SEP_VAL = -2;
    protected static final byte ESC_VAL = -3;
    protected static final byte FLAG_PUID = 1;
    protected byte[] _puid;
    private byte[] _suid;
    private org.omg.CORBA.ORB _orb;
    private ThreadGroup _rootGroup;
    private static final SystemException QUEUE_FULL_EX = new TRANSIENT(1146056705, CompletionStatus.COMPLETED_NO);
    private static final SystemException DISCARD_EX = new TRANSIENT(83099649, CompletionStatus.COMPLETED_NO);
    private static final SystemException INACTIVE_EX = new OBJ_ADAPTER(83099649, CompletionStatus.COMPLETED_NO);
    private static final SystemException DESTROYED_EX = new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
    private static final SystemException SHUTDOWN_EX = new BAD_INV_ORDER(0x4F40004, CompletionStatus.COMPLETED_NO);
    private final Object _syncIO = new Object();
    private ThreadGroup _ioThreads;
    private static ThreadGroup _staticIOThreads;
    private boolean _useStaticThreadGroup;
    private Object[] _protProfIDs = new Object[0];
    private Map _protToWorker = new HashMap();
    private Map _channels = new HashMap();
    private Thread _channelReaper = null;
    private int _reapCloseTime;
    private static final int DEFAULT_CLOSE_TIME = 600000;
    private Object _syncState = new Object();
    private boolean _shutdown = false;
    private boolean _running = false;
    private boolean _ioComplete = false;
    private ObjectAdapter _defaultAdapter = null;
    private Map _adapterCache = new HashMap();
    private boolean _allowPool = false;
    private ThreadGroup _poolThreads;
    private static ThreadGroup _staticPoolThreads;
    private Thread[] _poolThreadArray = new Thread[10];
    private int _maxThreadPoolSize = 5;
    private int _minThreadPoolSize = 1;
    private int _optThreadPoolSize = 0;
    private int _threadPoolSize = 0;
    private Set _serverThreads = new HashSet();
    private QueueEntry _queueHead = null;
    private QueueEntry _queueMiddle = null;
    private QueueEntry _queueTail = null;
    private int _activeRequests = 0;
    private int _tpMaxActiveRequests = 0;
    private int _tpMaxActiveRequestsPrev = 0;
    private int _maxQueueSize = 0;
    private int _holdingRequests = 0;
    private int _maxManagerHeldRequests = 0;
    private Thread _stThread = null;
    private QueueEntry _stHead = null;
    private QueueEntry _stTail = null;
    private Codec _componentCodec;
    private static final int POOL_ID_WAIT = -1;
    private static final int POOL_ID_NO_WAIT = -2;

    public ServerManagerImpl(org.omg.CORBA.ORB oRB) {
        this._orb = oRB;
        ORBLoader oRBLoader = ((ORB)oRB).getLoader();
        try {
            byte[] byArray = oRBLoader.getStringProperty("openorb.server.alias", "").getBytes("UTF-8");
            this._suid = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, this._suid, 0, byArray.length);
            this._suid[byArray.length] = -2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new INITIALIZE(unsupportedEncodingException.toString());
        }
        this._maxQueueSize = oRBLoader.getIntProperty("openorb.server.maxQueueSize", Integer.MAX_VALUE);
        this._maxManagerHeldRequests = oRBLoader.getIntProperty("openorb.server.maxManagerHeldRequests", Integer.MAX_VALUE);
        this._minThreadPoolSize = oRBLoader.getIntProperty("openorb.server.minThreadPoolSize", 1);
        this._maxThreadPoolSize = oRBLoader.getIntProperty("openorb.server.maxThreadPoolSize", 10);
        this._rootGroup = Thread.currentThread().getThreadGroup();
        long l = System.currentTimeMillis();
        this._puid = new byte[8];
        this._puid[7] = (byte)(l >>> 56);
        this._puid[6] = (byte)(l >>> 48);
        this._puid[5] = (byte)(l >>> 40);
        this._puid[4] = (byte)(l >>> 32);
        this._puid[3] = (byte)(l >>> 24);
        this._puid[2] = (byte)(l >>> 16);
        this._puid[1] = (byte)(l >>> 8);
        this._puid[0] = (byte)l;
        this._reapCloseTime = oRBLoader.getIntProperty("openorb.server.reapCloseDelay", 600000);
        this._useStaticThreadGroup = oRBLoader.getBooleanProperty("openorb.useStaticThreadGroup", false);
    }

    public org.omg.CORBA.ORB orb() {
        return this._orb;
    }

    public void setThreadPoolLimits(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid thread pool size range");
        }
        Object object = this._syncState;
        synchronized (object) {
            this._minThreadPoolSize = n;
            this._maxThreadPoolSize = n2;
        }
    }

    public void setMaxQueueSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid max queue size");
        }
        Object object = this._syncState;
        synchronized (object) {
            this._maxQueueSize = n;
        }
    }

    public void setMaxManagerHeldRequests(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid max held requests");
        }
        Object object = this._syncState;
        synchronized (object) {
            this._maxManagerHeldRequests = n;
        }
    }

    public byte[] create_cacheable_object_key(boolean bl, byte[][] byArray) {
        int n;
        int n2 = 4 + (bl ? this._suid.length : this._puid.length) + byArray.length - 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            n2 += byArray[n4].length;
            int n5 = 0;
            while (n5 < byArray[n4].length) {
                switch (byArray[n4][n5]) {
                    case -3: 
                    case -2: {
                        ++n3;
                    }
                }
                ++n5;
            }
            ++n4;
        }
        byte[] byArray2 = new byte[n2 += n3];
        byArray2[0] = 0;
        byArray2[1] = 79;
        byArray2[2] = 79;
        if (bl) {
            byArray2[3] = 0;
            System.arraycopy(this._suid, 0, byArray2, 4, this._suid.length);
            n = 4 + this._suid.length;
        } else {
            byArray2[3] = 1;
            System.arraycopy(this._puid, 0, byArray2, 4, this._puid.length);
            n = 4 + this._puid.length;
        }
        int n6 = 0;
        while (n6 < byArray.length && n3 > 0) {
            int n7 = 0;
            while (n7 < byArray[n6].length) {
                switch (byArray[n6][n7]) {
                    case -3: 
                    case -2: {
                        byArray2[n++] = -3;
                        --n3;
                    }
                }
                byArray2[n] = byArray[n6][n7];
                ++n7;
                ++n;
            }
            if (n < byArray2.length) {
                byArray2[n++] = -2;
            }
            ++n6;
        }
        while (n6 < byArray.length) {
            System.arraycopy(byArray[n6], 0, byArray2, n, byArray[n6].length);
            if ((n += byArray[n6].length) < byArray2.length) {
                byArray2[n++] = -2;
            }
            ++n6;
        }
        return byArray2;
    }

    public byte[][] extract_cacheable_object_key(byte[] byArray) {
        int[] nArray = this.find_object_key_offsets(byArray);
        if (nArray == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[nArray.length][];
        int n = byArray.length;
        int n2 = byArrayArray.length - 1;
        while (n2 >= 0) {
            int n3 = nArray[n2];
            int n4 = 0;
            int n5 = n3;
            while (n5 < n) {
                if (byArray[n5] == -3) {
                    ++n5;
                    ++n4;
                }
                ++n5;
            }
            byArrayArray[n2] = new byte[n - n3 - n4];
            if (n4 == 0) {
                System.arraycopy(byArray, n3, byArrayArray[n2], 0, n - n3);
            } else {
                int n6 = n3;
                int n7 = 0;
                while (n6 < n) {
                    if (byArray[n6] == -3) {
                        ++n6;
                    }
                    byArrayArray[n2][n7] = byArray[n6];
                    ++n6;
                    ++n7;
                }
            }
            n = n3 - 1;
            --n2;
        }
        return byArrayArray;
    }

    private int[] find_object_key_offsets(byte[] byArray) {
        if (!this.is_local_cacheable_object_key(byArray)) {
            return null;
        }
        int n = 4;
        n = (byArray[3] & 1) == 1 ? (n += this._puid.length) : (n += this._suid.length);
        int n2 = 1;
        int n3 = n;
        while (n3 < byArray.length) {
            switch (byArray[n3]) {
                case -2: {
                    ++n2;
                    break;
                }
                case -3: {
                    ++n3;
                }
            }
            ++n3;
        }
        int[] nArray = new int[n2];
        nArray[0] = n;
        int n4 = 1;
        int n5 = n;
        while (n5 < byArray.length && n4 < nArray.length) {
            switch (byArray[n5]) {
                case -2: {
                    nArray[n4++] = n5 + 1;
                    break;
                }
                case -3: {
                    ++n5;
                }
            }
            ++n5;
        }
        return nArray;
    }

    public boolean is_cacheable_object_key(byte[] byArray) {
        return byArray.length >= 4 && byArray[0] == 0 && byArray[1] == 79 && byArray[2] == 79;
    }

    public boolean is_suid_object_key(byte[] byArray) {
        return byArray.length >= 4 && (byArray[3] & 1) == 0;
    }

    public boolean is_local_cacheable_object_key(byte[] byArray) {
        if (!this.is_cacheable_object_key(byArray)) {
            return false;
        }
        if ((byArray[3] & 1) == 1) {
            if (byArray.length - 4 < this._puid.length) {
                return false;
            }
            int n = 0;
            while (n < this._puid.length) {
                if (byArray[n + 4] != this._puid[n]) {
                    return false;
                }
                ++n;
            }
        } else {
            if (byArray.length - 4 < this._suid.length) {
                return false;
            }
            int n = 0;
            while (n < this._suid.length) {
                if (byArray[n + 4] != this._suid[n]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public void register_protocol(int n, ServerProtocol serverProtocol) {
        if (serverProtocol == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this._protProfIDs.length) {
            if (this._protProfIDs[n2] == serverProtocol && n == (Integer)this._protProfIDs[n2 + 1]) {
                return;
            }
            ++n2;
        }
        Object[] objectArray = new Object[this._protProfIDs.length + 2];
        System.arraycopy(this._protProfIDs, 0, objectArray, 0, this._protProfIDs.length);
        objectArray[this._protProfIDs.length] = serverProtocol;
        objectArray[this._protProfIDs.length + 1] = new Integer(n);
        this._protProfIDs = objectArray;
    }

    public IOR construct_ior(String string, byte[] byArray, ComponentSet componentSet) {
        Object object;
        Object object2;
        IOR iOR = new IOR();
        iOR.type_id = string;
        int n = 0;
        TaggedComponent[] taggedComponentArray = componentSet.getComponents(1);
        if (taggedComponentArray != null && taggedComponentArray.length > 0) {
            iOR.profiles = new TaggedProfile[this._protProfIDs.length / 2 + 1];
        } else {
            taggedComponentArray = null;
            iOR.profiles = new TaggedProfile[this._protProfIDs.length / 2];
        }
        int n2 = 0;
        while (n2 < this._protProfIDs.length) {
            object2 = (ServerProtocol)this._protProfIDs[n2];
            int n3 = (Integer)this._protProfIDs[n2 + 1];
            object = object2.create_profile(n3, componentSet, byArray);
            if (object != null) {
                iOR.profiles[n++] = object;
            }
            n2 += 2;
        }
        if (n == 0) {
            return null;
        }
        if (taggedComponentArray != null) {
            object2 = this._orb.create_any();
            TaggedComponentSeqHelper.insert((Any)object2, taggedComponentArray);
            Codec codec = this.getComponentCodec();
            try {
                object = codec.encode_value((Any)object2);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                throw new INTERNAL(invalidTypeForEncoding.toString());
            }
            iOR.profiles[n++] = new TaggedProfile(1, (byte[])object);
        }
        if (n < iOR.profiles.length) {
            object2 = new TaggedProfile[n];
            System.arraycopy(iOR.profiles, 0, object2, 0, n);
            iOR.profiles = object2;
        }
        return iOR;
    }

    private Codec getComponentCodec() {
        if (this._componentCodec == null) {
            try {
                CodecFactory codecFactory = (CodecFactory)this._orb.resolve_initial_references("CodecFactory");
                this._componentCodec = codecFactory.create_codec(new Encoding(0, 1, 0));
            }
            catch (UserException userException) {
                throw new InternalError(userException.toString());
            }
        }
        return this._componentCodec;
    }

    public IOR merge_iors(String string, IOR[] iORArray) {
        HashSet<ProfileMember> hashSet = new HashSet<ProfileMember>();
        int n = 0;
        while (n < iORArray.length) {
            int n2 = 0;
            while (n2 < iORArray[n].profiles.length) {
                hashSet.add(new ProfileMember(iORArray[n].profiles[n2]));
                ++n2;
            }
            ++n;
        }
        IOR iOR = new IOR(string, new TaggedProfile[hashSet.size()]);
        int n3 = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            iOR.profiles[n3++] = ((ProfileMember)iterator.next())._profile;
        }
        return iOR;
    }

    public void protocol_listening(ServerProtocol serverProtocol) {
        Object object = this._syncIO;
        synchronized (object) {
            if (this._shutdown) {
                return;
            }
            if (this._ioThreads == null || this._ioThreads.isDestroyed()) {
                if (this._useStaticThreadGroup) {
                    if (_staticIOThreads == null || _staticIOThreads.isDestroyed()) {
                        _staticIOThreads = new ThreadGroup(this._rootGroup, "Server IO");
                    }
                    this._ioThreads = _staticIOThreads;
                } else {
                    this._ioThreads = new ThreadGroup(this._rootGroup, "Server IO");
                }
            }
            Thread thread = new Thread(this._ioThreads, new ProtocolRunner(serverProtocol), "Worker for " + serverProtocol.toString());
            thread.setDaemon(true);
            thread.start();
            this._protToWorker.put(serverProtocol, thread);
        }
    }

    public void protocol_not_listening(ServerProtocol serverProtocol, boolean bl) {
        Thread thread;
        Object object = this._syncIO;
        synchronized (object) {
            if (bl) {
                thread = (Thread)this._protToWorker.get(serverProtocol);
                if (thread != null) {
                    this._protToWorker.put(serverProtocol, null);
                }
            } else {
                thread = (Thread)this._protToWorker.remove(serverProtocol);
            }
        }
        if (thread != null) {
            Thread thread2 = Thread.currentThread();
            thread.interrupt();
            while (thread != thread2 && thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void register_channel(ServerChannel serverChannel) {
        Object object = this._syncIO;
        synchronized (object) {
            if (this._shutdown) {
                return;
            }
            if (this._channels.containsKey(serverChannel)) {
                return;
            }
            if (this._ioThreads == null || this._ioThreads.isDestroyed()) {
                if (this._useStaticThreadGroup) {
                    if (_staticIOThreads == null || _staticIOThreads.isDestroyed()) {
                        _staticIOThreads = new ThreadGroup(this._rootGroup, "Server IO");
                    }
                    this._ioThreads = _staticIOThreads;
                } else {
                    this._ioThreads = new ThreadGroup(this._rootGroup, "Server IO");
                }
            }
            Thread[] threadArray = new Thread[2];
            threadArray[0] = new Thread(this._ioThreads, new ChannelRecvRunner(serverChannel), "Recieve Worker for " + serverChannel.toString());
            threadArray[0].setDaemon(true);
            threadArray[0].start();
            threadArray[1] = new Thread(this._ioThreads, new ChannelSendRunner(serverChannel), "Send Worker for " + serverChannel.toString());
            threadArray[1].setDaemon(true);
            threadArray[1].start();
            this._channels.put(serverChannel, threadArray);
        }
    }

    public void unregister_channel(ServerChannel serverChannel) {
        Thread[] threadArray;
        Object object = this._syncIO;
        synchronized (object) {
            threadArray = (Thread[])this._channels.remove(serverChannel);
        }
        if (threadArray != null) {
            Thread thread = Thread.currentThread();
            threadArray[0].interrupt();
            while (threadArray[0] != thread && threadArray[0].isAlive()) {
                try {
                    threadArray[0].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threadArray[1].interrupt();
            while (threadArray[1] != thread && threadArray[1].isAlive()) {
                try {
                    threadArray[1].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void channel_reaper() {
        int n = RequestIDAllocator.get_request_id();
        ServerChannel[] serverChannelArray = new ServerChannel[]{};
        while (!this._shutdown) {
            try {
                Thread.sleep(this._reapCloseTime);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            Object object = this._syncState;
            synchronized (object) {
                this._tpMaxActiveRequestsPrev = this._tpMaxActiveRequests;
                this._tpMaxActiveRequests = this._activeRequests;
                this.recalcOptThreadPoolSize();
                if (this._optThreadPoolSize < this._threadPoolSize) {
                    this._syncState.notifyAll();
                }
                Object object2 = this._syncIO;
                synchronized (object2) {
                    if (this._shutdown) {
                        return;
                    }
                    if (this._channels.isEmpty()) {
                        continue;
                    }
                    serverChannelArray = this._channels.keySet().toArray(serverChannelArray);
                }
            }
            int n2 = 0;
            while (n2 < serverChannelArray.length && serverChannelArray[n2] != null) {
                if (serverChannelArray[n2].channel_age() < n) {
                    serverChannelArray[n2].soft_close(false);
                }
                ++n2;
            }
            n = RequestIDAllocator.get_request_id();
        }
    }

    public ObjectAdapter find_adapter(byte[] byArray) throws AdapterDestroyedException {
        try {
            return this.find_adapter(byArray, true);
        }
        catch (AdapterHoldingException adapterHoldingException) {
            Trace.assert(false);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectAdapter find_adapter(byte[] byArray, boolean bl) throws AdapterDestroyedException, AdapterHoldingException {
        boolean bl2;
        ObjectAdapter objectAdapter;
        block36: {
            Object object;
            SystemException systemException;
            block35: {
                if (!this.is_cacheable_object_key(byArray)) {
                    return this._defaultAdapter;
                }
                if (!this.is_local_cacheable_object_key(byArray)) {
                    return null;
                }
                int[] nArray = this.find_object_key_offsets(byArray);
                ProgressiveAIDKey progressiveAIDKey = new ProgressiveAIDKey(byArray, nArray);
                AdapterValue adapterValue = null;
                Object object2 = this._syncState;
                synchronized (object2) {
                    progressiveAIDKey.useHash(nArray.length - 1);
                    adapterValue = (AdapterValue)this._adapterCache.get(progressiveAIDKey);
                    if (adapterValue != null) {
                        ++adapterValue._hits;
                        return adapterValue._adapter;
                    }
                    int n = nArray.length - 2;
                    while (true) {
                        if (n < 0 || adapterValue != null) {
                            // MONITOREXIT @DISABLED, blocks:[20, 6, 31] lbl19 : MonitorExitStatement: MONITOREXIT : var6_6
                            if (adapterValue != null) break;
                            return null;
                        }
                        progressiveAIDKey.useHash(n);
                        adapterValue = (AdapterValue)this._adapterCache.get(progressiveAIDKey);
                        --n;
                    }
                }
                objectAdapter = adapterValue._adapter;
                if (objectAdapter.object_id(byArray) != null) {
                    ++adapterValue._hits;
                    return objectAdapter;
                }
                boolean bl3 = false;
                bl2 = false;
                try {
                    do {
                        Object object3;
                        if (!bl) {
                            systemException = null;
                            object3 = (AdapterManagerImpl)objectAdapter.getAdapterManager();
                            if (object3 != null || !bl3 && objectAdapter.single_threaded()) {
                                Object object4 = this._syncState;
                                synchronized (object4) {
                                    if (!bl3 && objectAdapter.single_threaded()) {
                                        if (this._stThread == Thread.currentThread()) {
                                            bl3 = true;
                                        } else {
                                            if (this._stThread != null) {
                                                throw new AdapterHoldingException(objectAdapter);
                                            }
                                            this._stThread = Thread.currentThread();
                                            bl2 = true;
                                            bl3 = true;
                                        }
                                    }
                                    if (object3 != null) {
                                        switch (((AdapterManagerImpl)object3)._state.value()) {
                                            case 1: {
                                                break;
                                            }
                                            case 2: {
                                                systemException = DISCARD_EX;
                                                break;
                                            }
                                            case 0: {
                                                throw new AdapterHoldingException(objectAdapter);
                                            }
                                            case 3: {
                                                systemException = INACTIVE_EX;
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        try {
                            objectAdapter = objectAdapter.find_adapter(byArray);
                        }
                        catch (AdapterDestroyedException adapterDestroyedException) {
                            object3 = adapterDestroyedException.getAdapterID();
                            int n = this.find_object_key_offsets((byte[])object3)[0];
                            AdapterValue adapterValue2 = new AdapterValue((byte[])object3, n, adapterDestroyedException.getObjectAdapter());
                            Object object5 = this._syncState;
                            synchronized (object5) {
                                if (this._adapterCache.containsKey(adapterValue2)) throw adapterDestroyedException;
                                this._adapterCache.put(adapterValue2, adapterValue2);
                                throw adapterDestroyedException;
                            }
                        }
                        if (objectAdapter != null) continue;
                        systemException = null;
                        Object var17_19 = null;
                        if (!bl2) return systemException;
                        object = this._syncState;
                        break block35;
                    } while (objectAdapter.object_id(byArray) == null);
                    break block36;
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    if (!bl2) throw throwable;
                    Object object6 = this._syncState;
                    synchronized (object6) {
                        this._stThread = null;
                        throw throwable;
                    }
                }
            }
            synchronized (object) {
                this._stThread = null;
                return systemException;
            }
        }
        Object var17_20 = null;
        if (bl2) {
            Object object = this._syncState;
            synchronized (object) {
                this._stThread = null;
            }
        }
        if (objectAdapter.cache_priority() < 0) return objectAdapter;
        this.register_adapter(objectAdapter.adapter_id(byArray), objectAdapter);
        return objectAdapter;
    }

    public void register_adapter(byte[] byArray, ObjectAdapter objectAdapter) {
        if (byArray.length == 0) {
            if (this._defaultAdapter == null) {
                this._defaultAdapter = objectAdapter;
            }
            return;
        }
        if (!this.is_local_cacheable_object_key(byArray)) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        int n = this.find_object_key_offsets(byArray)[0];
        AdapterValue adapterValue = new AdapterValue(byArray, n, objectAdapter);
        AdapterManagerImpl adapterManagerImpl = (AdapterManagerImpl)objectAdapter.getAdapterManager();
        Object object = this._syncState;
        synchronized (object) {
            if (this._adapterCache.containsKey(adapterValue)) {
                return;
            }
            if (adapterManagerImpl != null) {
                adapterManagerImpl._managedAdapters.put(objectAdapter, objectAdapter);
            }
            this._adapterCache.put(adapterValue, adapterValue);
        }
    }

    public void unregister_adapter(byte[] byArray) {
        if (byArray.length == 0) {
            this._defaultAdapter = null;
            return;
        }
        if (!this.is_local_cacheable_object_key(byArray)) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        int n = this.find_object_key_offsets(byArray)[0];
        AdapterValue adapterValue = new AdapterValue(byArray, n, null);
        boolean bl = false;
        Object object = this._syncState;
        synchronized (object) {
            AdapterManagerImpl adapterManagerImpl;
            adapterValue = (AdapterValue)this._adapterCache.remove(adapterValue);
            if (adapterValue == null) {
                return;
            }
            if (adapterValue._refindHead != null) {
                if (this._queueHead == null) {
                    bl = true;
                }
                this._activeRequests += adapterValue._refindCount;
                this._holdingRequests -= adapterValue._refindCount;
                adapterValue._refindCount = 0;
                if (this._queueMiddle == null) {
                    adapterValue._refindTail._next = this._queueHead;
                    this._queueHead = adapterValue._refindHead;
                } else {
                    adapterValue._refindTail = this._queueMiddle._next;
                    this._queueMiddle._next = adapterValue._refindHead;
                }
                this._queueMiddle = adapterValue._refindTail;
                adapterValue._refindHead = null;
                adapterValue._refindTail = null;
            }
            if ((adapterManagerImpl = (AdapterManagerImpl)adapterValue._adapter.getAdapterManager()) != null && adapterManagerImpl._managedAdapters.remove(adapterValue._adapter) != null) {
                bl = true;
            }
            if (bl) {
                this._syncState.notifyAll();
            }
        }
    }

    public ServerManager.AdapterManager create_adapter_manager() {
        return new AdapterManagerImpl();
    }

    public void enqueue_request(ServerRequest serverRequest) {
        Object object = this._syncState;
        synchronized (object) {
            if (this._shutdown) {
                serverRequest.server_cancel(SHUTDOWN_EX);
            }
            if (this._maxQueueSize == 0 || this._activeRequests < this._maxQueueSize) {
                if (this._queueHead == null) {
                    this._queueHead = this._queueTail = new QueueEntry(serverRequest);
                    this._syncState.notifyAll();
                } else {
                    this._queueTail = this._queueTail._next = new QueueEntry(serverRequest);
                }
                ++this._activeRequests;
                if (this._activeRequests > this._tpMaxActiveRequests) {
                    this._tpMaxActiveRequests = this._activeRequests;
                    this.recalcOptThreadPoolSize();
                }
                if (this._threadPoolSize < this._minThreadPoolSize) {
                    this.extend_thread_pool(this._minThreadPoolSize - this._threadPoolSize);
                } else if (this._threadPoolSize < this._maxThreadPoolSize && this._activeRequests > this._threadPoolSize) {
                    this.extend_thread_pool(1);
                }
                return;
            }
        }
        serverRequest.server_cancel(QUEUE_FULL_EX);
    }

    private void recalcOptThreadPoolSize() {
        this._optThreadPoolSize = this._tpMaxActiveRequestsPrev > this._tpMaxActiveRequests ? (this._tpMaxActiveRequests + this._tpMaxActiveRequestsPrev) / 2 : this._tpMaxActiveRequests * 11 / 10;
    }

    public boolean work_pending() {
        Object object = this._syncState;
        synchronized (object) {
            if (this._shutdown) {
                boolean bl = false;
                return bl;
            }
            if (!this._running) {
                Object object2 = this._syncIO;
                synchronized (object2) {
                    boolean bl = !this._channels.isEmpty();
                    return bl;
                }
            }
            boolean bl = this._queueHead != null;
            return bl;
        }
    }

    public boolean serve_request(boolean bl) {
        return this.thread_pool_main(bl ? -1 : -2);
    }

    private boolean thread_pool_main(int n) {
        QueueEntry queueEntry = null;
        boolean bl = false;
        while (true) {
            Object object = this._syncState;
            synchronized (object) {
                if (this._shutdown || n >= this._optThreadPoolSize && n >= this._minThreadPoolSize) {
                    if (bl) {
                        this._stThread = null;
                        bl = false;
                    }
                    if (n >= 0) {
                        this._poolThreadArray[n] = null;
                        --this._threadPoolSize;
                        Trace.high("ServerManager", "Thread pool shrunk");
                    }
                    this._serverThreads.remove(Thread.currentThread());
                    this._syncState.notifyAll();
                    boolean bl2 = queueEntry != null;
                    return bl2;
                }
                if (n < 0) {
                    if (!this._running) {
                        this.startup(false, false);
                    }
                    this._serverThreads.add(Thread.currentThread());
                }
                if ((this._stThread == null || bl) && this._stHead != null) {
                    if (!bl) {
                        this._stThread = Thread.currentThread();
                        bl = true;
                    }
                    queueEntry = this._stHead;
                    this._stHead = this._stHead._next;
                    ++this._activeRequests;
                    --this._holdingRequests;
                    if (this._stHead == null) {
                        this._stTail = null;
                    }
                } else {
                    if (bl) {
                        this._stThread = null;
                        bl = false;
                    }
                    if (this._queueHead == null) {
                        block24: {
                            if (n == -2) {
                                this._serverThreads.remove(Thread.currentThread());
                                this._syncState.notifyAll();
                                boolean bl3 = false;
                                return bl3;
                            }
                            try {
                                this._syncState.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                if (n != -1) break block24;
                                Thread.currentThread().interrupt();
                                boolean bl4 = false;
                                return bl4;
                            }
                        }
                        continue;
                    }
                    queueEntry = this._queueHead;
                    this._queueHead = this._queueHead._next;
                    queueEntry._next = null;
                    if (this._queueHead == null) {
                        this._queueTail = null;
                    }
                    if (queueEntry == this._queueMiddle) {
                        this._queueMiddle = null;
                    }
                }
            }
            this.serve_request(queueEntry, bl);
            if (n < 0) break;
        }
        Object object = this._syncState;
        synchronized (object) {
            this._serverThreads.remove(Thread.currentThread());
            this._syncState.notifyAll();
            if (bl) {
                this._stThread = null;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void serve_request(QueueEntry queueEntry, boolean bl) {
        boolean bl2 = false;
        try {
            while (true) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                try {
                    ObjectAdapter objectAdapter = queueEntry._request.find_adapter();
                    if (objectAdapter == null) {
                        object4 = this._syncState;
                        // MONITORENTER : object4
                        --this._activeRequests;
                        // MONITOREXIT : object4
                        Object var13_10 = null;
                        if (!bl2) return;
                        Object object5 = this._syncState;
                        // MONITORENTER : object5
                        this._stThread = null;
                        // MONITOREXIT : object5
                        return;
                    }
                    object4 = (AdapterManagerImpl)objectAdapter.getAdapterManager();
                    if (object4 != null || !bl && objectAdapter.single_threaded()) {
                        object3 = null;
                        object2 = this._syncState;
                        // MONITORENTER : object2
                        if (!bl && objectAdapter.single_threaded()) {
                            if (this._stThread != null) {
                                if (this._stHead == null) {
                                    this._stHead = this._stTail = queueEntry;
                                } else {
                                    this._stTail._next = queueEntry;
                                    this._stTail = queueEntry;
                                }
                                ++this._holdingRequests;
                                --this._activeRequests;
                                if (this._activeRequests == 0) {
                                    this._syncState.notifyAll();
                                }
                                // MONITOREXIT : object2
                                Object var13_11 = null;
                                if (!bl2) return;
                                Object object6 = this._syncState;
                                // MONITORENTER : object6
                                this._stThread = null;
                                // MONITOREXIT : object6
                                return;
                            }
                            this._stThread = Thread.currentThread();
                            bl = true;
                            bl2 = true;
                        }
                        if (object4 != null) {
                            switch (((AdapterManagerImpl)object4)._state.value()) {
                                case 1: {
                                    ++((AdapterManagerImpl)object4)._managedActiveRequests;
                                    break;
                                }
                                case 0: {
                                    if (((AdapterManagerImpl)object4)._managedHoldingRequests < (((AdapterManagerImpl)object4)._maxManagerHeldRequestsOverride < this._maxManagerHeldRequests ? ((AdapterManagerImpl)object4)._maxManagerHeldRequestsOverride : this._maxManagerHeldRequests)) {
                                        if (((AdapterManagerImpl)object4)._holdHead == null) {
                                            ((AdapterManagerImpl)object4)._holdHead = ((AdapterManagerImpl)object4)._holdTail = queueEntry;
                                        } else {
                                            ((AdapterManagerImpl)object4)._holdTail._next = queueEntry;
                                            ((AdapterManagerImpl)object4)._holdTail = queueEntry;
                                        }
                                        --this._activeRequests;
                                        if (this._activeRequests == 0) {
                                            this._syncState.notifyAll();
                                        }
                                        ++this._holdingRequests;
                                        ++((AdapterManagerImpl)object4)._managedHoldingRequests;
                                        // MONITOREXIT : object2
                                        Object var13_12 = null;
                                        if (!bl2) return;
                                        Object object7 = this._syncState;
                                        // MONITORENTER : object7
                                        this._stThread = null;
                                        // MONITOREXIT : object7
                                        return;
                                    }
                                }
                                case 2: {
                                    object3 = DISCARD_EX;
                                    --this._activeRequests;
                                    if (this._activeRequests != 0) break;
                                    this._syncState.notifyAll();
                                    break;
                                }
                                case 3: {
                                    object3 = INACTIVE_EX;
                                    --this._activeRequests;
                                    if (this._activeRequests != 0) break;
                                    this._syncState.notifyAll();
                                    break;
                                }
                            }
                        }
                        // MONITOREXIT : object2
                        if (object3 != null) {
                            queueEntry._request.server_cancel((SystemException)object3);
                            Object var13_13 = null;
                            if (!bl2) return;
                            Object object8 = this._syncState;
                            // MONITORENTER : object8
                            this._stThread = null;
                            // MONITOREXIT : object8
                            return;
                        }
                    }
                    queueEntry._request.dispatch();
                    object3 = this._syncState;
                    // MONITORENTER : object3
                    --this._activeRequests;
                    if (object4 != null) {
                        --((AdapterManagerImpl)object4)._managedActiveRequests;
                        if (this._activeRequests == 0 || ((AdapterManagerImpl)object4)._managedActiveRequests == 0) {
                            this._syncState.notifyAll();
                        }
                    }
                    if (bl2) {
                        this._stThread = null;
                        bl2 = false;
                    }
                    // MONITOREXIT : object3
                    Object var13_14 = null;
                    if (!bl2) return;
                    Object object9 = this._syncState;
                    // MONITORENTER : object9
                    this._stThread = null;
                    // MONITOREXIT : object9
                    return;
                }
                catch (AdapterHoldingException adapterHoldingException) {
                    object4 = adapterHoldingException.getObjectAdapter();
                    object3 = null;
                    object2 = this._syncState;
                    // MONITORENTER : object2
                    if (!bl && object4.single_threaded()) {
                        if (this._stThread != null) {
                            if (this._stHead == null) {
                                this._stHead = this._stTail = queueEntry;
                            } else {
                                this._stTail._next = queueEntry;
                                this._stTail = queueEntry;
                            }
                            ++this._holdingRequests;
                            --this._activeRequests;
                            if (this._activeRequests == 0) {
                                this._syncState.notifyAll();
                            }
                            // MONITOREXIT : object2
                            Object var13_15 = null;
                            if (!bl2) return;
                            Object object10 = this._syncState;
                            // MONITORENTER : object10
                            this._stThread = null;
                            // MONITOREXIT : object10
                            return;
                        }
                        this._stThread = Thread.currentThread();
                        bl = true;
                        bl2 = true;
                    }
                    if ((object = (Object)((AdapterManagerImpl)adapterHoldingException.getObjectAdapter().getAdapterManager())) != null) {
                        switch (object._state.value()) {
                            case 1: {
                                break;
                            }
                            case 0: {
                                if (object._managedHoldingRequests < (object._maxManagerHeldRequestsOverride < this._maxManagerHeldRequests ? object._maxManagerHeldRequestsOverride : this._maxManagerHeldRequests)) {
                                    if (object._holdHead == null) {
                                        object._holdHead = object._holdTail = queueEntry;
                                    } else {
                                        object._holdTail._next = queueEntry;
                                        object._holdTail = queueEntry;
                                    }
                                    ++this._holdingRequests;
                                    ++object._managedHoldingRequests;
                                    --this._activeRequests;
                                    if (this._activeRequests == 0) {
                                        this._syncState.notifyAll();
                                    }
                                    // MONITOREXIT : object2
                                    Object var13_16 = null;
                                    if (!bl2) return;
                                    Object object11 = this._syncState;
                                    // MONITORENTER : object11
                                    this._stThread = null;
                                    // MONITOREXIT : object11
                                    return;
                                }
                            }
                            case 2: {
                                object3 = DISCARD_EX;
                                --this._activeRequests;
                                if (this._activeRequests != 0) break;
                                this._syncState.notifyAll();
                                break;
                            }
                            case 3: {
                                object3 = INACTIVE_EX;
                                --this._activeRequests;
                                if (this._activeRequests != 0) break;
                                this._syncState.notifyAll();
                                break;
                            }
                        }
                    }
                    // MONITOREXIT : object2
                    if (object3 == null) continue;
                    queueEntry._request.server_cancel((SystemException)object3);
                    Object var13_17 = null;
                    if (!bl2) return;
                    Object object12 = this._syncState;
                    // MONITORENTER : object12
                    this._stThread = null;
                    // MONITOREXIT : object12
                    return;
                }
                catch (AdapterDestroyedException adapterDestroyedException) {
                    object3 = adapterDestroyedException.getAdapterID();
                    object2 = adapterDestroyedException.getObjectAdapter();
                    object = this.find_object_key_offsets((byte[])object3);
                    AdapterValue adapterValue = new AdapterValue((byte[])object3, object[0], (ObjectAdapter)object2);
                    Object object13 = this._syncState;
                    // MONITORENTER : object13
                    adapterValue = (AdapterValue)this._adapterCache.get(adapterValue);
                    if (adapterValue != null && adapterValue._adapter == object2) {
                        if (adapterValue._refindHead == null) {
                            adapterValue._refindHead = adapterValue._refindTail = queueEntry;
                        } else {
                            adapterValue._refindTail._next = queueEntry;
                            adapterValue._refindTail = queueEntry;
                        }
                        ++adapterValue._refindCount;
                        ++this._holdingRequests;
                        --this._activeRequests;
                        if (this._activeRequests == 0) {
                            this._syncState.notifyAll();
                        }
                        // MONITOREXIT : object13
                        Object var13_18 = null;
                        if (!bl2) return;
                        Object object14 = this._syncState;
                        // MONITORENTER : object14
                        this._stThread = null;
                        // MONITOREXIT : object14
                        return;
                    }
                    // MONITOREXIT : object13
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (!bl2) throw throwable;
            Object object = this._syncState;
            // MONITORENTER : object
            this._stThread = null;
            // MONITOREXIT : object
            throw throwable;
        }
    }

    private boolean is_server_thread() {
        Object object = this._syncState;
        synchronized (object) {
            boolean bl = this._serverThreads.contains(Thread.currentThread());
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extend_thread_pool(int var1_1) {
        if (this._poolThreads == null || this._poolThreads.isDestroyed()) {
            if (this._useStaticThreadGroup) {
                if (ServerManagerImpl._staticPoolThreads == null || ServerManagerImpl._staticPoolThreads.isDestroyed()) {
                    ServerManagerImpl._staticPoolThreads = new ThreadGroup(this._rootGroup, "Server Threads");
                }
                this._poolThreads = ServerManagerImpl._staticPoolThreads;
            } else {
                this._poolThreads = new ThreadGroup(this._rootGroup, "Server Threads");
            }
        }
        if (this._poolThreadArray.length < this._threadPoolSize + var1_1) {
            var2_2 = new Thread[this._threadPoolSize + var1_1];
            System.arraycopy(this._poolThreadArray, 0, var2_2, 0, this._poolThreadArray.length);
            this._poolThreadArray = var2_2;
        }
        this._threadPoolSize += var1_1;
        var2_3 = 0;
        var3_4 = 0;
        ** GOTO lbl27
        {
            ++var2_3;
            do {
                if (this._poolThreadArray[var2_3] != null) continue block0;
                this._poolThreadArray[var2_3] = new PoolThread(this._poolThreads, var2_3);
                this._serverThreads.add(this._poolThreadArray[var2_3]);
                this._poolThreadArray[var2_3].setDaemon(true);
                this._poolThreadArray[var2_3].start();
                ++var2_3;
                Trace.high("ServerManager", "Thread pool grew");
                ++var3_4;
lbl27:
                // 2 sources

            } while (var3_4 < var1_1);
        }
    }

    private boolean wait_for_startup() {
        if (!this._running) {
            Object object = this._syncState;
            synchronized (object) {
                while (!this._running) {
                    if (this._shutdown) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        this._syncState.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        return true;
    }

    public void startup(boolean bl, boolean bl2) {
        Object object = this._syncState;
        synchronized (object) {
            if (this._shutdown) {
                return;
            }
            if (!this._running) {
                this._running = true;
                this._allowPool = bl2;
                if (this._ioThreads == null || this._ioThreads.isDestroyed()) {
                    if (this._useStaticThreadGroup) {
                        if (_staticIOThreads == null || _staticIOThreads.isDestroyed()) {
                            _staticIOThreads = new ThreadGroup(this._rootGroup, "Server IO");
                        }
                        this._ioThreads = _staticIOThreads;
                    } else {
                        this._ioThreads = new ThreadGroup(this._rootGroup, "Server IO");
                    }
                }
                if (this._reapCloseTime > 0) {
                    this._channelReaper = new Thread(this._ioThreads, new Runnable(){

                        public void run() {
                            ServerManagerImpl.this.channel_reaper();
                        }
                    }, "Channel Reaper");
                    this._channelReaper.setDaemon(true);
                    this._channelReaper.start();
                }
                this._syncState.notifyAll();
            } else if (bl2 && !this._allowPool) {
                this._allowPool = true;
                if (this._optThreadPoolSize < this._minThreadPoolSize) {
                    this.extend_thread_pool(this._optThreadPoolSize);
                } else if (this._optThreadPoolSize < this._maxThreadPoolSize) {
                    this.extend_thread_pool(this._optThreadPoolSize);
                } else {
                    this.extend_thread_pool(this._maxThreadPoolSize);
                }
            }
            if (bl) {
                try {
                    while (this._running) {
                        this._syncState.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(boolean var1_1) {
        block43: {
            if (var1_1) break block43;
            var2_2 = this._syncIO;
            synchronized (var2_2) {
                if (this._shutdown) {
                    return;
                }
                var3_4 = new Thread(this._rootGroup, new Runnable(){

                    public void run() {
                        ServerManagerImpl.this.shutdown(true);
                    }
                }, "ORB shutdown thread");
                var3_4.setDaemon(true);
                var4_6 = this.is_server_thread();
                var3_4.start();
                if (true) ** GOTO lbl35
            }
        }
        if (this.is_server_thread()) {
            throw new BAD_INV_ORDER(83099651, CompletionStatus.COMPLETED_MAYBE);
        }
        var2_3 = false;
        var4_7 = this._syncState;
        synchronized (var4_7) {
            var5_9 = this._syncIO;
            synchronized (var5_9) {
                if (this._shutdown) {
                    return;
                }
                this._shutdown = true;
                var3_5 = new ServerProtocol[this._protToWorker.size()];
                var3_5 = this._protToWorker.keySet().toArray(var3_5);
                ** if (this._channelReaper == null) goto lbl26
            }
lbl-1000:
            // 1 sources

            {
                this._channelReaper.interrupt();
            }
lbl26:
            // 2 sources

            this._syncState.notifyAll();
        }
        var5_10 = 0;
        if (true) ** GOTO lbl41
        {
            do {
                try {
                    this._syncIO.wait();
                }
                catch (InterruptedException var5_8) {
                    Thread.currentThread().interrupt();
                }
lbl35:
                // 3 sources

            } while (!var4_6 && !this._ioComplete);
            return;
        }
        do {
            if (var3_5[var5_10] != null) {
                var3_5[var5_10].close();
            }
            ++var5_10;
lbl41:
            // 2 sources

        } while (var5_10 < var3_5.length);
        var6_11 = this._syncState;
        synchronized (var6_11) {
            while (!this._serverThreads.isEmpty()) {
                try {
                    this._syncState.wait();
                }
                catch (InterruptedException var7_12) {
                    var2_3 = true;
                }
            }
            var7_13 = this._syncIO;
            synchronized (var7_13) {
                this._ioComplete = true;
                this._syncIO.notifyAll();
            }
            while (this._queueHead != null) {
                this._queueHead._request.server_cancel(ServerManagerImpl.SHUTDOWN_EX);
                this._queueHead = this._queueHead._next;
                --this._activeRequests;
            }
            while (this._stHead != null) {
                this._stHead._request.server_cancel(ServerManagerImpl.SHUTDOWN_EX);
                this._stHead = this._stHead._next;
                --this._holdingRequests;
            }
            var9_15 = this._adapterCache.values().iterator();
            while (var9_15.hasNext()) {
                var10_16 = (AdapterValue)var9_15.next();
                var11_17 = (AdapterManagerImpl)var10_16._adapter.getAdapterManager();
                if (var11_17 != null && var11_17._state == State.HOLDING) {
                    this._holdingRequests -= var11_17._managedHoldingRequests;
                    while (var11_17._holdHead != null) {
                        var11_17._holdHead._request.server_cancel(ServerManagerImpl.SHUTDOWN_EX);
                        var11_17._holdHead = var11_17._holdHead._next;
                    }
                    var11_17._state = State.INACTIVE;
                }
                var10_16._adapter.etherialize(true);
            }
            Trace.assert(this._activeRequests == 0, "Active requests not empty");
            Trace.assert(this._holdingRequests == 0, "Holding requests not empty");
            ** if (this._channelReaper == null) goto lbl87
        }
lbl-1000:
        // 1 sources

        {
            try {
                this._channelReaper.join();
                this._channelReaper = null;
            }
            catch (InterruptedException var7_14) {
                var2_3 = true;
            }
        }
lbl87:
        // 3 sources

        var8_18 = this._syncIO;
        synchronized (var8_18) {
            var7_13 = new ServerChannel[this._channels.size()];
            var7_13 = this._channels.keySet().toArray(var7_13);
        }
        var13_19 = 0;
        while (var13_19 < var7_13.length) {
            var7_13[var13_19].soft_close(true);
            ++var13_19;
        }
        var14_20 = this._syncState;
        synchronized (var14_20) {
            this._running = false;
            this._syncState.notifyAll();
            ** if (this._useStaticThreadGroup) goto lbl115
        }
lbl-1000:
        // 1 sources

        {
            if (this._ioThreads != null) {
                this._ioThreads.setDaemon(true);
                try {
                    this._ioThreads.destroy();
                }
                catch (IllegalThreadStateException var15_21) {
                    // empty catch block
                }
            }
            if (this._poolThreads != null) {
                this._poolThreads.setDaemon(true);
                try {
                    this._poolThreads.destroy();
                }
                catch (IllegalThreadStateException var15_22) {
                    // empty catch block
                }
            }
        }
lbl115:
        // 5 sources

        if (var2_3) {
            Thread.currentThread().interrupt();
        }
    }

    static /* synthetic */ int access$300(ServerManagerImpl serverManagerImpl) {
        return serverManagerImpl._maxManagerHeldRequests;
    }

    private static class AdapterValue {
        byte[] _aid;
        int _hash;
        int _offset;
        ObjectAdapter _adapter;
        int _priority;
        int _hits = 0;
        QueueEntry _refindHead;
        QueueEntry _refindTail;
        int _refindCount = 0;

        public AdapterValue(byte[] byArray, int n, ObjectAdapter objectAdapter) {
            this._aid = byArray;
            this._offset = n;
            this._hash = 0;
            int n2 = n;
            while (n2 < this._aid.length) {
                this._hash = 31 * this._hash + (this._aid[n2] & 0xFF);
                ++n2;
            }
            this._adapter = objectAdapter;
            this._priority = this._adapter != null ? this._adapter.cache_priority() : -1;
        }

        public boolean is_cacheable_object_key() {
            return this._offset != 0;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object object) {
            if (object instanceof AdapterValue) {
                AdapterValue adapterValue = (AdapterValue)object;
                if (adapterValue._hash != this._hash || adapterValue._offset != this._offset || adapterValue._aid.length != this._aid.length) {
                    return false;
                }
                int n = this._aid.length - 1;
                while (n >= 0) {
                    if (this._aid[n] != adapterValue._aid[n]) {
                        return false;
                    }
                    --n;
                }
                return true;
            }
            if (object instanceof ProgressiveAIDKey) {
                int n;
                ProgressiveAIDKey progressiveAIDKey = (ProgressiveAIDKey)object;
                if (progressiveAIDKey._hash != this._hash) {
                    return false;
                }
                if (this._offset == 0 != (progressiveAIDKey._offsets[0] == 0)) {
                    return false;
                }
                int n2 = n = progressiveAIDKey._hashTo == progressiveAIDKey._offsets.length - 1 ? progressiveAIDKey._aid.length : progressiveAIDKey._offsets[progressiveAIDKey._hashTo + 1];
                if (n - progressiveAIDKey._offsets[0] != this._aid.length - this._offset) {
                    return false;
                }
                int n3 = this._aid.length;
                --n;
                --n3;
                while (n3 >= this._offset) {
                    if (progressiveAIDKey._aid[n] != this._aid[n3]) {
                        return false;
                    }
                    --n;
                    --n3;
                }
                return true;
            }
            return false;
        }
    }

    private static class ProgressiveAIDKey {
        byte[] _aid;
        int[] _offsets;
        int[] _hashes;
        int _hash;
        int _hashTo;

        public ProgressiveAIDKey(byte[] byArray, int[] nArray) {
            this._aid = byArray;
            this._offsets = nArray;
            this._hashes = new int[this._offsets.length];
            this._hash = 0;
            int n = 0;
            while (n < this._hashes.length) {
                int n2 = this._offsets[n];
                int n3 = n + 1 < this._hashes.length ? this._offsets[n + 1] : this._aid.length;
                int n4 = n2;
                while (n4 < n3) {
                    this._hash = 31 * this._hash + (this._aid[n4] & 0xFF);
                    ++n4;
                }
                this._hashes[n] = this._hash;
                ++n;
            }
            this._hashTo = this._offsets.length - 1;
        }

        public boolean is_cacheable_object_key() {
            return this._offsets[0] != 0;
        }

        public int hashCode() {
            return this._hash;
        }

        public int useHash(int n) {
            this._hashTo = n;
            this._hash = n == -1 ? 0 : this._hashes[n];
            return this._hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof AdapterValue) {
                int n;
                AdapterValue adapterValue = (AdapterValue)object;
                if (adapterValue._offset == 0 != (this._offsets[0] == 0)) {
                    return false;
                }
                if (adapterValue._hash != this._hash) {
                    return false;
                }
                int n2 = n = this._hashTo == this._offsets.length - 1 ? this._aid.length : this._offsets[this._hashTo + 1];
                if (n - this._offsets[0] != adapterValue._aid.length - adapterValue._offset) {
                    return false;
                }
                int n3 = adapterValue._aid.length;
                --n;
                --n3;
                while (n3 >= adapterValue._offset) {
                    if (this._aid[n] != adapterValue._aid[n3]) {
                        return false;
                    }
                    --n;
                    --n3;
                }
                return true;
            }
            if (object instanceof ProgressiveAIDKey) {
                ProgressiveAIDKey progressiveAIDKey = (ProgressiveAIDKey)object;
                if (progressiveAIDKey._offsets[0] == 0 != (this._offsets[0] == 0)) {
                    return false;
                }
                if (progressiveAIDKey._hashTo != this._hashTo) {
                    return false;
                }
                int n = this._hashTo;
                while (n >= 0) {
                    if (progressiveAIDKey._hashes[n] != this._hashes[n] || progressiveAIDKey._offsets[n] - progressiveAIDKey._offsets[0] != this._offsets[n] - this._offsets[0]) {
                        return false;
                    }
                    --n;
                }
                int n4 = this._hashTo == this._offsets.length - 1 ? this._aid.length : this._offsets[this._hashTo + 1];
                int n5 = progressiveAIDKey._hashTo == progressiveAIDKey._offsets.length - 1 ? progressiveAIDKey._aid.length : progressiveAIDKey._offsets[progressiveAIDKey._hashTo + 1];
                --n4;
                --n5;
                while (n4 >= this._offsets[0]) {
                    if (this._aid[n4] != progressiveAIDKey._aid[n5]) {
                        return false;
                    }
                    --n4;
                    --n5;
                }
                return true;
            }
            return false;
        }
    }

    private static class QueueEntry {
        QueueEntry _next = null;
        ServerRequest _request;
        ObjectAdapter _adapter;

        QueueEntry(ServerRequest serverRequest) {
            this._request = serverRequest;
        }
    }

    public class AdapterManagerImpl
    extends LocalObject
    implements POAManager,
    ServerManager.AdapterManager {
        State _state = State.HOLDING;
        int _managedActiveRequests = 0;
        int _managedHoldingRequests = 0;
        QueueEntry _holdHead;
        QueueEntry _holdTail;
        Map _managedAdapters = new HashMap();
        boolean _etherialize;
        int _maxManagerHeldRequestsOverride = ServerManagerImpl.access$300(ServerManagerImpl.this);

        AdapterManagerImpl() {
        }

        public void setMaxManagerHeldRequests(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this._maxManagerHeldRequestsOverride = n;
        }

        public State get_state() {
            Object object = ServerManagerImpl.this._syncState;
            synchronized (object) {
                State state = this._state;
                return state;
            }
        }

        public void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
            boolean bl3;
            if (bl2 && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(83099654, CompletionStatus.COMPLETED_NO);
            }
            Object object = ServerManagerImpl.this._syncState;
            synchronized (object) {
                bl3 = this._managedActiveRequests == 0;
                switch (this._state.value()) {
                    case 3: {
                        if (bl3) {
                            throw new AdapterInactive();
                        }
                        this.wait_for_complete();
                        return;
                    }
                    case 0: {
                        ServerManagerImpl.this._syncState.notifyAll();
                    }
                }
                this._state = State.INACTIVE;
                this._etherialize = bl;
            }
            if (this._managedHoldingRequests > 0) {
                while (this._holdHead != null) {
                    this._holdHead._request.server_cancel(INACTIVE_EX);
                    this._holdHead = this._holdHead._next;
                }
            }
            if (!bl3 && bl2 || this._managedHoldingRequests > 0) {
                Object object2 = ServerManagerImpl.this._syncState;
                synchronized (object2) {
                    ServerManagerImpl.this._holdingRequests -= this._managedHoldingRequests;
                    this._managedHoldingRequests = 0;
                    if (!bl3 && bl2) {
                        this.wait_for_complete();
                    }
                }
            }
            if (bl3) {
                this.complete_deactivate();
            }
        }

        void complete_deactivate() {
            if (this._etherialize) {
                Iterator iterator = this._managedAdapters.values().iterator();
                while (iterator.hasNext()) {
                    ((ObjectAdapter)iterator.next()).etherialize(true);
                }
            }
        }

        private void wait_for_complete() {
            try {
                while (this._managedActiveRequests > 0) {
                    ServerManagerImpl.this._syncState.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void discard_requests(boolean bl) throws AdapterInactive {
            Object object;
            if (bl && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(83099654, CompletionStatus.COMPLETED_NO);
            }
            int n = 0;
            QueueEntry queueEntry = null;
            Object object2 = ServerManagerImpl.this._syncState;
            synchronized (object2) {
                switch (this._state.value()) {
                    case 3: {
                        throw new AdapterInactive();
                    }
                    case 0: {
                        n = this._managedHoldingRequests;
                        queueEntry = this._holdHead;
                        this._managedHoldingRequests = 0;
                        this._holdTail = null;
                        this._holdHead = null;
                        ServerManagerImpl.this._syncState.notifyAll();
                    }
                }
                this._state = State.DISCARDING;
            }
            if (n > 0) {
                while (queueEntry != null) {
                    queueEntry._request.server_cancel(DISCARD_EX);
                    queueEntry = queueEntry._next;
                }
                object = ServerManagerImpl.this._syncState;
                synchronized (object) {
                    ServerManagerImpl.this._holdingRequests -= n;
                }
            }
            if (bl) {
                object = ServerManagerImpl.this._syncState;
                synchronized (object) {
                    this.wait_for_complete();
                }
            }
        }

        public void hold_requests(boolean bl) throws AdapterInactive {
            if (bl && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(83099654, CompletionStatus.COMPLETED_NO);
            }
            Object object = ServerManagerImpl.this._syncState;
            synchronized (object) {
                if (this._state == State.INACTIVE) {
                    throw new AdapterInactive();
                }
                this._state = State.HOLDING;
            }
            if (bl) {
                Object object2 = ServerManagerImpl.this._syncState;
                synchronized (object2) {
                    this.wait_for_complete();
                }
            }
        }

        public void activate() throws AdapterInactive {
            Object object = ServerManagerImpl.this._syncState;
            synchronized (object) {
                switch (this._state.value()) {
                    case 3: {
                        throw new AdapterInactive();
                    }
                    case 1: {
                        return;
                    }
                    case 0: {
                        ServerManagerImpl.this._syncState.notifyAll();
                        if (this._managedHoldingRequests > 0) {
                            ServerManagerImpl.this._holdingRequests -= this._managedHoldingRequests;
                            ServerManagerImpl.this._activeRequests += this._managedHoldingRequests;
                            this._managedHoldingRequests = 0;
                            if (ServerManagerImpl.this._queueMiddle == null) {
                                this._holdTail._next = ServerManagerImpl.this._queueHead;
                                ServerManagerImpl.this._queueHead = this._holdHead;
                            } else {
                                this._holdTail._next = ((ServerManagerImpl)ServerManagerImpl.this)._queueMiddle._next;
                                ((ServerManagerImpl)ServerManagerImpl.this)._queueMiddle._next = this._holdHead;
                            }
                            ServerManagerImpl.this._queueMiddle = this._holdTail;
                            this._holdHead = null;
                            this._holdTail = null;
                        }
                    }
                    case 2: {
                        this._state = State.ACTIVE;
                        return;
                    }
                }
            }
        }
    }

    private class PoolThread
    extends Thread {
        private int _id;

        private PoolThread(ThreadGroup threadGroup, int n) {
            super(threadGroup, "Thread pool thread #" + n);
            this._id = n;
        }

        public void run() {
            ServerManagerImpl.this.thread_pool_main(this._id);
        }
    }

    private class ChannelSendRunner
    implements Runnable {
        private ServerChannel _chan;

        public ChannelSendRunner(ServerChannel serverChannel) {
            this._chan = serverChannel;
        }

        public void run() {
            if (ServerManagerImpl.this.wait_for_startup()) {
                this._chan.run_send();
            }
        }
    }

    private class ChannelRecvRunner
    implements Runnable {
        private ServerChannel _chan;

        public ChannelRecvRunner(ServerChannel serverChannel) {
            this._chan = serverChannel;
        }

        public void run() {
            if (ServerManagerImpl.this.wait_for_startup()) {
                this._chan.run_recv();
            }
        }
    }

    private class ProtocolRunner
    implements Runnable {
        private ServerProtocol _svrproto;

        public ProtocolRunner(ServerProtocol serverProtocol) {
            this._svrproto = serverProtocol;
        }

        public void run() {
            if (ServerManagerImpl.this.wait_for_startup()) {
                this._svrproto.run_listen();
            }
        }
    }

    private static class ProfileMember {
        private int _hash;
        TaggedProfile _profile;

        ProfileMember(TaggedProfile taggedProfile) {
            this._profile = taggedProfile;
            this._hash = this._profile.tag;
            int n = 0;
            while (n < this._profile.profile_data.length) {
                this._hash = 31 * this._hash + this._profile.profile_data[n];
                ++n;
            }
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ProfileMember)) {
                return false;
            }
            ProfileMember profileMember = (ProfileMember)object;
            if (this._hash != profileMember._hash || this._profile.tag != profileMember._profile.tag || this._profile.profile_data.length != profileMember._profile.profile_data.length) {
                return false;
            }
            int n = 0;
            while (n < this._profile.profile_data.length) {
                if (this._profile.profile_data[n] != profileMember._profile.profile_data[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

