/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.policy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.PortableInterceptor.PolicyFactory;
import org.openorb.policy.PolicyFactoryManager;
import org.openorb.policy.PolicyReconciler;
import org.openorb.policy.PolicySet;
import org.openorb.policy.PolicySetManager;

public class ORBPolicyManagerImpl
extends LocalObject
implements PolicyManager,
PolicyReconciler,
PolicyFactoryManager,
PolicySetManager,
PolicyFactory {
    private PolicySet policy_set = null;
    private List domain_sets = new ArrayList(2);
    private Map policy_reconcilers = null;
    private Map factories;

    public ORBPolicyManagerImpl() {
        this.add_policy_domain();
        this.add_policy_domain();
    }

    public void set_policy_overrides(Policy[] policyArray, SetOverrideType setOverrideType) throws InvalidPolicies {
        if (this.policy_set == null) {
            this.policy_set = new PolicySet(null, -1);
        }
        this.policy_set.set_policy_overrides(policyArray, setOverrideType);
    }

    public Policy[] get_policy_overrides(int[] nArray) {
        if (this.policy_set == null) {
            return new Policy[0];
        }
        return this.policy_set.get_policy_overrides(nArray);
    }

    public PolicyManagerOperations create_policy_set() {
        return new PolicySet(null, -1);
    }

    public PolicyManagerOperations create_policy_set(int n) {
        return new PolicySet(this, n);
    }

    public void add_invalid_policy_type(int n, int n2) {
        ((Set)this.domain_sets.get(n)).add(new Integer(n2));
    }

    public int add_policy_domain() {
        int n = this.domain_sets.size();
        this.domain_sets.add(new TreeSet());
        return n;
    }

    public Policy reconcile_policies(int n, Policy policy, Policy policy2, DomainManager[] domainManagerArray) {
        IDLEntity iDLEntity;
        if (policy != null && n != policy.policy_type() || policy2 != null && n != policy2.policy_type()) {
            throw new INV_POLICY("policy types don't match", 1146056718, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.policy_reconcilers != null && (iDLEntity = (PolicyReconciler)this.policy_reconcilers.get(new Integer(n))) != null) {
            return iDLEntity.reconcile_policies(n, policy, policy2, domainManagerArray);
        }
        if (policy == null && policy2 != null) {
            return policy2;
        }
        if (policy != null && policy2 == null) {
            return policy;
        }
        if (policy == null && policy2 == null && domainManagerArray != null) {
            iDLEntity = null;
            int n2 = 0;
            while (n2 < domainManagerArray.length) {
                try {
                    iDLEntity = domainManagerArray[n2].get_domain_policy(n);
                    break;
                }
                catch (INV_POLICY iNV_POLICY) {
                    ++n2;
                }
            }
            while (n2 < domainManagerArray.length) {
                try {
                    domainManagerArray[n2].get_domain_policy(n);
                    iDLEntity = null;
                    break;
                }
                catch (INV_POLICY iNV_POLICY) {
                    ++n2;
                }
            }
            if (iDLEntity != null) {
                return iDLEntity;
            }
        }
        throw new INV_POLICY("policy types don't match", 1146056718, CompletionStatus.COMPLETED_MAYBE);
    }

    public void add_policy_reconciler(int n, PolicyReconciler policyReconciler) {
        if (this.policy_reconcilers == null) {
            this.policy_reconcilers = new HashMap();
        }
        if (policyReconciler == null) {
            this.policy_reconcilers.remove(new Integer(n));
        } else {
            this.policy_reconcilers.put(new Integer(n), policyReconciler);
        }
    }

    boolean invalid_policy(int n, int n2) {
        if (n < 0) {
            return false;
        }
        return ((Set)this.domain_sets.get(n)).contains(new Integer(n2));
    }

    public void add_policy_factory(int n, PolicyFactory policyFactory) {
        if (this.factories == null) {
            this.factories = new HashMap();
        }
        if (policyFactory == this) {
            return;
        }
        if (policyFactory == null) {
            this.factories.remove(new Integer(n));
        } else {
            this.factories.put(new Integer(n), policyFactory);
        }
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        PolicyFactory policyFactory = (PolicyFactory)this.factories.get(new Integer(n));
        if (policyFactory == null) {
            throw new PolicyError(3);
        }
        return policyFactory.create_policy(n, any);
    }
}

