/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingIteratorPOA;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHolder;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.fwd.ForwardAdapter;
import org.openorb.net.Address;
import org.openorb.net.ServerManager;
import org.openorb.util.NamingUtils;

public class MapNamingContext
extends TreeMap {
    private org.omg.CORBA.ORB _orb;
    private Set _subContexts = new HashSet();
    private static final int SHUTDOWN_DISALLOW = 0;
    private static final int SHUTDOWN_DESTROY_POA = 1;
    private static final int SHUTDOWN_DESTROY_ORB = 2;
    private int _shutdownMode = 0;
    private NamingContextExt _rootCtxt = null;
    private POA _firstPOA;
    private POA _ctxtPOA;
    private POA _iterPOA;
    private NamingContextExtImpl _ctxtImpl = new NamingContextExtImpl();
    private BindingIteratorImpl _iterImpl = new BindingIteratorImpl();
    private static int __nameservs = 0;
    private String _endpoint = null;
    private boolean _noDefaultAdapter = false;

    public MapNamingContext(org.omg.CORBA.ORB oRB, POA pOA) {
        try {
            this.init(oRB, pOA, null);
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            throw new INTERNAL();
        }
    }

    public MapNamingContext(org.omg.CORBA.ORB oRB, POA pOA, String string) throws AdapterAlreadyExists {
        this.init(oRB, pOA, string);
    }

    private void init(org.omg.CORBA.ORB oRB, POA pOA, String string) throws AdapterAlreadyExists {
        if (pOA == null) {
            try {
                pOA = (POA)oRB.resolve_initial_references("RootPOA");
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
                throw new INTERNAL(invalidName.toString());
            }
        }
        this._orb = oRB;
        Policy[] policyArray = new Policy[]{pOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), pOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), pOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), pOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), pOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
        try {
            this._firstPOA = this._ctxtPOA = pOA.create_POA(string == null ? "NameServ_" + __nameservs++ : string, null, policyArray);
            policyArray[1] = pOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
            this._iterPOA = this._firstPOA.create_POA("_IterPOA", this._firstPOA.the_POAManager(), policyArray);
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            if (string == null) {
                throw adapterAlreadyExists;
            }
        }
        catch (InvalidPolicy invalidPolicy) {
            throw new INTERNAL(invalidPolicy.toString());
        }
        try {
            this._ctxtPOA.set_servant(this._ctxtImpl);
            this._iterPOA.set_servant(this._iterImpl);
        }
        catch (WrongPolicy wrongPolicy) {
            throw new INTERNAL(wrongPolicy.toString());
        }
        try {
            this._rootCtxt = NamingContextExtHelper.narrow(this._ctxtPOA.create_reference_with_id(new byte[0], NamingContextExtHelper.id()));
        }
        catch (WrongPolicy wrongPolicy) {
            throw new INTERNAL();
        }
        try {
            this._ctxtPOA.the_POAManager().activate();
        }
        catch (AdapterInactive adapterInactive) {
            throw new INTERNAL(adapterInactive.toString());
        }
    }

    public NamingContextExt getRootCtxt() {
        return this._rootCtxt;
    }

    public String bindCorbaloc() {
        if (this._noDefaultAdapter) {
            throw new IllegalStateException("No default adapter exists. Default adapter must be initialized with the orb");
        }
        if (this._endpoint == null) {
            java.lang.Object object;
            ServerManager serverManager = (ServerManager)((ORB)this._orb).getFeature("ServerCPCManager");
            ForwardAdapter forwardAdapter = null;
            try {
                object = serverManager.find_adapter(new byte[0]);
                if (object instanceof ForwardAdapter) {
                    forwardAdapter = (ForwardAdapter)object;
                }
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                throw new INITIALIZE(0, CompletionStatus.COMPLETED_NO);
            }
            if (forwardAdapter == null) {
                this._noDefaultAdapter = true;
                throw new IllegalStateException("No default adapter exists. Default adapter must be initialized with the orb");
            }
            forwardAdapter.bind("NameService", this._rootCtxt, false);
            object = (Delegate)((ObjectImpl)((java.lang.Object)this._rootCtxt))._get_delegate();
            Address[] addressArray = ((Delegate)object).getAddresses(this._rootCtxt);
            int n = 0;
            while (n < addressArray.length) {
                if (addressArray[n].getProtocol().equals("iiop")) {
                    this._endpoint = addressArray[n].getEndpointString();
                    break;
                }
                ++n;
            }
            if (this._endpoint == null) {
                this._endpoint = addressArray[0].getEndpointString();
            }
        }
        return "corbaloc:" + this._endpoint + "/NameService";
    }

    public String getCorbaname(String string) {
        if (this._endpoint == null) {
            throw new IllegalStateException("Nameservice has not been bound as a corbaloc");
        }
        try {
            return NamingUtils.to_url(this._endpoint, string);
        }
        catch (InvalidName invalidName) {
            throw new IllegalArgumentException("Name is invalid: " + invalidName.getMessage());
        }
        catch (InvalidAddress invalidAddress) {
            throw new IllegalArgumentException("Address is invalid: " + invalidAddress.getMessage());
        }
    }

    public String getCorbaname(NameComponent[] nameComponentArray) {
        String string;
        if (this._endpoint == null) {
            throw new IllegalStateException("Nameservice has not been bound as a corbaloc");
        }
        try {
            string = this._ctxtImpl.to_string(nameComponentArray);
        }
        catch (InvalidName invalidName) {
            throw new IllegalArgumentException("Name is invalid: " + invalidName.getMessage());
        }
        return this.getCorbaname(string);
    }

    public boolean getAllowSelfDestruct() {
        return this._shutdownMode != 0;
    }

    public void setAllowSelfDestruct(boolean bl) {
        this._shutdownMode = bl ? 1 : 0;
    }

    public void deactivate(boolean bl) {
        this._ctxtPOA.destroy(true, bl);
    }

    public java.lang.Object put(java.lang.Object object, java.lang.Object object2) {
        if (object == null) {
            throw new NullPointerException("Null keys cannot be used.");
        }
        if (object2 != null && !(object2 instanceof Object)) {
            throw new ClassCastException("Only org.omg.CORBA.Object may be used as values in this map.");
        }
        if (object instanceof String) {
            return this.putStr((String)object, (Object)object2);
        }
        if (object instanceof NameComponent[]) {
            return this.putName((NameComponent[])object, (Object)object2);
        }
        throw new ClassCastException("Key type not compatable.");
    }

    public Object putName(NameComponent[] nameComponentArray, Object object) {
        String string;
        if (nameComponentArray.length == 0) {
            throw new IllegalArgumentException("Name is invalid: Zero length");
        }
        try {
            string = this._ctxtImpl.to_string(nameComponentArray);
        }
        catch (InvalidName invalidName) {
            throw new IllegalArgumentException("Name is invalid: " + invalidName.getMessage());
        }
        MapNamingContext mapNamingContext = this;
        synchronized (mapNamingContext) {
            if (this._subContexts.contains(string)) {
                throw new IllegalStateException("Name is bound to a context");
            }
            this.addContext(NamingUtils.parent(nameComponentArray));
            Object object2 = super.put(string, object);
            return object2;
        }
    }

    public Object putStr(String string, Object object) {
        NameComponent[] nameComponentArray;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Name is invalid: Zero length string");
        }
        boolean bl = true;
        if (string.endsWith("/")) {
            int n = string.length() - 2;
            while (n >= 0 && string.charAt(n) == '\\') {
                --n;
            }
            if (n >= 0 && (string.length() - n) % 2 == 0) {
                string = string.substring(0, string.length() - 2);
                bl = false;
            }
        }
        try {
            nameComponentArray = this._ctxtImpl.to_name(string);
        }
        catch (InvalidName invalidName) {
            throw new IllegalArgumentException("Name is invalid: " + invalidName.getMessage());
        }
        MapNamingContext mapNamingContext = this;
        synchronized (mapNamingContext) {
            if (bl) {
                if (this._subContexts.contains(string)) {
                    throw new IllegalStateException("Name is bound to a context");
                }
                this.addContext(NamingUtils.parent(nameComponentArray));
                Object object2 = super.put(string, object);
                return object2;
            }
            this.addContext(nameComponentArray);
            Object object3 = null;
            return object3;
        }
    }

    public NamingContextExt addContext(String string) {
        NameComponent[] nameComponentArray;
        try {
            nameComponentArray = this._ctxtImpl.to_name(string);
        }
        catch (InvalidName invalidName) {
            throw new IllegalArgumentException("Name is invalid: " + invalidName.getMessage());
        }
        return this.addContext(nameComponentArray);
    }

    public NamingContextExt addContext(NameComponent[] nameComponentArray) {
        if (nameComponentArray.length == 0) {
            return this._rootCtxt;
        }
        String[] stringArray = new String[nameComponentArray.length];
        try {
            stringArray[nameComponentArray.length - 1] = this._ctxtImpl.to_string(nameComponentArray);
        }
        catch (InvalidName invalidName) {
            throw new IllegalArgumentException("Name is invalid: " + invalidName.getMessage());
        }
        int n = nameComponentArray.length - 2;
        while (n >= 0) {
            stringArray[n] = NamingUtils.parent(stringArray[n + 1]);
            --n;
        }
        NamingContextExt namingContextExt = null;
        MapNamingContext mapNamingContext = this;
        synchronized (mapNamingContext) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                java.lang.Object v = this.get(stringArray[n2]);
                if (v == null) break;
                if (!(v instanceof NamingContext)) {
                    throw new IllegalStateException("Could not create context \"" + stringArray[n2] + "\", already bound to object.");
                }
                if (!this._subContexts.contains(stringArray[n2])) {
                    throw new IllegalStateException("Could not create context \"" + stringArray[n2] + "\", already bound to external context.");
                }
                namingContextExt = (NamingContextExt)v;
                ++n2;
            }
            while (n2 < stringArray.length) {
                namingContextExt = this._ctxtImpl.createRef(stringArray[n2]);
                ++n2;
            }
        }
        return namingContextExt;
    }

    public synchronized boolean removeContext(String string) {
        if (this._subContexts.remove(string)) {
            super.remove(string);
            super.subMap(string + '/', string + 48).clear();
            return true;
        }
        return false;
    }

    public synchronized boolean isContext(String string) {
        return this._subContexts.contains(string);
    }

    public void putAll(Map map) {
        if (map instanceof MapNamingContext) {
            super.putAll(map);
        } else {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private NameComponent[] tailOffExternal(String string, NamingContextHolder namingContextHolder) throws NotFound {
        java.lang.Object object;
        String string2 = string;
        while (string2.length() > 0) {
            NameComponent[] nameComponentArray;
            object = this.get(string2);
            if (object == null) {
                string2 = NamingUtils.parent(string2);
                continue;
            }
            try {
                nameComponentArray = this._ctxtImpl.to_name(string.substring(string2.length() + 1));
            }
            catch (InvalidName invalidName) {
                throw new INTERNAL();
            }
            if (object instanceof NamingContext) {
                if (this._subContexts.contains(string2)) {
                    throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
                }
                namingContextHolder.value = (NamingContext)object;
                return nameComponentArray;
            }
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        try {
            object = this._ctxtImpl.to_name(string);
        }
        catch (InvalidName invalidName) {
            throw new INTERNAL();
        }
        throw new NotFound(NotFoundReason.missing_node, (NameComponent[])object);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-default") || stringArray[n].equals("--default")) {
                bl3 = true;
            } else if (stringArray[n].equals("-printIOR") || stringArray[n].equals("--printIOR")) {
                bl = true;
            } else if (stringArray[n].equals("-print") || stringArray[n].equals("--print")) {
                bl2 = true;
            } else if (stringArray[n].equals("-shutdown") || stringArray[n].equals("--shutdown")) {
                bl4 = true;
            } else if (stringArray[n].startsWith("-ORB")) {
                if (stringArray.length < n + 1 && !stringArray[n + 1].startsWith("-")) {
                    ++n;
                }
            } else {
                System.err.println("usage: org.openorb.util.MapNamingContext [-default] [-printref] [-shutdown]");
                System.err.println("       print      Print corbaloc format reference to stderr.");
                System.err.println("       printIOR   Print IOR format reference to stderr.");
                System.err.println("       default    Run on default port.");
                System.err.println("       shutdown   Allow the destroy operation on the rootNC to shutdown the server.");
                if (stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                    return;
                }
                System.exit(1);
            }
            ++n;
        }
        Properties properties = new Properties();
        if (bl3) {
            ((Hashtable)properties).put("ImportModule.InitialReferencesService", "${openorb.home}config/default.xml#InitialReferencesService");
        } else {
            ((Hashtable)properties).put("ImportModule.ForwardAdapter", "${openorb.home}config/default.xml#ForwardAdapter");
        }
        org.omg.CORBA.ORB oRB = org.omg.CORBA.ORB.init(stringArray, properties);
        MapNamingContext mapNamingContext = new MapNamingContext(oRB, null);
        if (bl4) {
            mapNamingContext._shutdownMode = 2;
        }
        NamingContextExt namingContextExt = mapNamingContext.getRootCtxt();
        String string = mapNamingContext.bindCorbaloc();
        System.out.println("Transient naming service activated.");
        if (bl) {
            System.out.println("IOR Reference:");
            System.err.println(oRB.object_to_string(namingContextExt));
        }
        if (bl2) {
            System.out.println("Corbaloc Reference:");
            System.err.println(string);
        }
        try {
            POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
            pOA.the_POAManager().activate();
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new INTERNAL(invalidName.toString());
        }
        catch (AdapterInactive adapterInactive) {
            throw new INTERNAL(adapterInactive.toString());
        }
        oRB.run();
    }

    private class BindingIteratorImpl
    extends BindingIteratorPOA {
        private Map _iteratorData = new HashMap();

        private BindingIteratorImpl() {
        }

        public BindingIterator createIterator(String string, String string2, Iterator iterator, SortedMap sortedMap) {
            IteratorData iteratorData = new IteratorData();
            iteratorData.parent = string;
            iteratorData.last = string2;
            iteratorData.itt = iterator;
            iteratorData.subMap = sortedMap;
            try {
                BindingIterator bindingIterator = BindingIteratorHelper.narrow(MapNamingContext.this._iterPOA.create_reference(BindingIteratorHelper.id()));
                this._iteratorData.put(new ByteSeqKey(MapNamingContext.this._iterPOA.reference_to_id(bindingIterator)), iteratorData);
                return bindingIterator;
            }
            catch (WrongPolicy wrongPolicy) {
                throw new INTERNAL(wrongPolicy.toString());
            }
            catch (WrongAdapter wrongAdapter) {
                throw new INTERNAL(wrongAdapter.toString());
            }
        }

        public void destroy() {
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (this._iteratorData.remove(this.getKey()) == null) {
                    throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                }
            }
        }

        public boolean next_one(BindingHolder bindingHolder) {
            boolean bl;
            java.lang.Object object;
            Map.Entry entry = null;
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                object = (IteratorData)this._iteratorData.get(this.getKey());
                if (object == null) {
                    throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                }
                bl = ((IteratorData)object).parent.length() == 0;
                while (entry == null && ((IteratorData)object).itt.hasNext()) {
                    try {
                        do {
                            entry = (Map.Entry)((IteratorData)object).itt.next();
                            ((IteratorData)object).last = (String)entry.getKey();
                            String string = NamingUtils.parent(((IteratorData)object).last);
                            if (string.equals(((IteratorData)object).parent)) continue;
                            ((IteratorData)object).subMap = ((IteratorData)object).subMap.tailMap(string + 48);
                            ((IteratorData)object).itt = ((IteratorData)object).subMap.entrySet().iterator();
                            entry = null;
                        } while (entry == null && ((IteratorData)object).itt.hasNext());
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        ((IteratorData)object).subMap = ((IteratorData)object).subMap.tailMap(((IteratorData)object).last + '\u0000');
                        ((IteratorData)object).itt = ((IteratorData)object).subMap.entrySet().iterator();
                    }
                }
            }
            if (entry == null) {
                bindingHolder.value = new Binding(new NameComponent[0], BindingType.nobject);
                return false;
            }
            bindingHolder.value = entry.getValue() instanceof NamingContext ? new Binding(null, BindingType.ncontext) : new Binding(null, BindingType.nobject);
            object = (String)entry.getKey();
            if (!bl) {
                object = ((String)object).substring(NamingUtils.parent((String)object).length() + 1);
            }
            try {
                bindingHolder.value.binding_name = MapNamingContext.this._ctxtImpl.to_name((String)object);
            }
            catch (InvalidName invalidName) {
                throw new INTERNAL();
            }
            return true;
        }

        public boolean next_n(int n, BindingListHolder bindingListHolder) {
            boolean bl;
            java.lang.Object object;
            int n2 = 0;
            Map.Entry[] entryArray = new Map.Entry[n];
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                object = (IteratorData)this._iteratorData.get(this.getKey());
                if (object == null) {
                    throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                }
                bl = ((IteratorData)object).parent.length() == 0;
                while (n2 < n && ((IteratorData)object).itt.hasNext()) {
                    try {
                        do {
                            entryArray[n2] = (Map.Entry)((IteratorData)object).itt.next();
                            ((IteratorData)object).last = (String)entryArray[n2].getKey();
                            String string = NamingUtils.parent(((IteratorData)object).last);
                            if (string.equals(((IteratorData)object).parent)) {
                                ++n2;
                                continue;
                            }
                            ((IteratorData)object).subMap = ((IteratorData)object).subMap.tailMap(string + 48);
                            ((IteratorData)object).itt = ((IteratorData)object).subMap.entrySet().iterator();
                        } while (n2 < n && ((IteratorData)object).itt.hasNext());
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        ((IteratorData)object).subMap = ((IteratorData)object).subMap.tailMap(((IteratorData)object).last + '\u0000');
                        ((IteratorData)object).itt = ((IteratorData)object).subMap.entrySet().iterator();
                    }
                }
            }
            if (n2 == 0) {
                bindingListHolder.value = new Binding[0];
                return false;
            }
            Binding[] bindingArray = new Binding[n2];
            try {
                int n3 = 0;
                while (n3 < n2) {
                    bindingArray[n3] = entryArray[n3].getValue() instanceof NamingContext ? new Binding(null, BindingType.ncontext) : new Binding(null, BindingType.nobject);
                    object = (String)entryArray[n3].getKey();
                    if (!bl) {
                        object = ((String)object).substring(NamingUtils.parent((String)object).length() + 1);
                    }
                    bindingArray[n3].binding_name = MapNamingContext.this._ctxtImpl.to_name((String)object);
                    ++n3;
                }
            }
            catch (InvalidName invalidName) {
                throw new INTERNAL();
            }
            bindingListHolder.value = bindingArray;
            return true;
        }

        private java.lang.Object getKey() {
            return new ByteSeqKey(this._object_id());
        }
    }

    private static class IteratorData {
        String parent;
        String last;
        Iterator itt;
        SortedMap subMap;

        private IteratorData() {
        }
    }

    private class NamingContextExtImpl
    extends NamingContextExtPOA {
        private NamingContextExtImpl() {
        }

        public Object resolve(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] nameComponentArray2;
            NamingContextHolder namingContextHolder;
            if (nameComponentArray.length == 0) {
                throw new InvalidName();
            }
            String string = this.getPrefix() + this.to_string(nameComponentArray);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(string)) {
                    Object object = (Object)MapNamingContext.this.get(string);
                    return object;
                }
                namingContextHolder = new NamingContextHolder();
                nameComponentArray2 = MapNamingContext.this.tailOffExternal(string, namingContextHolder);
            }
            return namingContextHolder.value.resolve(nameComponentArray2);
        }

        public Object resolve_str(String string) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] nameComponentArray;
            NamingContextHolder namingContextHolder;
            this.to_name(string);
            string = this.getPrefix() + string;
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(string)) {
                    Object object = (Object)MapNamingContext.this.get(string);
                    return object;
                }
                namingContextHolder = new NamingContextHolder();
                nameComponentArray = MapNamingContext.this.tailOffExternal(string, namingContextHolder);
            }
            return namingContextHolder.value.resolve(nameComponentArray);
        }

        public void bind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
            NameComponent[] nameComponentArray2;
            NamingContextHolder namingContextHolder;
            if (nameComponentArray.length == 0) {
                throw new InvalidName();
            }
            String string = this.getPrefix() + this.to_string(nameComponentArray);
            String string2 = NamingUtils.parent(string);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(string)) {
                    throw new AlreadyBound();
                }
                if (string2.length() == 0 || MapNamingContext.this._subContexts.contains(string2)) {
                    MapNamingContext.super.put(string, object);
                    return;
                }
                namingContextHolder = new NamingContextHolder();
                nameComponentArray2 = MapNamingContext.this.tailOffExternal(string, namingContextHolder);
            }
            namingContextHolder.value.bind(nameComponentArray2, object);
        }

        public void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] nameComponentArray2;
            NamingContextHolder namingContextHolder;
            if (nameComponentArray.length == 0) {
                throw new InvalidName();
            }
            String string = this.getPrefix() + this.to_string(nameComponentArray);
            String string2 = NamingUtils.parent(string);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this._subContexts.contains(string)) {
                    NamingContextExt namingContextExt;
                    if (((Object)MapNamingContext.this.get(string))._is_equivalent(object)) {
                        return;
                    }
                    if (string2.length() != 0) {
                        namingContextExt = (NamingContextExt)MapNamingContext.this.get(string2);
                        if (namingContextExt == null) {
                            namingContextExt = this.createRef(string2);
                        }
                    } else {
                        namingContextExt = MapNamingContext.this._rootCtxt;
                    }
                    throw new CannotProceed(namingContextExt, new NameComponent[]{nameComponentArray[nameComponentArray.length - 1]});
                }
                if (string2.length() == 0 || MapNamingContext.this._subContexts.contains(string2)) {
                    MapNamingContext.super.put(string, object);
                    return;
                }
                namingContextHolder = new NamingContextHolder();
                nameComponentArray2 = MapNamingContext.this.tailOffExternal(string, namingContextHolder);
            }
            namingContextHolder.value.rebind(nameComponentArray2, object);
        }

        public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] nameComponentArray2;
            NamingContextHolder namingContextHolder;
            if (nameComponentArray.length == 0) {
                throw new InvalidName();
            }
            String string = this.getPrefix() + this.to_string(nameComponentArray);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this._subContexts.contains(string)) {
                    NamingContextExt namingContextExt;
                    String string2 = NamingUtils.parent(string);
                    if (string2.length() != 0) {
                        namingContextExt = (NamingContextExt)MapNamingContext.this.get(string2);
                        if (namingContextExt == null) {
                            namingContextExt = this.createRef(string2);
                        }
                    } else {
                        namingContextExt = MapNamingContext.this._rootCtxt;
                    }
                    throw new CannotProceed(namingContextExt, new NameComponent[]{nameComponentArray[nameComponentArray.length - 1]});
                }
                if (MapNamingContext.this.remove(string) != null) {
                    return;
                }
                namingContextHolder = new NamingContextHolder();
                nameComponentArray2 = MapNamingContext.this.tailOffExternal(string, namingContextHolder);
            }
            namingContextHolder.value.unbind(nameComponentArray2);
        }

        public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
            NameComponent[] nameComponentArray2;
            NamingContextHolder namingContextHolder;
            if (nameComponentArray.length == 0) {
                throw new InvalidName();
            }
            String string = this.getPrefix() + this.to_string(nameComponentArray);
            String string2 = NamingUtils.parent(string);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(string)) {
                    throw new AlreadyBound();
                }
                if (string2.length() == 0 || MapNamingContext.this._subContexts.contains(string2)) {
                    NamingContextExt namingContextExt = this.createRef(string);
                    return namingContextExt;
                }
                namingContextHolder = new NamingContextHolder();
                nameComponentArray2 = MapNamingContext.this.tailOffExternal(string, namingContextHolder);
            }
            return namingContextHolder.value.bind_new_context(nameComponentArray2);
        }

        public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
            NameComponent[] nameComponentArray2;
            NamingContextHolder namingContextHolder;
            if (nameComponentArray.length == 0) {
                throw new InvalidName();
            }
            String string = this.getPrefix() + this.to_string(nameComponentArray);
            String string2 = NamingUtils.parent(string);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(string)) {
                    throw new AlreadyBound();
                }
                if (string2.length() == 0 || MapNamingContext.this._subContexts.contains(string2)) {
                    MapNamingContext.super.put(string, namingContext);
                    return;
                }
                namingContextHolder = new NamingContextHolder();
                nameComponentArray2 = MapNamingContext.this.tailOffExternal(string, namingContextHolder);
            }
            namingContextHolder.value.bind_context(nameComponentArray2, namingContext);
        }

        public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] nameComponentArray2;
            NamingContextHolder namingContextHolder;
            if (nameComponentArray.length == 0) {
                throw new InvalidName();
            }
            String string = this.getPrefix() + this.to_string(nameComponentArray);
            String string2 = NamingUtils.parent(string);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this._subContexts.contains(string)) {
                    NamingContextExt namingContextExt;
                    if (((Object)MapNamingContext.this.get(string))._is_equivalent(namingContext)) {
                        return;
                    }
                    if (string2.length() != 0) {
                        namingContextExt = (NamingContextExt)MapNamingContext.this.get(string2);
                        if (namingContextExt == null) {
                            namingContextExt = this.createRef(string2);
                        }
                    } else {
                        namingContextExt = MapNamingContext.this._rootCtxt;
                    }
                    throw new CannotProceed(namingContextExt, new NameComponent[]{nameComponentArray[nameComponentArray.length - 1]});
                }
                if (string2.length() == 0 || MapNamingContext.this._subContexts.contains(string2)) {
                    MapNamingContext.super.put(string, namingContext);
                    return;
                }
                namingContextHolder = new NamingContextHolder();
                nameComponentArray2 = MapNamingContext.this.tailOffExternal(string, namingContextHolder);
            }
            namingContextHolder.value.rebind_context(nameComponentArray2, namingContext);
        }

        public NamingContext new_context() {
            MapNamingContext mapNamingContext = new MapNamingContext(this._orb(), MapNamingContext.this._firstPOA);
            mapNamingContext._firstPOA = MapNamingContext.this._firstPOA;
            mapNamingContext.setAllowSelfDestruct(true);
            return mapNamingContext.getRootCtxt();
        }

        public void destroy() throws NotEmpty {
            String string = this.getPrefix();
            if (string.length() == 0) {
                MapNamingContext mapNamingContext = MapNamingContext.this;
                synchronized (mapNamingContext) {
                    if (!MapNamingContext.this.isEmpty()) {
                        throw new NotEmpty();
                    }
                    if (MapNamingContext.this._shutdownMode == 0) {
                        throw new NO_PERMISSION();
                    }
                    MapNamingContext.this._rootCtxt = null;
                }
                if (MapNamingContext.this._shutdownMode == 1) {
                    MapNamingContext.this._ctxtPOA.destroy(true, false);
                } else {
                    this._orb().shutdown(false);
                }
                return;
            }
            string = string.substring(0, string.length() - 1);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this._rootCtxt == null) {
                    if (MapNamingContext.this._shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (!MapNamingContext.this.subMap(string + '/', string + 48).isEmpty()) {
                    throw new NotEmpty();
                }
                MapNamingContext.this.remove(string);
                MapNamingContext.this._subContexts.remove(string);
            }
        }

        public NameComponent[] to_name(String string) throws InvalidName {
            return NamingUtils.to_name(string);
        }

        public String to_string(NameComponent[] nameComponentArray) throws InvalidName {
            return NamingUtils.to_string(nameComponentArray);
        }

        public String to_url(String string, String string2) throws InvalidAddress, InvalidName {
            return NamingUtils.to_url(string, string2);
        }

        public void list(int n, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
            String string;
            Iterator iterator;
            SortedMap sortedMap;
            String string2 = this.getPrefix();
            String string3 = null;
            if (string2.length() > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            int n2 = 0;
            Map.Entry[] entryArray = new Map.Entry[n];
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                sortedMap = string2.length() == 0 ? MapNamingContext.this : MapNamingContext.this.subMap(string2 + '/', string2 + 48);
                iterator = sortedMap.entrySet().iterator();
                while (n2 < n && iterator.hasNext()) {
                    entryArray[n2] = iterator.next();
                    string3 = (String)entryArray[n2].getKey();
                    string = NamingUtils.parent(string3);
                    if (string.equals(string2)) {
                        ++n2;
                        continue;
                    }
                    sortedMap = sortedMap.tailMap(string + 48);
                    iterator = sortedMap.entrySet().iterator();
                }
            }
            if (n2 == 0) {
                bindingListHolder.value = new Binding[0];
            } else {
                Binding[] bindingArray = new Binding[n2];
                int n3 = 0;
                while (n3 < n2) {
                    bindingArray[n3] = entryArray[n3].getValue() instanceof NamingContext ? new Binding(null, BindingType.ncontext) : new Binding(null, BindingType.nobject);
                    string = (String)entryArray[n3].getKey();
                    if (string2.length() != 0) {
                        string = string.substring(NamingUtils.parent(string).length() + 1);
                    }
                    try {
                        bindingArray[n3].binding_name = MapNamingContext.this._ctxtImpl.to_name(string);
                    }
                    catch (InvalidName invalidName) {
                        throw new INTERNAL();
                    }
                    ++n3;
                }
                bindingListHolder.value = bindingArray;
            }
            if (iterator.hasNext()) {
                if (string3 == null) {
                    string3 = "";
                }
                bindingIteratorHolder.value = MapNamingContext.this._iterImpl.createIterator(string2, string3, iterator, sortedMap);
            }
        }

        private String getPrefix() {
            String string = new String(this._object_id());
            if (string.length() == 0) {
                return "";
            }
            if (!MapNamingContext.this._subContexts.contains(string)) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
            }
            return string + "/";
        }

        NamingContextExt createRef(String string) {
            NamingContextExt namingContextExt;
            try {
                namingContextExt = NamingContextExtHelper.narrow(MapNamingContext.this._ctxtPOA.create_reference_with_id(string.getBytes(), NamingContextExtHelper.id()));
            }
            catch (WrongPolicy wrongPolicy) {
                throw new INTERNAL();
            }
            MapNamingContext.this._subContexts.add(string);
            MapNamingContext.super.put(string, namingContextExt);
            return namingContextExt;
        }
    }

    private static class ByteSeqKey {
        private byte[] _key;
        private int _hashCode;

        public ByteSeqKey(byte[] byArray) {
            this._key = byArray;
            this._hashCode = 0;
            int n = 0;
            while (n < this._key.length) {
                this._hashCode = 31 * this._hashCode + this._key[n];
                ++n;
            }
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(java.lang.Object object) {
            if (object == null || !(object instanceof ByteSeqKey)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            ByteSeqKey byteSeqKey = (ByteSeqKey)object;
            if (byteSeqKey._hashCode != this._hashCode) {
                return false;
            }
            return Arrays.equals(this._key, byteSeqKey._key);
        }
    }
}

