/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public abstract class Profiler {
    private static long begin;
    private static long[] _sums;
    private static long[] _sumSq;
    private static int _upto;
    private static int _count;
    private static boolean _active;

    public static void reset(int n) {
        _sums = new long[n];
        _sumSq = new long[n];
        _upto = 0;
        _count = 0;
        _active = true;
        begin = System.currentTimeMillis();
    }

    public static void point() {
        if (!_active) {
            return;
        }
        long l = System.currentTimeMillis() - begin;
        int n = _upto;
        _sums[n] = _sums[n] + l;
        int n2 = _upto++;
        _sumSq[n2] = _sumSq[n2] + l * l;
        begin = System.currentTimeMillis();
    }

    public static int next() {
        Profiler.point();
        int n = _upto;
        ++_count;
        _upto = 0;
        begin = System.currentTimeMillis();
        return n;
    }

    public static double[] means() {
        double[] dArray = new double[_sums.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = (double)_sums[n] / (double)_count;
            ++n;
        }
        _active = false;
        return dArray;
    }

    public static double[] stddev() {
        double[] dArray = new double[_sums.length];
        double d = _count;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Math.sqrt((d * (double)_sumSq[n] - (double)_sums[n] * (double)_sums[n]) / (d * d));
            ++n;
        }
        _active = false;
        return dArray;
    }

    static {
        _active = false;
    }
}

