/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.io.HexPrintStream;
import org.openorb.io.StorageBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Trace {
    private static OutputStream os = System.out;
    private static PrintWriter out = new PrintWriter(os, true);
    private static HexPrintStream hout = new HexPrintStream(os, 2);
    private static int level = 0;

    public static void setTraceLevel(int n) {
        level = n;
    }

    public static void setTraceFile(String string) {
        if (string != null) {
            try {
                os = new FileOutputStream(string);
            }
            catch (IOException iOException) {
                throw new INTERNAL("Unable to open trace file", 0, CompletionStatus.COMPLETED_NO);
            }
        } else {
            os = System.out;
        }
        out = new PrintWriter(os, true);
        hout = new HexPrintStream(os, 2);
    }

    public static void start_debugging_session(String string, String string2, int n, org.omg.CORBA.ORB oRB) {
        Trace.setTraceLevel(n);
        Trace.setTraceFile(string2);
        out.println("----------------------------------------------------------------------------------------");
        out.println("OpenORB debugging session ");
        out.println();
        out.println("Session : " + string);
        out.println("----------------------------------------------------------------------------------------");
        out.println();
        out.println("Current configuration :");
        out.println();
        ORBLoader oRBLoader = (ORBLoader)((ORB)oRB).getFeature("ORBLoader");
        oRBLoader.display_configuration(out);
        out.println();
        out.println("----------------------------------------------------------------------------------------");
        out.println();
    }

    public static void low(String string, String string2) {
        if (level >= 4) {
            out.println("( " + string + " ) " + string2);
        }
    }

    public static void medium(String string, String string2) {
        if (level >= 3) {
            out.println("( " + string + " ) " + string2);
        }
    }

    public static void high(String string, String string2) {
        if (level >= 2) {
            out.println("( " + string + " ) " + string2);
        }
    }

    public static void exception(String string, Throwable throwable) {
        if (level != 0) {
            out.println("############################# Exception stack ################################");
            out.println("Exception raised from : " + string);
            out.println("------------------------------------------------------------------------------");
            throwable.printStackTrace(out);
            out.println("##############################################################################");
        }
    }

    public static void DumpCallException(String string, Exception exception) {
        out.print("# Exception raised in call : " + string + " #");
        exception.printStackTrace(out);
        out.println(" #");
    }

    public static void buffer(String string, byte[] byArray) {
        if (level >= 5) {
            out.println("------------------------------------------------------------------------------");
            out.println("( " + string + " ) Display a buffer, size = " + byArray.length);
            out.println("------------------------------------------------------------------------------");
            try {
                hout.write(byArray);
                hout.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            out.println("------------------------------------------------------------------------------");
        }
    }

    public static void buffer(String string, StorageBuffer storageBuffer) {
        if (level >= 5) {
            Trace.buffer(string, storageBuffer.linearize());
        }
    }

    public static void assert(boolean bl) {
        if (!bl) {
            Trace.assert(false, null);
        }
    }

    public static void assert(boolean bl, String string) {
        if (!bl) {
            out.println(string == null ? "Assertion failure" : "Assertion failure: " + string);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
                new Error().printStackTrace(printWriter);
                printWriter.close();
                BufferedReader bufferedReader = new BufferedReader(new StringReader(byteArrayOutputStream.toString()));
                System.out.println(bufferedReader.readLine());
                bufferedReader.readLine();
                out.println("Stack trace:");
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    out.println(string2);
                    string2 = bufferedReader.readLine();
                }
                out.println();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            System.exit(1);
        }
    }
}

