/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakValueHashMap
extends AbstractMap
implements Map {
    private Map _hash;
    private ReferenceQueue _queue = new ReferenceQueue();
    private Set _entrySet = null;

    public WeakValueHashMap(int n, float f) {
        this._hash = new HashMap(n, f);
    }

    public WeakValueHashMap(int n) {
        this._hash = new HashMap(n);
    }

    public WeakValueHashMap() {
        this._hash = new HashMap();
    }

    public WeakValueHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    private void processQueue() {
        WeakValue weakValue;
        while ((weakValue = (WeakValue)this._queue.poll()) != null) {
            this._hash.remove(weakValue.getKey());
        }
    }

    public boolean containsKey(Object object) {
        return this._hash.containsKey(object);
    }

    public Object get(Object object) {
        WeakValue weakValue = (WeakValue)this._hash.get(object);
        if (weakValue == null) {
            return null;
        }
        return weakValue.get();
    }

    public Object put(Object object, Object object2) {
        this.processQueue();
        return this._hash.put(object, new WeakValue(object, object2, this._queue));
    }

    public Object remove(Object object) {
        this.processQueue();
        return this._hash.remove(object);
    }

    public void clear() {
        this.processQueue();
        this._hash.clear();
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new EntrySet();
        }
        return this._entrySet;
    }

    private class EntrySet
    extends AbstractSet {
        Set hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = WeakValueHashMap.this._hash.entrySet();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = hashEntrySet.iterator();
                    this.next = null;
                }

                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)this.hashIterator.next();
                        WeakValue weakValue = (WeakValue)entry.getValue();
                        Object var3_3 = null;
                        if (weakValue != null) {
                            Object t = weakValue.get();
                            var3_3 = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(entry, var3_3);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry entry = this.next;
                    this.next = null;
                    return entry;
                }

                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            return n;
        }

        public boolean remove(Object object) {
            WeakValueHashMap.this.processQueue();
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            WeakValue weakValue = (WeakValue)WeakValueHashMap.this._hash.get(k);
            if (weakValue == null ? WeakValueHashMap.this._hash.containsKey(k) : weakValue.get() != null) {
                WeakValueHashMap.this._hash.remove(k);
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            Iterator iterator = this.hashEntrySet.iterator();
            while (iterator.hasNext()) {
                Object t;
                Map.Entry entry = (Map.Entry)iterator.next();
                Object k = entry.getKey();
                if (k == null) continue;
                WeakValue weakValue = (WeakValue)entry.getValue();
                n += k.hashCode() ^ (weakValue == null || (t = weakValue.get()) == null ? 0 : t.hashCode());
            }
            return n;
        }
    }

    private class Entry
    implements Map.Entry {
        private Map.Entry _ent;
        private Object _value;

        Entry(Map.Entry entry, Object object) {
            this._ent = entry;
            this._value = object;
        }

        public Object getKey() {
            return this._ent.getKey();
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object object) {
            this._value = object;
            return this._ent.setValue(new WeakValue(this._ent.getKey(), object, WeakValueHashMap.this._queue));
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return WeakValueHashMap.valEquals(this.getKey(), entry.getKey()) && WeakValueHashMap.valEquals(this._value, entry.getValue());
        }

        public int hashCode() {
            Object object = this.getKey();
            return (object == null ? 0 : object.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
        }
    }

    private static class WeakValue
    extends WeakReference {
        private Object _key;

        public WeakValue(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this._key = object;
        }

        public Object getKey() {
            return this._key;
        }
    }
}

