/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.openorb.util.ZipHandle;

public class ZipUtil {
    public static ZipHandle CreateZip(String string) throws IOException {
        ZipHandle zipHandle = new ZipHandle();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        zipHandle.out = new ZipOutputStream(fileOutputStream);
        return zipHandle;
    }

    public static ZipHandle OpenZip(String string) throws IOException {
        ZipHandle zipHandle = new ZipHandle();
        zipHandle.in = new ZipFile(new File(string));
        return zipHandle;
    }

    public static void CloseZip(ZipHandle zipHandle) throws IOException {
        if (zipHandle.in != null) {
            zipHandle.in.close();
        }
        if (zipHandle.out != null) {
            zipHandle.out.close();
        }
    }

    private static ZipEntry newEntry(String string) {
        return new ZipEntry(string);
    }

    public static void insert(String string, String string2, ZipHandle zipHandle) throws IOException {
        int n;
        byte[] byArray = new byte[5000];
        ZipOutputStream zipOutputStream = zipHandle.out;
        ZipEntry zipEntry = ZipUtil.newEntry(string2);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        do {
            n = fileInputStream.read(byArray);
            zipOutputStream.write(byArray, 0, n);
        } while (n == 5000);
        zipOutputStream.closeEntry();
        fileInputStream.close();
    }

    public static void addZipFileToZip(ZipEntry zipEntry, ZipFile zipFile, String string, ZipOutputStream zipOutputStream) throws IOException {
        byte[] byArray = new byte[500];
        ZipEntry zipEntry2 = ZipUtil.newEntry(string);
        zipOutputStream.putNextEntry(zipEntry2);
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        long l = 0L;
        long l2 = zipEntry.getSize();
        if (!zipEntry.isDirectory()) {
            long l3;
            do {
                l3 = inputStream.read(byArray);
                zipOutputStream.write(byArray, 0, (int)l3);
            } while ((l += l3) != l2);
        }
        zipOutputStream.closeEntry();
        inputStream.close();
    }

    public static void copy(ZipHandle zipHandle, ZipHandle zipHandle2, String[] stringArray) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipHandle.in.entries();
        ZipEntry zipEntry = null;
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (!ZipUtil.notInList(stringArray, zipEntry)) continue;
            ZipUtil.addZipFileToZip(zipEntry, zipHandle.in, zipEntry.getName(), zipHandle2.out);
        }
    }

    public static boolean containsFile(ZipHandle zipHandle, String string) {
        return zipHandle.in.getEntry(string) != null;
    }

    public static byte[] getFileContent(ZipHandle zipHandle, String string) {
        ZipEntry zipEntry = zipHandle.in.getEntry(string);
        byte[] byArray = null;
        try {
            int n;
            InputStream inputStream = zipHandle.in.getInputStream(zipEntry);
            byArray = new byte[(int)zipEntry.getSize()];
            int n2 = 0;
            while ((n = inputStream.read()) != -1) {
                byArray[n2++] = (byte)n;
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    private static boolean notInList(String[] stringArray, ZipEntry zipEntry) {
        String string = zipEntry.getName();
        if (stringArray == null) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

