/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.netbeans.modules.apisupport.beanbrowser.PropSetKids;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.execution.ThreadExecutor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public class BeanTester
extends ThreadExecutor {
    private static final long serialVersionUID = -4004964495171713724L;

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.apisupport.testers.Bean");
    }

    protected void checkClass(Class clazz) throws IOException {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new IOException("Class is not public");
        }
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IOException("Constructor is not public");
            }
        }
        catch (Exception exception) {
            throw BeanTester.mkioe(exception);
        }
        catch (LinkageError linkageError) {
            throw BeanTester.mkioe(linkageError);
        }
    }

    static IOException mkioe(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        IOException iOException = new IOException(throwable.toString());
        ErrorManager.getDefault().annotate((Throwable)iOException, throwable);
        return iOException;
    }

    protected void executeClass(Class clazz, String[] stringArray) {
        try {
            Object t = clazz.newInstance();
            Node node = t instanceof Node ? (Node)t : PropSetKids.makeObjectNode(t);
            TopManager.getDefault().getNodeOperation().explore(node);
        }
        catch (Exception exception) {
            BeanTester.dump(exception);
        }
        catch (LinkageError linkageError) {
            BeanTester.dump(linkageError);
        }
    }

    static void dump(Throwable throwable) {
        throwable.printStackTrace();
        ErrorManager.getDefault().notify(1, throwable);
    }
}

