/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.apisupport.CategoryNode;
import org.openide.ErrorManager;
import org.openide.execution.Executor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.ExecSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public interface ManifestProvider
extends Node.Cookie {
    public Manifest getManifest() throws IOException;

    public void setManifest(Manifest var1) throws IOException;

    public void addFiles(Set var1) throws IOException;

    public void removeFiles(Set var1) throws IOException;

    public Set getFiles() throws IOException;

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public boolean isValid();

    public Exception getParseException();

    public File getManifestAsFile();

    public File getModuleJar();

    class 2 {
        static /* synthetic */ Class class$org$netbeans$modules$apisupport$lite$LiteInstaller;
        static /* synthetic */ Class class$org$netbeans$modules$apisupport$ManifestProvider;
        static /* synthetic */ Class class$java$lang$String;

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class CategoryChildren
    extends Children.Keys {
        private ManifestProvider provider;
        private ChangeListener list;

        public CategoryChildren(ManifestProvider manifestProvider) {
            this.provider = manifestProvider;
            this.list = new ChangeListener(this){
                private final /* synthetic */ CategoryChildren this$0;
                {
                    this.this$0 = categoryChildren;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$0.addNotify();
                }
            };
            manifestProvider.addChangeListener(WeakListener.change((ChangeListener)this.list, (Object)manifestProvider));
        }

        protected void addNotify() {
            this.setKeys(new Object[]{"OpenIDE-Module-Install", "OpenIDE-Module-Layer", "OpenIDE-Module-Description", "Action", "ClipboardConvertor", "Debugger", "Filesystem", "Loader", "Node", "Option", "Service"});
        }

        protected void removeNotify() {
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{new CategoryNode(this.provider, (String)object)};
        }
    }

    public static abstract class Util {
        private Util() {
        }

        public static Exception checkForException(ManifestProvider manifestProvider) {
            if (manifestProvider == null) {
                return null;
            }
            if (!manifestProvider.isValid()) {
                Exception exception = manifestProvider.getParseException();
                if (exception != null) {
                    return exception;
                }
                return new Exception("(unspecified manifest syntax error)");
            }
            try {
                Manifest manifest = manifestProvider.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                Dependency.create((int)1, (String)attributes.getValue("OpenIDE-Module"));
                String string = attributes.getValue("OpenIDE-Module-Specification-Version");
                if (string != null) {
                    new SpecificationVersion(string);
                }
                Dependency.create((int)4, (String)attributes.getValue("OpenIDE-Module-IDE-Dependencies"));
                Dependency.create((int)3, (String)attributes.getValue("OpenIDE-Module-Java-Dependencies"));
                Dependency.create((int)1, (String)attributes.getValue("OpenIDE-Module-Module-Dependencies"));
                Dependency.create((int)2, (String)attributes.getValue("OpenIDE-Module-Package-Dependencies"));
                Dependency.create((int)5, (String)attributes.getValue("OpenIDE-Module-Requires"));
                Dependency.create((int)5, (String)attributes.getValue("OpenIDE-Module-Provides"));
                return null;
            }
            catch (Exception exception) {
                return exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String findLocalizedValue(Attributes attributes, String string) throws IOException {
            String string2 = attributes.getValue("OpenIDE-Module-Localizing-Bundle");
            if (string2 != null) {
                FileObject fileObject = FileSystemCapability.EXECUTE.findResource(string2);
                if (fileObject != null && fileObject.isData()) {
                    String string3;
                    InputStream inputStream = fileObject.getInputStream();
                    try {
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        string3 = properties.getProperty(string);
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    return string3;
                }
                return "<missing " + string2 + ">";
            }
            return attributes.getValue(string);
        }

        public static void updateName(Node node, String string) {
            Util.updateName(node, string, (ManifestProvider)node.getCookie(2.class$org$netbeans$modules$apisupport$ManifestProvider == null ? (2.class$org$netbeans$modules$apisupport$ManifestProvider = 2.class$("org.netbeans.modules.apisupport.ManifestProvider")) : 2.class$org$netbeans$modules$apisupport$ManifestProvider));
        }

        private static void updateName(Node node, String string, ManifestProvider manifestProvider) {
            if (manifestProvider == null) {
                node.setShortDescription("Unparsed " + string);
                return;
            }
            try {
                String string2 = manifestProvider.getManifest().getMainAttributes().getValue("OpenIDE-Module");
                if (string2 != null) {
                    int n = string2.lastIndexOf(47);
                    if (n != -1) {
                        string2 = string2.substring(0, n);
                    }
                    node.setShortDescription(string2 + " [" + string + "]");
                } else {
                    node.setShortDescription("Malformed " + string);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }

        public static void addToSheet(Sheet sheet, ManifestProvider manifestProvider) {
            Sheet.Set set = new Sheet.Set();
            set.setName("openide");
            set.setDisplayName("Module Properties");
            set.setShortDescription("General properties of the module.");
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module", "Code Name", "Code name for the module, e.g. \"com.mycom.mymodule\" or \"com.mycom.mymodule/1\"."));
            set.put((Node.Property)new GeneralProp(manifestProvider, true, "OpenIDE-Module-Name", "Display Name", "Display name for this module (in the base locale only!)."));
            set.put((Node.Property)new GeneralProp(manifestProvider, true, "OpenIDE-Module-Short-Description", "Short Description", "Short description of this module (in the base locale only!)."));
            set.put((Node.Property)new GeneralProp(manifestProvider, true, "OpenIDE-Module-Long-Description", "Long Description", "Longer description of this module (in the base locale only!)."));
            set.put((Node.Property)new GeneralProp(manifestProvider, true, "OpenIDE-Module-Display-Category", "Display Category", "Category of this module for display purposes (in the base locale only!)."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-Specification-Version", "Specification Version", "Specification version, e.g. 1.0 or 1.13.9.2."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-Implementation-Version", "Implementation Version", "Implementation version; no particular format."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-Module-Dependencies", "Module Dependencies", "Dependencies on other modules, e.g. \"com.mycom.myothermodule/1 > 0.9.1 , org.netbeans.modules.java\"."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-Package-Dependencies", "Package Dependencies", "Dependencies on packages and standard extensions, e.g. \"javax.servlet , javax.ejb > 1.1\"."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-Java-Dependencies", "Java Dependencies", "Dependencies on Java (APIs and VM), e.g. \"Java = 1.2.1b4, VM > 1.0\"."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-IDE-Dependencies", "IDE Dependencies", "Dependencies on the Open APIs, e.g. \"IDE/1 > 1.0\"."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-Provides", "Provided Tokens", "Capabilities offered, e.g. \"org.foo.Foo, org.foo.Bar\"."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-Requires", "Required Tokens", "Capabilities needed, e.g. \"org.foo.Foo, org.foo.Bar\"."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "OpenIDE-Module-Public-Packages", "Exported Packages", "Packages exported to client modules, e.g. \"org.api.foo.*, org.api.bar.**\"."));
            set.put((Node.Property)new GeneralProp(manifestProvider, false, "Class-Path", "Extension JARs", "Extra JARs to load, e.g. \"ext/foo.jar ext/bar.jar\"."));
            sheet.put(set);
            set = new Sheet.Set();
            set.setName("openideparse");
            set.setDisplayName("Manifest Parsing");
            set.setShortDescription("Information pertaining to the parse status of the manifest file.");
            set.put((Node.Property)new ManifestValidProp(manifestProvider));
            set.put((Node.Property)new ManifestErrorProp(manifestProvider));
            sheet.put(set);
        }

        private static class ManifestErrorProp
        extends PropertySupport.ReadOnly {
            private ManifestProvider p;

            public ManifestErrorProp(ManifestProvider manifestProvider) {
                super("manifestError", 2.class$java$lang$String == null ? (2.class$java$lang$String = 2.class$("java.lang.String")) : 2.class$java$lang$String, "Manifest Error", "Current parse error for the manifest, if any.");
                this.p = manifestProvider;
            }

            public Object getValue() {
                Exception exception = Util.checkForException(this.p);
                if (exception == null) {
                    return "<none>";
                }
                if (exception.getLocalizedMessage() == null) {
                    return "<unspecified " + Utilities.getShortClassName(exception.getClass()) + " error>";
                }
                return exception.getLocalizedMessage();
            }
        }

        private static class ManifestValidProp
        extends PropertySupport.ReadOnly {
            private ManifestProvider p;

            public ManifestValidProp(ManifestProvider manifestProvider) {
                super("manifestValid", Boolean.TYPE, "Valid Manifest", "Whether the manifest is currently valid (both in terms of raw syntax and OpenIDE requirements).");
                this.p = manifestProvider;
            }

            public Object getValue() {
                return new Boolean(Util.checkForException(this.p) == null);
            }
        }

        private static class GeneralProp
        extends PropertySupport.ReadWrite {
            private String tagname;
            private ManifestProvider provider;
            private boolean loc;

            public GeneralProp(ManifestProvider manifestProvider, boolean bl, String string, String string2, String string3) {
                super(string, 2.class$java$lang$String == null ? (2.class$java$lang$String = 2.class$("java.lang.String")) : 2.class$java$lang$String, string2, string3);
                this.provider = manifestProvider;
                this.loc = bl;
                this.tagname = string;
            }

            public Object getValue() throws InvocationTargetException {
                try {
                    Attributes attributes = this.provider.getManifest().getMainAttributes();
                    String string = this.loc ? Util.findLocalizedValue(attributes, this.tagname) : attributes.getValue(this.tagname);
                    return string == null ? "" : string;
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    Manifest manifest = this.provider.getManifest();
                    if (object.equals("")) {
                        manifest.getMainAttributes().remove(new Attributes.Name(this.tagname));
                    } else {
                        manifest.getMainAttributes().putValue(this.tagname, (String)object);
                    }
                    this.provider.setManifest(manifest);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public void restoreDefaultValue() throws IllegalArgumentException, InvocationTargetException {
                this.setValue("");
            }

            public boolean supportsDefaultValue() {
                return true;
            }
        }
    }

    public static class ModuleExecSupport
    extends ExecSupport {
        public ModuleExecSupport(MultiDataObject.Entry entry) {
            super(entry);
        }

        protected Executor defaultExecutor() {
            return Executor.find((Class)(2.class$org$netbeans$modules$apisupport$lite$LiteInstaller == null ? (2.class$org$netbeans$modules$apisupport$lite$LiteInstaller = 2.class$("org.netbeans.modules.apisupport.lite.LiteInstaller")) : 2.class$org$netbeans$modules$apisupport$lite$LiteInstaller));
        }
    }
}

