/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.beanbrowser;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.apisupport.beanbrowser.PropSetKids;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.MultiTransferObject;

public class ClipboardKids
extends Children.Keys {
    private Clipboard clip;
    private ClipboardListener list;

    public ClipboardKids(Clipboard clipboard) {
        this.clip = clipboard;
    }

    protected void addNotify() {
        this.updateKeys();
        if (this.list == null && this.clip instanceof ExClipboard) {
            this.list = new ClipboardListener(){

                public void clipboardChanged(ClipboardEvent clipboardEvent) {
                    ClipboardKids.this.updateKeys();
                }
            };
            ((ExClipboard)this.clip).addClipboardListener(this.list);
        }
    }

    private void cleanUp() {
        if (this.list != null) {
            ((ExClipboard)this.clip).removeClipboardListener(this.list);
            this.list = null;
        }
    }

    protected void removeNotify() {
        this.cleanUp();
        this.setKeys(Collections.EMPTY_SET);
    }

    protected void finalize() {
        this.cleanUp();
    }

    private void updateKeys() {
        Transferable transferable = this.clip.getContents(null);
        if (transferable == null) {
            this.setKeys(Collections.EMPTY_SET);
        } else {
            Object[] objectArray = transferable.getTransferDataFlavors();
            if (objectArray == null) {
                this.setKeys(Collections.EMPTY_SET);
            } else {
                this.setKeys(objectArray);
            }
        }
    }

    protected Node[] createNodes(Object object) {
        DataFlavor dataFlavor = (DataFlavor)object;
        try {
            Object object2 = this.clip.getContents(null).getTransferData(dataFlavor);
            if (object2 instanceof MultiTransferObject) {
                MultiTransferObject multiTransferObject = (MultiTransferObject)object2;
                LinkedList<Node> linkedList = new LinkedList<Node>();
                int n = multiTransferObject.getCount();
                int n2 = 0;
                while (n2 < n) {
                    linkedList.add(PropSetKids.makePlainNode("MultiTransferObject [" + n2 + "]"));
                    DataFlavor[] dataFlavorArray = multiTransferObject.getTransferDataFlavors(n2);
                    int n3 = 0;
                    while (n3 < dataFlavorArray.length) {
                        try {
                            linkedList.add(ClipboardKids.makeFlavorNode(dataFlavorArray[n3], multiTransferObject.getTransferData(n2, dataFlavorArray[n3])));
                        }
                        catch (Exception exception) {
                            linkedList.add(PropSetKids.makeErrorNode(exception));
                        }
                        ++n3;
                    }
                    ++n2;
                }
                linkedList.add(PropSetKids.makePlainNode("MultiTransferObject [end]"));
                return linkedList.toArray(new Node[linkedList.size()]);
            }
            return new Node[]{ClipboardKids.makeFlavorNode(dataFlavor, object2)};
        }
        catch (Exception exception) {
            return new Node[]{PropSetKids.makeErrorNode(exception)};
        }
    }

    private static Node makeFlavorNode(DataFlavor dataFlavor, Object object) {
        Node node = PropSetKids.makeObjectNode(object);
        node.setDisplayName(dataFlavor.getHumanPresentableName() + " = " + node.getDisplayName());
        return node;
    }
}

